/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.EnumScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import fr.esrf.tangoatk.widget.attribute.ScalarAttributeSetPanel;
import fr.esrf.tangoatk.widget.attribute.SimpleEnumScalarViewer;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class MultiScalarTableViewer
extends JTable {
    private int nbRows = 0;
    private int nbColumns = 0;
    private String[] columnIdents = null;
    private String[] rowIdents = null;
    private boolean alarmEnabled = true;
    private boolean unitVisible = true;
    private Color panelBackground = null;
    private IAttribute[][] attModels = null;
    private MultiScalarViewerTableModel tabModel = new MultiScalarViewerTableModel();
    private MultiScalarViewerCellRenderer scalarViewerRenderer = null;
    private RowIdentsCellRenderer rowIdentsRenderer = null;
    private ColHeaderCellRenderer colHeadRenderer = null;
    private long firstClickTime = 0L;
    private RootPaneContainer rpcParent = null;
    private JDialog attSetDialWindow = null;
    private ScalarAttributeSetPanel attSetPanel = null;

    public MultiScalarTableViewer() {
        this.setModel(this.tabModel);
        this.scalarViewerRenderer = new MultiScalarViewerCellRenderer();
        this.rowIdentsRenderer = new RowIdentsCellRenderer();
        this.colHeadRenderer = new ColHeaderCellRenderer();
        this.panelBackground = new Color(235, 235, 235);
        this.setRowMargin(0);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MultiScalarTableViewer.this.tableMouseDoubleClick(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (this.tabModel.getHasRowLabels() && n2 == 0) {
            return this.rowIdentsRenderer;
        }
        Object object = this.tabModel.getValueAt(n, n2);
        if (object != null && object instanceof SimpleScalarViewer) {
            return this.scalarViewerRenderer;
        }
        if (object != null && object instanceof SimpleEnumScalarViewer) {
            return this.scalarViewerRenderer;
        }
        if (object != null && object instanceof BooleanScalarCheckBoxViewer) {
            return this.scalarViewerRenderer;
        }
        return super.getCellRenderer(n, n2);
    }

    public Color getPanelBackground() {
        return this.panelBackground;
    }

    public void setPanelBackground(Color color) {
        this.panelBackground = color;
        this.attSetDialWindow.setBackground(this.panelBackground);
        this.attSetPanel.setBackground(this.panelBackground);
    }

    private void tableMouseDoubleClick(MouseEvent mouseEvent) {
        boolean bl;
        long l = System.currentTimeMillis();
        long l2 = l - this.firstClickTime;
        if (l2 < 500L) {
            this.firstClickTime = 0L;
            bl = true;
        } else {
            this.firstClickTime = l;
            bl = false;
        }
        if (!bl) {
            return;
        }
        if (this.tabModel.getHasRowLabels() && this.getSelectedColumn() == 0) {
            return;
        }
        this.doEdit(this.getSelectedRow(), this.getSelectedColumn());
    }

    private void doEdit(int n, int n2) {
        int n3 = n2;
        if (this.tabModel.getHasRowLabels()) {
            n3 = n2 - 1;
        }
        if (n < 0 || n3 < 0) {
            return;
        }
        if (n >= this.nbRows || n3 >= this.nbColumns) {
            return;
        }
        IAttribute iAttribute = this.attModels[n][n3];
        if (iAttribute == null) {
            return;
        }
        if (!iAttribute.isWritable()) {
            return;
        }
        if (!(iAttribute instanceof INumberScalar || iAttribute instanceof IStringScalar || iAttribute instanceof IEnumScalar || iAttribute instanceof IBooleanScalar)) {
            return;
        }
        if (this.attSetDialWindow == null || this.attSetPanel == null) {
            this.creatScalarSetWindows();
        }
        if (this.attSetDialWindow == null || this.attSetPanel == null) {
            return;
        }
        if (this.attSetPanel.getAttModel() != iAttribute) {
            this.attSetDialWindow.setVisible(false);
            this.attSetPanel.setAttModel(iAttribute);
            this.attSetDialWindow.setTitle(iAttribute.getName());
            this.attSetDialWindow.pack();
        }
        this.attSetDialWindow.setVisible(true);
    }

    private void creatScalarSetWindows() {
        Container container = this;
        while (this.rpcParent == null && (container = container.getParent()) != null) {
            if (!(container instanceof RootPaneContainer)) continue;
            this.rpcParent = (RootPaneContainer)((Object)container);
            break;
        }
        if (this.rpcParent != null) {
            System.out.println("MultiScalarTableViewer : the parent class (implementing RootPaneContainer) is : " + this.rpcParent.getClass().getName());
        }
        this.attSetDialWindow = this.rpcParent == null ? new JDialog() : (this.rpcParent instanceof Frame ? new JDialog((Frame)((Object)this.rpcParent)) : (this.rpcParent instanceof Dialog ? new JDialog((Dialog)((Object)this.rpcParent)) : new JDialog()));
        this.attSetDialWindow.getContentPane().setLayout(new GridBagLayout());
        this.attSetDialWindow.getContentPane().setBackground(this.panelBackground);
        this.attSetPanel = new ScalarAttributeSetPanel();
        this.attSetPanel.setBackground(this.panelBackground);
        this.attSetPanel.setFont(this.getFont());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.attSetDialWindow.getContentPane().add((Component)this.attSetPanel, gridBagConstraints);
        JButton jButton = new JButton();
        jButton.setText("Dismiss");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiScalarTableViewer.this.attSetDialWindow.setVisible(false);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.attSetDialWindow.getContentPane().add((Component)jButton, gridBagConstraints);
    }

    public int getNbRows() {
        return this.nbRows;
    }

    public void setNbRows(int n) {
        if (n <= 0) {
            return;
        }
        if (this.attModels != null) {
            return;
        }
        if (this.rowIdents != null && n != this.rowIdents.length) {
            return;
        }
        this.nbRows = n;
    }

    public int getNbColumns() {
        return this.nbColumns;
    }

    public void setNbColumns(int n) {
        if (n <= 0) {
            return;
        }
        if (this.attModels != null) {
            return;
        }
        if (this.columnIdents != null && n != this.columnIdents.length) {
            return;
        }
        this.nbColumns = n;
    }

    public String[] getColumnIdents() {
        return this.columnIdents;
    }

    public void setColumnIdents(String[] stringArray) {
        if (stringArray == null) {
            this.columnIdents = null;
            return;
        }
        if (this.attModels != null && this.attModels[0].length != stringArray.length) {
            return;
        }
        if (this.attModels == null) {
            this.nbColumns = stringArray.length;
        }
        this.columnIdents = stringArray;
    }

    public String[] getRowIdents() {
        return this.rowIdents;
    }

    public void setRowIdents(String[] stringArray) {
        if (stringArray == null) {
            this.rowIdents = null;
            return;
        }
        if (this.attModels != null && this.attModels.length != stringArray.length) {
            return;
        }
        if (this.attModels == null) {
            this.nbRows = stringArray.length;
        }
        this.rowIdents = stringArray;
    }

    public boolean getAlarmEnabled() {
        return this.alarmEnabled;
    }

    public void setAlarmEnabled(boolean bl) {
        if (this.alarmEnabled == bl) {
            return;
        }
        this.alarmEnabled = bl;
        if (this.attModels == null) {
            return;
        }
        for (int i = 0; i < this.attModels.length; ++i) {
            for (int j = 0; j < this.attModels[i].length; ++j) {
                Object object;
                int n = j;
                if (this.tabModel.getHasRowLabels()) {
                    n = j + 1;
                }
                if (!((object = this.tabModel.getValueAt(i, n)) instanceof SimpleScalarViewer)) continue;
                SimpleScalarViewer simpleScalarViewer = (SimpleScalarViewer)object;
                simpleScalarViewer.setAlarmEnabled(this.alarmEnabled);
            }
        }
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean bl) {
        if (this.unitVisible == bl) {
            return;
        }
        this.unitVisible = bl;
        if (this.attSetPanel != null) {
            this.attSetPanel.setUnitVisible(this.unitVisible);
        }
        if (this.attModels == null) {
            return;
        }
        for (int i = 0; i < this.attModels.length; ++i) {
            for (int j = 0; j < this.attModels[i].length; ++j) {
                Object object;
                int n = j;
                if (this.tabModel.getHasRowLabels()) {
                    n = j + 1;
                }
                if (!((object = this.tabModel.getValueAt(i, n)) instanceof SimpleScalarViewer)) continue;
                SimpleScalarViewer simpleScalarViewer = (SimpleScalarViewer)object;
                simpleScalarViewer.setUnitVisible(this.unitVisible);
            }
        }
    }

    public JLabel getRowIdCellRenderer() {
        return this.rowIdentsRenderer;
    }

    public IAttribute[][] getAttModels() {
        return this.attModels;
    }

    public void setModelAt(IAttribute iAttribute, int n, int n2) {
        boolean bl = false;
        if (this.nbRows <= 0 || this.nbColumns <= 0) {
            System.out.println("Please set the number of columns and rows of the table before calling setModelAt.");
            return;
        }
        if (iAttribute instanceof INumberScalar || iAttribute instanceof IStringScalar || iAttribute instanceof IEnumScalar || iAttribute instanceof IBooleanScalar) {
            bl = true;
        }
        if (!bl) {
            System.out.println("Unsupported type of attribute; setModelAt failed.");
            return;
        }
        if (this.attModels == null) {
            this.initAttModels();
        }
        if (n < 0 || n2 < 0) {
            return;
        }
        if (n >= this.nbRows || n2 >= this.nbColumns) {
            return;
        }
        this.clearModelAt(n, n2);
        if (iAttribute == null) {
            return;
        }
        this.attModels[n][n2] = iAttribute;
        if (iAttribute instanceof INumberScalar) {
            INumberScalar iNumberScalar = (INumberScalar)iAttribute;
            this.addAttributeAt(iNumberScalar, n, n2);
            return;
        }
        if (iAttribute instanceof IStringScalar) {
            IStringScalar iStringScalar = (IStringScalar)iAttribute;
            this.addAttributeAt(iStringScalar, n, n2);
            return;
        }
        if (iAttribute instanceof IEnumScalar) {
            IEnumScalar iEnumScalar = (IEnumScalar)iAttribute;
            this.addAttributeAt(iEnumScalar, n, n2);
            return;
        }
        if (iAttribute instanceof IBooleanScalar) {
            IBooleanScalar iBooleanScalar = (IBooleanScalar)iAttribute;
            this.addAttributeAt(iBooleanScalar, n, n2);
            return;
        }
    }

    private void addAttributeAt(INumberScalar iNumberScalar, int n, int n2) {
        SimpleScalarViewer simpleScalarViewer = new SimpleScalarViewer();
        simpleScalarViewer.setBackgroundColor(this.getBackground());
        simpleScalarViewer.setFont(this.getFont());
        simpleScalarViewer.setModel(iNumberScalar);
        simpleScalarViewer.setAlarmEnabled(this.alarmEnabled);
        simpleScalarViewer.setUnitVisible(this.unitVisible);
        simpleScalarViewer.setHasToolTip(true);
        if ((double)this.rowHeight < simpleScalarViewer.getPreferredSize().getHeight()) {
            this.rowHeight = (int)simpleScalarViewer.getPreferredSize().getHeight();
        }
        this.tabModel.addAttributeAt(n, n2, (IAttribute)iNumberScalar, simpleScalarViewer);
    }

    private void addAttributeAt(IStringScalar iStringScalar, int n, int n2) {
        SimpleScalarViewer simpleScalarViewer = new SimpleScalarViewer();
        simpleScalarViewer.setBackgroundColor(this.getBackground());
        simpleScalarViewer.setFont(this.getFont());
        simpleScalarViewer.setModel(iStringScalar);
        simpleScalarViewer.setAlarmEnabled(this.alarmEnabled);
        simpleScalarViewer.setHasToolTip(true);
        if ((double)this.rowHeight < simpleScalarViewer.getPreferredSize().getHeight()) {
            this.rowHeight = (int)simpleScalarViewer.getPreferredSize().getHeight();
        }
        this.tabModel.addAttributeAt(n, n2, (IAttribute)iStringScalar, simpleScalarViewer);
    }

    private void addAttributeAt(IEnumScalar iEnumScalar, int n, int n2) {
        SimpleEnumScalarViewer simpleEnumScalarViewer = new SimpleEnumScalarViewer();
        simpleEnumScalarViewer.setBackgroundColor(this.getBackground());
        simpleEnumScalarViewer.setFont(this.getFont());
        simpleEnumScalarViewer.setModel(iEnumScalar);
        simpleEnumScalarViewer.setAlarmEnabled(this.alarmEnabled);
        if ((double)this.rowHeight < simpleEnumScalarViewer.getPreferredSize().getHeight()) {
            this.rowHeight = (int)simpleEnumScalarViewer.getPreferredSize().getHeight();
        }
        this.tabModel.addAttributeAt(n, n2, (IAttribute)iEnumScalar, simpleEnumScalarViewer);
    }

    private void addAttributeAt(IBooleanScalar iBooleanScalar, int n, int n2) {
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = new BooleanScalarCheckBoxViewer();
        booleanScalarCheckBoxViewer.setBorderPainted(true);
        booleanScalarCheckBoxViewer.setBorder(BorderUIResource.getEtchedBorderUIResource());
        booleanScalarCheckBoxViewer.setBackground(this.getBackground());
        booleanScalarCheckBoxViewer.setFont(this.getFont());
        booleanScalarCheckBoxViewer.setAttModel(iBooleanScalar);
        booleanScalarCheckBoxViewer.setTrueLabel(new String());
        booleanScalarCheckBoxViewer.setFalseLabel(new String());
        booleanScalarCheckBoxViewer.setHasToolTip(true);
        booleanScalarCheckBoxViewer.setHorizontalAlignment(0);
        if ((double)this.rowHeight < booleanScalarCheckBoxViewer.getPreferredSize().getHeight()) {
            this.rowHeight = (int)booleanScalarCheckBoxViewer.getPreferredSize().getHeight();
        }
        this.tabModel.addAttributeAt(n, n2, (IAttribute)iBooleanScalar, booleanScalarCheckBoxViewer);
    }

    public void clearModelAt(int n, int n2) {
        if (this.attModels == null) {
            return;
        }
        if (this.nbRows <= 0 || this.nbColumns <= 0) {
            System.out.println("Please set the number of columns and rows before calling clearModelAt.");
            return;
        }
        if (n < 0 || n2 < 0) {
            return;
        }
        if (n >= this.nbRows || n2 >= this.nbColumns) {
            return;
        }
        if (this.attModels[n][n2] == null) {
            return;
        }
        if (this.attModels[n][n2] instanceof INumberScalar) {
            this.tabModel.removeAttributeAt(n, n2);
            this.attModels[n][n2] = null;
            return;
        }
    }

    public void clearModel() {
        if (this.attModels == null) {
            return;
        }
        for (int i = 0; i < this.attModels.length; ++i) {
            for (int j = 0; j < this.attModels[i].length; ++j) {
                this.clearModelAt(i, j);
            }
        }
        this.attModels = null;
    }

    private void initAttModels() {
        if (this.nbRows <= 0 || this.nbColumns <= 0) {
            System.out.println("Please set the number of columns and rows before calling initAttModels.");
            return;
        }
        this.attModels = new IAttribute[this.nbRows][this.nbColumns];
        for (int i = 0; i < this.nbRows; ++i) {
            for (int j = 0; j < this.nbColumns; ++j) {
                this.attModels[i][j] = null;
            }
        }
        this.tabModel.init();
        this.initColumnHeaderRenderers();
    }

    private void initColumnHeaderRenderers() {
        if (this.columnIdents == null) {
            return;
        }
        for (int i = 0; i < this.columnIdents.length; ++i) {
            try {
                TableColumn tableColumn = this.getColumn(this.columnIdents[i]);
                tableColumn.setHeaderRenderer(this.colHeadRenderer);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"att_un", "att_deux", "att_trois", "att_cinq", "att_six", "att_bool"};
        String[] stringArray3 = new String[]{"jlp/test/1", "jlp/test/2"};
        AttributeList attributeList = new AttributeList();
        JFrame jFrame = new JFrame();
        MultiScalarTableViewer multiScalarTableViewer = new MultiScalarTableViewer();
        multiScalarTableViewer.setNbRows(2);
        multiScalarTableViewer.setNbColumns(6);
        multiScalarTableViewer.setColumnIdents(stringArray2);
        multiScalarTableViewer.setRowIdents(stringArray3);
        multiScalarTableViewer.setUnitVisible(false);
        multiScalarTableViewer.setFont(new Font("Dialog", 0, 16));
        try {
            IAttribute iAttribute = (IAttribute)attributeList.add("jlp/test/1/att_un");
            multiScalarTableViewer.setModelAt(iAttribute, 0, 0);
            iAttribute = (IAttribute)attributeList.add("jlp/test/1/att_deux");
            multiScalarTableViewer.setModelAt(iAttribute, 0, 1);
            iAttribute = (IAttribute)attributeList.add("jlp/test/1/att_trois");
            multiScalarTableViewer.setModelAt(iAttribute, 0, 2);
            iAttribute = (IAttribute)attributeList.add("fp/test/1/string_scalar");
            multiScalarTableViewer.setModelAt(iAttribute, 0, 3);
            iAttribute = (IAttribute)attributeList.add("jlp/test/1/att_six");
            multiScalarTableViewer.setModelAt(iAttribute, 0, 4);
            iAttribute = (IAttribute)attributeList.add("jlp/test/1/att_boolean");
            multiScalarTableViewer.setModelAt(iAttribute, 0, 5);
            iAttribute = (IAttribute)attributeList.add("jlp/test/2/att_un");
            multiScalarTableViewer.setModelAt(iAttribute, 1, 0);
            iAttribute = (IAttribute)attributeList.add("jlp/test/2/att_deux");
            multiScalarTableViewer.setModelAt(iAttribute, 1, 1);
            iAttribute = (IAttribute)attributeList.add("jlp/test/2/att_trois");
            multiScalarTableViewer.setModelAt(iAttribute, 1, 2);
            iAttribute = (IAttribute)attributeList.add("fp/test/2/string_scalar");
            multiScalarTableViewer.setModelAt(iAttribute, 1, 3);
            iAttribute = (IAttribute)attributeList.add("jlp/test/2/att_six");
            multiScalarTableViewer.setModelAt(iAttribute, 1, 4);
            iAttribute = (IAttribute)attributeList.add("jlp/test/2/att_boolean");
            multiScalarTableViewer.setModelAt(iAttribute, 1, 5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Cannot connect to jlp/test/1");
        }
        attributeList.startRefresher();
        multiScalarTableViewer.setPreferredScrollableViewportSize(new Dimension(700, 70));
        JScrollPane jScrollPane = new JScrollPane(multiScalarTableViewer);
        jFrame.setContentPane(jScrollPane);
        jFrame.setDefaultCloseOperation(3);
        multiScalarTableViewer.doLayout();
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static /* synthetic */ String[] access$502(MultiScalarTableViewer multiScalarTableViewer, String[] stringArray) {
        multiScalarTableViewer.rowIdents = stringArray;
        return stringArray;
    }

    class ColHeaderCellRenderer
    extends RowIdentsCellRenderer {
        ColHeaderCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof String) {
                String string = (String)object;
                this.setText(string);
                return this;
            }
            return new JLabel("Unsupported column header Class");
        }
    }

    class RowIdentsCellRenderer
    extends JLabel
    implements TableCellRenderer {
        RowIdentsCellRenderer() {
            this.setHorizontalAlignment(2);
            this.setOpaque(true);
            this.setBackground(new Color(220, 220, 220));
            this.setBorder(BorderUIResource.getEtchedBorderUIResource());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof String) {
                String string = (String)object;
                this.setText(string);
                return this;
            }
            return new JLabel("Unsupported row id Class");
        }
    }

    class MultiScalarViewerCellRenderer
    implements TableCellRenderer {
        MultiScalarViewerCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof SimpleScalarViewer) {
                SimpleScalarViewer simpleScalarViewer = (SimpleScalarViewer)object;
                return simpleScalarViewer;
            }
            if (object instanceof SimpleEnumScalarViewer) {
                SimpleEnumScalarViewer simpleEnumScalarViewer = (SimpleEnumScalarViewer)object;
                return simpleEnumScalarViewer;
            }
            if (object instanceof BooleanScalarCheckBoxViewer) {
                BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = (BooleanScalarCheckBoxViewer)object;
                return booleanScalarCheckBoxViewer;
            }
            return new JLabel("Unsupported Class");
        }
    }

    class MultiScalarViewerTableModel
    extends DefaultTableModel
    implements INumberScalarListener,
    IStringScalarListener,
    IEnumScalarListener,
    IBooleanScalarListener {
        private boolean hasRowLabels = false;
        private HashMap attMap = new HashMap();

        MultiScalarViewerTableModel() {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        void init() {
            if (MultiScalarTableViewer.this.attModels == null) {
                return;
            }
            if (MultiScalarTableViewer.this.attModels.length != MultiScalarTableViewer.this.nbRows) {
                MultiScalarTableViewer.this.nbRows = MultiScalarTableViewer.this.attModels.length;
            }
            if (MultiScalarTableViewer.this.attModels[0].length != MultiScalarTableViewer.this.nbColumns) {
                MultiScalarTableViewer.this.nbColumns = MultiScalarTableViewer.this.attModels[0].length;
            }
            if (MultiScalarTableViewer.this.rowIdents != null && MultiScalarTableViewer.this.rowIdents.length != MultiScalarTableViewer.this.nbRows) {
                MultiScalarTableViewer.access$502(MultiScalarTableViewer.this, null);
            }
            if (MultiScalarTableViewer.this.rowIdents != null) {
                this.hasRowLabels = true;
                Object[] objectArray = null;
                if (MultiScalarTableViewer.this.columnIdents != null) {
                    objectArray = new String[MultiScalarTableViewer.this.columnIdents.length + 1];
                    objectArray[0] = " ";
                    for (int i = 0; i < MultiScalarTableViewer.this.columnIdents.length; ++i) {
                        objectArray[i + 1] = MultiScalarTableViewer.this.columnIdents[i];
                    }
                }
                Object[][] objectArray2 = new Object[MultiScalarTableViewer.this.attModels.length][MultiScalarTableViewer.this.attModels[0].length + 1];
                this.setDataVector(objectArray2, objectArray);
                for (int i = 0; i < MultiScalarTableViewer.this.nbRows; ++i) {
                    this.setValueAt(MultiScalarTableViewer.this.rowIdents[i], i, 0);
                }
            } else {
                this.setDataVector(MultiScalarTableViewer.this.attModels, MultiScalarTableViewer.this.columnIdents);
            }
        }

        void addAttributeAt(int n, int n2, IAttribute iAttribute, SimpleScalarViewer simpleScalarViewer) {
            INumberScalar iNumberScalar = null;
            IStringScalar iStringScalar = null;
            if (iAttribute instanceof INumberScalar) {
                iNumberScalar = (INumberScalar)iAttribute;
            } else if (iAttribute instanceof IStringScalar) {
                iStringScalar = (IStringScalar)iAttribute;
            }
            if (iNumberScalar == null && iStringScalar == null) {
                return;
            }
            if (iNumberScalar != null) {
                iNumberScalar.addNumberScalarListener((INumberScalarListener)this);
            } else if (iStringScalar != null) {
                iStringScalar.addStringScalarListener((IStringScalarListener)this);
            }
            int n3 = n2;
            if (this.hasRowLabels) {
                n3 = n2 + 1;
            }
            this.setValueAt(simpleScalarViewer, n, n3);
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(0, new Integer(n));
            vector.add(1, new Integer(n3));
            if (!this.attMap.containsKey(iAttribute)) {
                this.attMap.put(iAttribute, vector);
            }
        }

        void addAttributeAt(int n, int n2, IAttribute iAttribute, SimpleEnumScalarViewer simpleEnumScalarViewer) {
            IEnumScalar iEnumScalar = null;
            if (iAttribute instanceof IEnumScalar) {
                iEnumScalar = (IEnumScalar)iAttribute;
            }
            if (iEnumScalar == null) {
                return;
            }
            int n3 = n2;
            if (this.hasRowLabels) {
                n3 = n2 + 1;
            }
            iEnumScalar.addEnumScalarListener((IEnumScalarListener)this);
            this.setValueAt(simpleEnumScalarViewer, n, n3);
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(0, new Integer(n));
            vector.add(1, new Integer(n3));
            if (!this.attMap.containsKey(iAttribute)) {
                this.attMap.put(iAttribute, vector);
            }
        }

        void addAttributeAt(int n, int n2, IAttribute iAttribute, BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer) {
            IBooleanScalar iBooleanScalar = null;
            if (iAttribute instanceof IBooleanScalar) {
                iBooleanScalar = (IBooleanScalar)iAttribute;
            }
            if (iBooleanScalar == null) {
                return;
            }
            int n3 = n2;
            if (this.hasRowLabels) {
                n3 = n2 + 1;
            }
            iBooleanScalar.addBooleanScalarListener((IBooleanScalarListener)this);
            this.setValueAt(booleanScalarCheckBoxViewer, n, n3);
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(0, new Integer(n));
            vector.add(1, new Integer(n3));
            if (!this.attMap.containsKey(iAttribute)) {
                this.attMap.put(iAttribute, vector);
            }
        }

        void removeAttributeAt(int n, int n2) {
            Object object;
            int n3 = n2;
            if (this.hasRowLabels) {
                n3 = n2 + 1;
            }
            if ((object = this.getValueAt(n, n3)) == null) {
                return;
            }
            if (object instanceof SimpleScalarViewer) {
                SimpleScalarViewer simpleScalarViewer = (SimpleScalarViewer)object;
                this.removeAttributeAt(simpleScalarViewer, n, n3);
                return;
            }
            if (object instanceof SimpleEnumScalarViewer) {
                SimpleEnumScalarViewer simpleEnumScalarViewer = (SimpleEnumScalarViewer)object;
                this.removeAttributeAt(simpleEnumScalarViewer, n, n3);
                return;
            }
            if (object instanceof BooleanScalarCheckBoxViewer) {
                BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = (BooleanScalarCheckBoxViewer)object;
                this.removeAttributeAt(booleanScalarCheckBoxViewer, n, n3);
                return;
            }
        }

        private void removeAttributeAt(SimpleScalarViewer simpleScalarViewer, int n, int n2) {
            INumberScalar iNumberScalar = simpleScalarViewer.getNumberModel();
            IStringScalar iStringScalar = simpleScalarViewer.getStringModel();
            if (iNumberScalar != null) {
                if (this.attMap.containsKey(iNumberScalar)) {
                    this.attMap.remove(iNumberScalar);
                }
                iNumberScalar.removeNumberScalarListener((INumberScalarListener)this);
            } else if (iStringScalar != null) {
                if (this.attMap.containsKey(iStringScalar)) {
                    this.attMap.remove(iStringScalar);
                }
                iStringScalar.removeStringScalarListener((IStringScalarListener)this);
            }
            simpleScalarViewer.clearModel();
            simpleScalarViewer = null;
            this.setValueAt(null, n, n2);
        }

        private void removeAttributeAt(SimpleEnumScalarViewer simpleEnumScalarViewer, int n, int n2) {
            IEnumScalar iEnumScalar = simpleEnumScalarViewer.getModel();
            if (iEnumScalar != null) {
                if (this.attMap.containsKey(iEnumScalar)) {
                    this.attMap.remove(iEnumScalar);
                }
                iEnumScalar.removeEnumScalarListener((IEnumScalarListener)this);
            }
            simpleEnumScalarViewer.clearModel();
            simpleEnumScalarViewer = null;
            this.setValueAt(null, n, n2);
        }

        private void removeAttributeAt(BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer, int n, int n2) {
            IBooleanScalar iBooleanScalar = booleanScalarCheckBoxViewer.getAttModel();
            if (iBooleanScalar != null) {
                if (this.attMap.containsKey(iBooleanScalar)) {
                    this.attMap.remove(iBooleanScalar);
                }
                iBooleanScalar.removeBooleanScalarListener((IBooleanScalarListener)this);
            }
            booleanScalarCheckBoxViewer.clearModel();
            booleanScalarCheckBoxViewer = null;
            this.setValueAt(null, n, n2);
        }

        boolean getHasRowLabels() {
            return this.hasRowLabels;
        }

        public void stateChange(AttributeStateEvent attributeStateEvent) {
            IAttribute iAttribute = (IAttribute)attributeStateEvent.getSource();
            this.doUpdateAttCell(iAttribute);
        }

        public void errorChange(ErrorEvent errorEvent) {
            Object object = errorEvent.getSource();
            if (object instanceof IAttribute) {
                IAttribute iAttribute = (IAttribute)object;
                this.doUpdateAttCell(iAttribute);
            }
        }

        public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
            INumberScalar iNumberScalar = numberScalarEvent.getNumberSource();
            this.doUpdateAttCell((IAttribute)iNumberScalar);
        }

        public void stringScalarChange(StringScalarEvent stringScalarEvent) {
            IStringScalar iStringScalar = (IStringScalar)stringScalarEvent.getSource();
            this.doUpdateAttCell((IAttribute)iStringScalar);
        }

        public void enumScalarChange(EnumScalarEvent enumScalarEvent) {
            IEnumScalar iEnumScalar = (IEnumScalar)enumScalarEvent.getSource();
            this.doUpdateAttCell((IAttribute)iEnumScalar);
        }

        public void booleanScalarChange(BooleanScalarEvent booleanScalarEvent) {
            IBooleanScalar iBooleanScalar = (IBooleanScalar)booleanScalarEvent.getSource();
            this.doUpdateAttCell((IAttribute)iBooleanScalar);
        }

        private void doUpdateAttCell(IAttribute iAttribute) {
            if (!this.attMap.containsKey(iAttribute)) {
                return;
            }
            Object v = this.attMap.get(iAttribute);
            if (!(v instanceof Vector)) {
                return;
            }
            Vector vector = (Vector)v;
            if (vector.size() >= 2) {
                Integer n = (Integer)vector.get(0);
                int n2 = n;
                n = (Integer)vector.get(1);
                int n3 = n;
                this.fireTableCellUpdated(n2, n3);
            }
        }
    }
}

