/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.IRefresherListener;
import fr.esrf.tangoatk.widget.attribute.BooleanChart;
import fr.esrf.tangoatk.widget.attribute.BooleanConfigPanel;
import fr.esrf.tangoatk.widget.attribute.BooleanTrendRenderer;
import fr.esrf.tangoatk.widget.attribute.BooleanTrendSelectionNode;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.IControlee;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class BooleanTrend
extends JPanel
implements IControlee,
ActionListener,
IJLChartActionListener,
IRefresherListener {
    public static final int SEL_NONE = 0;
    public static final int SEL_Y1 = 2;
    public static final int SEL_Y2 = 3;
    public static final int DEVICE_LABEL_AUTO = 0;
    public static final int DEVICE_LABEL_NEVER = 1;
    public static final int DEVICE_LABEL_ALWAYS = 2;
    static final Color[] defaultColor = new Color[]{Color.red, Color.blue, Color.cyan, Color.green, Color.magenta, Color.orange, Color.pink, Color.yellow, Color.black};
    protected JFrame parent = null;
    protected JToolBar theToolBar;
    protected JPopupMenu toolMenu;
    protected JButton optionButton;
    protected JMenuItem optionMenuI;
    protected JButton stopButton;
    protected JMenuItem stopMenuI;
    protected JButton startButton;
    protected JMenuItem startMenuI;
    protected JButton loadButton;
    protected JMenuItem loadMenuI;
    protected JButton saveButton;
    protected JMenuItem saveMenuI;
    protected JButton zoomButton;
    protected JMenuItem zoomMenuI;
    protected JButton timeButton;
    protected JMenuItem timeMenuI;
    protected JButton cfgButton;
    protected JMenuItem cfgMenuI;
    protected JMenuItem showtoolMenuI;
    protected JPanel innerPanel;
    protected JLabel dateLabel;
    protected JScrollPane treeView = null;
    protected JTree mainTree = null;
    protected DefaultTreeModel mainTreeModel = null;
    protected BooleanTrendSelectionNode rootNode = null;
    protected JPopupMenu treeMenu;
    protected JMenuItem addY1MenuItem;
    protected JMenuItem addY2MenuItem;
    protected JMenuItem removeMenuItem;
    protected JMenuItem optionMenuItem;
    protected JMenuItem attOptionMenuItem;
    protected BooleanChart theGraph;
    protected String graphTitle = "";
    protected BooleanConfigPanel cfgPanel = null;
    protected static Point framePos = new Point(0, 0);
    protected static Point frameDimension = new Point(640, 480);
    protected AttributePolledList attList = null;
    protected BooleanTrendSelectionNode lastAdded = null;
    protected AttributePolledList lastCreatedList = null;
    protected SimplePropertyFrame propFrame = null;
    protected String lastConfig = "";
    protected boolean singleDevice = true;
    protected int isShowingDeviceName = 0;
    protected static final GregorianCalendar calendar = new GregorianCalendar();
    protected static final SimpleDateFormat genFormat = new SimpleDateFormat("EEE dd/MM/yy HH:mm:ss");
    protected Map buttonMap = new HashMap();
    public static final String start = "START";
    public static final String stop = "STOP";
    public static final String save = "SAVE";
    public static final String load = "LOAD";
    public static final String zoom = "ZOOM";
    public static final String time = "TIME";
    public static final String option = "OPTION";
    public static final String config = "CONFIG";
    protected int timePrecision = 0;
    protected static final String[] labels = new String[]{"true", "false"};
    protected static final double[] labelPositions = new double[]{1.0, 0.0};
    protected static final double[] defaultMinMax = new double[]{-0.01, 1.1};
    protected static final IEntityFilter booleanFilter = new IEntityFilter(){

        public boolean keep(IEntity iEntity) {
            return iEntity instanceof IBooleanScalar;
        }
    };

    public BooleanTrend(JFrame jFrame) {
        this();
        this.parent = jFrame;
    }

    public BooleanTrend() {
        this.theToolBar = new JToolBar();
        this.toolMenu = new JPopupMenu();
        this.optionButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_settings.gif")));
        this.optionButton.setToolTipText("Global settings");
        this.optionMenuI = new JMenuItem("Global settings");
        this.stopButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_stop.gif")));
        this.stopButton.setToolTipText("Stop monitoring");
        this.stopMenuI = new JMenuItem("Stop monitoring");
        this.startButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_start.gif")));
        this.startButton.setToolTipText("Start monitoring");
        this.startMenuI = new JMenuItem("Start monitoring");
        this.loadButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_load.gif")));
        this.loadButton.setToolTipText("Load configuration");
        this.loadMenuI = new JMenuItem("Load configuration");
        this.saveButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_save.gif")));
        this.saveButton.setToolTipText("Save configuration");
        this.saveMenuI = new JMenuItem("Save configuration");
        this.zoomButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_zoom.gif")));
        this.zoomButton.setToolTipText("Zoom");
        this.zoomMenuI = new JMenuItem("Zoom");
        this.timeButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_time.gif")));
        this.timeButton.setToolTipText("Set refresh interval");
        this.timeMenuI = new JMenuItem("Set refresh interval");
        this.cfgButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_config.gif")));
        this.cfgButton.setToolTipText("Add new attribute");
        this.cfgMenuI = new JMenuItem("Add new attribute");
        this.showtoolMenuI = new JMenuItem("Hide toolbar");
        this.theToolBar.setFloatable(true);
        this.loadButton.addActionListener(this);
        this.loadMenuI.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.saveMenuI.addActionListener(this);
        this.optionButton.addActionListener(this);
        this.optionMenuI.addActionListener(this);
        this.zoomButton.addActionListener(this);
        this.zoomMenuI.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.stopMenuI.addActionListener(this);
        this.startButton.addActionListener(this);
        this.startMenuI.addActionListener(this);
        this.timeButton.addActionListener(this);
        this.timeMenuI.addActionListener(this);
        this.cfgButton.addActionListener(this);
        this.cfgMenuI.addActionListener(this);
        this.showtoolMenuI.addActionListener(this);
        this.theToolBar.add(this.loadButton);
        this.theToolBar.add(this.saveButton);
        this.theToolBar.add(this.optionButton);
        this.theToolBar.add(this.zoomButton);
        this.theToolBar.add(this.startButton);
        this.theToolBar.add(this.stopButton);
        this.theToolBar.add(this.timeButton);
        this.theToolBar.add(this.cfgButton);
        this.buttonMap.put(load, this.loadButton);
        this.buttonMap.put(save, this.saveButton);
        this.buttonMap.put(option, this.optionButton);
        this.buttonMap.put(zoom, this.zoomButton);
        this.buttonMap.put(start, this.startButton);
        this.buttonMap.put(stop, this.stopButton);
        this.buttonMap.put(time, this.timeButton);
        this.buttonMap.put(config, this.cfgButton);
        this.toolMenu.add(this.loadMenuI);
        this.toolMenu.add(this.saveMenuI);
        this.toolMenu.add(this.optionMenuI);
        this.toolMenu.add(this.zoomMenuI);
        this.toolMenu.add(this.startMenuI);
        this.toolMenu.add(this.stopMenuI);
        this.toolMenu.add(this.timeMenuI);
        this.toolMenu.add(this.cfgMenuI);
        this.toolMenu.add(this.showtoolMenuI);
        this.theGraph = new BooleanChart();
        this.theGraph.setBorder(new EtchedBorder());
        this.theGraph.setBackground(new Color(180, 180, 180));
        this.theGraph.getY1Axis().setAutoScale(false);
        this.theGraph.getY1Axis().setMinimum(defaultMinMax[0]);
        this.theGraph.getY1Axis().setMaximum(defaultMinMax[1]);
        this.theGraph.getY1Axis().setLabels(labels, labelPositions);
        this.theGraph.getY2Axis().setAutoScale(false);
        this.theGraph.getY2Axis().setMinimum(defaultMinMax[0]);
        this.theGraph.getY2Axis().setMaximum(defaultMinMax[1]);
        this.theGraph.getY2Axis().setLabels(labels, labelPositions);
        this.theGraph.getXAxis().setAutoScale(true);
        this.theGraph.setDisplayDuration(300000.0);
        this.theGraph.addUserAction("chkShow toolbar");
        this.theGraph.addUserAction("chkShow selection tree");
        this.theGraph.addUserAction("chkShow date");
        this.theGraph.addUserAction("Load configuration");
        this.theGraph.addUserAction("Save configuration");
        this.theGraph.addJLChartActionListener(this);
        this.theGraph.setMaxDisplayDuration(8.64E7);
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.theToolBar, "North");
        this.innerPanel.add((Component)this.theGraph, "Center");
        this.add((Component)this.innerPanel, "Center");
        this.treeMenu = new JPopupMenu();
        this.addY1MenuItem = new JMenuItem("Add to Y1");
        this.addY2MenuItem = new JMenuItem("Add to Y2");
        this.removeMenuItem = new JMenuItem("Remove");
        this.optionMenuItem = new JMenuItem("Graphic properties");
        this.attOptionMenuItem = new JMenuItem("Attribute properties");
        this.treeMenu.add(this.addY1MenuItem);
        this.treeMenu.add(this.addY2MenuItem);
        this.treeMenu.add(this.removeMenuItem);
        this.treeMenu.add(this.optionMenuItem);
        this.treeMenu.add(this.attOptionMenuItem);
        this.addY1MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = BooleanTrend.this.mainTree.getSelectionPaths();
                for (int i = 0; i < treePathArray.length; ++i) {
                    BooleanTrendSelectionNode booleanTrendSelectionNode = (BooleanTrendSelectionNode)treePathArray[i].getLastPathComponent();
                    if (booleanTrendSelectionNode.getModel() == null || booleanTrendSelectionNode.getSelected() == 2) continue;
                    booleanTrendSelectionNode.setSelected(2);
                }
                BooleanTrend.this.mainTree.repaint();
                BooleanTrend.this.theGraph.repaint();
            }
        });
        this.addY2MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = BooleanTrend.this.mainTree.getSelectionPaths();
                for (int i = 0; i < treePathArray.length; ++i) {
                    BooleanTrendSelectionNode booleanTrendSelectionNode = (BooleanTrendSelectionNode)treePathArray[i].getLastPathComponent();
                    if (booleanTrendSelectionNode.getModel() == null || booleanTrendSelectionNode.getSelected() == 3) continue;
                    booleanTrendSelectionNode.setSelected(3);
                }
                BooleanTrend.this.mainTree.repaint();
                BooleanTrend.this.theGraph.repaint();
            }
        });
        this.removeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreePath[] treePathArray = BooleanTrend.this.mainTree.getSelectionPaths();
                for (int i = 0; i < treePathArray.length; ++i) {
                    BooleanTrendSelectionNode booleanTrendSelectionNode = (BooleanTrendSelectionNode)treePathArray[i].getLastPathComponent();
                    if (booleanTrendSelectionNode.getModel() == null) continue;
                    booleanTrendSelectionNode.setSelected(0);
                }
                BooleanTrend.this.mainTree.repaint();
                BooleanTrend.this.theGraph.repaint();
            }
        });
        this.optionMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BooleanTrendSelectionNode booleanTrendSelectionNode = (BooleanTrendSelectionNode)BooleanTrend.this.mainTree.getSelectionPath().getLastPathComponent();
                IBooleanScalar iBooleanScalar = booleanTrendSelectionNode.getModel();
                if (iBooleanScalar != null) {
                    booleanTrendSelectionNode.showOptions();
                }
            }
        });
        this.attOptionMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BooleanTrendSelectionNode booleanTrendSelectionNode = (BooleanTrendSelectionNode)BooleanTrend.this.mainTree.getSelectionPath().getLastPathComponent();
                IBooleanScalar iBooleanScalar = booleanTrendSelectionNode.getModel();
                if (iBooleanScalar != null) {
                    if (BooleanTrend.this.propFrame == null) {
                        BooleanTrend.this.propFrame = new SimplePropertyFrame();
                    }
                    BooleanTrend.this.propFrame.setModel((IAttribute)iBooleanScalar);
                    BooleanTrend.this.propFrame.setVisible(true);
                }
            }
        });
        calendar.setTimeInMillis(System.currentTimeMillis());
        this.dateLabel = new JLabel();
        this.dateLabel.setText(genFormat.format(calendar.getTime()));
        this.dateLabel.setHorizontalAlignment(0);
        this.dateLabel.setVisible(false);
        this.add((Component)this.dateLabel, "South");
    }

    void refreshNode(BooleanTrendSelectionNode booleanTrendSelectionNode) {
        this.theGraph.repaint();
        this.mainTreeModel.nodeChanged(booleanTrendSelectionNode);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.optionButton || object == this.optionMenuI) {
            this.optionButtonActionPerformed();
        } else if (object == this.stopButton || object == this.stopMenuI) {
            this.attList.stopRefresher();
        } else if (object == this.startButton || object == this.startMenuI) {
            this.attList.startRefresher();
        } else if (object == this.loadButton || object == this.loadMenuI) {
            this.loadButtonActionPerformed();
        } else if (object == this.saveButton || object == this.saveMenuI) {
            this.saveButtonActionPerformed();
        } else if (object == this.zoomButton || object == this.zoomMenuI) {
            if (!this.theGraph.isZoomed()) {
                this.theGraph.enterZoom();
            } else {
                this.theGraph.exitZoom();
            }
        } else if (object == this.timeButton || object == this.timeMenuI) {
            this.setRefreshInterval();
        } else if (object == this.cfgButton || object == this.cfgMenuI) {
            if (this.cfgPanel == null) {
                Window window = ATKGraphicsUtils.getWindowForComponent(this);
                this.cfgPanel = window instanceof Frame ? new BooleanConfigPanel((Frame)window, this) : (window instanceof Dialog ? new BooleanConfigPanel((Dialog)window, this) : new BooleanConfigPanel((Frame)null, this));
            }
            this.cfgPanel.showPanel();
        } else if (object == this.showtoolMenuI) {
            boolean bl = this.isButtonBarVisible();
            bl = !bl;
            this.setButtonBarVisible(bl);
        }
    }

    public void actionPerformed(JLChartActionEvent jLChartActionEvent) {
        if (jLChartActionEvent.getName().equals("Show toolbar")) {
            this.setButtonBarVisible(jLChartActionEvent.getState());
        } else if (jLChartActionEvent.getName().equals("Show selection tree")) {
            this.setSelectionTreeVisible(jLChartActionEvent.getState());
        } else if (jLChartActionEvent.getName().equals("Show date")) {
            this.setDateVisible(jLChartActionEvent.getState());
        } else if (jLChartActionEvent.getName().equalsIgnoreCase("Load configuration")) {
            this.loadButtonActionPerformed();
        } else if (jLChartActionEvent.getName().equalsIgnoreCase("Save configuration")) {
            this.saveButtonActionPerformed();
        }
    }

    public boolean getActionState(JLChartActionEvent jLChartActionEvent) {
        if (jLChartActionEvent.getName().equals("Show toolbar")) {
            return this.isButtonBarVisible();
        }
        if (jLChartActionEvent.getName().equals("Show selection tree")) {
            return this.isSelectionTreeVisible();
        }
        if (jLChartActionEvent.getName().equals("Show date")) {
            return this.isDateVisible();
        }
        return false;
    }

    public int getTimePrecision() {
        return this.timePrecision;
    }

    public void setTimePrecision(int n) {
        this.timePrecision = n;
        if (this.theGraph != null) {
            this.theGraph.setTimePrecision(n);
        }
    }

    public void refreshStep() {
        if (this.isDateVisible()) {
            calendar.setTimeInMillis(System.currentTimeMillis());
            this.dateLabel.setText(genFormat.format(calendar.getTime()));
        }
        this.theGraph.repaint();
    }

    private void setRefreshInterval() {
        int n = this.attList.getRefreshInterval();
        String string = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(n));
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                this.attList.setRefreshInterval(n2);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.parent, "Invalid number !", "Error", 0);
            }
        }
    }

    private void updateModel() {
        this.singleDevice = true;
        if (this.attList != null) {
            int n;
            Vector vector;
            int n2 = this.attList.size();
            if (n2 > 1) {
                vector = (IBooleanScalar)this.attList.get(0);
                String string = vector.getDevice().getName();
                for (n = 1; n < n2 && this.singleDevice; ++n) {
                    vector = (IBooleanScalar)this.attList.get(n);
                    this.singleDevice = string.equalsIgnoreCase(vector.getDevice().getName());
                }
            }
            vector = this.rootNode.getSelectableItems();
            for (n = 0; n < vector.size(); ++n) {
                ((BooleanTrendSelectionNode)vector.get(n)).refreshNode();
            }
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    public void setModel(AttributePolledList attributePolledList) {
        Serializable serializable;
        int n;
        this.theGraph.unselectAll();
        if (this.attList != null) {
            this.attList.stopRefresher();
            this.attList.removeRefresherListener((IRefresherListener)this);
            this.attList.clear();
        }
        if (this.rootNode != null) {
            Vector vector = this.rootNode.getSelectableItems();
            for (n = 0; n < vector.size(); ++n) {
                serializable = (BooleanTrendSelectionNode)vector.get(n);
                ((BooleanTrendSelectionNode)serializable).clearModel();
            }
        }
        if (this.lastCreatedList != null) {
            this.lastCreatedList.stopRefresher();
            this.lastCreatedList.clear();
            this.lastCreatedList = null;
        }
        this.rootNode = new BooleanTrendSelectionNode(this);
        if (attributePolledList != null) {
            for (n = 0; n < attributePolledList.size(); ++n) {
                if (!(attributePolledList.get(n) instanceof IBooleanScalar)) continue;
                int n2 = n;
                this.lastAdded = this.rootNode.addItem(this, (IBooleanScalar)attributePolledList.get(n2), defaultColor[n2 % defaultColor.length]);
            }
        }
        serializable = new BooleanTrendRenderer();
        this.mainTreeModel = new DefaultTreeModel(this.rootNode);
        this.mainTree = new JTree(this.mainTreeModel);
        this.mainTree.setCellRenderer((TreeCellRenderer)((Object)serializable));
        this.mainTree.setEditable(false);
        this.mainTree.getSelectionModel().setSelectionMode(4);
        this.mainTree.setShowsRootHandles(true);
        this.mainTree.setRootVisible(true);
        this.mainTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.mainTree);
        this.mainTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                BooleanTrend.this.revalidate();
                int n = BooleanTrend.this.mainTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath[] treePathArray = BooleanTrend.this.mainTree.getSelectionPaths();
                if (n != -1 && mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3 && treePathArray != null && treePathArray.length > 0) {
                    if (treePathArray.length == 1) {
                        BooleanTrendSelectionNode booleanTrendSelectionNode = (BooleanTrendSelectionNode)treePathArray[0].getLastPathComponent();
                        if (booleanTrendSelectionNode.getModel() != null) {
                            BooleanTrend.this.addY1MenuItem.setEnabled(booleanTrendSelectionNode.getSelected() != 2);
                            BooleanTrend.this.addY2MenuItem.setEnabled(booleanTrendSelectionNode.getSelected() != 3);
                            BooleanTrend.this.removeMenuItem.setEnabled(booleanTrendSelectionNode.getSelected() != 0);
                            BooleanTrend.this.treeMenu.show(BooleanTrend.this.mainTree, mouseEvent.getX(), mouseEvent.getY());
                        } else if (booleanTrendSelectionNode == BooleanTrend.this.rootNode) {
                            if (BooleanTrend.this.isButtonBarVisible()) {
                                BooleanTrend.this.showtoolMenuI.setText("Hide toolbar");
                            } else {
                                BooleanTrend.this.showtoolMenuI.setText("Show toolbar");
                            }
                            BooleanTrend.this.toolMenu.show(BooleanTrend.this.mainTree, mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else {
                        BooleanTrendSelectionNode booleanTrendSelectionNode = null;
                        int n2 = 0;
                        boolean bl = false;
                        for (int i = 0; i < treePathArray.length; ++i) {
                            BooleanTrendSelectionNode booleanTrendSelectionNode2 = (BooleanTrendSelectionNode)treePathArray[i].getLastPathComponent();
                            if (booleanTrendSelectionNode2.getModel() != null) {
                                ++n2;
                                booleanTrendSelectionNode = booleanTrendSelectionNode2;
                                continue;
                            }
                            if (booleanTrendSelectionNode2 != BooleanTrend.this.rootNode) continue;
                            bl = true;
                        }
                        if (n2 > 0) {
                            if (n2 == 1) {
                                BooleanTrend.this.addY1MenuItem.setEnabled(booleanTrendSelectionNode.getSelected() != 2);
                                BooleanTrend.this.addY2MenuItem.setEnabled(booleanTrendSelectionNode.getSelected() != 3);
                                BooleanTrend.this.removeMenuItem.setEnabled(booleanTrendSelectionNode.getSelected() != 0);
                            } else {
                                BooleanTrend.this.addY1MenuItem.setEnabled(true);
                                BooleanTrend.this.addY2MenuItem.setEnabled(true);
                                BooleanTrend.this.removeMenuItem.setEnabled(true);
                            }
                            BooleanTrend.this.treeMenu.show(BooleanTrend.this.mainTree, mouseEvent.getX(), mouseEvent.getY());
                            booleanTrendSelectionNode = null;
                        } else if (bl) {
                            if (BooleanTrend.this.isButtonBarVisible()) {
                                BooleanTrend.this.showtoolMenuI.setText("Hide toolbar");
                            } else {
                                BooleanTrend.this.showtoolMenuI.setText("Show toolbar");
                            }
                            BooleanTrend.this.toolMenu.show(BooleanTrend.this.mainTree, mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                }
            }
        });
        this.innerPanel.add((Component)this.treeView, "West");
        this.attList = attributePolledList;
        if (this.attList != null) {
            this.attList.addRefresherListener((IRefresherListener)this);
        }
        this.updateModel();
    }

    public void addAttribute(String string) {
        try {
            if (this.attList == null) {
                AttributePolledList attributePolledList = new AttributePolledList();
                attributePolledList.setFilter(booleanFilter);
                attributePolledList.add(string);
                this.setModel(attributePolledList);
                this.lastCreatedList = attributePolledList;
                attributePolledList.setRefreshInterval(1000);
                attributePolledList.startRefresher();
            } else if (this.attList.get(string) == null) {
                IBooleanScalar iBooleanScalar = (IBooleanScalar)this.attList.add(string);
                int n = this.attList.size();
                this.lastAdded = this.rootNode.addItem(this, iBooleanScalar, defaultColor[n % defaultColor.length]);
                this.mainTreeModel = new DefaultTreeModel(this.rootNode);
                this.mainTree.setModel(this.mainTreeModel);
            }
            TreePath treePath = new TreePath(this.lastAdded.getPath());
            this.mainTree.setSelectionPath(treePath);
            this.mainTree.expandPath(treePath);
            this.mainTree.makeVisible(treePath);
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        this.updateModel();
        this.theGraph.repaint();
        this.innerPanel.revalidate();
    }

    public void addAttribute(IBooleanScalar iBooleanScalar) {
        if (this.attList == null) {
            AttributePolledList attributePolledList = new AttributePolledList();
            attributePolledList.setFilter(booleanFilter);
            attributePolledList.add((IEntity)iBooleanScalar);
            this.setModel(attributePolledList);
            this.lastCreatedList = attributePolledList;
            attributePolledList.setRefreshInterval(1000);
            attributePolledList.startRefresher();
        } else if (!this.attList.contains((Object)iBooleanScalar)) {
            this.attList.add((IEntity)iBooleanScalar);
            int n = this.attList.size();
            this.lastAdded = this.rootNode.addItem(this, iBooleanScalar, defaultColor[n % defaultColor.length]);
            this.mainTreeModel = new DefaultTreeModel(this.rootNode);
            this.mainTree.setModel(this.mainTreeModel);
        }
        TreePath treePath = new TreePath(this.lastAdded.getPath());
        this.mainTree.setSelectionPath(treePath);
        this.mainTree.expandPath(treePath);
        this.mainTree.makeVisible(treePath);
        this.updateModel();
        this.theGraph.repaint();
        this.innerPanel.revalidate();
    }

    public void removeAttribute(IBooleanScalar iBooleanScalar) {
        this.lastAdded = null;
        if (this.attList.contains((Object)iBooleanScalar)) {
            System.out.println("Removing " + iBooleanScalar.getName());
            this.rootNode.delItem(iBooleanScalar);
            this.attList.remove(iBooleanScalar.getName());
            this.mainTreeModel = new DefaultTreeModel(this.rootNode);
            this.mainTree.setModel(this.mainTreeModel);
            this.innerPanel.revalidate();
            this.updateModel();
        }
    }

    public AttributePolledList getModel() {
        return this.attList;
    }

    private void optionButtonActionPerformed() {
        this.theGraph.showOptionDialog();
    }

    private String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    private void saveButtonActionPerformed() {
        File file;
        int n;
        int n2 = 0;
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = BooleanTrend.this.getExtension(file);
                return string != null && string.equals("txt");
            }

            public String getDescription() {
                return "text files ";
            }
        });
        if (this.lastConfig.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((n = jFileChooser.showSaveDialog(this.parent)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            if (this.getExtension(file) == null) {
                file = new File(file.getAbsolutePath() + ".txt");
            }
            if (file.exists()) {
                n2 = JOptionPane.showConfirmDialog(this.parent, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
            }
            if (n2 == 0) {
                this.saveSetting(file.getAbsolutePath());
            }
        }
    }

    private void loadButtonActionPerformed() {
        String string;
        File file;
        int n;
        boolean bl = false;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = BooleanTrend.this.getExtension(file);
                return string != null && string.equals("txt");
            }

            public String getDescription() {
                return "text files ";
            }
        });
        if (this.lastConfig.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((n = jFileChooser.showOpenDialog(this.parent)) == 0 && (file = jFileChooser.getSelectedFile()) != null && !bl && (string = this.loadSetting(file.getAbsolutePath())).length() > 0) {
            JOptionPane.showMessageDialog(this.parent, string, "Errors reading " + file.getName(), 0);
        }
    }

    public String getSettings() {
        String string = "";
        string = string + this.theGraph.getConfiguration();
        string = string + "toolbar_visible:" + this.isButtonBarVisible() + "\n";
        string = string + "tree_visible:" + this.isSelectionTreeVisible() + "\n";
        string = string + "date_visible:" + this.isDateVisible() + "\n";
        if (this.graphTitle.length() > 0) {
            string = string + "frame_title:'" + this.graphTitle + "'\n";
        }
        string = string + "window_pos:" + this.getLocationOnScreen().x + "," + this.getLocationOnScreen().y + "\n";
        string = string + "window_size:" + this.getSize().width + "," + this.getSize().height + "\n";
        string = string + "show_device_name:" + this.isShowingDeviceNames() + "\n";
        if (this.attList != null) {
            string = string + "refresh_time:" + this.attList.getRefreshInterval() + "\n";
        }
        string = string + this.theGraph.getXAxis().getConfiguration("x");
        string = string + this.theGraph.getY1Axis().getConfiguration("y1");
        string = string + this.theGraph.getY2Axis().getConfiguration("y2");
        if (this.rootNode == null) {
            return string;
        }
        Vector vector = this.rootNode.getSelectableItems();
        string = string + "dv_number:" + vector.size() + "\n";
        for (int i = 0; i < vector.size(); ++i) {
            BooleanTrendSelectionNode booleanTrendSelectionNode = (BooleanTrendSelectionNode)vector.get(i);
            string = string + "dv" + i + "_name:'" + booleanTrendSelectionNode.getModelName() + "'\n";
            string = string + "dv" + i + "_selected:" + booleanTrendSelectionNode.getSelected() + "\n";
            string = string + booleanTrendSelectionNode.getData().getConfiguration("dv" + i);
        }
        return string;
    }

    private String applySettings(CfFileReader cfFileReader) {
        int n;
        int n2;
        String string = "";
        this.theGraph.setMaxDisplayDuration(Double.POSITIVE_INFINITY);
        this.theGraph.setDisplayDuration(Double.POSITIVE_INFINITY);
        AttributePolledList attributePolledList = new AttributePolledList();
        attributePolledList.setFilter(booleanFilter);
        Vector vector = cfFileReader.getParam("dv_number");
        if (vector != null) {
            try {
                n2 = Integer.parseInt(vector.get(0).toString());
            }
            catch (NumberFormatException numberFormatException) {
                string = string + "dv_number: invalid number\n";
                return string;
            }
            for (n = 0; n < n2; ++n) {
                vector = cfFileReader.getParam("dv" + n + "_name");
                if (vector == null) {
                    string = string + "Unable to find dv" + n + "_name param\n";
                    return string;
                }
                try {
                    attributePolledList.add(vector.get(0).toString());
                    continue;
                }
                catch (Exception exception) {
                    string = string + exception.getMessage() + "\n";
                }
            }
            if (n2 > 0) {
                if (this.attList != null) {
                    this.innerPanel.remove(this.treeView);
                    this.treeView = null;
                    this.mainTree = null;
                }
                if ((vector = cfFileReader.getParam("refresh_time")) != null) {
                    attributePolledList.setRefreshInterval(OFormat.getInt(vector.get(0).toString()));
                } else {
                    attributePolledList.setRefreshInterval(1000);
                }
                attributePolledList.startRefresher();
                this.setModel(attributePolledList);
                this.lastCreatedList = attributePolledList;
            }
        } else {
            n2 = 0;
        }
        this.innerPanel.revalidate();
        this.theGraph.applyConfiguration(cfFileReader);
        this.theGraph.setMaxDisplayDuration(8.64E7);
        vector = cfFileReader.getParam("toolbar_visible");
        if (vector != null) {
            this.setButtonBarVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("tree_visible")) != null) {
            this.setSelectionTreeVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("date_visible")) != null) {
            this.setDateVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("frame_title")) != null) {
            this.graphTitle = vector.get(0).toString();
        }
        if ((vector = cfFileReader.getParam("window_pos")) != null) {
            framePos = OFormat.getPoint(vector);
        }
        if ((vector = cfFileReader.getParam("window_size")) != null) {
            frameDimension = OFormat.getPoint(vector);
        }
        if ((vector = cfFileReader.getParam("show_device_name")) != null) {
            this.setShowingDeviceNames(OFormat.getInt(vector.get(0).toString()));
        }
        this.theGraph.getXAxis().applyConfiguration("x", cfFileReader);
        this.theGraph.getY1Axis().applyConfiguration("y1", cfFileReader);
        this.theGraph.getY2Axis().applyConfiguration("y2", cfFileReader);
        if (this.rootNode == null) {
            return string;
        }
        Vector vector2 = this.rootNode.getSelectableItems();
        BooleanTrendSelectionNode booleanTrendSelectionNode = null;
        for (n = 0; n < n2; ++n) {
            String string2 = "dv" + n;
            vector = cfFileReader.getParam(string2 + "_name");
            String string3 = vector.get(0).toString();
            vector = cfFileReader.getParam(string2 + "_selected");
            if (vector == null) continue;
            int n3 = OFormat.getInt(vector.get(0).toString());
            int n4 = 0;
            boolean bl = false;
            while (!bl && n4 < vector2.size()) {
                booleanTrendSelectionNode = (BooleanTrendSelectionNode)vector2.get(n4);
                bl = booleanTrendSelectionNode.getModelName().equals(string3);
                if (bl) continue;
                ++n4;
            }
            if (!bl) continue;
            if (n3 > 0) {
                booleanTrendSelectionNode.setSelected(n3);
            }
            JLDataView jLDataView = booleanTrendSelectionNode.getData();
            jLDataView.applyConfiguration(string2, cfFileReader);
        }
        return string;
    }

    public String setSetting(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.parseText(string)) {
            return "Trend.setSettings: Failed to parse given text";
        }
        return this.applySettings(cfFileReader);
    }

    public void saveSetting(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            String string2 = this.getSettings();
            fileWriter.write(string2, 0, string2.length());
            fileWriter.close();
            this.lastConfig = string;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.parent, "Failed to write " + string, "Error", 0);
        }
    }

    public String loadSetting(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.readFile(string)) {
            return "Failed to read " + string;
        }
        this.lastConfig = string;
        return this.applySettings(cfFileReader);
    }

    public String getTitle() {
        return this.graphTitle;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = 0;
        return dimension;
    }

    public void setLegendVisible(boolean bl) {
    }

    public boolean isLegendVisible() {
        return false;
    }

    public void setSamplingRate(double d) {
    }

    public double getSamplingRate() {
        return 0.0;
    }

    public void setXAxisLength(int n) {
    }

    public int getXAxisLength() {
        return 0;
    }

    public void setLogarithmicScale(boolean bl) {
    }

    public boolean isLogarithmicScale() {
        return false;
    }

    public void setListVisible(boolean bl) {
    }

    public boolean isListVisible() {
        return false;
    }

    public void setShowingNames(boolean bl) {
    }

    public boolean isShowingNames() {
        return false;
    }

    public void setShowingDeviceNames(int n) {
        this.isShowingDeviceName = n;
    }

    public int isShowingDeviceNames() {
        return this.isShowingDeviceName;
    }

    boolean displayDeviceNames() {
        switch (this.isShowingDeviceName) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return !this.singleDevice;
    }

    public void setButtonBarVisible(boolean bl) {
        if (this.theToolBar != null) {
            this.theToolBar.setVisible(bl);
        }
    }

    public boolean isButtonBarVisible() {
        if (this.theToolBar != null) {
            return this.theToolBar.isVisible();
        }
        return false;
    }

    public void setDateVisible(boolean bl) {
        if (this.dateLabel != null) {
            this.dateLabel.setVisible(bl);
        }
    }

    public boolean isDateVisible() {
        if (this.dateLabel != null) {
            return this.dateLabel.isVisible();
        }
        return false;
    }

    public void setSelectionTreeVisible(boolean bl) {
        if (this.treeView != null) {
            this.treeView.setVisible(bl);
            this.revalidate();
        }
    }

    public boolean isSelectionTreeVisible() {
        if (this.treeView != null) {
            return this.treeView.isVisible();
        }
        return false;
    }

    public JLChart getChart() {
        return this.theGraph;
    }

    public void ok() {
        this.getRootPane().getParent().setVisible(false);
    }

    public void disableButton(String string) {
        JButton jButton = (JButton)this.buttonMap.get(string);
        if (jButton != null) {
            jButton.setEnabled(false);
        }
    }

    public void enableButton(String string) {
        JButton jButton = (JButton)this.buttonMap.get(string);
        if (jButton != null) {
            jButton.setEnabled(true);
        }
    }

    public void addToAxis(String string, int n, boolean bl) {
        if (bl) {
            try {
                if (this.getModel() == null) {
                    this.addAttribute(string);
                } else if (this.getModel().get(string) == null) {
                    this.addAttribute(string);
                }
            }
            catch (ClassCastException classCastException) {
                return;
            }
        }
        if (this.rootNode == null) {
            return;
        }
        int n2 = 0;
        Vector vector = this.rootNode.getSelectableItems();
        BooleanTrendSelectionNode booleanTrendSelectionNode = null;
        boolean bl2 = false;
        while (!bl2 && n2 < vector.size()) {
            booleanTrendSelectionNode = (BooleanTrendSelectionNode)vector.get(n2);
            bl2 = booleanTrendSelectionNode != null && booleanTrendSelectionNode.getModel() != null && booleanTrendSelectionNode.getModel().getName().equals(string);
            if (bl2) continue;
            ++n2;
        }
        if (bl2) {
            switch (n) {
                case 0: 
                case 2: 
                case 3: {
                    booleanTrendSelectionNode.setSelected(n);
                    this.mainTree.repaint();
                    this.theGraph.repaint();
                }
            }
            return;
        }
    }

    public void addToAxis(IBooleanScalar iBooleanScalar, int n, boolean bl) {
        if (bl) {
            if (this.getModel() == null) {
                this.addAttribute(iBooleanScalar);
            } else if (this.getModel().get(iBooleanScalar.getName()) == null) {
                this.addAttribute(iBooleanScalar);
            }
        }
        if (this.rootNode == null) {
            return;
        }
        int n2 = 0;
        Vector vector = this.rootNode.getSelectableItems();
        BooleanTrendSelectionNode booleanTrendSelectionNode = null;
        boolean bl2 = false;
        while (!bl2 && n2 < vector.size()) {
            booleanTrendSelectionNode = (BooleanTrendSelectionNode)vector.get(n2);
            bl2 = booleanTrendSelectionNode != null && booleanTrendSelectionNode.getModel() != null && booleanTrendSelectionNode.getModel().getName().equals(iBooleanScalar.getName());
            if (bl2) continue;
            ++n2;
        }
        if (bl2) {
            switch (n) {
                case 0: 
                case 2: 
                case 3: {
                    booleanTrendSelectionNode.setSelected(n);
                    this.mainTree.repaint();
                    this.theGraph.repaint();
                }
            }
            return;
        }
    }

    public int getAxisForAttribute(String string) {
        int n = 0;
        if (this.rootNode == null) {
            return n;
        }
        int n2 = 0;
        Vector vector = this.rootNode.getSelectableItems();
        BooleanTrendSelectionNode booleanTrendSelectionNode = null;
        boolean bl = false;
        while (!bl && n2 < vector.size()) {
            booleanTrendSelectionNode = (BooleanTrendSelectionNode)vector.get(n2);
            bl = booleanTrendSelectionNode != null && booleanTrendSelectionNode.getModel() != null && booleanTrendSelectionNode.getModel().getName().equals(string);
            if (bl) continue;
            ++n2;
        }
        if (bl) {
            n = booleanTrendSelectionNode.getSelected();
        }
        return n;
    }

    public JLDataView getDataViewForAttribute(String string) {
        JLDataView jLDataView = null;
        if (this.rootNode == null) {
            return jLDataView;
        }
        int n = 0;
        Vector vector = this.rootNode.getSelectableItems();
        BooleanTrendSelectionNode booleanTrendSelectionNode = null;
        boolean bl = false;
        while (!bl && n < vector.size()) {
            booleanTrendSelectionNode = (BooleanTrendSelectionNode)vector.get(n);
            bl = booleanTrendSelectionNode != null && booleanTrendSelectionNode.getModel() != null && booleanTrendSelectionNode.getModel().getName().equals(string);
            if (bl) continue;
            ++n;
        }
        if (bl) {
            jLDataView = booleanTrendSelectionNode.getData();
        }
        return jLDataView;
    }

    public void setMaxDisplayDuration(double d) {
        this.theGraph.setMaxDisplayDuration(d);
    }

    public double getMaxDisplayDuration() {
        return this.theGraph.getMaxDisplayDuration();
    }

    public static void main(String[] stringArray) throws Exception {
        JFrame jFrame = new JFrame();
        BooleanTrend booleanTrend = new BooleanTrend();
        String string = "jlp/test/1/att_boolean";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            booleanTrend.addToAxis(string, 2, true);
        }
        catch (Exception exception) {
            System.out.println("Cannot connect to " + string);
            System.out.println("Try to load " + string + " as a file");
            try {
                booleanTrend.loadSetting(string);
            }
            catch (Exception exception2) {
                System.out.println("Failed to load " + string + " as a file. Exiting...");
                System.exit(-1);
            }
        }
        jFrame.setDefaultCloseOperation(3);
        if (booleanTrend.getTitle().length() > 0) {
            jFrame.setTitle(booleanTrend.getTitle());
        } else {
            jFrame.setTitle("BooleanTrends");
        }
        jFrame.setContentPane(booleanTrend);
        Image image = Toolkit.getDefaultToolkit().getImage(booleanTrend.getClass().getResource("/fr/esrf/tangoatk/widget/attribute/trend_icon.gif"));
        if (image != null) {
            jFrame.setIconImage(image);
        }
        jFrame.pack();
        jFrame.setBounds(BooleanTrend.framePos.x, BooleanTrend.framePos.y, BooleanTrend.frameDimension.x, BooleanTrend.frameDimension.y);
        jFrame.setVisible(true);
    }
}

