/*
 * Decompiled with CFR 0.152.
 */
package pogo.servers2www;

import fr.esrf.TangoDs.Except;
import java.util.Vector;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.servers2www.HTMLpage;
import pogo.servers2www.ModuleFamily;
import pogo.servers2www.ScanRepository;

public class Servers2www {
    private String[] cvsroots;
    private Vector repositories;
    public int nb_servers = 0;
    public String final_message = "";

    public Servers2www(String cvs_roots) throws Exception {
        this.cvsroots = new PogoString(cvs_roots).string2array(":");
        this.repositories = new Vector();
        PogoString pgs = new PogoString(System.getProperty("TABLE_TITLES"));
        if (pgs.str == null) {
            throw new PogoException("TABLE_TITLES property not defined");
        }
        String[] prop = pgs.string2array(":");
        if (prop.length < this.cvsroots.length) {
            throw new PogoException("TABLE_TITLES property must have the same number than CVSROOT");
        }
        System.out.println(this.cvsroots.length + " repositories");
        for (int i = 0; i < this.cvsroots.length; ++i) {
            this.repositories.add(new ScanRepository(this.cvsroots[i], prop[i]));
        }
    }

    public void buildHtmlPage() throws Exception {
        Vector<ModuleFamily> families = new Vector<ModuleFamily>();
        for (int i = 0; i < this.repositories.size(); ++i) {
            ScanRepository repository = (ScanRepository)this.repositories.elementAt(i);
            this.nb_servers += repository.cvsCheckOutModules();
            for (int f = 0; f < repository.servers.size(); ++f) {
                ModuleFamily family = (ModuleFamily)repository.servers.elementAt(f);
                families.add(family);
                HTMLpage h = new HTMLpage(family);
                this.final_message = this.final_message + h.generateServersList();
            }
            repository.cvsReleaseModules();
        }
        HTMLpage.generateIndexFile(families, this.nb_servers);
    }

    public String toString() {
        String s = "" + this.cvsroots.length + " TANGO CVS repositories:\n";
        for (int i = 0; i < this.cvsroots.length; ++i) {
            s = s + this.cvsroots[i] + "\n";
        }
        return s;
    }

    public static void main(String[] args) {
        String cvsroot = System.getProperty("CVSROOT");
        try {
            if (cvsroot == null) {
                throw new PogoException("CVSROOT Not set !");
            }
            long t0 = System.currentTimeMillis();
            System.out.println("CVSROOT=" + cvsroot);
            Servers2www appli = new Servers2www(cvsroot);
            appli.buildHtmlPage();
            long t = System.currentTimeMillis() - t0;
            int n_sec = (int)(t / 1000L);
            int n_min = n_sec / 60;
            System.out.println("\n-------------------------------------------------");
            System.out.println(appli.final_message);
            System.out.print("Elapsed time : " + n_min + " min " + (n_sec -= n_min * 60) + " sec");
            System.out.println("  for " + appli.nb_servers + " servers");
            System.exit(0);
        }
        catch (Exception e) {
            Except.print_exception((Exception)e);
            e.printStackTrace();
            System.exit(1);
        }
    }
}

