/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.PogoDefs;
import pogo.gene.PogoString;
import pogo.gene.TangoTypes;

public class Property
implements PogoDefs {
    public String name;
    public TangoTypes type;
    public String description;
    public String default_value;

    public Property(String name, String type_name, String desc) {
        this.name = name;
        this.type = new TangoTypes(type_name, desc);
        if (desc != null) {
            this.description = desc;
        }
    }

    public Property(String name, String type_name, String desc, String def_val) {
        this.name = name;
        this.type = new TangoTypes(type_name);
        if (desc != null) {
            this.description = desc;
        }
        this.default_value = def_val;
    }

    public String getVarName() {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < this.name.length(); ++i) {
            if (i == 0 && this.name.charAt(i) >= 'A' && this.name.charAt(i) <= 'Z') {
                sb.append((char)(this.name.charAt(i) + 32));
                continue;
            }
            sb.append(this.name.charAt(i));
        }
        return sb.toString();
    }

    public String buildDefinition(int lang) {
        String tab;
        String str = "";
        String typestr = lang == 1 ? this.type.cpp : this.type.java;
        String string = tab = lang == 1 ? "" : "\t";
        if (typestr.equals("Tango::DevString")) {
            typestr = "string";
        }
        str = str + tab + "/**\n" + tab + " *\t" + this.description + "\n" + tab + " */\n" + "\t" + typestr + "\t" + this.getVarName() + ";\n";
        return str;
    }

    String geneDefaultValue(int source) {
        String s1 = source == 0 ? "cl_" : "dev_";
        String s2 = source == 0 ? "class_" : "dev_";
        PogoString pgs = new PogoString(this.description);
        while (pgs.str.indexOf("\n") > 0) {
            pgs.replace("\n", "\\n");
        }
        String code = "";
        code = code + "\tprop_name = \"" + this.name + "\";\n";
        code = code + "\tprop_desc = \"" + pgs.str + "\";\n";
        code = code + "\tprop_def  = \"";
        if (this.default_value != null && this.default_value.length() > 0) {
            pgs = new PogoString(this.default_value);
            while (pgs.str.indexOf("\n") > 0) {
                pgs.replace("\n", "\\n");
            }
            code = code + pgs.str;
        }
        code = code + "\";\n";
        if (this.default_value != null && this.default_value.length() > 0) {
            int pos;
            code = code + "\tvect_data.clear();\n";
            String tmp = this.default_value;
            while ((pos = tmp.indexOf(10)) >= 0) {
                String line = tmp.substring(0, pos);
                code = code + "\tvect_data.push_back(\"" + line + "\");\n";
                tmp = tmp.substring(pos + 1);
            }
            code = code + "\tvect_data.push_back(\"" + tmp + "\");\n";
        }
        code = code + "\tif (prop_def.length()>0)\n";
        code = code + "\t{\n";
        code = code + "\t\tTango::DbDatum\tdata(prop_name);\n";
        code = code + "\t\tdata << vect_data ;\n";
        code = code + "\t\t" + s1 + "def_prop.push_back(data);\n";
        code = code + "\t\tadd_wiz_" + s2 + "prop(prop_name, prop_desc,  prop_def);\n";
        code = code + "\t}\n";
        code = code + "\telse\n";
        code = code + "\t\tadd_wiz_" + s2 + "prop(prop_name, prop_desc);\n";
        code = code + "\n";
        return code;
    }

    String buildPyFactoryLine() {
        int idx;
        String desc = this.description;
        while ((idx = desc.indexOf("\n")) > 0) {
            desc = desc.substring(0, idx) + "\\n" + desc.substring(idx + 1);
        }
        String line = "\t\t'" + this.name + "'" + ":\n";
        line = line + "\t\t\t[" + this.type.pyType() + ",\n" + "\t\t\t\"" + desc + "\",\n";
        line = line + "\t\t\t[";
        if (this.default_value != null && this.default_value.length() > 0) {
            StringTokenizer stk = new StringTokenizer(this.default_value, "\n");
            Vector<String> v = new Vector<String>();
            while (stk.hasMoreTokens()) {
                v.add(stk.nextToken());
            }
            if (v.size() == 1) {
                if (this.type.code == 16 || this.type.code == 8) {
                    line = line + " \"" + v.get(0) + "\" ] ],\n";
                } else if (this.type.code == 1) {
                    String s = v.get(0).toString();
                    s = s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
                    line = line + " " + s + " ] ],\n";
                } else {
                    line = line + " " + v.get(0) + " ] ],\n";
                }
            } else {
                line = line + "\n";
                for (int i = 0; i < v.size(); ++i) {
                    line = line + "\t\t\t\t";
                    if (this.type.code == 16 || this.type.code == 8) {
                        line = line + "\"" + v.get(i) + "\"";
                    } else if (this.type.code == 1) {
                        String s = v.get(0).toString();
                        s = s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
                        line = line + " " + s + " ] ],\n";
                    } else {
                        line = line + v.get(i);
                    }
                    line = line + ",\n";
                }
                line = line + "\t\t\t] ],\n";
            }
        } else {
            line = line + "] ],\n";
        }
        return line;
    }

    public String toString() {
        return this.name;
    }
}

