/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Cmd;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;

public class CmdTable
extends Vector
implements PogoDefs {
    Exception except = null;

    private void createVirtualStatusCmd() {
        Cmd cmd1 = new Cmd("State", "StateCmd", "Tango::DEV_VOID", "Tango::DEV_STATE", "none.", "State Code", "This command gets the device state (stored in its <i>device_state</i> data member) and returns it to the caller.");
        cmd1.virtual_method = true;
        cmd1.override_method = 0;
        this.addElement(cmd1);
        Cmd cmd2 = new Cmd("Status", "StatusCmd", "Tango::DEV_VOID", "Tango::CONST_DEV_STRING", "none.", "Status description", "This command gets the device status (stored in its <i>device_status</i> data member) and returns it to the caller.");
        cmd2.virtual_method = true;
        cmd2.override_method = 0;
        this.addElement(cmd2);
    }

    public CmdTable() {
        this.createVirtualStatusCmd();
    }

    public CmdTable(Vector v_in) {
        if (v_in.size() == 0) {
            this.createVirtualStatusCmd();
        }
        for (int i = this.size(); i < v_in.size(); ++i) {
            this.addElement(v_in.elementAt(i));
        }
    }

    public CmdTable(String filename, int deviceImpl) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String add_list_str;
        int lang;
        if (filename.indexOf(".cpp") > 0) {
            lang = 1;
            add_list_str = "command_list.push_back";
        } else if (filename.indexOf(".java") > 0) {
            lang = 0;
            add_list_str = "command_list.addElement";
        } else if (filename.indexOf(".py") > 0) {
            lang = 2;
            add_list_str = "cmd_list = {";
        } else {
            throw new PogoException("Unrecognised file type !");
        }
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        this.createVirtualStatusCmd();
        if (lang == 2) {
            this.parsePyCommands(code);
        } else {
            int start = code.str.indexOf("::command_factory()");
            start = code.str.indexOf("{", start);
            int end = code.outMethod(start);
            String cmd_factory = code.str.substring(start, end);
            int i = 0;
            while ((i = cmd_factory.indexOf(add_list_str, i)) > 0) {
                start = cmd_factory.indexOf("new ", i) + "new ".length();
                while (cmd_factory.charAt(start) <= ' ') {
                    ++start;
                }
                end = cmd_factory.indexOf("));", start);
                Cmd cmd = new Cmd(cmd_factory.substring(start, end));
                cmd.setPolledPerriod(cmd_factory, lang);
                switch (lang) {
                    case 1: {
                        if (deviceImpl >= 3) break;
                        cmd.setNotAllowedFor(code.str, lang);
                        break;
                    }
                    case 0: {
                        String path = new PogoString(filename).extractPathFromFullPath();
                        String jcode = PogoUtil.readFile(path + "/" + cmd.cmd_class + ".java");
                        cmd.setNotAllowedFor(jcode, lang);
                    }
                }
                this.addElement(cmd);
                ++i;
            }
        }
    }

    private void parsePyCommands(PogoString code) throws PogoException {
        int start;
        this.cmdAt((int)0).exec_method = "State";
        if (code.indexOf("def State(self):") > 0) {
            this.cmdAt((int)0).override_method = 2;
        }
        this.cmdAt((int)1).exec_method = "Status";
        if (code.indexOf("def Status(self):") > 0) {
            this.cmdAt((int)1).override_method = 2;
        }
        if ((start = code.str.indexOf("Class(PyTango.PyDeviceClass):")) < 0) {
            throw new PogoException("No DeviceClass class found !");
        }
        if ((start = code.str.indexOf("cmd_list = {", start)) < 0) {
            throw new PogoException("No command list found !");
        }
        int end = code.outMethod(start += "cmd_list = {".length());
        String cmd_list = code.str.substring(start, end);
        end = 0;
        String target = "[[";
        while ((start = cmd_list.indexOf(target, end)) > 0) {
            end = cmd_list.lastIndexOf("'", start - 1);
            start = cmd_list.lastIndexOf("'", end - 1);
            String name = cmd_list.substring(start + 1, end).trim();
            start = end + target.length();
            end = cmd_list.indexOf(",", start);
            start = cmd_list.lastIndexOf(".", end);
            String argin_type = "Tango::" + cmd_list.substring(start + 1, end).trim();
            start = cmd_list.indexOf("\"", end);
            end = cmd_list.indexOf("\"", ++start);
            String argin_desc = cmd_list.substring(start, end).trim();
            start = cmd_list.indexOf("[", end);
            end = cmd_list.indexOf(",", start);
            start = cmd_list.lastIndexOf(".", end);
            String argout_type = "Tango::" + cmd_list.substring(start + 1, end).trim();
            start = cmd_list.indexOf("\"", end);
            end = cmd_list.indexOf("\"", ++start);
            String argout_desc = cmd_list.substring(start, end).trim();
            start = cmd_list.indexOf("]", end) + 1;
            end = cmd_list.indexOf("]", start);
            String props = cmd_list.substring(start, end);
            Cmd cmd = new Cmd(name, name, argin_type, argout_type, argin_desc, argout_desc, "");
            cmd.exec_method = name;
            cmd.parsePyDescription(code.str);
            if (props.length() > 2) {
                cmd.parsePyProperties(props);
            }
            cmd.setNotAllowedFor(code.str, 2);
            cmd.exec_method = name;
            this.addElement(cmd);
        }
    }

    void setAllowedState(String class_name, String filename, boolean is_abstractclass) throws FileNotFoundException, SecurityException, IOException, PogoException {
        PogoString readcode;
        try {
            readcode = new PogoString(PogoUtil.readFile(filename));
        }
        catch (FileNotFoundException e) {
            if (is_abstractclass) {
                return;
            }
            this.except = e;
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            Cmd cmd = this.cmdAt(i);
            String signature = cmd.allowedFullSignatureMethod(class_name);
            int start = readcode.indexOf(signature);
            if (start <= 0) continue;
            String method = readcode.extractMethodCore(start);
            cmd.notAllowedFor = new DevStateTable(method);
        }
    }

    public String buildCommandFactoryMethod(int lang) throws PogoException {
        Cmd cmd;
        int i;
        String retStr = "";
        for (i = 0; i < this.size(); ++i) {
            cmd = this.cmdAt(i);
            if (cmd.virtual_method) continue;
            retStr = retStr + cmd.AddCmdFactoryLine(lang);
        }
        if (lang == 2) {
            return retStr;
        }
        retStr = "{\n" + retStr;
        switch (lang) {
            case 0: {
                retStr = retStr + "\n\t\t//\tadd polling if any\n\t\tfor (int i=0 ; i<command_list.size(); i++)\n\t\t{\n\t\t\tCommand\tcmd = (Command)command_list.elementAt(i);\n";
                break;
            }
            case 1: {
                retStr = retStr + "\n\t//\tadd polling if any\n\tfor (unsigned int i=0 ; i<command_list.size(); i++)\n\t{\n";
            }
        }
        for (i = 0; i < this.size(); ++i) {
            cmd = this.cmdAt(i);
            if (cmd.virtual_method) continue;
            retStr = retStr + cmd.AddCmdPollingLine(lang);
        }
        if (lang == 0) {
            retStr = retStr + "\t";
        }
        retStr = retStr + "\t}\n";
        if (lang == 0) {
            retStr = retStr + "\t";
        }
        retStr = retStr + "}\n";
        return retStr;
    }

    public void getDescriptions(String descFile, String serverClass, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String readcode = PogoUtil.readFile(descFile);
        for (int i = 0; i < this.size(); ++i) {
            if (this.cmdAt((int)i).virtual_method) continue;
            this.cmdAt(i).getExecMethodDescription(readcode, lang);
        }
    }

    public String checkArgsType() {
        String str = "";
        for (int i = 0; i < this.size(); ++i) {
            Cmd cmd = this.cmdAt(i);
            if (cmd.argin.code == -1) {
                str = str + "Argin type (" + cmd.argin.cpp + ") unknown for command " + cmd.name + "!\n";
            }
            if (cmd.argout.code != -1) continue;
            str = str + "Argout type (" + cmd.argout.cpp + ") unknown for command " + cmd.name + "!\n";
        }
        if (str.length() > 0) {
            return str;
        }
        return null;
    }

    public Cmd cmdAt(int idx) {
        return (Cmd)this.elementAt(idx);
    }

    String updatePyCommands(String code, String readcode, String template, String class_name) throws PogoException {
        String target = "return argout";
        int start = template.indexOf(target);
        if (start < 0) {
            throw new PogoException("Command template syntax error.");
        }
        String exec_templ = template.substring(0, start += target.length() + 1);
        String stm_templ = "\t" + template.substring(start).trim();
        int insert_pos = code.indexOf(class_name + " command methods");
        insert_pos = code.indexOf("#=========", insert_pos);
        insert_pos = code.indexOf("\n", insert_pos) + 1;
        for (int i = this.size() - 1; i >= 0; --i) {
            String exe_method;
            Cmd cmd = this.cmdAt(i);
            if (cmd.virtual_method && cmd.override_method == 0) continue;
            String signature = cmd.buildPyExecCmdMethodSignature();
            if (readcode.indexOf(signature) > 0) {
                exe_method = PogoUtil.pythonMethod(readcode, signature);
                exe_method = cmd.pyUpdateDescription(exe_method);
            } else {
                exe_method = cmd.buildPyExecMethod(exec_templ);
            }
            exe_method = "\n" + exe_method.trim() + "\n\n";
            String stm_method = null;
            if (!(cmd.virtual_method || (stm_method = PogoUtil.pythonMethod(readcode, signature = "def is_" + cmd.name + "_allowed(self):")) == null && cmd.notAllowedFor.size() <= 0)) {
                if (stm_method == null) {
                    stm_method = stm_templ;
                    target = "TemplCmd";
                    while ((start = stm_method.indexOf(target)) > 0) {
                        stm_method = stm_method.substring(0, start) + cmd.name + stm_method.substring(start + target.length());
                    }
                }
                stm_method = cmd.pyUpdateAllowedStates(stm_method, signature);
                stm_method = "\n" + stm_method.trim() + "\n\n";
            }
            if (stm_method != null) {
                code = code.substring(0, insert_pos) + stm_method + code.substring(insert_pos);
            }
            code = code.substring(0, insert_pos) + exe_method + code.substring(insert_pos);
        }
        return code;
    }

    protected String addCommentsTable() {
        int max = 0;
        for (int i = 0; i < this.size(); ++i) {
            Cmd cmd = this.cmdAt(i);
            if (cmd.name.length() <= max) continue;
            max = cmd.name.length();
        }
        max += 2;
        String str = "//===================================================================\n//\n//\tThe following table gives the correspondance\n//\tbetween commands and method's name.\n//\n//  Command's name";
        for (int j = "Command's name".length(); j < max; ++j) {
            str = str + " ";
        }
        str = str + "|  Method's name\n";
        str = str + "//\t----------------------------------------\n";
        for (int i = 0; i < this.size(); ++i) {
            Cmd cmd = this.cmdAt(i);
            str = str + "//  " + cmd.name;
            for (int j = cmd.name.length(); j < max; ++j) {
                str = str + " ";
            }
            str = str + "|  " + cmd.exec_method + "()\n";
        }
        str = str + "//\n//===================================================================";
        return str;
    }

    public String toString(int idx) throws PogoException {
        if (idx >= this.size()) {
            throw new PogoException("Command index out of bounds !");
        }
        Cmd cmd = this.cmdAt(idx);
        String str = cmd.name + ", " + cmd.cmd_class + ", " + cmd.argin.cpp_code_str + ", " + cmd.argout.cpp_code_str;
        return str;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.size(); ++i) {
            Cmd cmd = this.cmdAt(i);
            str = str + "--------------------------------------------\n";
            str = str + cmd.name + ", " + cmd.cmd_class + ", " + cmd.argin.cpp_code_str + ", " + cmd.argout.cpp_code_str;
            str = cmd.argin.description != null ? str + ",\n\t" + cmd.argin.description + "\n\t" + cmd.argout.description + "\n" : str + "\n";
        }
        return str;
    }
}

