/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.Property;

public class PropertyTable
extends Vector
implements PogoDefs {
    private int type;

    public PropertyTable(int type) {
        this.type = type;
    }

    public PropertyTable(Vector v_in, int type) {
        this.type = type;
        for (int i = 0; i < v_in.size(); ++i) {
            this.addElement(v_in.elementAt(i));
        }
    }

    public PropertyTable(String filename, int type, int lang) throws FileNotFoundException, SecurityException, IOException {
        int end;
        this.type = type;
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        if (lang == 2) {
            this.parsePyProperies(code.str);
            return;
        }
        String startstr = lang == 0 ? "//--------- Start of properties data members ----------" : "properties member data";
        int start = code.str.indexOf(startstr);
        if (start < 0) {
            System.out.println("No property found in " + filename);
            return;
        }
        if (type == 0) {
            String endstr = lang == 0 ? "//--------- End of properties data members ----------" : "//\tMethod prototypes";
            start = code.nextCr(start) + 1;
            end = code.str.indexOf(endstr, start);
            end = code.previousCr(end) - 1;
        } else if (lang == 0) {
            start = code.str.indexOf("/**", start);
            end = code.str.indexOf("//--------- End of properties data members ----------", start);
        } else {
            start = code.inMethod(start) + 2;
            end = code.str.indexOf("//@}", start);
        }
        if (start > end || start < 0 || end < 0) {
            System.out.println("No property found in " + filename);
            return;
        }
        String core = code.str.substring(start, end);
        end = 0;
        start = 0;
        while ((end = core.indexOf("*/", end)) > 0) {
            PogoString pgs = new PogoString(core.substring(start, end += 3));
            String desc = pgs.getDescription();
            start = end;
            end = core.indexOf(";", start);
            StringTokenizer st = new StringTokenizer(core.substring(start, end));
            String data_type = st.nextToken();
            String name = st.nextToken();
            if (name.charAt(0) >= 'a' || name.charAt(0) >= 'z') {
                char car = (char)(name.charAt(0) - 32);
                name = car + name.substring(1);
            }
            this.addElement(new Property(name, data_type, desc));
        }
    }

    private void parsePyProperies(String code) {
        int start = code.indexOf("Class(PyTango.PyDeviceClass):");
        String target = this.type == 1 ? "device_property_list =" : "class_property_list =";
        start = code.indexOf(target, start);
        if (start < 0) {
            return;
        }
        start = code.indexOf("\n", start) + 1;
        int end = code.indexOf("}", start);
        String prop_list = code.substring(start, end).trim();
        target = "[";
        end = 0;
        while ((start = prop_list.indexOf(target, end)) > 0) {
            int idx;
            end = prop_list.lastIndexOf("'", start - 1);
            start = prop_list.lastIndexOf("'", end - 1);
            String name = prop_list.substring(start + 1, end).trim();
            start = end + target.length();
            end = prop_list.indexOf(",", start);
            start = prop_list.lastIndexOf(".", end);
            String type = "Tango::" + prop_list.substring(start + 1, end).trim();
            start = end + 1;
            end = prop_list.indexOf(",", start);
            String desc = prop_list.substring(start + 1, end).trim();
            desc = desc.substring(desc.indexOf(34) + 1, desc.lastIndexOf(34)).trim();
            while ((idx = desc.indexOf("\\n")) > 0) {
                desc = desc.substring(0, idx) + "\n" + desc.substring(idx + 2);
            }
            start = prop_list.indexOf("[", end) + 1;
            end = prop_list.indexOf("]", start);
            String def_val = "";
            StringTokenizer stk = new StringTokenizer(prop_list.substring(start, end).trim(), ",");
            while (stk.hasMoreTokens()) {
                String line = stk.nextToken().trim();
                int idx1 = line.indexOf(34);
                int idx2 = line.lastIndexOf(34);
                if (idx1 >= 0 && idx2 > idx1) {
                    line = line.substring(idx1 + 1, idx2);
                }
                def_val = def_val + line + "\n";
            }
            Property prop = new Property(name, type, desc);
            prop.default_value = def_val;
            this.add(prop);
        }
    }

    public Property propertyAt(int idx) {
        return (Property)this.elementAt(idx);
    }

    protected String updateJavaMethod(String readcode, String target, String classname) throws PogoException {
        Property property;
        int i;
        PogoString core = new PogoString(readcode);
        String cl_array = "cl_prop";
        String prop_array = target.equals("device") ? "dev_prop" : cl_array;
        int start = core.str.indexOf("Automatic code generation");
        if (start < 0) {
            throw new PogoException("Input File Syntax error 1!'Automatic code generation' Not found");
        }
        start = core.nextCr(start) + 1;
        start = core.nextCr(start) + 1;
        int end = core.str.indexOf("End of Automatic code generation", start);
        end = core.previousCr(end);
        String str = core.str.substring(0, start);
        str = str + "\t\tif (Util._UseDb==false)\n\t\t\treturn;\n";
        str = str + "\t\tString[]\tpropnames = {\n";
        for (i = 0; i < this.size(); ++i) {
            property = this.propertyAt(i);
            str = str + "\t\t\t\t\"" + property + "\"";
            if (i < this.size() - 1) {
                str = str + ",";
            }
            str = str + "\n";
        }
        str = str + "\t\t\t};\n\n\t\t//\tCall database and extract values\n\t\t//--------------------------------------------\n";
        str = target.equals("device") ? str + "\t\tDbDatum[]\t" : str + "\t\t";
        str = str + prop_array + " = get_db_" + target + "().get_property(propnames);\n";
        if (target.equals("device")) {
            str = str + "\t\t" + classname + "Class\tds_class = (" + classname + "Class)get_device_class();\n";
        }
        str = str + "\t\tint\ti = -1;\n";
        for (i = 0; i < this.size(); ++i) {
            property = this.propertyAt(i);
            str = str + "\t\t//\tExtract " + property.name + " value\n" + "\t\tif (" + prop_array + "[++i].is_empty()==false)" + "\t\t" + property.getVarName() + " = " + prop_array + "[i]." + property.type.extract_java_method() + ";\n" + "\t\telse\n";
            str = target.equals("device") ? str + "\t\t{\n\t\t\t//\tTry to get value from class property\n\t\t\tDbDatum\tcl_prop = ds_class.get_class_property(dev_prop[i].name);\n\t\t\tif (cl_prop.is_empty()==false)\t" + property.getVarName() + " = cl_prop." + property.type.extract_java_method() + ";\n" + "\t\t}\n" : str + "\t\t\t" + prop_array + "[i].insert(" + property.getVarName() + ");\n";
            if (i >= this.size() - 1) continue;
            str = str + "\n";
        }
        str = str + "\n";
        str = str + core.str.substring(end);
        return str;
    }

    protected String addJavaDataMembers(String readcode) throws PogoException {
        PogoString pg = new PogoString(readcode);
        int start = pg.str.indexOf("//--------- Start of properties data members ----------");
        if (start < 0) {
            throw new PogoException("Input File Syntax error !\n//--------- Start of properties data members ----------\n Not found !");
        }
        int end = pg.str.indexOf("//--------- End of properties data members ----------");
        if (end < 0) {
            throw new PogoException("Input File Syntax error !\n//--------- End of properties data members ----------\n Not found !");
        }
        String prev_declar = pg.str.substring(start, end);
        String str = "//--------- Start of properties data members ----------\n\n";
        for (int i = 0; i < this.size(); ++i) {
            Property property = this.propertyAt(i);
            str = str + property.buildDefinition(0);
        }
        str = str + "\n";
        pg.replace(prev_declar, str);
        return pg.str;
    }

    void readDefaultValues(String filename, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        if (lang == 0) {
            return;
        }
        PogoString code = new PogoString(PogoUtil.readFile(filename));
        int start = code.indexOf("::set_default_property()");
        if (start < 0) {
            return;
        }
        start = code.str.indexOf("{", start);
        int end = code.outMethod(start);
        PogoString method = new PogoString(code.str.substring(start, end));
        String tag = "//\tSet Default Device Properties";
        int idx = method.indexOf(tag);
        if (end < 0) {
            throw new PogoException("\"" + tag + "\" Not Found");
        }
        method = this.type == 0 ? new PogoString(method.str.substring(0, idx)) : new PogoString(method.str.substring(idx));
        for (int i = 0; i < this.size(); ++i) {
            Property prop = this.propertyAt(i);
            start = method.indexOf("\"" + prop.name + "\"");
            if (start <= 0) continue;
            start = method.indexOf("prop_def", start);
            start = method.indexOf("\"", start);
            end = method.nextCr(++start);
            end = method.lastIndexOf("\"", end);
            PogoString pgs = new PogoString(method.str.substring(start, end));
            while (pgs.str.indexOf("\\n") > 0) {
                pgs.replace("\\n", "\n");
            }
            prop.default_value = pgs.str;
        }
    }

    String buildPyFactory() {
        String code = "";
        for (int i = 0; i < this.size(); ++i) {
            code = code + this.propertyAt(i).buildPyFactoryLine();
        }
        return code;
    }

    String toStringComments(int lang) {
        int i;
        String start_line;
        if (lang != 2) {
            return "";
        }
        String code = start_line = "#   ";
        code = this.type == 1 ? code + "Device " : code + "Class ";
        code = code + "Properies Description:\n#\n";
        int max_len = 0;
        for (i = 0; i < this.size(); ++i) {
            int len = this.propertyAt((int)i).name.length();
            if (len <= max_len) continue;
            max_len = len;
        }
        max_len += 2;
        for (i = 0; i < this.size(); ++i) {
            Property prop = this.propertyAt(i);
            code = code + start_line + prop.name + ":";
            for (int s = prop.name.length(); s < max_len; ++s) {
                code = code + " ";
            }
            code = code + prop.type.pyType().substring("PyTango.".length()) + "\n";
            StringTokenizer stk = new StringTokenizer(prop.description, "\n");
            while (stk.hasMoreTokens()) {
                code = code + start_line;
                for (int s = 0; s <= max_len; ++s) {
                    code = code + " ";
                }
                code = code + stk.nextToken() + "\n";
            }
        }
        return code;
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.size(); ++i) {
            Property prop = (Property)this.elementAt(i);
            str = str + prop.name + "\t" + prop.type.cpp_code_str + "\n";
        }
        return str;
    }
}

