/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.FileNotFoundException;
import java.io.IOException;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.gene.PropertyTable;

public class JavaServer
extends PogoGene
implements PogoDefs,
TangoConst {
    private String classname;
    private PropertyTable properties;
    private static String readprop_method_name = "get_device_property";
    private String readprop_method_signature;
    private String init_signature;

    public JavaServer(PogoClass pogo) {
        super(pogo);
        this.properties = pogo.dev_properties;
        this.classname = pogo.class_name;
        this.init_signature = "public void init_device()";
        this.readprop_method_signature = "public void " + readprop_method_name + "()";
    }

    public void generateSource(String server) throws FileNotFoundException, SecurityException, IOException, PogoException {
        System.out.println("Generating " + server + "....");
        boolean src_exist = this.already_exists(server);
        String filename = src_exist ? server : this.pogo.templates_dir + "/java/" + "DevServ" + ".java";
        PogoString readcode = new PogoString(PogoUtil.readFile(filename));
        if (!src_exist) {
            readcode = PogoUtil.removeLogMessages(readcode);
        }
        if (!src_exist) {
            while (readcode.str.indexOf("TemplateDevServ") >= 0) {
                readcode.replace("TemplateDevServ", this.pogo.class_name);
            }
        }
        String newcode = readcode.str;
        if (src_exist) {
            newcode = this.checkForExecMethodModif(new PogoString(newcode), 0);
        }
        newcode = this.addMethodsToExecuteCmd(newcode);
        newcode = this.addClassDescription(newcode);
        newcode = this.addStatesDescriptions(newcode);
        if (this.pogo.attributes.size() > 0) {
            newcode = this.buildAttributesMethods(new PogoString(newcode), 0);
        }
        if (this.properties.size() > 0) {
            newcode = this.properties.addJavaDataMembers(newcode);
            newcode = this.addReadPropMethod(new PogoString(newcode));
        }
        PogoUtil.writeFile(server, newcode);
    }

    protected String addMethodsToExecuteCmd(String readcode) throws PogoException {
        PogoString newcode = new PogoString(readcode);
        int start = 0;
        if ((start = newcode.str.indexOf("public static void main(String[] argv)", start)) < 0) {
            throw new PogoException("Input File Syntax error !\npublic static void main(String[] argv)\nNot Found !");
        }
        start = newcode.str.lastIndexOf("}", start);
        start += 2;
        for (int i = 0; i < this.pogo.commands.size(); ++i) {
            Cmd cmd = this.pogo.commands.cmdAt(i);
            if (cmd.virtual_method && (!cmd.virtual_method || cmd.override_method == 0)) continue;
            boolean generate = true;
            String signature = cmd.buildJavaExecCmdMethodSignature(0);
            int sig_pos = newcode.str.indexOf(signature);
            if (sig_pos > 0) {
                generate = false;
            }
            if (generate) {
                String method = cmd.buildJavaExecCmdMethodComments();
                method = method + "\t" + cmd.buildJavaExecCmdMethod();
                start = newcode.str.indexOf("public static void main(String[] argv)", start);
                start = newcode.str.lastIndexOf("}", start);
                newcode.insert(start += 2, method);
                continue;
            }
            int start_comments = newcode.str.lastIndexOf("}", sig_pos) + 3;
            String old_comments = newcode.str.substring(start_comments, sig_pos);
            newcode.replace(old_comments, cmd.buildJavaExecCmdMethodComments() + "\t");
        }
        return newcode.toString();
    }

    private String addReadPropMethod(PogoString readcode) throws FileNotFoundException, SecurityException, IOException, PogoException {
        if (this.properties.size() == 0) {
            return readcode.str;
        }
        String templatefile = this.pogo.templates_dir + "/java/readPropMethodName.java";
        PogoString method = new PogoString(PogoUtil.readFile(templatefile));
        method = PogoUtil.removeLogMessages(method);
        int start = method.str.indexOf("//================================");
        start = method.str.indexOf("//================================", start + 1);
        start = method.str.indexOf("//================================", start + 1);
        method.str = method.str.substring(start);
        while (method.str.indexOf("TemplateDevServ") >= 0) {
            method.replace("TemplateDevServ", this.pogo.class_name);
        }
        while (method.str.indexOf("target") >= 0) {
            method.replace("target", "device");
        }
        String template_method = method.str;
        if (readcode.str.indexOf(this.readprop_method_signature) < 0) {
            start = readcode.str.indexOf(this.init_signature);
            if (start < 0) {
                throw new PogoException("Syntax error in input file\n" + this.init_signature + "\n Not Found !");
            }
            start = readcode.inMethod(start);
            start = readcode.outMethod(start) + 1;
            readcode.insert(start, template_method);
        }
        readcode.str = this.properties.updateJavaMethod(readcode.str, "device", this.classname);
        this.addReadPropMethodCall(readcode);
        return readcode.str;
    }

    private void addReadPropMethodCall(PogoString readcode) throws PogoException {
        int end;
        int start = readcode.str.indexOf(this.init_signature);
        if (start < 0) {
            throw new PogoException("Syntax error in input file\n" + this.init_signature + "\n Not Found !");
        }
        String meth_core = readcode.str.substring(start = readcode.inMethod(start), end = readcode.outMethod(start));
        if (meth_core.indexOf(readprop_method_name) >= 0) {
            return;
        }
        start = readcode.str.indexOf("Initialise variables to default values", start);
        start = readcode.nextCr(start) + 1;
        start = readcode.nextCr(start) + 1;
        readcode.insert(start, "\t\t" + readprop_method_name + "();\n");
    }

    protected String addStatesDescriptions(String readcode) throws PogoException {
        PogoString pg = new PogoString(readcode);
        int start = pg.str.indexOf("//--------- Start of States Description ----------");
        if (start < 0) {
            throw new PogoException("Input File Syntax error !\n//--------- Start of States Description ----------\n Not found !");
        }
        int end = pg.str.indexOf("//--------- End of States Description ----------");
        if (end < 0) {
            throw new PogoException("Input File Syntax error !\n//--------- End of States Description ----------\n Not found !");
        }
        String prev_code = pg.str.substring(start, end);
        StringBuffer sb = new StringBuffer("//--------- Start of States Description ----------");
        sb.append("\n/*\n");
        sb.append(this.pogo.states.toStringComments(0));
        sb.append(" */\n");
        pg.replace(prev_code, sb.toString());
        return pg.str;
    }

    protected String addClassDescription(String readcode) throws PogoException {
        PogoString pg = new PogoString(readcode);
        String startComments = " *\tClass Description:";
        int start = pg.str.indexOf(startComments);
        if (start < 0 && (start = pg.str.indexOf(startComments = " * Class Description:")) < 0) {
            throw new PogoException("Input File Syntax error !\n" + startComments + "\n Not found !");
        }
        String author = " * @author\t$Author:";
        int end = pg.str.indexOf(author);
        if (end < 0) {
            throw new PogoException("Input File Syntax error !\n" + author + "\n Not found !");
        }
        String prev_code = pg.str.substring(start, end);
        StringBuffer sb = new StringBuffer(startComments);
        sb.append("\n *\t");
        PogoString desc = new PogoString(this.pogo.class_desc);
        sb.append(desc.setComments());
        sb.append("\n *\n");
        pg.replace(prev_code, sb.toString());
        return pg.str;
    }
}

