/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import app_util.MultiLineToolTipUI;
import app_util.PopupError;
import app_util.PopupHtml;
import app_util.PopupMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import pogo.appli.ClassDialog;
import pogo.appli.GenerateThread;
import pogo.appli.InheritanceTree;
import pogo.appli.PogoAppliDefs;
import pogo.appli.PogoCmdLine;
import pogo.appli.PogoFileFilter;
import pogo.appli.PogoTree;
import pogo.appli.PrefGeneDialog;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGeneCpp;
import pogo.gene.PogoGenePython;
import pogo.gene.PogoUtil;
import pogo.gene.ServerDefinitions;
import pogo.gene.Taco2Tango;

public class PogoAppli
extends JFrame
implements PogoAppliDefs,
PogoDefs {
    private static String revNumber = "Release 5.1.0  -  Wed Jun 13 08:16:07 CEST 2007";
    PogoTree tree;
    InheritanceTree inheritanceTree;
    private PogoClass pogo;
    private String homeDir;
    private JFileChooser chooser;
    static Vector v_appli = new Vector();
    private JMenuItem guideMenu;
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JRadioButton cppBtn;
    private JMenuItem deleteMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenuItem geneDocBtn;
    private JMenuItem geneSrcBtn;
    private JMenu helpMenu;
    private JMenuItem importMenuItem;
    private JRadioButtonMenuItem inheritanceItem;
    private JPanel inheritancePanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator4;
    private JRadioButton javaBtn;
    private JLabel leftBtnLabel;
    private JMenuBar menuBar;
    private JPanel mousePanel;
    private JMenuItem moveDownItem;
    private JMenuItem moveUpItem;
    private JMenuItem newMenuItem;
    private JMenuItem openMenuItem;
    private JRadioButton pyBtn;
    private JMenuItem releaseBtn;
    private JLabel rightBtnLabel;
    private JPanel southPanel;
    private JMenu viewMenu;
    private JMenuItem whatNewBtn;

    public PogoAppli(String filename) {
        this();
        this.readSourceFile(filename);
        Point p = this.getLocation();
        p.translate(20, 20);
        this.setLocation(p);
        this.homeDir = this.pogo.projectFiles.getPath();
    }

    public PogoAppli() {
        this.initComponents();
        this.tree = new PogoTree(this);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 450));
        this.jScrollPane1.setViewportView(this.tree);
        this.jScrollPane1.setBackground(this.tree.getBackground());
        this.inheritanceTree = new InheritanceTree();
        this.inheritancePanel.add((Component)this.inheritanceTree, "Center");
        this.inheritancePanel.add((Component)new JLabel("   "), "East");
        this.inheritancePanel.add((Component)new JLabel("   "), "West");
        this.inheritanceItem.setSelected(true);
        this.inheritanceTree.setVisible(true);
        String super_home = System.getProperty("SUPER_HOME");
        if (super_home != null && super_home.length() > 0) {
            JLabel lbl = new JLabel("Abstr. Class: " + super_home);
            lbl.setFont(new Font("Dialog", 0, 12));
            this.inheritancePanel.add((Component)lbl, "South");
        }
        this.customMenu();
        this.setPogoDefined(false);
        this.setTitle("POGO - " + revNumber);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/app_util/img/tango_icon.jpg"));
        this.setIconImage(icon.getImage());
        this.pack();
        this.centerWindow();
        MultiLineToolTipUI.initialize();
        v_appli.add(this);
    }

    public void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrsize = toolkit.getScreenSize();
        Dimension appsize = this.getSize();
        Point p = new Point();
        p.x = (scrsize.width - appsize.width) / 2;
        p.y = (scrsize.height - appsize.height) / 2;
        this.setLocation(p);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.southPanel = new JPanel();
        this.mousePanel = new JPanel();
        this.leftBtnLabel = new JLabel();
        this.rightBtnLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cppBtn = new JRadioButton();
        this.javaBtn = new JRadioButton();
        this.pyBtn = new JRadioButton();
        this.inheritancePanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.importMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.geneSrcBtn = new JMenuItem();
        this.geneDocBtn = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.deleteMenuItem = new JMenuItem();
        this.moveUpItem = new JMenuItem();
        this.moveDownItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.inheritanceItem = new JRadioButtonMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.whatNewBtn = new JMenuItem();
        this.releaseBtn = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.aboutMenuItem = new JMenuItem();
        this.setTitle("Pogo Appli");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PogoAppli.this.exitForm(evt);
            }
        });
        this.jScrollPane1.setBackground(Color.white);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.mousePanel.setLayout(new BorderLayout());
        this.leftBtnLabel.setHorizontalTextPosition(2);
        this.mousePanel.add((Component)this.leftBtnLabel, "Center");
        this.mousePanel.add((Component)this.rightBtnLabel, "North");
        this.southPanel.add((Component)this.mousePanel, "Center");
        this.jLabel1.setBackground(Color.white);
        this.jLabel1.setText("Generate: ");
        this.jPanel1.add(this.jLabel1);
        this.cppBtn.setText("C++");
        this.cppBtn.setToolTipText("The device server will be generated in C++");
        this.cppBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.languageBtnAP(evt);
            }
        });
        this.jPanel1.add(this.cppBtn);
        this.javaBtn.setText("Java");
        this.javaBtn.setToolTipText("The device server will be generated in Java");
        this.javaBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.languageBtnAP(evt);
            }
        });
        this.jPanel1.add(this.javaBtn);
        this.pyBtn.setText("Python");
        this.pyBtn.setToolTipText("The device server will be generated in Python");
        this.pyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.languageBtnAP(evt);
            }
        });
        this.jPanel1.add(this.pyBtn);
        this.pyBtn.getAccessibleContext().setAccessibleDescription("The device server will be generated in Python");
        this.southPanel.add((Component)this.jPanel1, "North");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.inheritancePanel.setLayout(new BorderLayout());
        this.jLabel2.setText(" ");
        this.inheritancePanel.add((Component)this.jLabel2, "South");
        this.jLabel3.setFont(new Font("Dialog", 1, 12));
        this.jLabel3.setText("Inheritance :");
        this.inheritancePanel.add((Component)this.jLabel3, "North");
        this.getContentPane().add((Component)this.inheritancePanel, "North");
        this.fileMenu.setText("File");
        this.fileMenu.setName("File");
        this.newMenuItem.setText("New Class");
        this.newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.newMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.openMenuItem.setText("Open");
        this.openMenuItem.setToolTipText("Open Class File");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.importMenuItem.setText("Import");
        this.importMenuItem.setToolTipText("import TACO server");
        this.importMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.importMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.importMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.geneSrcBtn.setText("Generate Source");
        this.geneSrcBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.generateAP(evt);
            }
        });
        this.fileMenu.add(this.geneSrcBtn);
        this.geneDocBtn.setText("Generate Doc.");
        this.geneDocBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.generateAP(evt);
            }
        });
        this.fileMenu.add(this.geneDocBtn);
        this.fileMenu.add(this.jSeparator2);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                PogoAppli.this.editAP(evt);
            }
        });
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deleteMenuItem);
        this.moveUpItem.setText("Move Up");
        this.moveUpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.moveUpActionPerformed(evt);
            }
        });
        this.editMenu.add(this.moveUpItem);
        this.moveDownItem.setText("Move Down");
        this.moveDownItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.moveDownActionPerformed(evt);
            }
        });
        this.editMenu.add(this.moveDownItem);
        this.menuBar.add(this.editMenu);
        this.viewMenu.setText("View");
        this.inheritanceItem.setText("Inheritance");
        this.inheritanceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.inheritanceItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.inheritanceItem);
        this.menuBar.add(this.viewMenu);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Shortcuts");
        this.contentsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.helpAP(evt);
            }
        });
        this.helpMenu.add(this.contentsMenuItem);
        this.whatNewBtn.setText("What's New ?");
        this.whatNewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.helpAP(evt);
            }
        });
        this.helpMenu.add(this.whatNewBtn);
        this.releaseBtn.setText("Release Notes");
        this.releaseBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.helpAP(evt);
            }
        });
        this.helpMenu.add(this.releaseBtn);
        this.helpMenu.add(this.jSeparator4);
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.helpAP(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    private void inheritanceItemActionPerformed(ActionEvent evt) {
        boolean b = this.inheritanceItem.getSelectedObjects() != null;
        this.inheritancePanel.setVisible(b);
    }

    void setInheritanceVisible(boolean b) {
        this.inheritancePanel.setVisible(b);
    }

    boolean isInheritanceVisible() {
        return this.inheritanceItem.getSelectedObjects() != null;
    }

    private void moveDownActionPerformed(ActionEvent evt) {
        this.tree.moveSelection("Down");
    }

    private void moveUpActionPerformed(ActionEvent evt) {
        this.tree.moveSelection("Up");
    }

    private void editAP(MenuEvent evt) {
        boolean state = this.tree.isLeafSelected();
        this.deleteMenuItem.setEnabled(state);
        this.moveUpItem.setEnabled(state);
        this.moveDownItem.setEnabled(state);
    }

    private void helpAP(ActionEvent evt) {
        JMenuItem btn = (JMenuItem)evt.getSource();
        String message = null;
        if (btn == this.guideMenu) {
            String template = System.getProperty("TEMPL_HOME");
            if (template != null) {
                String html_file = "file:" + template + "/html/TangoProgrammerGuide.html";
                new PopupHtml(this, false).show(html_file);
            } else {
                PopupError.show((Component)this, "TEMPL_HOME  not set !");
            }
        } else if (btn == this.aboutMenuItem) {
            message = "                     POGO \n\n(Program Obviously used to Generate tango Object)\n        TANGO device server code generator.\n\n" + revNumber + "\n\n" + "Pascal Verdier - Software Engineering Group - ESRF";
        } else if (btn == this.releaseBtn) {
            new PopupHtml(this, true).show("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<HEAD>\n<Title> Release Note </Title>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<P><!-------TITLE------></P>\n<Center>\t<h2>Pogo Release Note</h2>\n\t(Generated Wed Jun 13 08:16:07 CEST 2007)</Center><Br>\n<li><b>Pogo-5.1.0 - 13/06/07:</b><Br>\n&nbsp; &nbsp; 64 bits data types (Tango 6) added.<Br>\n&nbsp; &nbsp; UShort added for java servers.<Br>\n&nbsp; &nbsp; Erase main method in python bug fixed.<Br>\n<li><b>Pogo-5.0.9 - 21/05/07:</b><Br>\n&nbsp; &nbsp; Problem with2 attributes with names very closed fixed.<Br>\n<li><b>Pogo-5.0.8 - 09/05/07:</b><Br>\n&nbsp; &nbsp; File to be load can be passed as argument.<Br>\n<li><b>Pogo-5.0.7 - 27/04/07:</b><Br>\n&nbsp; &nbsp; Bug in changing DeviceImpl revision fixed.<Br>\n&nbsp; &nbsp; Attribute collection checked in creation.<Br>\n<li><b>Pogo-5.0.6 - 19/04/07:</b><Br>\n&nbsp; &nbsp; Abstract Class path displayed<Br>\n&nbsp; &nbsp; New instance of Pogo when open or new.<Br>\n<li><b>Pogo-5.0.5 - 18/04/07:</b><Br>\n&nbsp; &nbsp; Attributes are now displayed separatly<Br>\n&nbsp; &nbsp; (Scalar, Spectrum and image attributes)<Br>\n<li><b>Pogo-5.0.4 - 29/03/07:</b><Br>\n&nbsp; &nbsp; Bug in DsClass.h generation fixed.<Br>\n<li><b>Pogo-5.0.3 - 09/03/07:</b><Br>\n&nbsp; &nbsp; Bug in python attribute properties (with coma) fixed.<Br>\n<li><b>Pogo-5.0.2 - 12/01/07:</b><Br>\n&nbsp; &nbsp; Bug in attribute_factory fixed.<Br>\n<li><b>Pogo-5.0.1 - 08/01/07:</b><Br>\n&nbsp; &nbsp; Bug in python init_device method fixed.<Br>\n&nbsp; &nbsp; Bug in abstract class generation fixed.<Br>\n<li><b>Pogo-5.0.0 - 18/12/06:</b><Br>\n&nbsp; &nbsp; Pyton code generation added.<Br>\n&nbsp; &nbsp; User code part added for C++.<Br>\n&nbsp; &nbsp; Bugs fixed in java code generation.<Br>\n&nbsp; &nbsp; Inheritance diagram added.<Br>\n<li><b>Pogo-4.6.0:</b><Br>\n&nbsp; &nbsp; Allow boolean attribute for java servers.<Br>\n&nbsp; &nbsp; Bug in command factory for abstract class generation fixed.<Br>\n&nbsp; &nbsp; Bug in changing class name fixed.<Br>\n&nbsp; &nbsp; Put class inheritance as class property.<Br>\n&nbsp; &nbsp; Edit Abstract class if any added.<Br>\n&nbsp; &nbsp; Generate inheritance diagram in index.html<Br>\n<li><b>Pogo-4.5.10:</b><Br>\n&nbsp; &nbsp; Bug command comments fixed.<Br>\n<li><b>Pogo-4.5.9:</b><Br>\n&nbsp; &nbsp; Bug project file when using abstract classes under win32 fixed.<Br>\n<li><b>Pogo-4.5.8:</b><Br>\n&nbsp; &nbsp; Change buttons text on attribute dialog.<Br>\n<li><b>Pogo-4.5.7:</b><Br>\n&nbsp; &nbsp; NullPointerException fixed in PogoString class.<Br>\n<li><b>Pogo-4.5.6:</b><Br>\n&nbsp; &nbsp; One line Added to get round a file database usage bug.<Br>\n<li><b>Pogo-4.5.5:</b><Br>\n&nbsp; &nbsp; Tango-5.5 compatiblity.<Br>\n&nbsp; &nbsp; extern C method added to be used as shared library.<Br>\n&nbsp; &nbsp; VCC 6 project file generated if running on Win32.<Br>\n&nbsp; &nbsp; .obj, .so, executable files generated in separated directories.<Br>\n<li><b>Pogo-4.5.1:</b><Br>\n&nbsp; &nbsp; Add a missing class to jar file.<Br>\n<li><b>Pogo-4.5.0:</b><Br>\n&nbsp; &nbsp; Add the pdf doc generation (under linux only).<Br>\n&nbsp; &nbsp; Revision and cvsroot get from CVS files if exist.<Br>\n<li><b>Pogo-4.4.10:</b><Br>\n&nbsp; &nbsp; Bug in get_class_property() call position fixed.<Br>\n&nbsp; &nbsp; Bug in State description fixed.<Br>\n<li><b>Pogo-4.4.9:</b><Br>\n&nbsp; &nbsp; If ...StateMachine not found, display a warning message<Br>\n&nbsp; &nbsp; and generate a default one at next code genaration.<Br>\n<li><b>Pogo-4.4.8:</b><Br>\n&nbsp; &nbsp; Bug fixed in command execute method.<Br>\n<li><b>Pogo-4.4.7:</b><Br>\n&nbsp; &nbsp; Bug fixed in read property description (due to '*' char).<Br>\n&nbsp; &nbsp; Change in tag syntax.<Br>\n<li><b>Pogo-4.4.6:</b><Br>\n&nbsp; &nbsp; Display Release note in help menu added.<Br>\n<li><b>Pogo-4.4.5:</b><Br>\n&nbsp; &nbsp; make_util package added (for tag module).<Br>\n<li><b>Pogo-4.4.4:</b><Br>\n&nbsp; &nbsp; Bug in renaming command has been fixed.<Br>\n<li><b>Pogo-4.4.3:</b><Br>\n&nbsp; &nbsp; Memorized attribute written or not at starteup added.<Br>\n<li><b>Pogo-4.4.2:</b><Br>\n&nbsp; &nbsp; Bug on AttributeDialog fixed.<Br>\n&nbsp; &nbsp; Splash screen is not displayed any more at startup.<Br>\n<li><b>Pogo-4.4.1:</b><Br>\n&nbsp; &nbsp; Bug on array property fixed.<Br>\n<li><b>Pogo-4.4.0:</b><Br>\n&nbsp; &nbsp; Property Wizard functionalities added.<Br>\n<li><b>Pogo-4.3.2:</b><Br>\n&nbsp; &nbsp; Bug on display message about Device_2 to Device_3 fixed.<Br>\n<li><b>Pogo-4.3.1:</b><Br>\n&nbsp; &nbsp; Check main.cpp file and add tg->server_cleanup() call if not already done.<Br>\n<li><b>Pogo-4.3.0:</b><Br>\n&nbsp; &nbsp; CVS tags to Database management added.<Br>\n&nbsp; &nbsp; State machine inherited from abstract class (if any) added.<Br>\n</Body>\n</Html>\n");
        } else {
            message = PogoUtil.getHelpMessage(btn.getText());
        }
        if (message != null) {
            PopupMessage.showImage((Component)this, message, "/app_util/img/tango_icon.jpg");
        }
    }

    private boolean checkForAnotherInstance(int action) {
        if (JOptionPane.showConfirmDialog(this, "Would you like to open it in a new Pogo instance ?", "Question", 0) != 0) {
            return false;
        }
        if (this.homeDir != null) {
            System.setProperty("HOME_GENE", this.homeDir);
        }
        PogoAppli pa = new PogoAppli();
        Point p = this.getLocation();
        p.x += 20;
        p.y += 20;
        pa.setLocation(p);
        pa.setVisible(true);
        switch (action) {
            case 2: {
                pa.createNewServer();
                break;
            }
            case 0: 
            case 1: {
                pa.buildPogoFromFile(action);
            }
        }
        return true;
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        if (this.pogo != null && this.checkForAnotherInstance(2)) {
            return;
        }
        this.createNewServer();
    }

    void createNewServer() {
        ClassDialog classDialog;
        Object[] options;
        if (this.tree != null && this.tree.hasBeenModified() && JOptionPane.showOptionDialog(this, "This project has not been saved !\n\nDiscard modifications ?", "Warning", -1, 2, null, options = new Object[]{"OK", "CANCEL"}, options[0]) != 0) {
            return;
        }
        if (this.homeDir == null && (this.homeDir = System.getProperty("HOME_GENE")) == null) {
            this.homeDir = new File("").getAbsolutePath();
        }
        if ((classDialog = new ClassDialog(this, new ServerDefinitions())).showDialog() == 1) {
            if (this.tree != null) {
                this.setPogoDefined(false);
                this.pogo = null;
            }
            try {
                ServerDefinitions sd = classDialog.getInput();
                if (sd == null) {
                    return;
                }
                if (!sd.inherited_from.equals("Device_3Impl")) {
                    this.pogo = new PogoClass(sd.inherited_from);
                    this.pogo.class_name = sd.name;
                    this.pogo.is_abstractclass = false;
                    this.pogo.inherited_from = sd.inherited_from;
                    this.pogo.class_desc = sd.description;
                    this.pogo.title = sd.project_title;
                } else {
                    this.pogo = new PogoClass(sd, this.getLanguage(), this.homeDir);
                }
                this.tree.setPogoClass(this.pogo, true);
                this.setPogoDefined(true);
                this.resetLanguage();
                this.tree.setHomeDir(this.homeDir);
            }
            catch (PogoException ex) {
                PopupError.show((Component)this, ex);
            }
            catch (Exception e) {
                PopupError.show((Component)this, e);
            }
        }
    }

    private void generateAP(ActionEvent evt) {
        String type = evt.getActionCommand();
        if (type.indexOf("Source") > 0) {
            if (this.getLanguage() == -1) {
                PopupError.show((Component)this, "Select a language before code generation.");
            } else {
                this.generateSource(0);
            }
        } else if (type.indexOf("Doc.") > 0 && this.tree != null) {
            if (this.tree.hasBeenModified()) {
                Object[] options = new Object[]{"Generate Source\n Before", "Generate Only\n Documentation", "CANCEL"};
                switch (JOptionPane.showOptionDialog(this, "The source files have not been generated !\nThe programmer's guide generation use source files.\n\n\n", "Warning", -1, 2, null, options, options[0])) {
                    case 0: {
                        this.generateSource(0);
                        this.generateSource(1);
                        break;
                    }
                    case 1: {
                        this.generateSource(1);
                    }
                }
            } else {
                this.generateSource(1);
            }
        }
    }

    private void languageBtnAP(ActionEvent evt) {
        String lang = evt.getActionCommand();
        if (lang.equals("Java")) {
            this.cppBtn.setSelected(false);
            this.javaBtn.setSelected(true);
            this.pyBtn.setSelected(false);
            PogoClass server = this.tree.getPogoClass();
            if (this.pogo.inherited_from != null && !this.pogo.inherited_from.equals("Device_3Impl")) {
                PopupMessage.show((Component)this, "Java classes inheritance is not yet available");
                this.cppBtn.setSelected(true);
                this.javaBtn.setSelected(false);
                this.pyBtn.setSelected(false);
                return;
            }
            String[] problems = server.attributes.isJavaCompatible();
            if (problems != null) {
                PopupMessage.show((Component)this, "WARNING: Java Servers API do not support:", problems);
            }
        } else if (lang.equals("Python")) {
            this.cppBtn.setSelected(false);
            this.javaBtn.setSelected(false);
            this.pyBtn.setSelected(true);
            PogoClass server = this.tree.getPogoClass();
            if (this.pogo.inherited_from != null && !this.pogo.inherited_from.equals("Device_3Impl")) {
                PopupMessage.show((Component)this, "Python classes inheritance is not yet available");
                this.cppBtn.setSelected(true);
                this.javaBtn.setSelected(false);
                this.pyBtn.setSelected(false);
                return;
            }
        } else {
            this.cppBtn.setSelected(true);
            this.javaBtn.setSelected(false);
            this.pyBtn.setSelected(false);
        }
        this.tree.setLanguage(this.getLanguage());
    }

    private void generateSource(int item) {
        this.generateSource(item, 1);
    }

    private void generateSource(int item, int exiting) {
        if (this.homeDir == null && (this.homeDir = System.getProperty("HOME_GENE")) == null) {
            this.homeDir = new File("").getAbsolutePath();
        }
        int lang = 0;
        lang = this.getLanguage();
        this.tree.setLanguage(lang);
        PogoClass server = this.tree.getPogoClass();
        if (server == null) {
            return;
        }
        if (item == 0) {
            PrefGeneDialog dialog = new PrefGeneDialog(this, lang);
            if (dialog.showDialog(this.homeDir, server.is_abstractclass) != 1) {
                return;
            }
            this.homeDir = dialog.getOutputPath();
            server.is_abstractclass = dialog.getOutputModel();
            this.tree.setHomeDir(this.homeDir);
            this.tree.setOutputModel(server.is_abstractclass);
        }
        if (lang == 0) {
            Object[] options;
            String dir;
            int idx = this.homeDir.lastIndexOf(47);
            if (idx < 0) {
                idx = this.homeDir.lastIndexOf(92);
            }
            if (!this.pogo.class_name.equals(dir = idx >= 0 ? this.homeDir.substring(idx + 1) : this.homeDir) && JOptionPane.showOptionDialog(this, "The Class name will be used as package name.\n\nBut the directory does not have the Class name !\n\nProblem will occur when you try to compile.\n", "Warning", -1, 2, null, options = new String[]{"Generate Source", "CANCEL"}, options[1]) == 1) {
                return;
            }
            if (this.pogo.inherited_from != null && !this.pogo.inherited_from.equals("Device_3Impl")) {
                PopupMessage.show((Component)this, "Java classes inheritance is not yet available");
                return;
            }
            String[] problems = server.attributes.isJavaCompatible();
            if (problems != null) {
                PopupMessage.show((Component)this, "Java Servers API do not support:", problems);
                return;
            }
        }
        server.projectFiles = this.pogo.projectFiles;
        server.projectFiles.setPath(this.homeDir);
        server.author = this.pogo.author;
        server.revision = this.pogo.revision;
        server.cvs_repository = this.pogo.cvs_repository;
        if ((lang == 1 || lang == 2) && server.projectFiles.getOriginalClassName() != null && server.projectFiles.getOriginalPath() != null && !server.class_name.equals(server.projectFiles.getOriginalClassName()) && this.homeDir.equals(server.projectFiles.getOriginalPath())) {
            Object[] options = new Object[]{"Modify", "New Files", "CANCEL"};
            switch (JOptionPane.showOptionDialog(this, "The class name has been modified !\n\nWould you like to modify old files or create new ones ?", "Warning", -1, 2, null, options, options[0])) {
                case 0: {
                    System.out.println("Modify old files");
                    try {
                        if (lang == 1) {
                            new PogoGeneCpp(server).changeClassName();
                            break;
                        }
                        if (lang == 2) {
                            new PogoGenePython(server).changeClassName();
                            break;
                        }
                        System.out.println("Not implemented yet");
                    }
                    catch (Exception e) {
                        PopupError.show((Component)this, e);
                    }
                    break;
                }
                case 1: {
                    System.out.println("Create new files");
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        server.language = this.getLanguage();
        GenerateThread gt = new GenerateThread(this, server, item, exiting);
        gt.start();
        this.tree.setModified(false);
        this.tree.setLanguage(this.getLanguage());
        if (exiting == 0) {
            try {
                gt.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void customMenu() {
        File f;
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/pogo/img/pogo.jpg")));
        this.jLabel1.setDisabledIcon(null);
        this.jLabel1.setBackground(Color.black);
        this.fileMenu.setMnemonic('F');
        this.editMenu.setMnemonic('E');
        this.viewMenu.setMnemonic('V');
        this.helpMenu.setMnemonic('H');
        this.newMenuItem.setMnemonic('N');
        this.openMenuItem.setMnemonic('O');
        this.importMenuItem.setMnemonic('I');
        this.inheritanceItem.setMnemonic('I');
        this.exitMenuItem.setMnemonic('E');
        this.deleteMenuItem.setMnemonic('D');
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.geneSrcBtn.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.geneDocBtn.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.moveUpItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.moveDownItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.resetLanguage();
        this.inheritanceItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        String template = System.getProperty("TEMPL_HOME");
        if (template != null && (f = new File(template = template + "/html/TangoProgrammerGuide.html")).exists()) {
            this.guideMenu = new JMenuItem();
            this.guideMenu.setText("TANGO Programmer's Guide");
            this.guideMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    PogoAppli.this.helpAP(evt);
                }
            });
            this.helpMenu.insert(this.guideMenu, this.helpMenu.getItemCount() - 2);
        }
    }

    private void setLanguage() {
        switch (this.pogo.language) {
            case 0: {
                this.cppBtn.setSelected(false);
                this.javaBtn.setSelected(true);
                this.pyBtn.setSelected(false);
                break;
            }
            case 1: {
                this.cppBtn.setSelected(true);
                this.javaBtn.setSelected(false);
                this.pyBtn.setSelected(false);
                break;
            }
            case 2: {
                this.cppBtn.setSelected(false);
                this.javaBtn.setSelected(false);
                this.pyBtn.setSelected(true);
                break;
            }
            default: {
                this.cppBtn.setSelected(false);
                this.javaBtn.setSelected(false);
                this.pyBtn.setSelected(false);
            }
        }
    }

    private void resetLanguage() {
        this.cppBtn.setSelected(false);
        this.javaBtn.setSelected(false);
        this.pyBtn.setSelected(false);
    }

    int getLanguage() {
        if (this.javaBtn.getSelectedObjects() != null) {
            return 0;
        }
        if (this.cppBtn.getSelectedObjects() != null) {
            return 1;
        }
        if (this.pyBtn.getSelectedObjects() != null) {
            return 2;
        }
        return -1;
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        this.tree.removeSelectedLeaf();
    }

    void checkInheritance() throws PogoException, FileNotFoundException, SecurityException, IOException {
        int j;
        int i;
        if (System.getProperty("SUPER_HOME") == null) {
            PopupMessage.show((Component)this, "WARNING:\n" + this.pogo.class_name + " inherit from " + this.pogo.inheritedClassName() + "\nBut SUPER_HOME is not defined !");
            return;
        }
        if (!new File(this.pogo.inherited_from + ".h").exists()) {
            PopupMessage.show((Component)this, "WARNING:\n" + this.pogo.class_name + " inherit from " + this.pogo.inheritedClassName() + "\n But " + this.pogo.inherited_from + ".h not found !");
            return;
        }
        PogoClass sp = new PogoClass(this.pogo.inherited_from + ".h");
        Vector<Object> v = new Vector<Object>();
        for (int i2 = 0; i2 < sp.commands.size(); ++i2) {
            boolean found = false;
            String name = sp.commands.cmdAt((int)i2).name;
            for (int j2 = 0; !found && j2 < this.pogo.commands.size(); ++j2) {
                found = this.pogo.commands.cmdAt((int)j2).name.equals(name);
            }
            if (found) continue;
            v.add(sp.commands.cmdAt(i2));
        }
        String message = "";
        if (v.size() > 0) {
            message = "Command" + (v.size() > 1 ? "s  " : "  ");
            for (i = 0; i < v.size(); ++i) {
                this.pogo.commands.add(v.elementAt(i));
                message = message + v.elementAt(i).toString() + ", ";
            }
            message = message + " ha" + (v.size() > 1 ? "ve" : "s") + " been added in super class !";
        }
        if (message.length() > 0) {
            PopupMessage.show((Component)this, "WARNING:\n" + this.pogo.class_name + " inherit from " + this.pogo.inheritedClassName() + "\n     But \n" + message);
        }
        v.clear();
        for (i = 0; i < sp.attributes.size(); ++i) {
            boolean found = false;
            String name = sp.attributes.attributeAt((int)i).name;
            for (j = 0; !found && j < this.pogo.attributes.size(); ++j) {
                found = this.pogo.attributes.attributeAt((int)j).name.equals(name);
            }
            if (found) continue;
            v.add(sp.attributes.attributeAt(i));
        }
        if (v.size() > 0) {
            message = "Attribute" + (v.size() > 1 ? "s  " : "  ");
            for (i = 0; i < v.size(); ++i) {
                this.pogo.attributes.add(v.elementAt(i));
                message = message + v.elementAt(i).toString() + ", ";
            }
            message = message + " ha" + (v.size() > 1 ? "ve" : "s") + " been added in super class !";
        }
        v.clear();
        for (i = 0; i < sp.states.size(); ++i) {
            boolean found = false;
            String name = sp.states.stateAt((int)i).name;
            for (j = 0; !found && j < this.pogo.states.size(); ++j) {
                found = this.pogo.states.stateAt((int)j).name.equals(name);
            }
            if (found) continue;
            v.add(sp.states.stateAt(i));
        }
        if (v.size() > 0) {
            message = "State" + (v.size() > 1 ? "s  " : "  ");
            for (i = 0; i < v.size(); ++i) {
                this.pogo.states.add(v.elementAt(i));
                message = message + v.elementAt(i).toString() + ", ";
            }
            message = message + " ha" + (v.size() > 1 ? "ve" : "s") + " been added in super class !";
        }
        if (message.length() > 0) {
            PopupMessage.show((Component)this, "WARNING:\n" + this.pogo.class_name + " inherit from " + this.pogo.inheritedClassName() + "\n     But \n" + message);
        }
    }

    private void readSourceFile(String filename) {
        try {
            boolean action = false;
            String ext = PogoFileFilter.getExtension(filename);
            if (ext == null) {
                ext = "cpp";
                filename = filename + ".cpp";
            }
            if (ext.equals("h")) {
                filename = filename.substring(0, filename.length() - 2) + ".cpp";
            }
            if (ext.equals("h") || ext.equals("cpp") || ext.equals("java") || ext.equals("py")) {
                this.pogo = new PogoClass(filename);
                if (this.pogo.inherited_from != null && !this.pogo.inheritedClassName().equals("Device_3Impl")) {
                    this.checkInheritance();
                }
            } else {
                Taco2Tango t2t = new Taco2Tango(filename);
                this.pogo = t2t.getPogoClass();
                action = true;
            }
            this.tree.setPogoClass(this.pogo, false);
            this.setPogoDefined(true);
            String message = this.pogo.commands.checkArgsType();
            if (message != null) {
                PopupError.show((Component)this, message);
            }
            if (action && this.pogo.states != null && this.pogo.states.size() > 0) {
                PopupMessage.show((Component)this, "WARNING:\nDevice States have been created \n   BUT Not\nthe allowed state command !!!");
            }
        }
        catch (Exception ex) {
            PopupError.show((Component)this, ex);
            ex.printStackTrace();
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        if (this.pogo != null && this.checkForAnotherInstance(0)) {
            return;
        }
        this.buildPogoFromFile(0);
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        if (this.pogo != null && this.checkForAnotherInstance(1)) {
            return;
        }
        this.buildPogoFromFile(1);
    }

    void buildPogoFromFile(int action) {
        Object[] options;
        String defaultfile = System.getProperty("POGO_FILE");
        if (defaultfile != null && defaultfile.length() == 0) {
            defaultfile = null;
        }
        if (this.tree.hasBeenModified() && JOptionPane.showOptionDialog(this, "This project has not been saved !\n\nDiscard modifications ?", "Warning", -1, 2, null, options = new Object[]{"OK", "CANCEL"}, options[0]) != 0) {
            return;
        }
        String[] ext = new String[]{"h", "java", "py"};
        PogoFileFilter tangoFF = new PogoFileFilter(ext, "TANGO Classes");
        tangoFF.setExtensionListInDescription(false);
        PogoFileFilter tacoFF = new PogoFileFilter("c", "TACO 'C' Classes");
        if (this.chooser == null) {
            this.homeDir = System.getProperty("HOME_GENE");
            if (this.homeDir == null) {
                this.homeDir = new File("").getAbsolutePath();
            }
            this.chooser = new JFileChooser(this.homeDir);
            this.chooser.addChoosableFileFilter(tacoFF);
            this.chooser.addChoosableFileFilter(tangoFF);
            if (action == 1) {
                this.chooser.setFileFilter(tacoFF);
            }
        } else if (action == 0) {
            PogoFileFilter ff = (PogoFileFilter)this.chooser.getFileFilter();
            if (ff.getDescription().indexOf("TACO") >= 0) {
                this.chooser.setFileFilter(tangoFF);
            }
        } else {
            this.chooser.setFileFilter(tacoFF);
        }
        this.chooser.setDialogTitle(action == 0 ? "Open" : "Import");
        this.chooser.setCurrentDirectory(new File(this.homeDir));
        int retval = defaultfile == null ? this.chooser.showOpenDialog(this) : 0;
        if (retval == 0) {
            File file;
            if (this.tree != null) {
                this.tree.clear();
                this.setPogoDefined(false);
                this.pogo = null;
            }
            if ((file = defaultfile == null ? this.chooser.getSelectedFile() : new File(defaultfile)) != null && !file.isDirectory()) {
                String filename = file.getAbsolutePath();
                this.readSourceFile(filename);
                this.homeDir = file.getParentFile().toString();
                if (this.pogo == null) {
                    return;
                }
                if (file.getAbsolutePath().indexOf(".h") > 0) {
                    this.cppBtn.setSelected(true);
                    this.javaBtn.setSelected(false);
                } else if (file.getAbsolutePath().indexOf(".java") > 0) {
                    this.cppBtn.setSelected(false);
                    this.javaBtn.setSelected(true);
                }
                this.tree.setLanguage(this.getLanguage());
                this.tree.setHomeDir(this.homeDir);
                this.checkDevImplRev(filename);
            }
            this.pogo.projectFiles.setOriginalClassName(this.pogo.class_name);
            this.pogo.projectFiles.setOriginalPath(this.homeDir);
            if (this.pogo.except != null) {
                String str = this.pogo.except.toString();
                if (str.indexOf("FileNotFound") > 0 && str.indexOf("StateMachine") > 0) {
                    str = str + "\n\nA default one will be created at next code generation !";
                }
                PopupError.show((Component)this, str);
                this.pogo.except = null;
            }
        }
    }

    private void checkDevImplRev(String filename) {
        String message;
        int lang = 0;
        lang = this.getLanguage();
        if (lang == 0) {
            return;
        }
        if (lang == 2) {
            return;
        }
        String template_file = this.pogo.templates_dir + "/cpp/DevServ.h";
        int template_rev = PogoUtil.deviceImplRevisionNumber(template_file);
        System.out.println("Template files are for Device_" + template_rev + "Impl");
        if (template_rev < 0) {
            message = "Cannot not found the C++ template files at\n" + this.pogo.templates_dir + "/cpp\n";
            JOptionPane.showMessageDialog(this, message, "WARNING Window", 2);
            this.closeAppli();
        } else if (template_rev < 3) {
            message = "The C++ template files situated in:\n" + this.pogo.templates_dir + "/cpp\n" + "are not for this POGO version !\n\n" + "Please download and install the latest version.";
            JOptionPane.showMessageDialog(this, message, "WARNING Window", 2);
            this.closeAppli();
        }
        int devimpl_rev = PogoUtil.deviceImplRevisionNumber(filename);
        if (devimpl_rev < 3) {
            System.out.println();
            System.out.println("**********************************************************************");
            System.out.println("This device server has been generated for an old TANGO release.\n\nBefore any modification of this project, Pogo needs to generate\ncode for new attribute model.\nYour code will be splited from :\n          read_attr(Tango::Attribute &attr)\n                       and\n          write_attr_hardware(vector<long> &attr_list)\nto the new methods generated for each attribute.\n\nThen you will be able to remove these two old methods.");
            System.out.println("**********************************************************************");
            System.out.println();
            Object[] options = new Object[]{"GENERATE", "CANCEL"};
            if (JOptionPane.showOptionDialog(this, "This device server has been generated for an old TANGO release.\n\nBefore any modification of this project, Pogo needs to generate\ncode for new attribute model.\nYour code will be splited from :\n          read_attr(Tango::Attribute &attr)\n                       and\n          write_attr_hardware(vector<long> &attr_list)\nto the new methods generated for each attribute.\n\nThen you will be able to remove these two old methods.", "Warning", -1, 2, null, options, options[0]) == 0) {
                System.out.println("Generate......");
                this.generateSource(0, 0);
                System.out.println();
                System.out.println("**********************************************************************");
                System.out.println("\tConversion to new TANGO model successfull");
                System.out.println("**********************************************************************");
                System.out.println();
                this.closeAppli();
            }
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.tree != null && this.tree.hasBeenModified()) {
            Object[] options = new Object[]{"Yes", "No", "Cancel"};
            int choice = JOptionPane.showOptionDialog(this, "This project has not been saved !\n\nWould you like to generate modifications ?", "Warning", -1, 2, null, options, options[0]);
            switch (choice) {
                case 0: {
                    this.generateSource(0, 0);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.closeAppli();
    }

    private void exitForm(WindowEvent evt) {
        if (this.tree != null && this.tree.hasBeenModified() && JOptionPane.showConfirmDialog(this, "This project has not been saved !\n\nWould you like to generate modifications ?", "information", 0) == 0) {
            this.generateSource(0, 0);
        }
        this.closeAppli();
    }

    private void closeAppli() {
        v_appli.remove(this);
        if (v_appli.size() == 0) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void setPogoDefined(boolean state) {
        this.tree.setVisible(state);
        this.geneSrcBtn.setEnabled(state);
        this.geneDocBtn.setEnabled(state);
        if (state) {
            this.setLanguage();
        }
    }

    public static void centerDialog(JDialog dialog, JFrame parent) {
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - dialog.getWidth()) / 2;
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        dialog.setLocation(p);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                new PogoCmdLine(args);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
        try {
            PogoAppli pogoAppli = new PogoAppli();
            pogoAppli.setVisible(true);
            String[] list = PogoUtil.getTangoFilesList(".");
            if (System.getProperty("POGO_FILE") != null || list.length > 0) {
                pogoAppli.buildPogoFromFile(0);
            }
        }
        catch (Exception e) {
            System.out.println("POGO Startup Failed.");
            System.out.println(e);
            e.printStackTrace();
        }
    }
}

