/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import app_util.PopupError;
import fr.esrf.TangoDs.TangoConst;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import pogo.appli.MultiLineCellEditor;
import pogo.appli.PogoAppli;
import pogo.appli.PogoAppliDefs;
import pogo.gene.Attrib;
import pogo.gene.AttribTable;
import pogo.gene.Cmd;
import pogo.gene.CmdTable;
import pogo.gene.DevState;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.Property;
import pogo.gene.PropertyTable;

public class CommentsDialog
extends JDialog
implements TangoConst,
PogoDefs,
PogoAppliDefs {
    private DataTableModel model;
    private CmdTable cmd_vector;
    private AttribTable attr_vector;
    private PropertyTable prop_vector;
    private DevStateTable state_vector;
    private String[] COL_NAMES = new String[]{"Name", "Description", "Input arg. description", "Output arg. description"};
    private static final int[] col_width = new int[]{100, 400, 200, 200};
    private static final int NAME = 0;
    private static final int DESCRIPTION = 1;
    private static final int ARGIN_DESC = 2;
    private static final int ARGOUT_DESC = 3;
    private static final boolean modal = true;
    private static boolean modified = false;
    private static JFrame parent;
    private static int manage;
    private Vector tmp_cmd_vector = null;
    private Vector tmp_attr_vector = null;
    private Vector tmp_prop_vector = null;
    private Vector tmp_state_vector = null;
    private static final String[] collec_names;
    private static JTable descTable;
    private JPanel jPanel1;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel titleLabel;
    private JScrollPane scrollPane;

    private void componentFactory() {
        this.COL_NAMES[1] = collec_names[manage] + "  " + this.COL_NAMES[1];
        this.initComponents();
        this.initMyComponents();
        this.titleLabel.setText(collec_names[manage] + " Description");
        this.pack();
        PogoAppli.centerDialog(this, parent);
    }

    public CommentsDialog(JFrame parent, CmdTable cmd_vector) {
        super((Frame)parent, true);
        CommentsDialog.parent = parent;
        this.cmd_vector = cmd_vector;
        manage = 2;
        this.componentFactory();
    }

    public CommentsDialog(JFrame parent, AttribTable attr_vector) {
        super((Frame)parent, true);
        CommentsDialog.parent = parent;
        this.attr_vector = attr_vector;
        manage = 3;
        this.componentFactory();
    }

    public CommentsDialog(JFrame parent, DevStateTable state_vector) {
        super((Frame)parent, true);
        CommentsDialog.parent = parent;
        this.state_vector = state_vector;
        manage = 4;
        this.componentFactory();
    }

    public CommentsDialog(JFrame parent, PropertyTable prop_vector, int manage) {
        super((Frame)parent, true);
        CommentsDialog.parent = parent;
        this.prop_vector = prop_vector;
        CommentsDialog.manage = manage;
        this.componentFactory();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CommentsDialog.this.closeDialog(evt);
            }
        });
        JButton applyBtn = new JButton("Apply");
        applyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommentsDialog.this.applyBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(applyBtn);
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommentsDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void initMyComponents() {
        try {
            JTable table;
            this.model = new DataTableModel();
            descTable = table = new JTable(this.model);
            this.displayDescriptions();
            Enumeration<TableColumn> cenum = table.getColumnModel().getColumns();
            int width = 0;
            int i = 0;
            while (cenum.hasMoreElements()) {
                TableColumn tc = cenum.nextElement();
                tc.setPreferredWidth(col_width[i]);
                width += col_width[i];
                ++i;
            }
            MultiLineCellEditor editor = new MultiLineCellEditor(table);
            table.setDefaultEditor(String.class, editor);
            int height = 20;
            for (int i2 = 0; i2 < descTable.getModel().getRowCount(); ++i2) {
                height += descTable.getRowHeight(i2);
            }
            if (height > 500) {
                height = 500;
            }
            if (height < 100) {
                height = 100;
            }
            this.scrollPane = new JScrollPane(table);
            this.scrollPane.setPreferredSize(new Dimension(width, height));
            this.getContentPane().add((Component)this.scrollPane, "Center");
        }
        catch (Exception e) {
            e.printStackTrace();
            PopupError.show((Component)parent, e.toString() + "\nCommentsDialog.initMyComponents()");
        }
    }

    private void displayDescriptions() {
        switch (manage) {
            case 2: {
                if (this.tmp_cmd_vector == null) {
                    this.tmp_cmd_vector = new Vector();
                } else {
                    this.tmp_cmd_vector.clear();
                }
                for (int i = 2; i < this.cmd_vector.size(); ++i) {
                    Cmd cmd = this.cmd_vector.cmdAt(i);
                    String[] tmp = new String[]{new String(cmd.name), new String(cmd.description), new String(cmd.argin.description), new String(cmd.argout.description)};
                    this.tmp_cmd_vector.add(tmp);
                }
                this.model.fireTableDataChanged();
                break;
            }
            case 3: {
                if (this.tmp_attr_vector == null) {
                    this.tmp_attr_vector = new Vector();
                } else {
                    this.tmp_attr_vector.clear();
                }
                for (int i = 0; i < this.attr_vector.size(); ++i) {
                    Attrib attr = this.attr_vector.attributeAt(i);
                    String[] tmp = new String[2];
                    tmp[0] = attr.name;
                    if (attr.getDescription() != null) {
                        tmp[1] = new String(attr.getDescription());
                        StringBuffer sb = new StringBuffer();
                        for (int j = 0; j < tmp[1].length(); ++j) {
                            if (tmp[1].charAt(j) == '\\' && tmp[1].charAt(j + 1) == 'n') {
                                sb.append("\n");
                                ++j;
                                continue;
                            }
                            sb.append(tmp[1].charAt(j));
                        }
                        tmp[1] = sb.toString();
                    } else {
                        tmp[1] = "";
                    }
                    this.tmp_attr_vector.add(tmp);
                }
                break;
            }
            case 0: 
            case 1: {
                if (this.tmp_prop_vector == null) {
                    this.tmp_prop_vector = new Vector();
                } else {
                    this.tmp_prop_vector.clear();
                }
                for (int i = 0; i < this.prop_vector.size(); ++i) {
                    Property prop = this.prop_vector.propertyAt(i);
                    String[] tmp = new String[]{new String(prop.name), prop.description != null ? prop.description : ""};
                    this.tmp_prop_vector.add(tmp);
                }
                break;
            }
            case 4: {
                if (this.tmp_state_vector == null) {
                    this.tmp_state_vector = new Vector();
                } else {
                    this.tmp_state_vector.clear();
                }
                for (int i = 0; i < this.state_vector.size(); ++i) {
                    DevState state = this.state_vector.stateAt(i);
                    String[] tmp = new String[]{new String(state.name), state.description != null ? state.description : ""};
                    this.tmp_state_vector.add(tmp);
                }
                break;
            }
        }
    }

    private void applyBtnActionPerformed(ActionEvent evt) {
        switch (manage) {
            case 2: {
                for (int i = 0; i < this.tmp_cmd_vector.size(); ++i) {
                    Cmd cmd = this.cmd_vector.cmdAt(i + 2);
                    String[] str = (String[])this.tmp_cmd_vector.elementAt(i);
                    cmd.description = str[1];
                    cmd.argin.description = str[2];
                    cmd.argout.description = str[3];
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.tmp_attr_vector.size(); ++i) {
                    Attrib attr = this.attr_vector.attributeAt(i);
                    String[] str = (String[])this.tmp_attr_vector.elementAt(i);
                    if (str[1].length() <= 0) continue;
                    StringBuffer sb = new StringBuffer();
                    for (int j = 0; j < str[1].length(); ++j) {
                        if (str[1].charAt(j) == '\n') {
                            sb.append("\\n");
                            continue;
                        }
                        sb.append(str[1].charAt(j));
                    }
                    attr.setDescription(sb.toString());
                }
                break;
            }
            case 0: 
            case 1: {
                for (int i = 0; i < this.tmp_prop_vector.size(); ++i) {
                    Property prop = this.prop_vector.propertyAt(i);
                    String[] str = (String[])this.tmp_prop_vector.elementAt(i);
                    prop.description = str[1];
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.tmp_state_vector.size(); ++i) {
                    DevState state = this.state_vector.stateAt(i);
                    String[] str = (String[])this.tmp_state_vector.elementAt(i);
                    state.description = str[1];
                }
                break;
            }
        }
        modified = true;
    }

    boolean getModified() {
        return modified;
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    static {
        collec_names = new String[]{"Class  Properties", "Device Properties", "Commands", "Attributes", "States"};
    }

    public class DataTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            switch (manage) {
                case 2: {
                    return CommentsDialog.this.COL_NAMES.length;
                }
            }
            return 2;
        }

        public int getRowCount() {
            switch (manage) {
                case 2: {
                    if (CommentsDialog.this.tmp_cmd_vector == null) {
                        return 0;
                    }
                    return CommentsDialog.this.tmp_cmd_vector.size();
                }
                case 3: {
                    if (CommentsDialog.this.tmp_attr_vector == null) {
                        return 0;
                    }
                    return CommentsDialog.this.tmp_attr_vector.size();
                }
                case 0: 
                case 1: {
                    if (CommentsDialog.this.tmp_prop_vector == null) {
                        return 0;
                    }
                    return CommentsDialog.this.tmp_prop_vector.size();
                }
                case 4: {
                    if (CommentsDialog.this.tmp_state_vector == null) {
                        return 0;
                    }
                    return CommentsDialog.this.tmp_state_vector.size();
                }
            }
            return 0;
        }

        public String getColumnName(int aCol) {
            return CommentsDialog.this.COL_NAMES[aCol];
        }

        public void setValueAt(Object obj, int row, int col) {
            switch (manage) {
                case 2: {
                    String[] str = (String[])CommentsDialog.this.tmp_cmd_vector.elementAt(row);
                    str[col] = obj.toString();
                    break;
                }
                case 3: {
                    String[] str = (String[])CommentsDialog.this.tmp_attr_vector.elementAt(row);
                    str[col] = obj.toString();
                    break;
                }
                case 0: 
                case 1: {
                    String[] str = (String[])CommentsDialog.this.tmp_prop_vector.elementAt(row);
                    str[col] = obj.toString();
                    break;
                }
                case 4: {
                    String[] str = (String[])CommentsDialog.this.tmp_state_vector.elementAt(row);
                    str[col] = obj.toString();
                }
            }
        }

        public Object getValueAt(int row, int col) {
            switch (manage) {
                case 2: {
                    String[] str = (String[])CommentsDialog.this.tmp_cmd_vector.elementAt(row);
                    return str[col];
                }
                case 3: {
                    String[] str = (String[])CommentsDialog.this.tmp_attr_vector.elementAt(row);
                    return str[col];
                }
                case 0: 
                case 1: {
                    String[] str = (String[])CommentsDialog.this.tmp_prop_vector.elementAt(row);
                    return str[col];
                }
                case 4: {
                    String[] str = (String[])CommentsDialog.this.tmp_state_vector.elementAt(row);
                    return str[col];
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }
    }

    public class ResultTableRowRenderer
    extends DefaultTableCellRenderer {
        ResultTableRowRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        }
    }
}

