/*
 * Decompiled with CFR 0.152.
 */
package app_util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class PopupText
extends JDialog {
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;
    private JTextPane textPane;

    public PopupText(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.pack();
        Point p = parent.getLocationOnScreen();
        p.x += 10;
        p.y += 10;
        this.setLocation(p);
    }

    public PopupText(JDialog parent, boolean modal) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.pack();
        Point p = parent.getLocationOnScreen();
        p.x += 10;
        p.y += 10;
        this.setLocation(p);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textPane = new JTextPane();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PopupText.this.closeDialog(evt);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        this.cancelButton.setText("Dismiss");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PopupText.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jScrollPane1.setViewportView(this.textPane);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
    }

    public void setFont(Font font) {
        this.textPane.setFont(font);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    private void showMsg(String text, SimpleAttributeSet attrs) {
        Document doc = this.textPane.getDocument();
        try {
            doc.insertString(doc.getLength(), text, attrs);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void showFormated(String text) {
        int end;
        int nblines = 0;
        int start = 0;
        while ((end = text.indexOf(10, start)) >= 0) {
            String line = text.substring(start, ++end);
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            if (line.indexOf(58) < 0) {
                StyleConstants.setBold(attrs, false);
            } else {
                StyleConstants.setBold(attrs, true);
            }
            int start1 = line.indexOf("Running");
            if (start1 > 0) {
                this.showMsg(line.substring(0, start1), attrs);
                StyleConstants.setForeground(attrs, Color.green);
                this.showMsg(line.substring(start1), attrs);
            } else {
                start1 = line.indexOf("Stopped");
                if (start1 > 0) {
                    this.showMsg(line.substring(0, start1), attrs);
                    StyleConstants.setForeground(attrs, Color.red);
                    this.showMsg(line.substring(start1), attrs);
                } else {
                    StyleConstants.setForeground(attrs, Color.black);
                    this.showMsg(line, attrs);
                }
            }
            start = end;
            ++nblines;
        }
        this.textPane.setEditable(false);
        this.textPane.setSize(400, 300);
        this.pack();
        this.setVisible(true);
    }

    public void show(String text) {
        this.textPane.setText(text);
        this.textPane.setEditable(false);
        this.textPane.setSize(400, 300);
        this.pack();
        this.setVisible(true);
    }

    public void show(String title, String[] array, int width, int height) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        int fs = StyleConstants.getFontSize(attrs);
        StyleConstants.setBold(attrs, true);
        StyleConstants.setUnderline(attrs, true);
        StyleConstants.setFontSize(attrs, fs + 4);
        this.showMsg(title + "\n\n", attrs);
        StyleConstants.setBold(attrs, false);
        StyleConstants.setUnderline(attrs, false);
        StyleConstants.setFontSize(attrs, fs);
        for (int i = 0; i < array.length; ++i) {
            this.showMsg(array[i] + "\n", attrs);
        }
        this.textPane.setEditable(false);
        this.textPane.setPreferredSize(new Dimension(width, height));
        this.pack();
        this.setVisible(true);
    }

    public void show(String title, String[] array) {
        this.show(title, array, 800, 600);
    }

    public void show(String text, int sizeX, int sizeY) {
        this.textPane.setText(text);
        this.textPane.setEditable(false);
        this.textPane.setPreferredSize(new Dimension(sizeX, sizeY));
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] args) {
        new PopupText((Frame)new JFrame(), true).setVisible(true);
    }
}

