/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.UsersTree;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class TreePopupMenu
extends JPopupMenu {
    private UsersTree parent;
    private static int x = 0;
    private static final int COPY = x++;
    private static final int PASTE = x++;
    private static final int ADD_ITEM = x++;
    private static final int EDIT = x++;
    private static final int CLONE = x++;
    private static final int REMOVE = x++;
    private static final int TOGGLE_RIGHTS = x++;
    private static String[] menuLabels = new String[]{"Copy", "Paste", "Add Item", "Edit", "Clone", "Remove", "Toggle rights"};
    private static final int OFFSET = 2;
    private JLabel title;

    public TreePopupMenu(UsersTree parent) {
        this.parent = parent;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        this.title = new JLabel();
        this.title.setFont(new Font("Dialog", 1, 16));
        this.add(this.title);
        this.add(new JPopupMenu.Separator());
        for (int i = 0; i < menuLabels.length; ++i) {
            if (menuLabels[i] == null) {
                this.add(new JPopupMenu.Separator());
                continue;
            }
            JMenuItem btn = new JMenuItem(menuLabels[i]);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TreePopupMenu.this.hostActionPerformed(evt);
                }
            });
            this.add(btn);
        }
    }

    public void showMenu(MouseEvent evt, int type, Object obj) {
        TreePath selectedPath = this.parent.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        this.parent.setSelectionPath(selectedPath);
        this.title.setText(obj.toString());
        for (int i = 0; i < menuLabels.length; ++i) {
            this.getComponent(2 + i).setVisible(false);
        }
        switch (type) {
            case -2: {
                this.getComponent(2 + CLONE).setVisible(true);
                this.getComponent(2 + REMOVE).setVisible(true);
                break;
            }
            case -1: {
                this.getComponent(2 + ADD_ITEM).setVisible(true);
                this.getComponent(2 + PASTE).setVisible(true);
                this.getComponent(2 + PASTE).setEnabled(false);
                if (obj.toString().equals(UsersTree.collecStr[0]) && this.parent.copied_addresses.size() > 0) {
                    this.getComponent(2 + PASTE).setEnabled(true);
                }
                if (!obj.toString().equals(UsersTree.collecStr[1]) || this.parent.copied_devices.size() <= 0) break;
                this.getComponent(2 + PASTE).setEnabled(true);
                break;
            }
            case 0: {
                this.getComponent(2 + COPY).setVisible(true);
                this.getComponent(2 + EDIT).setVisible(true);
                this.getComponent(2 + REMOVE).setVisible(true);
                break;
            }
            case 1: {
                this.getComponent(2 + COPY).setVisible(true);
                this.getComponent(2 + EDIT).setVisible(true);
                this.getComponent(2 + REMOVE).setVisible(true);
                this.getComponent(2 + TOGGLE_RIGHTS).setVisible(true);
            }
        }
        this.show(this.parent, evt.getX(), evt.getY());
    }

    private void hostActionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals(menuLabels[COPY])) {
            this.parent.copyItem();
        } else if (cmd.equals(menuLabels[PASTE])) {
            this.parent.pasteItem();
        } else if (cmd.equals(menuLabels[ADD_ITEM])) {
            this.parent.addItem();
        } else if (cmd.equals(menuLabels[EDIT])) {
            this.parent.editItem();
        } else if (cmd.equals(menuLabels[CLONE])) {
            this.parent.cloneUser();
        } else if (cmd.equals(menuLabels[REMOVE])) {
            this.parent.removeItem();
        } else if (cmd.equals(menuLabels[TOGGLE_RIGHTS])) {
            this.parent.toggleRight();
        }
    }
}

