/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.tools.SubscribedSignal;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HistoryDialog
extends JDialog
implements IJLChartListener {
    private JLChart chart = new JLChart();
    private SubscribedSignal signal;
    private JButton cancelBtn;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel titleLabel;

    public HistoryDialog(JDialog parent, SubscribedSignal signal) {
        super((Dialog)parent, false);
        this.signal = signal;
        this.initComponents();
        this.initOwnComponents();
        this.titleLabel.setText("Events History for " + signal.name);
        this.pack();
    }

    private void initOwnComponents() {
        this.chart.setBackground(Color.white);
        this.chart.setChartBackground(Color.lightGray);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.setHeader("History");
        this.chart.setLabelFont(new Font("Dialog", 1, 12));
        this.chart.getY1Axis().setName("Read Value");
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getXAxis().setName("Time");
        this.chart.getXAxis().setGridVisible(true);
        this.chart.setPreferredSize(new Dimension(800, 600));
        this.chart.setJLChartListener((IJLChartListener)this);
        this.getContentPane().add((Component)this.chart, "Center");
        int nb = 0;
        for (int i = 0; nb == 0 && i < this.signal.histo.size(); ++i) {
            SubscribedSignal.EventHisto histo = (SubscribedSignal.EventHisto)this.signal.histo.get(i);
            if (histo.values == null) continue;
            nb = histo.values.length;
        }
        AstorUtil util = AstorUtil.getInstance();
        util.initColors(nb);
        JLDataView[] dv = new JLDataView[nb];
        for (int i = 0; i < nb; ++i) {
            dv[i] = new JLDataView();
            dv[i].setColor(util.getNewColor());
            dv[i].setName("Values[" + i + "]");
            dv[i].setLabelVisible(false);
            dv[i].setMarker(8);
            JLAxis axis = this.chart.getY1Axis();
            axis.addDataView(dv[i]);
        }
        double x = 0.0;
        double y = 0.0;
        double maxi = 0.0;
        for (int i = 0; i < this.signal.histo.size(); ++i) {
            SubscribedSignal.EventHisto histo = (SubscribedSignal.EventHisto)this.signal.histo.get(i);
            if (histo.values == null) continue;
            double max = 0.0;
            for (int v = 0; v < histo.values.length; ++v) {
                x = histo.time;
                y = histo.values[v];
                if (y > max) {
                    max = y;
                }
                this.chart.addData(dv[v], x, y);
            }
        }
    }

    public String[] clickOnChart(JLChartEvent event) {
        JLDataView dv = event.getDataView();
        int idx = event.getDataViewIndex();
        DataList data = dv.getData();
        for (int i = 0; i < idx; ++i) {
            data = data.next;
        }
        String[] retVal = new String[4];
        retVal[0] = new Date((long)data.x).toString();
        retVal[1] = "Value = " + SubscribedSignal.formatValue(data.y);
        SubscribedSignal.EventHisto histo = (SubscribedSignal.EventHisto)this.signal.histo.get(idx);
        retVal[2] = "Delta Value = " + histo.d_value;
        retVal[3] = "Delta time  = " + histo.d_time;
        return retVal;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HistoryDialog.this.closeDialog(evt);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HistoryDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
    }
}

