/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.PolledElement;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.util.Vector;

public class DevPollStatus
extends Vector {
    private DeviceProxy dev;
    private static final boolean FULL_NAME = true;
    private static final boolean ATTR_NAME = false;

    public DevPollStatus(String devname) throws DevFailed {
        this.dev = new DeviceProxy(devname).get_adm_dev();
        this.readData(devname, false);
    }

    public DevPollStatus(String[] devnames) throws DevFailed {
        boolean full_name = true;
        if (devnames.length < 2) {
            full_name = false;
        }
        for (int i = 0; i < devnames.length; ++i) {
            this.dev = new DeviceProxy(devnames[i]).get_adm_dev();
            this.readData(devnames[i], full_name);
        }
    }

    private void readData(String devname, boolean full_name) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        DeviceData argout = this.dev.command_inout("DevPollStatus", argin);
        String[] s = argout.extractStringArray();
        for (int i = 0; i < s.length; ++i) {
            PolledElement pe = new PolledElement(s[i]);
            boolean found = false;
            for (int j = 0; !found && j < this.size(); ++j) {
                found = full_name ? this.polledElementAt((int)j).name.toLowerCase().equals(devname + "/" + pe.name.toLowerCase()) : this.polledElementAt((int)j).name.toLowerCase().equals(pe.name.toLowerCase());
            }
            if (found) continue;
            if (full_name) {
                pe.name = devname + "/" + pe.name;
            }
            this.add(pe);
        }
    }

    public PolledElement polledElementAt(int i) {
        return (PolledElement)this.get(i);
    }

    static void displaySyntax() {
        System.out.println("device name ?");
        System.exit(1);
    }

    public static void main(String[] args) {
        String devname = null;
        if (args.length > 0) {
            devname = args[0];
        } else {
            DevPollStatus.displaySyntax();
        }
        try {
            DevPollStatus client = new DevPollStatus(devname);
            for (int i = 0; i < client.size(); ++i) {
                String[] info = client.polledElementAt(i).getInfo();
                for (int j = 0; j < info.length; ++j) {
                    System.out.println(info[j]);
                }
                System.out.println();
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
            System.exit(1);
        }
        System.exit(0);
    }
}

