/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.CommunicationFailed;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.EventSystemFailed;
import fr.esrf.TangoApi.NonDbDevice;
import fr.esrf.TangoApi.NonSupportedFeature;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoApi.WrongNameSyntax;
import fr.esrf.TangoDs.Except;
import java.awt.Color;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class AstorUtil
implements AstorDefs {
    private static DbClass _class = null;
    private static AstorUtil instance = null;
    private static short readInfoPeriod = (short)5;
    private static short nbStartupLevels = (short)5;
    private static String rloginCmd = null;
    private static String rloginUser = null;
    private static String[] tools = null;
    private static String[] known_tango_hosts = null;
    private static String[] last_collec = null;
    private static boolean jiveReadOnly = false;
    private static String serverHelpURL = "http://www.esrf.fr/computing/cs/tango/";
    private static String appliHelpURL = "http://www.esrf.fr/computing/cs/tango/";
    private static boolean properties_read = false;
    private static boolean debug = false;
    private static boolean no_ctrl_btn = false;
    private static String[] helps;
    MyCompare compare = new MyCompare();
    private static final String[] astor_propnames;
    private static boolean _osIsUnix;
    private static boolean _osIsUnixTested;
    private static RGB rgb;

    private AstorUtil() {
    }

    public static AstorUtil getInstance() {
        if (instance == null) {
            instance = new AstorUtil();
        }
        return instance;
    }

    static boolean getCtrlBtn() {
        if (!no_ctrl_btn) {
            AstorUtil.readAstorProperties();
        }
        return !no_ctrl_btn;
    }

    static boolean getDebug() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return debug;
    }

    public static String getRloginCmd() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return rloginCmd;
    }

    public static void setRloginCmd(String s) {
        rloginCmd = s;
    }

    public static String getRloginUser() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return rloginUser;
    }

    public static void setRloginUser(String s) {
        rloginUser = s;
    }

    public static void setTools(String[] t) {
        tools = t;
    }

    public static String[] getTools() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return tools;
    }

    public static void setHtmlHelps(String[] h) {
        helps = h;
    }

    public static String[] getHtmlHelps() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return helps;
    }

    public static String[] getKnownTangoHosts() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return known_tango_hosts;
    }

    public static void setKnownTangoHosts(String[] kth) {
        known_tango_hosts = kth;
    }

    static void readAstorProperties() {
        try {
            Database dbase = ApiUtil.get_db_obj();
            DbDatum[] data = dbase.get_property("Astor", astor_propnames);
            int i = -1;
            if (!data[++i].is_empty()) {
                debug = data[i].extractBoolean();
            }
            if (!data[++i].is_empty()) {
                last_collec = data[i].extractStringArray();
            }
            if (!data[++i].is_empty()) {
                rloginCmd = data[i].extractString();
            }
            if (!data[++i].is_empty()) {
                rloginUser = data[i].extractString();
            }
            if (!data[++i].is_empty()) {
                no_ctrl_btn = data[i].extractBoolean();
            }
            if (!data[++i].is_empty()) {
                jiveReadOnly = data[i].extractBoolean();
            }
            if (!data[++i].is_empty()) {
                known_tango_hosts = data[i].extractStringArray();
            }
            if (!data[++i].is_empty()) {
                tools = data[i].extractStringArray();
            }
            if (!data[++i].is_empty()) {
                helps = data[i].extractStringArray();
            }
            properties_read = true;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    static void putAstorProperties() throws DevFailed {
        Database dbase = ApiUtil.get_db_obj();
        DbDatum[] data = new DbDatum[astor_propnames.length];
        int i = 0;
        data[i] = new DbDatum(astor_propnames[i]);
        data[i++].insert(debug);
        data[i] = new DbDatum(astor_propnames[i]);
        data[i++].insert(last_collec);
        data[i] = new DbDatum(astor_propnames[i]);
        data[i++].insert(rloginCmd);
        data[i] = new DbDatum(astor_propnames[i]);
        data[i++].insert(rloginUser);
        data[i] = new DbDatum(astor_propnames[i]);
        data[i++].insert(no_ctrl_btn);
        data[i] = new DbDatum(astor_propnames[i]);
        data[i++].insert(jiveReadOnly);
        data[i] = new DbDatum(astor_propnames[i]);
        data[i++].insert(known_tango_hosts);
        data[i] = new DbDatum(astor_propnames[i]);
        data[i++].insert(tools);
        data[i] = new DbDatum(astor_propnames[i]);
        data[i++].insert(helps);
        dbase.put_property("Astor", data);
    }

    void setJiveReadOnly(boolean b) {
        jiveReadOnly = b;
    }

    boolean jiveIsReadOnly() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return jiveReadOnly;
    }

    void setLastCollectionList(String[] lcl) {
        last_collec = lcl;
    }

    String[] getLastCollectionList() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return last_collec;
    }

    String[] getCollectionList(TangoHost[] hosts) {
        Vector<String> vect = new Vector<String>();
        for (int i = 0; i < hosts.length; ++i) {
            if (hosts[i].collection == null) {
                hosts[i].collection = "Miscellaneous";
            }
            boolean found = false;
            for (int j = 0; j < vect.size() && !found; ++j) {
                found = hosts[i].collection.equals(vect.elementAt(j));
            }
            if (found) continue;
            vect.add(hosts[i].collection);
        }
        Collections.sort(vect, this.compare);
        vect.add(0, "Tango Database");
        String[] last = this.getLastCollectionList();
        if (last != null) {
            for (int i = 0; i < last.length; ++i) {
                boolean found = false;
                for (int j = 0; !found && j < vect.size(); ++j) {
                    found = last[i].equals(vect.get(j).toString());
                    if (!found) continue;
                    String s = vect.get(j).toString();
                    vect.remove(j);
                    vect.add(s);
                }
            }
        }
        String[] list = new String[vect.size()];
        for (int i = 0; i < vect.size(); ++i) {
            list[i] = (String)vect.elementAt(i);
        }
        return list;
    }

    public TangoHost[] getTangoHostList() throws DevFailed {
        String[] hostnames = this.getHostControlledList();
        TangoHost[] hosts = new TangoHost[hostnames.length];
        int i = 0;
        int j = 0;
        while (i < hostnames.length) {
            hosts[j] = new TangoHost(hostnames[i]);
            ++i;
            ++j;
        }
        return hosts;
    }

    private String[] getHostControlledList() throws DevFailed {
        Database dbase = ApiUtil.get_db_obj();
        return dbase.get_device_member("tango/admin/*");
    }

    public static String getTangoHost() {
        return System.getProperty("TANGO_HOST");
    }

    public static void setTangoHost(String tango_host) {
        Properties props = System.getProperties();
        props.put("TANGO_HOST", tango_host);
        System.setProperties(props);
        _class = null;
    }

    public static short getStarterReadPeriod() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return readInfoPeriod;
    }

    public static short getStarterNbStartupLevels() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return nbStartupLevels;
    }

    public static String getStarterHelpURL() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return serverHelpURL;
    }

    public static String getAppliHelpURL() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return appliHelpURL;
    }

    private static void getStarterClassProperties() {
        try {
            _class = new DbClass("Starter");
            String[] propnames = new String[]{"NbStartupLevels", "ReadInfoDbPeriod", "doc_url", "appli_doc_url"};
            DbDatum[] properties = _class.get_property(propnames);
            if (!properties[0].is_empty()) {
                nbStartupLevels = properties[0].extractShort();
            }
            if (!properties[1].is_empty()) {
                readInfoPeriod = properties[1].extractShort();
            }
            readInfoPeriod = (short)(readInfoPeriod * 1000);
            if (!properties[2].is_empty()) {
                serverHelpURL = properties[2].extractString();
            }
            if (!properties[3].is_empty()) {
                appliHelpURL = properties[3].extractString();
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
        if (AstorUtil.getDebug()) {
            System.out.println("NbStartupLevels:  " + nbStartupLevels);
            System.out.println("ReadInfoDbPeriod: " + readInfoPeriod);
            System.out.println("server doc_url:   " + serverHelpURL);
            System.out.println("appli_doc_url:    " + appliHelpURL);
        }
    }

    static String[] getServerClassProperties(String classname) {
        String[] result = new String[3];
        try {
            DbClass dbclass = new DbClass(classname);
            String[] propnames = new String[]{"ProjectTitle", "Description", "doc_url"};
            DbDatum[] prop = dbclass.get_property(propnames);
            if (!prop[0].is_empty()) {
                result[0] = prop[0].extractString();
            }
            if (!prop[1].is_empty()) {
                String[] desc = prop[1].extractStringArray();
                result[1] = "";
                for (int i = 0; i < desc.length; ++i) {
                    result[1] = result[1] + desc[i];
                    if (i >= desc.length - 1) continue;
                    result[1] = result[1] + "\n";
                }
            }
            result[2] = prop[2].is_empty() ? "Doc location unknown...." : prop[2].extractString();
        }
        catch (DevFailed e) {
            result[2] = null;
            result[1] = null;
            result[0] = null;
        }
        return result;
    }

    public static String strException(Exception except) {
        String str = "";
        if (except instanceof ConnectionFailed) {
            str = str + ((ConnectionFailed)except).getStack();
        } else if (except instanceof CommunicationFailed) {
            str = str + ((CommunicationFailed)except).getStack();
        } else if (except instanceof WrongNameSyntax) {
            str = str + ((WrongNameSyntax)except).getStack();
        } else if (except instanceof WrongData) {
            str = str + ((WrongData)except).getStack();
        } else if (except instanceof NonDbDevice) {
            str = str + ((NonDbDevice)except).getStack();
        } else if (except instanceof NonSupportedFeature) {
            str = str + ((NonSupportedFeature)except).getStack();
        } else if (except instanceof EventSystemFailed) {
            str = str + ((EventSystemFailed)except).getStack();
        } else if (except instanceof AsynReplyNotArrived) {
            str = str + ((AsynReplyNotArrived)except).getStack();
        } else if (except instanceof DevFailed) {
            DevFailed df = (DevFailed)((Object)except);
            str = str + "Tango exception  " + df.toString() + "\n";
            for (int i = 0; i < df.errors.length; ++i) {
                str = str + "Severity -> ";
                switch (df.errors[i].severity.value()) {
                    case 0: {
                        str = str + "WARNING \n";
                        break;
                    }
                    case 1: {
                        str = str + "ERROR \n";
                        break;
                    }
                    case 2: {
                        str = str + "PANIC \n";
                        break;
                    }
                    default: {
                        str = str + "Unknown severity code";
                    }
                }
                str = str + "Desc   -> " + df.errors[i].desc + "\n";
                str = str + "Reason -> " + df.errors[i].reason + "\n";
                str = str + "Origin -> " + df.errors[i].origin + "\n";
                if (i >= df.errors.length - 1) continue;
                str = str + "-------------------------------------------------------------\n";
            }
        } else {
            str = except.toString();
        }
        return str;
    }

    public static void centerDialog(JDialog dialog, JFrame parent) {
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - dialog.getWidth()) / 2;
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        if (p.y <= 0) {
            p.y = 20;
        }
        if (p.x <= 0) {
            p.x = 20;
        }
        dialog.setLocation(p);
    }

    public static void centerDialog(JDialog dialog, JDialog parent) {
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - dialog.getWidth()) / 2;
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        if (p.y <= 0) {
            p.y = 20;
        }
        if (p.x <= 0) {
            p.x = 20;
        }
        dialog.setLocation(p);
    }

    public static void rightShiftDialog(JDialog dialog, JFrame parent) {
        Point p = parent.getLocationOnScreen();
        p.x += parent.getWidth();
        p.y += (parent.getHeight() - dialog.getHeight()) / 2;
        if (p.y <= 0) {
            p.y = 20;
        }
        if (p.x <= 0) {
            p.x = 20;
        }
        dialog.setLocation(p);
    }

    static String[] string2StringArray(String str) {
        int idx;
        Vector<String> v = new Vector<String>();
        while ((idx = str.indexOf("\n")) > 0) {
            v.add(str.substring(0, idx));
            str = str.substring(idx + 1);
        }
        v.add(str);
        String[] result = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            result[i] = (String)v.elementAt(i);
        }
        return result;
    }

    public static void executeShellCmdAndReturn(String cmd) throws Exception {
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream istr = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(istr));
    }

    public static String executeShellCmd(String cmd) throws Exception {
        String str;
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream istr = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(istr));
        String sb = "";
        while ((str = br.readLine()) != null) {
            sb = sb + str + "\n";
        }
        proc.waitFor();
        int retVal = proc.exitValue();
        if (retVal != 0) {
            InputStream errstr = proc.getErrorStream();
            br = new BufferedReader(new InputStreamReader(errstr));
            while ((str = br.readLine()) != null) {
                System.out.println(str);
                sb = sb + str + "\n";
            }
            Except.throw_exception((String)"SHELL_CMD_FAILED", (String)("the shell command\n" + cmd + "\nreturns : " + retVal + " !\n\n" + sb), (String)"AstorUtil.executeShellCmd()");
        }
        return sb;
    }

    public static boolean osIsUnix() {
        if (!_osIsUnixTested) {
            try {
                String os = System.getProperty("os.name");
                _osIsUnix = !os.toLowerCase().startsWith("windows");
            }
            catch (Exception e) {
                _osIsUnix = false;
            }
        }
        return _osIsUnix;
    }

    public void initColors(int nb) {
        if (rgb == null) {
            rgb = new RGB(nb);
        } else {
            rgb.initColor(nb);
        }
    }

    public Color getNewColor() {
        if (rgb == null) {
            rgb = new RGB();
        }
        return rgb.getNewColor();
    }

    public void sort(Vector[] array) {
        for (int i = 0; i < array.length; ++i) {
            Collections.sort(array[i], this.compare);
        }
    }

    public void sort(Vector v) {
        Collections.sort(v, this.compare);
    }

    static {
        astor_propnames = new String[]{"Debug", "LastCollections", "RloginCmd", "RloginUser", "NoCtrlButton", "JiveReadOnly", "KnownTangoHosts", "Tools", "HtmlHelps"};
        _osIsUnix = true;
        _osIsUnixTested = false;
        rgb = null;
    }

    class MyCompare
    implements Comparator {
        MyCompare() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1.toString().toLowerCase();
            String s2 = o2.toString().toLowerCase();
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }

    class RGB {
        int r = 0;
        int g = 0;
        int b = 0;
        int step = 10;
        private boolean red = true;
        private boolean green = false;
        private boolean blue = false;

        RGB() {
        }

        RGB(int nb) {
            this.initColor(nb);
        }

        void initColor(int nb) {
            this.step = 1020 / nb;
            if (this.step == 255) {
                this.step = 128;
            }
            this.red = true;
            this.green = false;
            this.blue = false;
            this.b = 0;
            this.g = 0;
            this.r = 0;
        }

        void increase() {
            if (this.red) {
                if (this.r + this.step < 255) {
                    this.r += this.step;
                } else {
                    this.r = 255;
                    this.red = false;
                    this.green = true;
                }
            } else if (this.green) {
                if (this.g + this.step < 255) {
                    if (this.r - this.step > 0) {
                        this.r -= this.step;
                    }
                    this.g += this.step;
                } else {
                    this.g = 255;
                    this.green = false;
                    this.blue = true;
                }
            } else if (this.blue) {
                if (this.b + this.step < 255) {
                    if (this.g - this.step > 0) {
                        this.g -= this.step;
                    }
                    this.b += this.step;
                } else {
                    this.b = 255;
                    this.r = 255;
                    this.blue = false;
                }
            } else if (this.r - this.step > 0) {
                this.r -= this.step;
                this.b -= this.step;
            }
        }

        Color getNewColor() {
            this.increase();
            return new Color(this.r, this.g, this.b);
        }
    }
}

