/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.ControlPanel;
import fr.esrf.logviewer.DetailPanel;
import fr.esrf.logviewer.ExitAction;
import fr.esrf.logviewer.HistoryArea;
import fr.esrf.logviewer.LoadXMLAction;
import fr.esrf.logviewer.MyTableModel;
import fr.esrf.logviewer.TangoLoggingReceiver;
import fr.esrf.tangoatk.widget.device.Tree;
import fr.esrf.tangoatk.widget.device.tree.DomainNode;
import fr.esrf.tangoatk.widget.device.tree.FamilyNode;
import fr.esrf.tangoatk.widget.device.tree.MemberNode;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main
extends JFrame {
    private static final Logger LOG = Logger.getLogger((Class)(class$fr$esrf$logviewer$Main == null ? (class$fr$esrf$logviewer$Main = Main.class$("fr.esrf.logviewer.Main")) : class$fr$esrf$logviewer$Main));
    private static TangoLoggingReceiver mTlr;
    private static Tree mAtkTree;
    private static JPopupMenu mRootPopup;
    private static JPopupMenu mDomainFamilyPopup;
    private static JPopupMenu mMemberPopup;
    private static JMenu mDomainFamilyLevelMenu;
    private static JMenuItem mDomainFamilyNameItem;
    private static JMenu mMemberLevelMenu;
    private static ButtonGroup mMemberLevelGroup1;
    private static ButtonGroup mMemberLevelGroup2;
    private static JMenuItem mMemberNameItem;
    private static JMenu mMemberColocatedLevelMenu;
    private static JMenuItem mColocatedDevNameItem;
    private static CustomLabel mLabel;
    private static HistoryArea mHistoryArea;
    private boolean mPopupTrigger = false;
    private boolean closeOnExit = false;
    static /* synthetic */ Class class$fr$esrf$logviewer$Main;

    public Main(JFrame jFrame) {
        this(new String[0], true);
    }

    private Main(String[] stringArray, boolean bl) {
        super("Tango LogViewer (exported as ...)");
        JMenuItem jMenuItem;
        Serializable serializable;
        this.closeOnExit = bl;
        String string = System.getProperty("HOST");
        Object var4_4 = null;
        Splash splash = new Splash();
        splash.setTitle("TANGO LogViewer");
        splash.setVersion("1.1.0");
        splash.setAuthor("Stolen and hacked by Nicolas Leclercq");
        splash.setCopyright("(c) TANGO Team 2002-2004 / (c) Apache Project 2002");
        splash.initProgress(10);
        splash.setMessage("Setting up UI...");
        int n = 1;
        splash.progress(n++);
        Font font = new Font("terminal", 0, 12);
        UIManager.put("Label.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("Button.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TableColumn.font", font);
        UIManager.put("TextArea.font", font);
        MyTableModel myTableModel = new MyTableModel();
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        try {
            serializable = new LoadXMLAction(this, myTableModel);
            jMenuItem = new JMenuItem("Load file...");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener((ActionListener)((Object)serializable));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            LOG.info((Object)"Missing classes for XML parser", (Throwable)noClassDefFoundError);
            JOptionPane.showMessageDialog(this, "XML parser not in classpath - unable to load XML events.", "Tango LogViewer", 0);
        }
        catch (Exception exception) {
            LOG.info((Object)"Unable to create the action to load XML files", (Throwable)exception);
            JOptionPane.showMessageDialog(this, "Unable to create a XML parser - unable to load XML events.", "Tango LogViewer", 0);
        }
        serializable = new JMenuItem("Exit");
        jMenu.add((JMenuItem)serializable);
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.exitBtnActionPerformed(actionEvent);
            }
        });
        jMenuItem = new JMenu("Actions");
        jMenuBar.add((JMenu)jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Refresh Device Tree");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                mLabel.setText("Refreshing the device tree... ");
                mAtkTree.refresh();
                mLabel.setText(" ");
            }
        });
        ((JMenu)jMenuItem).add(jMenuItem2);
        ((JMenu)jMenuItem).add(new JSeparator());
        jMenuItem2 = new JMenuItem("Logging Source List");
        jMenuItem2.addActionListener(new SourceListActionListener());
        ((JMenu)jMenuItem).add(jMenuItem2);
        ((JMenu)jMenuItem).add(new JSeparator());
        jMenuItem2 = new JMenuItem("Remove All Logging Source");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                mLabel.setText("Removing all logging source... ");
                if (mTlr.removeAllSources() != -1) {
                    mHistoryArea.write("Removed all sources");
                }
                mLabel.setText(" ");
            }
        });
        ((JMenu)jMenuItem).add(jMenuItem2);
        splash.progress(n++);
        ControlPanel controlPanel = new ControlPanel(myTableModel, this, bl);
        this.getContentPane().add((Component)controlPanel, "North");
        splash.progress(n++);
        JTable jTable = new JTable(myTableModel);
        jTable.setRowSelectionAllowed(true);
        jTable.setColumnSelectionAllowed(true);
        jTable.setDragEnabled(true);
        jTable.setSelectionMode(0);
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        LogTableRowRenderer logTableRowRenderer = new LogTableRowRenderer();
        int n2 = 0;
        int[] nArray = new int[]{60, 140, 75, 155, 500};
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setCellRenderer(logTableRowRenderer);
            tableColumn.setPreferredWidth(nArray[n2++]);
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Logs"));
        jScrollPane.setMinimumSize(new Dimension(150, 150));
        jScrollPane.setPreferredSize(new Dimension(790, 450));
        splash.progress(n++);
        DetailPanel detailPanel = new DetailPanel(jTable, myTableModel);
        detailPanel.setMinimumSize(new Dimension(0, 0));
        detailPanel.setPreferredSize(new Dimension(790, 0));
        splash.progress(n++);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, detailPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerSize(9);
        mAtkTree = new Tree();
        mAtkTree.getSelectionModel().setSelectionMode(1);
        mAtkTree.setMinimumSize(new Dimension(0, 0));
        mAtkTree.setDragEnabled(true);
        mAtkTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Main.this.deviceTreeMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Main.this.deviceTreeMouseReleased(mouseEvent);
            }
        });
        splash.progress(n++);
        mRootPopup = new JPopupMenu();
        jMenuItem2 = new JMenuItem("Refresh");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                mLabel.setText("Refreshing the device tree... ");
                mAtkTree.refresh();
                mLabel.setText(" ");
            }
        });
        mRootPopup.add(jMenuItem2);
        mDomainFamilyPopup = new JPopupMenu();
        mDomainFamilyNameItem = new JMenuItem("domain/family/goes.here");
        mDomainFamilyNameItem.setEnabled(false);
        mDomainFamilyPopup.add(mDomainFamilyNameItem);
        mDomainFamilyPopup.add(new JSeparator());
        jMenuItem2 = new JMenuItem("Add");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.addLoggingSource();
            }
        });
        mDomainFamilyPopup.add(jMenuItem2);
        mDomainFamilyPopup.add(new JSeparator());
        jMenuItem2 = new JMenuItem("Remove");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.removeLoggingSource();
            }
        });
        mDomainFamilyPopup.add(jMenuItem2);
        mDomainFamilyPopup.add(new JSeparator());
        mDomainFamilyPopup.add(new BasicLoggingLevelMenu("Set Logging Level"));
        mMemberPopup = new JPopupMenu();
        mMemberNameItem = new JMenuItem("dev/name/goes.here");
        mMemberNameItem.setEnabled(false);
        mMemberPopup.add(mMemberNameItem);
        mMemberPopup.add(new JSeparator());
        jMenuItem2 = new JMenuItem("Add");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.addLoggingSource();
            }
        });
        mMemberPopup.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Add Colocated");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.addColocatedSources();
            }
        });
        mMemberPopup.add(jMenuItem2);
        mMemberLevelGroup1 = new ButtonGroup();
        mMemberPopup.add(new LoggingLevelMenu("Add/Set Logging Level", mMemberLevelGroup1, true));
        mMemberPopup.add(new JSeparator());
        jMenuItem2 = new JMenuItem("Remove");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.removeLoggingSource();
            }
        });
        mMemberPopup.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Remove Colocated");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.removeColocatedSources();
            }
        });
        mMemberPopup.add(jMenuItem2);
        mMemberPopup.add(jMenuItem2);
        mMemberPopup.add(new JSeparator());
        mMemberLevelGroup2 = new ButtonGroup();
        mMemberPopup.add(new LoggingLevelMenu("Set Logging Level", mMemberLevelGroup2, false));
        mMemberPopup.add(new BasicLoggingLevelMenu("Set Logging Level (colocated)"));
        JScrollPane jScrollPane2 = new JScrollPane((Component)mAtkTree);
        JSplitPane jSplitPane2 = new JSplitPane(1, jScrollPane2, jSplitPane);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setDividerSize(9);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Main.this.windowClosingPerformed(windowEvent);
            }
        });
        splash.progress(n++);
        jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createTitledBorder("History"));
        mHistoryArea = new HistoryArea(jScrollPane);
        mHistoryArea.setMinimumSize(new Dimension(0, 0));
        Date date = new Date(System.currentTimeMillis());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
        mHistoryArea.write("Welcome to the TANGO LogViewer (started on " + dateFormat.format(date) + ")");
        jScrollPane.setViewportView(mHistoryArea);
        JSplitPane jSplitPane3 = new JSplitPane(0, jSplitPane2, jScrollPane);
        jSplitPane3.setOneTouchExpandable(true);
        jSplitPane3.setDividerSize(9);
        this.getContentPane().add((Component)jSplitPane3, "Center");
        splash.progress(n++);
        mLabel = new CustomLabel();
        mLabel.setBorder(new SoftBevelBorder(1));
        this.getContentPane().add((Component)mLabel, "South");
        splash.setMessage("Starting up the LogConsumer device...");
        this.setupReceiver(stringArray, myTableModel);
        splash.progress(n++);
        if (mTlr.isRunningInStaticMode()) {
            ((JMenu)jMenuItem).add(new JSeparator());
            jMenu = new JMenu("Logging Sources Property");
            jMenuItem2 = new JMenuItem("Save");
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    mLabel.setText("Saving logging source list into the TANGO database...");
                    mTlr.setLoggingSourceProperty();
                    mLabel.setText(" ");
                }
            });
            jMenu.add(jMenuItem2);
            jMenuItem2 = new JMenuItem("Delete");
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    mLabel.setText("Deleting logging source list from the TANGO database...");
                    mTlr.deleteLoggingSourceProperty();
                    mLabel.setText(" ");
                }
            });
            jMenu.add(jMenuItem2);
            jMenuItem2 = new JMenuItem("Restore");
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    mLabel.setText("Restoring logging sources from the TANGO database...");
                    mTlr.removeAllSources();
                    mTlr.getLoggingSourceProperty();
                    mLabel.setText(" ");
                }
            });
            jMenu.add(jMenuItem2);
            ((JMenu)jMenuItem).add(jMenu);
        }
        String string2 = mTlr.getDeviceName();
        this.setTitle("Tango Log Viewer [" + string2 + "]");
        this.pack();
        this.setLocationRelativeTo((Component)splash);
        splash.setVisible(false);
        this.setVisible(true);
        splash.toFront();
        splash.setVisible(true);
        mAtkTree.setVisible(false);
        splash.setMessage("Initializing device tree...");
        mLabel.setText("Initializing the device tree... ");
        mAtkTree.refresh();
        mLabel.setText(" ");
        splash.progress(n++);
        splash.setVisible(false);
        splash.dispose();
        mAtkTree.setVisible(true);
    }

    private void exitBtnActionPerformed(ActionEvent actionEvent) {
        if (this.closeOnExit) {
            this.setVisible(false);
        } else {
            ExitAction.INSTANCE.actionPerformed(null);
        }
    }

    private void windowClosingPerformed(WindowEvent windowEvent) {
        if (this.closeOnExit) {
            this.setVisible(false);
        } else {
            ExitAction.INSTANCE.actionPerformed(null);
        }
    }

    private void setupReceiver(String[] stringArray, MyTableModel myTableModel) {
        try {
            mTlr = new TangoLoggingReceiver(stringArray, myTableModel, mHistoryArea);
            mTlr.start();
        }
        catch (Exception exception) {
            LOG.fatal((Object)"Unable to instanciate the TANGO log consumer device. Quiting", (Throwable)exception);
            JOptionPane.showMessageDialog(this, "Unable to instanciate the TANGO log consumer device. Quiting", "Tango Log Viewer", 0);
            if (this.closeOnExit) {
                this.setVisible(false);
            }
            ExitAction.INSTANCE.actionPerformed(null);
        }
    }

    private void addLoggingSource() {
        Object object = mAtkTree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof DomainNode)) {
            return;
        }
        if (object instanceof MemberNode) {
            String string = ((MemberNode)object).getName();
            mLabel.setText("Contacting " + string + "...");
            if (mTlr.addLoggingSource(string) != -1) {
                mHistoryArea.write("Added " + string);
            }
        } else {
            String string = "logging sources matching " + ((DomainNode)object).getName() + "/*";
            mLabel.setText("Adding " + string);
            if (mTlr.addLoggingSources(((DomainNode)object).getName() + "/*") != -1) {
                mHistoryArea.write("Added " + string);
            }
        }
        mLabel.reset();
    }

    private void addTangoCoreLogger() {
        Object object = mAtkTree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof DomainNode)) {
            return;
        }
        if (object instanceof MemberNode) {
            String string = ((MemberNode)object).getName();
            mLabel.setText("Contacting admin device for " + string);
            if (mTlr.addTangoCoreLogger(string) != -1) {
                mHistoryArea.write("Added Tango core logger for " + string);
            }
        }
        mLabel.reset();
    }

    private void addColocatedSources() {
        Object object = mAtkTree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof MemberNode)) {
            return;
        }
        String string = ((MemberNode)object).getName();
        mLabel.setText("Adding  " + string + " and colocated devices...");
        if (mTlr.addColocatedSources(string) != -1) {
            mHistoryArea.write("Added  " + string + " and colocated devices");
        }
        mLabel.reset();
    }

    private void removeLoggingSource() {
        Object object = mAtkTree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof DomainNode)) {
            return;
        }
        if (object instanceof MemberNode) {
            String string = ((MemberNode)object).getName();
            mLabel.setText("Contacting " + string + "...");
            if (mTlr.removeLoggingSource(string) != -1) {
                mHistoryArea.write("Removed " + string);
            }
        } else {
            String string = "logging sources matching " + ((DomainNode)object).getName() + "/*";
            mLabel.setText("Removing " + string);
            if (mTlr.removeLoggingSources(((DomainNode)object).getName() + "/*") != -1) {
                mHistoryArea.write("Removed " + string);
            }
        }
        mLabel.reset();
    }

    private void removeTangoCoreLogger() {
        Object object = mAtkTree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof DomainNode)) {
            return;
        }
        if (object instanceof MemberNode) {
            String string = ((MemberNode)object).getName();
            mLabel.setText("Contacting admin device for " + string);
            if (mTlr.removeTangoCoreLogger(string) != -1) {
                mHistoryArea.write("Removed Tango core logger for " + string);
            }
        }
        mLabel.reset();
    }

    private void removeColocatedSources() {
        Object object = mAtkTree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof MemberNode)) {
            return;
        }
        String string = ((MemberNode)object).getName();
        mLabel.setText("Removing  " + string + " and colocated devices...");
        if (mTlr.removeColocatedSources(string) != -1) {
            mHistoryArea.write("Removed  " + string + " and colocated devices");
        }
        mLabel.reset();
    }

    public void deviceTreeMousePressed(MouseEvent mouseEvent) {
        int n = mAtkTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n != -1) {
            LoggingLevelMenuItem loggingLevelMenuItem;
            this.mPopupTrigger = mouseEvent.isPopupTrigger();
            mAtkTree.setSelectionRow(n);
            Object object = mAtkTree.getLastSelectedPathComponent();
            if (object == null || !(object instanceof MemberNode)) {
                return;
            }
            mLabel.setText("Contacting " + ((MemberNode)object).getName());
            int n2 = mTlr.getDeviceLoggingLevel(((MemberNode)object).getName());
            mLabel.reset();
            if (n2 == -1) {
                return;
            }
            Enumeration<AbstractButton> enumeration = mMemberLevelGroup1.getElements();
            while (enumeration.hasMoreElements()) {
                loggingLevelMenuItem = (LoggingLevelMenuItem)enumeration.nextElement();
                if (loggingLevelMenuItem.getLevel() != n2) continue;
                loggingLevelMenuItem.setSelected(true);
                break;
            }
            enumeration = mMemberLevelGroup2.getElements();
            while (enumeration.hasMoreElements()) {
                loggingLevelMenuItem = (LoggingLevelMenuItem)enumeration.nextElement();
                if (loggingLevelMenuItem.getLevel() != n2) continue;
                loggingLevelMenuItem.setSelected(true);
                break;
            }
        }
    }

    public void deviceTreeMouseReleased(MouseEvent mouseEvent) {
        int n = mAtkTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n != -1 && (mouseEvent.isPopupTrigger() || this.mPopupTrigger)) {
            mAtkTree.setSelectionRow(n);
            Object object = mAtkTree.getLastSelectedPathComponent();
            if (object == null || !(object instanceof DefaultMutableTreeNode)) {
                return;
            }
            LOG.debug((Object)("n is a " + object.getClass().getName()));
            if (object instanceof MemberNode) {
                mMemberNameItem.setText(((DomainNode)object).getName());
                mMemberPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (object instanceof DomainNode || object instanceof FamilyNode) {
                mDomainFamilyNameItem.setText(((DomainNode)object).getName());
                mDomainFamilyPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else {
                mRootPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private static void initLog4J() {
        Properties properties = new Properties();
        properties.setProperty("log4j.rootCategory", "ERROR, A1");
        properties.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.A1.layout", "org.apache.log4j.TTCCLayout");
        PropertyConfigurator.configure((Properties)properties);
    }

    public static void cleanup() {
        mTlr.cleanup();
    }

    public static void main(String[] stringArray) {
        Main.initLog4J();
        new Main(stringArray, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class LogTableRowRenderer
    extends DefaultTableCellRenderer {
        private final Color _scolor = new Color(204, 204, 255);
        private final Color _color = new Color(230, 230, 230);
        private final JCheckBox _true = new JCheckBox("", true);
        private final JCheckBox _false = new JCheckBox("", false);

        LogTableRowRenderer() {
            this.setHorizontalAlignment(0);
            this._true.setHorizontalAlignment(0);
            this._false.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            String string = (String)jTable.getColumnModel().getColumn(n2).getHeaderValue();
            if (bl) {
                this.setBackground(this._scolor);
            } else if (string.equals("Level")) {
                object2 = (Level)object;
                if (object2 == Level.FATAL) {
                    this.setBackground(Color.black);
                    this.setForeground(Color.white);
                } else if (object2 == Level.ERROR) {
                    this.setBackground(Color.red);
                    this.setForeground(Color.black);
                } else if (object2 == Level.WARN) {
                    this.setBackground(Color.orange);
                    this.setForeground(Color.black);
                } else if (object2 == Level.INFO) {
                    this.setBackground(Color.green);
                    this.setForeground(Color.black);
                } else if (object2 == Level.DEBUG) {
                    this.setBackground(Color.cyan);
                    this.setForeground(Color.black);
                }
            } else {
                if (n % 2 == 0) {
                    this.setBackground(this._color);
                } else {
                    this.setBackground(Color.white);
                }
                this.setForeground(Color.black);
            }
            if (string.equals("Trace")) {
                object2 = (Boolean)object == Boolean.TRUE ? this._true : this._false;
                return object2;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class CustomLabel
    extends JLabel {
        public CustomLabel() {
            super.setText(" ");
        }

        public void setText(String string) {
            super.setText(string);
            this.update(this.getGraphics());
        }

        public void reset() {
            this.setText(" ");
        }
    }

    private class LoggingLevelMenu
    extends JMenu {
        public LoggingLevelMenu(String string, ButtonGroup buttonGroup, boolean bl) {
            super(string);
            ButtonGroup buttonGroup2 = buttonGroup != null ? buttonGroup : new ButtonGroup();
            LoggingLevelMenuItem loggingLevelMenuItem = new LoggingLevelMenuItem("OFF", 0);
            loggingLevelMenuItem.addActionListener(new LevelActionListener(bl));
            loggingLevelMenuItem.setSelected(true);
            buttonGroup2.add(loggingLevelMenuItem);
            this.add(loggingLevelMenuItem);
            loggingLevelMenuItem = new LoggingLevelMenuItem("FATAL", 1);
            loggingLevelMenuItem.addActionListener(new LevelActionListener(bl));
            buttonGroup2.add(loggingLevelMenuItem);
            this.add(loggingLevelMenuItem);
            loggingLevelMenuItem = new LoggingLevelMenuItem("ERROR", 2);
            loggingLevelMenuItem.addActionListener(new LevelActionListener(bl));
            buttonGroup2.add(loggingLevelMenuItem);
            this.add(loggingLevelMenuItem);
            loggingLevelMenuItem = new LoggingLevelMenuItem("WARN", 3);
            loggingLevelMenuItem.addActionListener(new LevelActionListener(bl));
            buttonGroup2.add(loggingLevelMenuItem);
            this.add(loggingLevelMenuItem);
            loggingLevelMenuItem = new LoggingLevelMenuItem("INFO", 4);
            loggingLevelMenuItem.addActionListener(new LevelActionListener(bl));
            buttonGroup2.add(loggingLevelMenuItem);
            this.add(loggingLevelMenuItem);
            loggingLevelMenuItem = new LoggingLevelMenuItem("DEBUG", 5);
            loggingLevelMenuItem.addActionListener(new LevelActionListener(bl));
            buttonGroup2.add(loggingLevelMenuItem);
            this.add(loggingLevelMenuItem);
        }
    }

    private class LoggingLevelMenuItem
    extends JRadioButtonMenuItem {
        private int mLevel;

        public LoggingLevelMenuItem(String string, int n) {
            super(string);
            this.mLevel = n;
        }

        public int getLevel() {
            return this.mLevel;
        }
    }

    private class LevelActionListener
    implements ActionListener {
        private boolean mAddBefore = false;

        public LevelActionListener(boolean bl) {
            this.mAddBefore = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((JMenuItem)actionEvent.getSource()).getText();
            Object object = mAtkTree.getLastSelectedPathComponent();
            if (object == null || !(object instanceof DomainNode)) {
                return;
            }
            if (object instanceof MemberNode) {
                int n = ((LoggingLevelMenuItem)actionEvent.getSource()).getLevel();
                String string2 = ((MemberNode)object).getName();
                mLabel.setText("Contacting " + string2 + "...");
                if (mTlr.setDeviceLoggingLevel(string2, n, this.mAddBefore) != -1) {
                    if (this.mAddBefore) {
                        mHistoryArea.write("Added " + string2);
                    }
                    mHistoryArea.write("Changed " + string2 + " logging level to " + string);
                }
            } else {
                int n = ((BasicLoggingLevelMenuItem)actionEvent.getSource()).getLevel();
                String string3 = "for sources matching " + ((DomainNode)object).getName() + "/* to " + string;
                mLabel.setText("Setting logging level " + string3);
                if (mTlr.setDevicesLoggingLevel(((DomainNode)object).getName() + "/*", n) != -1) {
                    mHistoryArea.write("Changed logging level " + string3);
                }
            }
            mLabel.reset();
        }
    }

    private class BasicLoggingLevelMenu
    extends JMenu {
        public BasicLoggingLevelMenu(String string) {
            super(string);
            BasicLoggingLevelMenuItem basicLoggingLevelMenuItem = new BasicLoggingLevelMenuItem("OFF", 0);
            basicLoggingLevelMenuItem.addActionListener(new BasicLevelActionListener());
            this.add(basicLoggingLevelMenuItem);
            basicLoggingLevelMenuItem = new BasicLoggingLevelMenuItem("FATAL", 1);
            basicLoggingLevelMenuItem.addActionListener(new BasicLevelActionListener());
            this.add(basicLoggingLevelMenuItem);
            basicLoggingLevelMenuItem = new BasicLoggingLevelMenuItem("ERROR", 2);
            basicLoggingLevelMenuItem.addActionListener(new BasicLevelActionListener());
            this.add(basicLoggingLevelMenuItem);
            basicLoggingLevelMenuItem = new BasicLoggingLevelMenuItem("WARN", 3);
            basicLoggingLevelMenuItem.addActionListener(new BasicLevelActionListener());
            this.add(basicLoggingLevelMenuItem);
            basicLoggingLevelMenuItem = new BasicLoggingLevelMenuItem("INFO", 4);
            basicLoggingLevelMenuItem.addActionListener(new BasicLevelActionListener());
            this.add(basicLoggingLevelMenuItem);
            basicLoggingLevelMenuItem = new BasicLoggingLevelMenuItem("DEBUG", 5);
            basicLoggingLevelMenuItem.addActionListener(new BasicLevelActionListener());
            this.add(basicLoggingLevelMenuItem);
        }
    }

    private class BasicLoggingLevelMenuItem
    extends JMenuItem {
        private int mLevel;

        public BasicLoggingLevelMenuItem(String string, int n) {
            super(string);
            this.mLevel = n;
        }

        public int getLevel() {
            return this.mLevel;
        }
    }

    private class BasicLevelActionListener
    implements ActionListener {
        private BasicLevelActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((JMenuItem)actionEvent.getSource()).getText();
            Object object = mAtkTree.getLastSelectedPathComponent();
            if (object == null) {
                return;
            }
            int n = ((BasicLoggingLevelMenuItem)actionEvent.getSource()).getLevel();
            String string2 = "logging level for devices matching " + ((DomainNode)object).getName() + "/* to " + string;
            mLabel.setText("Changing " + string2);
            if (mTlr.setDevicesLoggingLevel(((DomainNode)object).getName() + "/*", n) != -1) {
                mHistoryArea.write("Changed " + string2);
            }
            mLabel.reset();
        }
    }

    private class SourceListActionListener
    implements ActionListener {
        private SourceListActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            mHistoryArea.write("Current source list:");
            String[] stringArray = mTlr.getLoggingSources();
            if (stringArray.length == 0) {
                mHistoryArea.write("\t- none");
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    mHistoryArea.write("\t- " + stringArray[i]);
                }
            }
        }
    }
}

