/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDExtensionEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.MultiLineCellEditor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

class JDExtensionPanel
extends JPanel
implements ActionListener {
    JDObject[] allObjects = null;
    JDrawEditor invoker;
    JTable theTable;
    JScrollPane tableView;
    DefaultTableModel theModel;
    JButton newExtensionBtn;
    JButton delExtensionBtn;
    JButton editExtensionBtn;
    JButton helpExtensionBtn;
    JButton applyBtn;
    MultiLineCellEditor cellEditor = null;
    static String[] colName = new String[]{"Name", "Value"};

    public JDExtensionPanel(JDObject[] jDObjectArray, JDrawEditor jDrawEditor) {
        this.invoker = jDrawEditor;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(JDUtils.createTitleBorder("Extensions"));
        jPanel.setBounds(5, 5, 370, 280);
        this.theModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 == 1;
            }

            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    JDExtensionPanel.this.applyBtn.setEnabled(true);
                }
            }
        };
        this.theTable = new JTable(this.theModel);
        this.cellEditor = new MultiLineCellEditor(this.theTable);
        this.theTable.setDefaultEditor(String.class, this.cellEditor);
        this.tableView = new JScrollPane(this.theTable);
        this.tableView.setVerticalScrollBarPolicy(22);
        this.tableView.setBounds(10, 20, 350, 220);
        jPanel.add(this.tableView);
        this.newExtensionBtn = new JButton("New");
        this.newExtensionBtn.setMargin(new Insets(0, 0, 0, 0));
        this.newExtensionBtn.setFont(JDUtils.labelFont);
        this.newExtensionBtn.addActionListener(this);
        this.newExtensionBtn.setBounds(10, 245, 50, 24);
        jPanel.add(this.newExtensionBtn);
        this.delExtensionBtn = new JButton("Delete");
        this.delExtensionBtn.setMargin(new Insets(0, 0, 0, 0));
        this.delExtensionBtn.setFont(JDUtils.labelFont);
        this.delExtensionBtn.addActionListener(this);
        this.delExtensionBtn.setBounds(65, 245, 60, 24);
        jPanel.add(this.delExtensionBtn);
        this.editExtensionBtn = new JButton("Edit");
        this.editExtensionBtn.setMargin(new Insets(0, 0, 0, 0));
        this.editExtensionBtn.setFont(JDUtils.labelFont);
        this.editExtensionBtn.addActionListener(this);
        this.editExtensionBtn.setBounds(130, 245, 60, 24);
        jPanel.add(this.editExtensionBtn);
        this.helpExtensionBtn = new JButton("?");
        this.helpExtensionBtn.setMargin(new Insets(0, 0, 0, 0));
        this.helpExtensionBtn.setFont(JDUtils.labelFont);
        this.helpExtensionBtn.addActionListener(this);
        this.helpExtensionBtn.setBounds(195, 245, 30, 24);
        jPanel.add(this.helpExtensionBtn);
        this.applyBtn = new JButton("Apply");
        this.applyBtn.setMargin(new Insets(0, 0, 0, 0));
        this.applyBtn.setFont(JDUtils.labelFont);
        this.applyBtn.addActionListener(this);
        this.applyBtn.setBounds(270, 245, 90, 24);
        this.applyBtn.setEnabled(false);
        jPanel.add(this.applyBtn);
        this.add(jPanel);
        this.updatePanel(jDObjectArray);
    }

    public void updatePanel(JDObject[] jDObjectArray) {
        this.allObjects = jDObjectArray;
        this.refreshTable();
    }

    private void refreshTable() {
        if (this.allObjects == null || this.allObjects.length == 0) {
            this.theModel.setDataVector((Object[][])null, colName);
            this.delExtensionBtn.setEnabled(false);
            this.editExtensionBtn.setEnabled(false);
            this.helpExtensionBtn.setEnabled(false);
        } else {
            int n = this.allObjects[0].getExtendedParamNumber();
            Object[][] objectArray = new Object[n][2];
            for (int i = 0; i < n; ++i) {
                objectArray[i][0] = this.allObjects[0].getExtendedParamName(i);
                objectArray[i][1] = this.allObjects[0].getExtendedParam(i);
            }
            this.theModel.setDataVector(objectArray, colName);
            this.cellEditor.updateRows();
            this.delExtensionBtn.setEnabled(n > 0);
            this.editExtensionBtn.setEnabled(n > 0);
            this.helpExtensionBtn.setEnabled(n > 0);
        }
        this.applyBtn.setEnabled(false);
        this.theTable.getColumnModel().getColumn(1).setPreferredWidth(230);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.newExtensionBtn) {
            String string = JOptionPane.showInputDialog("Enter extension name");
            if (string != null) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].addExtension(string);
                }
                this.refreshTable();
                this.invoker.setNeedToSave(true, "New extension");
            }
        } else if (object == this.delExtensionBtn) {
            int n = this.theTable.getSelectedRow();
            if (n >= 0) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].removeExtension(n);
                }
                this.refreshTable();
                this.invoker.setNeedToSave(true, "Remove extension");
            } else {
                JOptionPane.showMessageDialog(this, "Please select a row first.", "Error", 0);
            }
        } else if (object == this.applyBtn) {
            if (this.theModel.getRowCount() > 0) {
                for (int i = 0; i < this.theModel.getRowCount(); ++i) {
                    String string = (String)this.theModel.getValueAt(i, 0);
                    String string2 = (String)this.theModel.getValueAt(i, 1);
                    this.applyExtension(string, string2);
                }
                this.invoker.setNeedToSave(true, "Edit extension");
                this.refreshTable();
            }
        } else if (object == this.editExtensionBtn) {
            int n = this.theTable.getSelectedRow();
            if (n >= 0) {
                String string = (String)this.theModel.getValueAt(n, 0);
                String string3 = (String)this.theModel.getValueAt(n, 1);
                String string4 = JDExtensionEditor.showExtensionEditor(this, "Edit " + string, string3);
                if (string4 != null) {
                    this.applyExtension(string, string4);
                    this.invoker.setNeedToSave(true, "Edit extension");
                }
                this.refreshTable();
            } else {
                JOptionPane.showMessageDialog(this, "Please select a row first.", "Error", 0);
            }
        } else if (object == this.helpExtensionBtn) {
            int n = this.theTable.getSelectedRow();
            if (n >= 0) {
                String string = (String)this.theModel.getValueAt(n, 0);
                String string5 = this.allObjects[0].getExtendedParamDesc(string);
                if (string5 != null && string5.length() > 0) {
                    JOptionPane.showMessageDialog(this, string5, "Help for " + string, 1);
                } else {
                    JOptionPane.showMessageDialog(this, "No help for " + string + ".", "Error", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Please select a row first.", "Error", 0);
            }
        }
    }

    private void applyExtension(String string, String string2) {
        JDObject jDObject = this.allObjects[0];
        jDObject.setExtendedParam(string, string2);
        if (jDObject instanceof JDSwingObject) {
            this.invoker.repaint(jDObject.getRepaintRect());
        }
        for (int i = 1; i < this.allObjects.length; ++i) {
            jDObject = this.allObjects[i];
            if (jDObject instanceof JDSwingObject) {
                ((JDSwingObject)jDObject).setExtendedParam(string, string2, true);
                this.invoker.repaint(jDObject.getRepaintRect());
                continue;
            }
            jDObject.setExtendedParam(string, string2);
        }
    }
}

