/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import fr.esrf.tangoatk.widget.util.interlock.XpssLink;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Vector;

class XpssObject {
    public static final int OBJECT_NONE = 0;
    public static final int OBJECT_BUBBLE = 1;
    public static final int OBJECT_SPLIT = 2;
    public static final int OBJECT_JOIN = 3;
    public static final int OBJECT_STARTPOINT = 4;
    public static final int OBJECT_ENDPOINT = 5;
    public static final int OBJECT_CORNER = 6;
    public static final int OBJECT_TEXT = 7;
    public static final int OBJECT_PERMIT = 8;
    public int type = 0;
    public Point org = new Point();
    String label1 = "";
    String label2 = "";
    String typeStr = "";
    String permitFileName = "";
    public int id = 0;
    public int idHigh;
    public int idLow;
    public int idDev;
    Vector links = new Vector();
    String retLabel;
    int lx;
    int ly;
    static String[] xpssDevices = new String[]{"ELIN/ELIN/ELIN", "ELIN/SA-CR1/SL0", "ELIN/SA-CR2/SL0", "ELIN/SA-CR3/SL0", "ELIN/INTLK/0", "SY/SA-CR5/SL0", "SY/SA-CR6/SL0", "SY/SA-CR7/SL0", "SY/SA-CR8/SL0", "SR/SA-CR9/SL0", "ELIN/ELIN/ELIN", "SR/SA-CR11/SL0", "ELIN/ELIN/ELIN", "SR/SA-CR13/SL0"};
    static String[] bubbleExts = new String[]{"Device", "Board", "Relay", "Type", "Net Name"};
    static String[] permitExts = new String[]{"Type", "Net Name"};

    XpssObject() {
    }

    void addLink(XpssLink xpssLink) {
        if (xpssLink.type == 2) {
            this.links.add(xpssLink);
        }
    }

    void convertLabels() {
        this.retLabel = "";
        if (this.label1.length() == 0) {
            if (this.label2.length() != 0) {
                this.retLabel = this.retLabel + this.label2;
            }
        } else if (this.label2.length() == 0) {
            this.retLabel = this.retLabel + this.label1;
            switch (this.type) {
                case 8: {
                    this.lx = 17;
                    this.ly = 13;
                    break;
                }
                case 1: {
                    this.lx = 0;
                    this.ly = -12;
                    break;
                }
                case 4: {
                    this.lx = 0;
                    this.ly = 8;
                }
            }
        } else {
            this.retLabel = this.retLabel + this.label1 + "\n" + this.label2;
            if (this.type != 8) {
                this.lx = 0;
                this.ly = -12;
            } else {
                this.lx = 17;
                this.ly = 13;
            }
        }
    }

    NetObject convert(Dimension dimension) {
        NetObject netObject = null;
        switch (this.type) {
            case 1: {
                netObject = new NetObject(1, 1, 1, 1, this.org.x, this.org.y);
                this.convertLabels();
                netObject.setLabel(this.retLabel);
                netObject.labelOffset.x = this.lx;
                netObject.labelOffset.y = this.ly;
                netObject.setExtensionList(bubbleExts);
                netObject.setExtendedParam(0, xpssDevices[this.idDev]);
                netObject.setExtendedParam(1, Integer.toString(this.idHigh));
                netObject.setExtendedParam(2, Integer.toString(this.idLow));
                netObject.setExtendedParam(3, this.typeStr);
                netObject.setExtendedParam(4, this.permitFileName);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                netObject = new NetObject(1, 5, 1000, 1000, this.org.x, this.org.y);
                netObject.setShape(5);
                break;
            }
            case 4: {
                netObject = new NetObject(1, 3, 0, 1, this.org.x, this.org.y);
                this.convertLabels();
                netObject.setLabel(this.retLabel);
                netObject.labelOffset.x = this.lx;
                netObject.labelOffset.y = this.ly;
                netObject.setShape(3);
                break;
            }
            case 5: {
                netObject = new NetObject(1, 4, 1, 0, this.org.x, this.org.y);
                netObject.setShape(4);
                break;
            }
            case 7: {
                netObject = new NetObject(2, 0, 0, 0, this.org.x * dimension.width, this.org.y * dimension.height - 3);
                this.convertLabels();
                netObject.setLabel(this.retLabel);
                netObject.labelOffset.x = this.lx;
                netObject.labelOffset.y = this.ly - 2;
                netObject.justify = 0;
                break;
            }
            case 8: {
                netObject = new NetObject(1, 2, 1, 1, this.org.x, this.org.y);
                this.convertLabels();
                netObject.setLabel(this.retLabel);
                netObject.labelOffset.x = this.lx;
                netObject.labelOffset.y = this.ly;
                netObject.setExtensionList(permitExts);
                netObject.setExtendedParam(0, this.typeStr);
                netObject.setExtendedParam(1, this.permitFileName);
                netObject.justify = 0;
                netObject.setShape(1);
                netObject.setSize(9);
                break;
            }
            default: {
                System.out.println("Warning: Unknown object detected. Ignoring...");
                return null;
            }
        }
        return netObject;
    }
}

