/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart.math;

import fr.esrf.tangoatk.widget.util.chart.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.JLDataViewOption;
import fr.esrf.tangoatk.widget.util.chart.math.ParserHelpDialog;
import fr.esrf.tangoatk.widget.util.chart.math.VariablePanel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class ParserOptionDialog
extends JLDataViewOption {
    protected boolean isValidated = true;
    protected JButton cancelButton;
    protected JLDataView dataView;
    protected JTextField expressionField;
    protected JLabel expressionLabel;
    protected JTextField dvNameField;
    protected JLabel dvNameLabel;
    protected JComboBox axisBox;
    protected JLabel axisLabel;
    protected int selectedAxis = -1;
    protected JButton generateButton;
    protected JButton helpButton;
    protected VariablePanel variablePanel = null;
    protected JScrollPane variableScrollPane = null;

    public ParserOptionDialog(JDialog jDialog, JLChart jLChart, JLDataView jLDataView) {
        super(jDialog, jLChart, jLDataView);
        this.initComponents();
        this.dataView = jLDataView;
        this.addWindowListener();
        this.setTitle();
    }

    public ParserOptionDialog(JFrame jFrame, JLChart jLChart, JLDataView jLDataView) {
        super(jFrame, jLChart, jLDataView);
        this.initComponents();
        this.dataView = jLDataView;
        this.addWindowListener();
        this.setTitle();
    }

    protected void initComponents() {
        JPanel jPanel = (JPanel)this.getContentPane();
        JPanel jPanel2 = new JPanel();
        Vector vector = new Vector();
        if (this.chart.getXAxis().isXY()) {
            vector.addAll(this.chart.getXAxis().getViews());
        }
        vector.addAll(this.chart.getY1Axis().getViews());
        vector.addAll(this.chart.getY2Axis().getViews());
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = ((JLDataView)vector.get(i)).getName();
        }
        vector.clear();
        vector = null;
        this.variablePanel = new VariablePanel(stringArray, this);
        stringArray = null;
        jPanel2.setLayout(null);
        this.expressionLabel = new JLabel("Enter your expression:");
        this.expressionLabel.setFont(GraphicsUtils.getLabelFont());
        this.expressionField = new JTextField("");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMargin(new Insets(0, 0, 0, 0));
        this.cancelButton.addMouseListener(this);
        this.expressionLabel.setBounds(0, 5, 140, 25);
        this.expressionField.setBounds(140, 5, 130, 25);
        this.dvNameLabel = new JLabel("Enter your DataView name:");
        this.dvNameLabel.setFont(GraphicsUtils.getLabelFont());
        this.dvNameField = new JTextField("");
        this.dvNameLabel.setBounds(0, 35, 160, 25);
        this.dvNameField.setBounds(160, 35, 110, 25);
        this.helpButton = new JButton("?");
        this.helpButton.setToolTipText("About Expressions");
        this.helpButton.setMargin(new Insets(0, 0, 0, 0));
        this.helpButton.setBounds(0, 65, 25, 25);
        this.helpButton.addMouseListener(this);
        this.generateButton = new JButton("Generate Variables");
        this.generateButton.setMargin(new Insets(0, 0, 0, 0));
        this.generateButton.addMouseListener(this);
        this.generateButton.setBounds(80, 65, 190, 25);
        this.variableScrollPane = new JScrollPane(this.variablePanel);
        this.variableScrollPane.setBounds(0, 90, 270, 215);
        this.variableScrollPane.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), "Variables"));
        this.axisLabel = new JLabel("Axis:");
        this.axisBox = new JComboBox();
        this.axisBox.addItem("Y1");
        this.axisBox.addItem("Y2");
        this.axisBox.addItem("X");
        this.axisLabel.setBounds(0, 315, 50, 25);
        this.axisBox.setBounds(50, 315, 50, 25);
        jPanel.setBounds(0, 340, 270, 265);
        this.cancelButton.setBounds(5, 230, 80, 25);
        this.closeBtn.setText("Ok");
        jPanel.remove(this.nameLabel);
        jPanel.add(this.cancelButton);
        jPanel2.add(this.expressionLabel);
        jPanel2.add(this.expressionField);
        jPanel2.add(this.dvNameLabel);
        jPanel2.add(this.dvNameField);
        jPanel2.add(this.variableScrollPane);
        jPanel2.add(this.helpButton);
        jPanel2.add(this.generateButton);
        jPanel2.add(this.axisLabel);
        jPanel2.add(this.axisBox);
        jPanel2.add(jPanel);
        this.setResizable(false);
        jPanel2.setPreferredSize(new Dimension(270, 600));
        this.setContentPane(jPanel2);
    }

    protected void addWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ParserOptionDialog.this.isValidated = false;
                ParserOptionDialog.this.setVisible(false);
            }
        });
    }

    protected void setTitle() {
        this.setTitle("Expression Evaluation");
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.cancelButton) {
            this.isValidated = false;
            this.setVisible(false);
        } else if (mouseEvent.getSource() == this.closeBtn) {
            this.isValidated = true;
            this.selectedAxis = this.axisBox.getSelectedIndex();
            if (this.dvNameField.getText() == null || "".equals(this.dvNameField.getText().trim())) {
                this.dataView.setName(this.expressionField.getText().trim());
            } else {
                this.dataView.setName(this.dvNameField.getText().trim());
            }
            this.setVisible(false);
        } else if (mouseEvent.getSource() == this.generateButton) {
            this.variablePanel.setExpression(this.expressionField.getText());
            this.variablePanel.generateVariables();
        } else if (mouseEvent.getSource() == this.helpButton) {
            new ParserHelpDialog(this).setVisible(true);
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    public boolean isX() {
        return this.variablePanel.isX();
    }

    public String[] getVariables() {
        return this.variablePanel.getVariables();
    }

    public void dispose() {
        this.cancelButton = null;
        this.dataView = null;
        this.expressionField = null;
        this.expressionLabel = null;
        super.dispose();
    }
}

