/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import com.braju.format.Format;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import java.awt.Color;
import java.util.Vector;

public class JLDataView {
    public static final int MARKER_NONE = 0;
    public static final int MARKER_DOT = 1;
    public static final int MARKER_BOX = 2;
    public static final int MARKER_TRIANGLE = 3;
    public static final int MARKER_DIAMOND = 4;
    public static final int MARKER_STAR = 5;
    public static final int MARKER_VERT_LINE = 6;
    public static final int MARKER_HORIZ_LINE = 7;
    public static final int MARKER_CROSS = 8;
    public static final int MARKER_CIRCLE = 9;
    public static final int MARKER_SQUARE = 10;
    public static final int STYLE_SOLID = 0;
    public static final int STYLE_DOT = 1;
    public static final int STYLE_DASH = 2;
    public static final int STYLE_LONG_DASH = 3;
    public static final int STYLE_DASH_DOT = 4;
    public static final int TYPE_LINE = 0;
    public static final int TYPE_BAR = 1;
    public static final int METHOD_FILL_FROM_TOP = 0;
    public static final int METHOD_FILL_FROM_ZERO = 1;
    public static final int METHOD_FILL_FROM_BOTTOM = 2;
    public static final int FILL_STYLE_NONE = 0;
    public static final int FILL_STYLE_SOLID = 1;
    public static final int FILL_STYLE_LARGE_RIGHT_HATCH = 2;
    public static final int FILL_STYLE_LARGE_LEFT_HATCH = 3;
    public static final int FILL_STYLE_LARGE_CROSS_HATCH = 4;
    public static final int FILL_STYLE_SMALL_RIGHT_HATCH = 5;
    public static final int FILL_STYLE_SMALL_LEFT_HATCH = 6;
    public static final int FILL_STYLE_SMALL_CROSS_HATCH = 7;
    public static final int FILL_STYLE_DOT_PATTERN_1 = 8;
    public static final int FILL_STYLE_DOT_PATTERN_2 = 9;
    public static final int FILL_STYLE_DOT_PATTERN_3 = 10;
    public static final double NAN_FOR_NULL = Double.longBitsToDouble(9218868487374504191L);
    public static final double NAN_FOR_POSITIVE_INFINITY = Double.longBitsToDouble(-1217159371947777L);
    public static final double NAN_FOR_NEGATIVE_INFINITY = Double.longBitsToDouble(-4503599626605057L);
    private JLAxis parentAxis = null;
    private Color lineColor = Color.red;
    private Color fillColor = Color.lightGray;
    private Color markerColor = Color.red;
    private int lineStyle = 0;
    private int lineWidth = 1;
    private int markerType = 0;
    private int markerSize = 6;
    private int barWidth = 10;
    private int fillStyle = 0;
    private int fillMethod = 2;
    private int type = 0;
    private double A0 = 0.0;
    private double A1 = 1.0;
    private double A2 = 0.0;
    private DataList theData = null;
    private int dataLength = 0;
    private DataList theDataEnd = null;
    private double max = -1.7976931348623157E308;
    private double min = Double.MAX_VALUE;
    private double maxXValue = -1.7976931348623157E308;
    private double minXValue = Double.MAX_VALUE;
    private String name = "";
    private String unit = "";
    private boolean clickable = true;
    private boolean labelVisible = true;
    private String userFormat = null;

    public static String getHelpString() {
        return "-- Dataview settings --\n  Parameter name is preceded by the dataview name.\n\nlinecolor:r,g,b  Curve color\nlinewidth:width  Curve width\nlinestyle:style  Line style (0 Solid,1 Dot, 2 Dash, 3 Long Dash,...)\nfillcolor:r,g,b  Curve fill color\nfillmethod:m   Bar filling method (0 Top,1 Zero,2 Bottom)\nfillstyle:style  Curve filling style (0 No fill,1 Solid,...)\nviewtype:type   Type of plot (0 Line, 1 Bar)\nbarwidth:width   Bar width in pixel (0 autoscale)\nmarkercolor:r,g,b   Marker color\nmarkersize:size   Marker size\nmarkerstyle:style  Marker style (0 No marker,1 Dot,2 Box,...)\nA0,A1,A2:value   Vertical transfrom Y = A0 + A1*y + A2*y*y\nA0,A1,A2:value   Vertical transfrom Y = A0 + A1*y + A2*y*y\nlabelvisible:true or false   Displays legend of this view\nclickable:true or false  Shows tooltip on mouse click\n";
    }

    public void setViewType(int n) {
        this.type = n;
    }

    public int getViewType() {
        return this.type;
    }

    public void setFillStyle(int n) {
        this.fillStyle = n;
    }

    public int getFillStyle() {
        return this.fillStyle;
    }

    public void setFillMethod(int n) {
        this.fillMethod = n;
    }

    public int getFillMethod() {
        return this.fillMethod;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setColor(Color color) {
        this.lineColor = color;
    }

    public Color getColor() {
        return this.lineColor;
    }

    public boolean isFill() {
        return this.fillStyle != 0;
    }

    public void setFill(boolean bl) {
        if (!bl) {
            this.setFillStyle(0);
        } else {
            this.setFillStyle(1);
        }
    }

    public void setClickable(boolean bl) {
        this.clickable = bl;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setLabelVisible(boolean bl) {
        this.labelVisible = bl;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setBarWidth(int n) {
        this.barWidth = n;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setMarkerColor(Color color) {
        this.markerColor = color;
    }

    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setStyle(int n) {
        this.lineStyle = n;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(int n) {
        this.markerSize = n;
    }

    public int getStyle() {
        return this.lineStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getExtendedName() {
        String string = "";
        if (this.hasTransform()) {
            String string2 = this.name + " [";
            if (this.A0 != 0.0) {
                string2 = string2 + Double.toString(this.A0);
                string = " + ";
            }
            if (this.A1 != 0.0) {
                string2 = string2 + string + Double.toString(this.A1) + "*y";
                string = " + ";
            }
            if (this.A2 != 0.0) {
                string2 = string2 + string + Double.toString(this.A2) + "*y^2";
            }
            string2 = string2 + "]";
            return string2;
        }
        return this.name;
    }

    public int getMarker() {
        return this.markerType;
    }

    public void setMarker(int n) {
        this.markerType = n;
    }

    public double getA0() {
        return this.A0;
    }

    public double getA1() {
        return this.A1;
    }

    public double getA2() {
        return this.A2;
    }

    public void setA0(double d) {
        this.A0 = d;
    }

    public void setA1(double d) {
        this.A1 = d;
    }

    public void setA2(double d) {
        this.A2 = d;
    }

    public boolean hasTransform() {
        return this.A0 != 0.0 || this.A1 != 1.0 || this.A2 != 0.0;
    }

    public void setAxis(JLAxis jLAxis) {
        this.parentAxis = jLAxis;
    }

    public JLAxis getAxis() {
        return this.parentAxis;
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }

    public double getMinTime() {
        if (this.theData != null) {
            return this.theData.x;
        }
        return Double.MAX_VALUE;
    }

    public double getMinXValue() {
        return this.minXValue;
    }

    public double getPositiveMinXValue() {
        double d = Double.MAX_VALUE;
        DataList dataList = this.theData;
        while (dataList != null) {
            if (dataList.x > 0.0 && dataList.x < d) {
                d = dataList.x;
            }
            dataList = dataList.next;
        }
        return d;
    }

    public double getPositiveMinTime() {
        DataList dataList = this.theData;
        boolean bl = false;
        while (dataList != null && !bl) {
            bl = dataList.x > 0.0;
            if (bl) continue;
            dataList = dataList.next;
        }
        if (dataList != null) {
            return dataList.x;
        }
        return Double.MAX_VALUE;
    }

    public double getMaxXValue() {
        return this.maxXValue;
    }

    public double getMaxTime() {
        if (this.theDataEnd != null) {
            return this.theDataEnd.x;
        }
        return -1.7976931348623157E308;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public DataList getData() {
        return this.theData;
    }

    public void commitChange() {
        this.computeMin();
        this.computeMax();
    }

    public synchronized void add(double d, double d2) {
        DataList dataList;
        if (Double.isInfinite(d2)) {
            d2 = d2 > 0.0 ? NAN_FOR_POSITIVE_INFINITY : NAN_FOR_NEGATIVE_INFINITY;
        }
        if ((dataList = new DataList(d, d2)) == null) {
            System.out.println("Warning: Cannot add data to the chart (may be a memory problem...)");
            return;
        }
        this.theDataEnd = this.theData == null ? (this.theData = dataList) : (this.theDataEnd.next = dataList);
        if (d2 < this.min) {
            this.min = d2;
        }
        if (d2 > this.max) {
            this.max = d2;
        }
        if (d < this.minXValue) {
            this.minXValue = d;
        }
        if (d > this.maxXValue) {
            this.maxXValue = d;
        }
        ++this.dataLength;
    }

    public void setData(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            System.out.println("Warning: Cannot set data, x vector and y vector have not the same length");
            return;
        }
        this.reset();
        for (int i = 0; i < dArray.length; ++i) {
            this.add(dArray[i], dArray2[i]);
        }
    }

    public synchronized int garbagePointTime(double d) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        if (this.theData != null) {
            while (this.theData != null && !bl3) {
                bl3 = this.theData.x > this.maxXValue - d - 3000.0;
                if (bl3) continue;
                bl = bl || this.theData.y == this.max;
                bl2 = bl2 || this.theData.y == this.min;
                DataList dataList = this.theData;
                this.theData = this.theData.next;
                dataList.next = null;
                dataList = null;
                --this.dataLength;
                ++n;
            }
        }
        if (this.theData == null) {
            this.reset();
        } else {
            if (bl) {
                this.computeMax();
            }
            if (bl2) {
                this.computeMin();
            }
        }
        return n;
    }

    public synchronized void garbagePointLimit(int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = this.dataLength - n;
        for (int i = 0; i < n2; ++i) {
            bl = bl || this.theData.y == this.max;
            bl2 = bl2 || this.theData.y == this.min;
            bl3 = bl3 || this.theData.x == this.maxXValue;
            bl4 = bl4 || this.theData.x == this.minXValue;
            DataList dataList = this.theData;
            this.theData = this.theData.next;
            dataList.next = null;
            --this.dataLength;
        }
        if (bl) {
            this.computeMax();
        }
        if (bl2) {
            this.computeMin();
        }
        if (bl3) {
            this.computeMaxXValue();
        }
        if (bl4) {
            this.computeMinXValue();
        }
    }

    private void computeMin() {
        this.min = Double.MAX_VALUE;
        DataList dataList = this.theData;
        while (dataList != null) {
            if (dataList.y < this.min) {
                this.min = dataList.y;
            }
            dataList = dataList.next;
        }
    }

    private void computeMax() {
        this.max = -1.7976931348623157E308;
        DataList dataList = this.theData;
        while (dataList != null) {
            if (dataList.y > this.max) {
                this.max = dataList.y;
            }
            dataList = dataList.next;
        }
    }

    private void computeMinXValue() {
        this.minXValue = Double.MAX_VALUE;
        DataList dataList = this.theData;
        while (dataList != null) {
            if (dataList.x < this.minXValue) {
                this.minXValue = dataList.x;
            }
            dataList = dataList.next;
        }
    }

    private void computeMaxXValue() {
        this.maxXValue = -1.7976931348623157E308;
        DataList dataList = this.theData;
        while (dataList != null) {
            if (dataList.x > this.maxXValue) {
                this.maxXValue = dataList.x;
            }
            dataList = dataList.next;
        }
    }

    public double[] computeTransformedMinMax() {
        double[] dArray = new double[2];
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        DataList dataList = this.theData;
        while (dataList != null) {
            double d3 = this.A0 + this.A1 * dataList.y + this.A2 * dataList.y * dataList.y;
            if (d3 < d) {
                d = d3;
            }
            if (d3 > d2) {
                d2 = d3;
            }
            dataList = dataList.next;
        }
        if (d == Double.MAX_VALUE) {
            d = 0.0;
        }
        if (d2 == -1.7976931348623157E308) {
            d2 = 99.0;
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }

    public double computePositiveMin() {
        double d = Double.MAX_VALUE;
        DataList dataList = this.theData;
        while (dataList != null) {
            if (dataList.y > 0.0 && dataList.y < d) {
                d = dataList.y;
            }
            dataList = dataList.next;
        }
        return d;
    }

    public double getTransformedValue(double d) {
        return this.A0 + this.A1 * d + this.A2 * d * d;
    }

    public DataList getLastValue() {
        return this.theDataEnd;
    }

    public synchronized void reset() {
        this.theData = null;
        this.theDataEnd = null;
        this.dataLength = 0;
        this.computeMin();
        this.computeMax();
    }

    public void applyConfiguration(String string, CfFileReader cfFileReader) {
        Vector vector = cfFileReader.getParam(string + "_linecolor");
        if (vector != null) {
            this.setColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam(string + "_linewidth")) != null) {
            this.setLineWidth(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_linestyle")) != null) {
            this.setStyle(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_fillcolor")) != null) {
            this.setFillColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam(string + "_fillmethod")) != null) {
            this.setFillMethod(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_fillstyle")) != null) {
            this.setFillStyle(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_viewtype")) != null) {
            this.setViewType(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_barwidth")) != null) {
            this.setBarWidth(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_markercolor")) != null) {
            this.setMarkerColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam(string + "_markersize")) != null) {
            this.setMarkerSize(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_markerstyle")) != null) {
            this.setMarker(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_A0")) != null) {
            this.setA0(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_A1")) != null) {
            this.setA1(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_A2")) != null) {
            this.setA2(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_labelvisible")) != null) {
            this.setLabelVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "_clickable")) != null) {
            this.setClickable(OFormat.getBoolean(vector.get(0).toString()));
        }
    }

    public String getConfiguration(String string) {
        String string2 = "";
        string2 = string2 + string + "_linecolor:" + OFormat.color(this.getColor()) + "\n";
        string2 = string2 + string + "_linewidth:" + this.getLineWidth() + "\n";
        string2 = string2 + string + "_linestyle:" + this.getStyle() + "\n";
        string2 = string2 + string + "_fillcolor:" + OFormat.color(this.getFillColor()) + "\n";
        string2 = string2 + string + "_fillmethod:" + this.getFillMethod() + "\n";
        string2 = string2 + string + "_fillstyle:" + this.getFillStyle() + "\n";
        string2 = string2 + string + "_viewtype:" + this.getViewType() + "\n";
        string2 = string2 + string + "_barwidth:" + this.getBarWidth() + "\n";
        string2 = string2 + string + "_markercolor:" + OFormat.color(this.getMarkerColor()) + "\n";
        string2 = string2 + string + "_markersize:" + this.getMarkerSize() + "\n";
        string2 = string2 + string + "_markerstyle:" + this.getMarker() + "\n";
        string2 = string2 + string + "_A0:" + this.getA0() + "\n";
        string2 = string2 + string + "_A1:" + this.getA1() + "\n";
        string2 = string2 + string + "_A2:" + this.getA2() + "\n";
        string2 = string2 + string + "_labelvisible:" + this.isLabelVisible() + "\n";
        string2 = string2 + string + "_clickable:" + this.isClickable() + "\n";
        return string2;
    }

    public double getYValueByIndex(int n) {
        if (n < 0 || n >= this.getDataLength()) {
            return Double.NaN;
        }
        DataList dataList = this.theData;
        for (int i = 0; dataList != null && i < n; ++i) {
            dataList = dataList.next;
        }
        if (dataList != null) {
            return dataList.y;
        }
        return Double.NaN;
    }

    public double getXValueByIndex(int n) {
        if (n < 0 || n >= this.getDataLength()) {
            return Double.NaN;
        }
        DataList dataList = this.theData;
        for (int i = 0; dataList != null && i < n; ++i) {
            dataList = dataList.next;
        }
        if (dataList != null) {
            return dataList.x;
        }
        return Double.NaN;
    }

    public void setUserFormat(String string) {
        if (string != null && string.length() > 0) {
            this.userFormat = string;
            return;
        }
        this.userFormat = null;
    }

    public String getUserFormat() {
        return this.userFormat;
    }

    public String formatValue(double d) {
        if (Double.isNaN(d)) {
            long l = Double.doubleToRawLongBits(d);
            if (l == Double.doubleToRawLongBits(NAN_FOR_NULL)) {
                return "null";
            }
            if (l == Double.doubleToRawLongBits(NAN_FOR_NEGATIVE_INFINITY)) {
                return "-Infinity";
            }
            if (l == Double.doubleToRawLongBits(NAN_FOR_POSITIVE_INFINITY)) {
                return "+Infinity";
            }
            return "NaN";
        }
        if (this.userFormat != null) {
            Object[] objectArray = new Object[]{new Double(d)};
            String string = Double.toString(d);
            try {
                string = Format.sprintf((String)this.userFormat, (Object[])objectArray);
                double d2 = Double.parseDouble(string);
                if (Double.isNaN(d2)) {
                    string = Double.toString(d);
                }
            }
            catch (Exception exception) {
                string = Double.toString(d);
            }
            return string;
        }
        if (this.parentAxis == null) {
            return Double.toString(d);
        }
        return this.parentAxis.formatValue(d, 0.0);
    }

    public synchronized double[] getSortedTimes() {
        double[] dArray = new double[this.dataLength];
        DataList dataList = this.theData;
        int n = 0;
        while (n < this.dataLength) {
            dArray[n] = dataList.x;
            dataList = dataList.next;
        }
        JLDataView.mergeSort(dArray, null);
        return dArray;
    }

    public synchronized double[] getSortedValues() {
        double[] dArray = new double[this.dataLength];
        DataList dataList = this.theData;
        int n = 0;
        while (n < this.dataLength) {
            dArray[n] = dataList.y;
            dataList = dataList.next;
        }
        JLDataView.mergeSort(dArray, null);
        return dArray;
    }

    public synchronized double[][] getDataSortedByTimes() {
        double[][] dArray = new double[2][this.dataLength];
        double[] dArray2 = new double[this.dataLength];
        double[] dArray3 = new double[this.dataLength];
        DataList dataList = this.theData;
        int n = 0;
        while (n < this.dataLength) {
            dArray2[n] = dataList.x;
            dArray3[n] = dataList.y;
            dataList = dataList.next;
        }
        JLDataView.mergeSort(dArray2, dArray3);
        dArray[0] = dArray2;
        dArray[1] = dArray3;
        return dArray;
    }

    public synchronized double[][] getDataSortedByValues() {
        double[][] dArray = new double[2][this.dataLength];
        double[] dArray2 = new double[this.dataLength];
        double[] dArray3 = new double[this.dataLength];
        DataList dataList = this.theData;
        int n = 0;
        while (n < this.dataLength) {
            dArray2[n] = dataList.x;
            dArray3[n] = dataList.y;
            dataList = dataList.next;
        }
        JLDataView.mergeSort(dArray3, dArray2);
        dArray[0] = dArray2;
        dArray[1] = dArray3;
        return dArray;
    }

    public static void mergeSort(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n > 0) {
            JLDataView.mergeSort(dArray, dArray2, 0, n - 1);
        }
    }

    private static void mergeSort(double[] dArray, double[] dArray2, int n, int n2) {
        if (n != n2) {
            int n3 = (n2 + n) / 2;
            JLDataView.mergeSort(dArray, dArray2, n, n3);
            JLDataView.mergeSort(dArray, dArray2, n3 + 1, n2);
            JLDataView.merge(dArray, dArray2, n, n3, n2);
        }
    }

    private static void merge(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        int n4;
        int n5 = n2 + 1;
        double[] dArray3 = new double[n2 - n + 1];
        double[] dArray4 = dArray2 == null ? null : new double[n2 - n + 1];
        for (n4 = n; n4 <= n2; ++n4) {
            dArray3[n4 - n] = dArray[n4];
            if (dArray2 == null) continue;
            dArray4[n4 - n] = dArray2[n4];
        }
        n4 = n;
        int n6 = n5;
        for (int i = n; i <= n3 && n4 != n5; ++i) {
            if (n6 == n3 + 1) {
                dArray[i] = dArray3[n4 - n];
                if (dArray2 != null) {
                    dArray2[i] = dArray4[n4 - n];
                }
                ++n4;
                continue;
            }
            if (dArray3[n4 - n] < dArray[n6]) {
                dArray[i] = dArray3[n4 - n];
                if (dArray2 != null) {
                    dArray2[i] = dArray4[n4 - n];
                }
                ++n4;
                continue;
            }
            dArray[i] = dArray[n6];
            if (dArray2 != null) {
                dArray2[i] = dArray2[n6];
            }
            ++n6;
        }
    }
}

