/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class JSmoothLabel
extends JComponent {
    public static int CENTER_ALIGNMENT = 1;
    public static int LEFT_ALIGNMENT = 2;
    public static int RIGHT_ALIGNMENT = 3;
    public static int CLASSIC_BEHAVIOR = 2;
    public static int MATRIX_BEHAVIOR = 1;
    private String text;
    private int off_y = 0;
    private int align;
    private int sizingBehavior;

    public JSmoothLabel() {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setOpaque(true);
        this.align = CENTER_ALIGNMENT;
        this.text = "";
        this.sizingBehavior = CLASSIC_BEHAVIOR;
    }

    public void setText(String string) {
        this.text = string == null ? "" : string;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setVerticalOffset(int n) {
        this.off_y = n;
        this.repaint();
    }

    public int getVerticalOffset() {
        return this.off_y;
    }

    public void setValueOffsets(int n, int n2) {
        System.out.println("JSmoothLabel.setValueOffsets() is deprecated and has no effects.");
    }

    public void setSizingBehavior(int n) {
        this.sizingBehavior = n;
    }

    public int getSizingBehavior() {
        return this.sizingBehavior;
    }

    public void setHorizontalAlignment(int n) {
        this.align = n;
    }

    public int getHorizontalAlignment() {
        return this.align;
    }

    protected void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.setColor(this.getForeground());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = graphics.getFont().getStringBounds(this.text, fontRenderContext);
        double d = this.getFont().getLineMetrics(this.text, fontRenderContext).getAscent();
        int n3 = (int)(((double)n2 - rectangle2D.getHeight()) / 2.0 + d);
        int n4 = 0;
        switch (this.align) {
            case 1: {
                n4 = (n - (int)rectangle2D.getWidth()) / 2;
                break;
            }
            case 2: {
                n4 = 3;
                break;
            }
            case 3: {
                n4 = n - (int)rectangle2D.getWidth() - 3;
            }
        }
        graphics.drawString(this.text, n4, this.off_y + n3);
    }

    public Dimension getPreferredSize() {
        if (this.sizingBehavior == MATRIX_BEHAVIOR) {
            return super.getPreferredSize();
        }
        Dimension dimension = ATKGraphicsUtils.measureString(this.text, this.getFont());
        dimension.width += 6;
        dimension.height += 4;
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

