/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.ErrorTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

class ErrorDialog
extends JDialog {
    JTextArea simpleError;
    JPanel simpleErrorPanel;
    JPanel buttonPanel;
    JButton okButton;
    JButton moreButton;
    JLabel iconLabel;
    ATKException theError;
    Icon errorIcon;
    JTabbedPane tabPanel;
    ErrorTree stackPanel;
    JScrollPane stackView;
    JTextArea stackTraceText;
    JScrollPane stackTraceView;
    String deviceName;
    boolean showDetails = false;

    ErrorDialog(Frame frame, ATKException aTKException, String string, String string2) {
        super(frame, string, true);
        this.theError = aTKException;
        this.deviceName = string2;
        this.initComponents();
    }

    ErrorDialog(Dialog dialog, ATKException aTKException, String string, String string2) {
        super(dialog, string, true);
        this.theError = aTKException;
        this.deviceName = string2;
        this.initComponents();
    }

    private void fillInStackTrace() {
        StackTraceElement[] stackTraceElementArray = this.theError.getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.theError.getSourceName() + "\n at\n");
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append(stackTraceElementArray[i]);
            stringBuffer.append('\n');
        }
        this.stackTraceText.setText(stringBuffer.toString());
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.okButton = new JButton("Ok");
        this.moreButton = new JButton("Details...");
        this.moreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ErrorDialog.this.showDetails) {
                    ErrorDialog.this.getContentPane().add((Component)ErrorDialog.this.tabPanel, "Center");
                    ErrorDialog.this.moreButton.setText("Hide...");
                    ErrorDialog.this.showDetails = true;
                    ErrorDialog.this.pack();
                    ErrorDialog.this.fillInStackTrace();
                    ErrorDialog.this.setResizable(true);
                } else {
                    ErrorDialog.this.getContentPane().remove(ErrorDialog.this.tabPanel);
                    ErrorDialog.this.moreButton.setText("Details...");
                    ErrorDialog.this.showDetails = false;
                    ErrorDialog.this.pack();
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorDialog.this.dispose();
                ErrorDialog.this.setVisible(false);
            }
        });
        this.simpleError = new JTextArea();
        this.simpleError.setEditable(false);
        this.simpleError.setBackground(container.getBackground());
        this.simpleError.setFont(this.okButton.getFont());
        if (this.deviceName != null && this.deviceName.length() > 0) {
            this.simpleError.setText(this.deviceName + " :\n" + this.theError.getDescription());
        } else {
            this.simpleError.setText(this.theError.getDescription());
        }
        this.simpleErrorPanel = new JPanel();
        this.simpleErrorPanel.setLayout(new FlowLayout(0, 15, 10));
        this.iconLabel = new JLabel(new ImageIcon(ErrorPane.errorImage));
        this.simpleErrorPanel.add((Component)this.iconLabel, "West");
        this.simpleErrorPanel.add((Component)this.simpleError, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.setPreferredSize(new Dimension(260, 40));
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.moreButton);
        container.add((Component)this.simpleErrorPanel, "North");
        container.add((Component)this.buttonPanel, "South");
        if (this.theError.getStackLength() > 0) {
            this.stackPanel = new ErrorTree();
            this.stackPanel.addErrors(this.theError.getErrors());
            this.stackView = new JScrollPane(this.stackPanel);
            this.stackView.setBorder(BorderFactory.createEtchedBorder());
        }
        this.stackTraceText = new JTextArea();
        this.stackTraceText.setEditable(false);
        this.stackTraceView = new JScrollPane(this.stackTraceText);
        this.stackTraceView.setBorder(BorderFactory.createEtchedBorder());
        this.tabPanel = new JTabbedPane();
        if (this.theError.getStackLength() > 0) {
            this.tabPanel.add("Error", this.stackView);
        } else {
            this.stackTraceView.setPreferredSize(new Dimension(0, 200));
        }
        this.tabPanel.add("Trace", this.stackTraceView);
        this.setResizable(false);
    }
}

