/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.UIManagerHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class ATKField
extends JTextField {
    protected boolean inserting = false;
    protected boolean editable = false;
    protected boolean modelEditable = false;
    protected boolean receivedEvent = false;
    protected int length = 0;
    protected String format = "";
    protected String error = "-------";
    protected ATKFormat userFormat;

    public ATKField() {
        Keymap keymap = this.getKeymap();
        Keymap keymap2 = JTextComponent.addKeymap("entermap", keymap);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, false);
        keymap2.addActionForKeyStroke(keyStroke, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATKField.this.enter(actionEvent);
            }
        });
        this.setKeymap(keymap2);
    }

    public void setUserFormat(ATKFormat aTKFormat) {
        this.userFormat = aTKFormat;
    }

    public ATKFormat getUserFormat() {
        return this.userFormat;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.length > 0) {
            Dimension dimension = UIManagerHelper.getRequiredSize(this.getFontMetrics(this.getFont()), this.length);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
        }
    }

    protected void enter(ActionEvent actionEvent) {
    }

    public void setState(Color color) {
        if (this.isEditable()) {
            return;
        }
        this.setBackground(color);
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl && this.modelEditable);
        this.editable = bl;
        this.receivedEvent = false;
    }

    public boolean isEditable() {
        return this.editable && this.modelEditable;
    }

    public void setError() {
        if (this.isEditable()) {
            return;
        }
        this.setText(this.error);
    }

    public void setFormat(String string) {
        if ("No format".equals(string)) {
            string = "%s";
        }
        this.format = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setMaximumLength(int n) {
        this.length = n;
        this.setPreferredSize(UIManagerHelper.getRequiredSize(this.getFontMetrics(this.getFont()), this.length));
    }

    public int getMaximumLength() {
        return this.length;
    }
}

