/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class TabbedPaneDevStateScalarViewer
extends JTabbedPane
implements IDevStateScalarListener {
    public static final String TAB_NO_TOOLTIP = "None";
    public static final String TAB_STATE_TOOLTIP = "State";
    public static final String TAB_NAME_TOOLTIP = "Name";
    private HashMap stateModelMap = new HashMap();
    private HashMap indexStateAttMap = new HashMap();
    private String tooltipMode = "None";

    public TabbedPaneDevStateScalarViewer() {
        this.setUI(new DevStateTabbedPaneUI());
    }

    public String getTooltipMode() {
        return this.tooltipMode;
    }

    public void setTooltipMode(String string) {
        if (this.tooltipMode.equalsIgnoreCase(string)) {
            return;
        }
        if (!(string.equalsIgnoreCase(TAB_NO_TOOLTIP) || string.equalsIgnoreCase(TAB_NAME_TOOLTIP) || string.equalsIgnoreCase(TAB_STATE_TOOLTIP))) {
            return;
        }
        this.tooltipMode = string;
        int n = this.getTabCount();
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            IDevStateScalar iDevStateScalar;
            if (this.tooltipMode.equalsIgnoreCase(TAB_NO_TOOLTIP)) {
                this.setToolTipTextAt(i, null);
                continue;
            }
            if (this.tooltipMode.equalsIgnoreCase(TAB_NAME_TOOLTIP)) {
                iDevStateScalar = this.getStateAttAt(i);
                if (iDevStateScalar == null) {
                    this.setToolTipTextAt(i, "NoName");
                    continue;
                }
                this.setToolTipTextAt(i, iDevStateScalar.getName());
                continue;
            }
            if (!this.tooltipMode.equalsIgnoreCase(TAB_STATE_TOOLTIP)) continue;
            iDevStateScalar = this.getStateAttAt(i);
            if (iDevStateScalar == null) {
                this.setToolTipTextAt(i, "NoState");
                continue;
            }
            try {
                this.setToolTipTextAt(i, iDevStateScalar.getValue());
                continue;
            }
            catch (Exception exception) {
                this.setToolTipTextAt(i, "UNKNOWN");
            }
        }
    }

    public IDevStateScalar getStateAttAt(int n) {
        if (n < 0 || n >= this.getTabCount()) {
            return null;
        }
        Integer n2 = new Integer(n);
        if (!this.indexStateAttMap.containsKey(n2)) {
            return null;
        }
        if (!this.stateModelMap.containsValue(n2)) {
            return null;
        }
        Object v = this.indexStateAttMap.get(n2);
        if (!(v instanceof IDevStateScalar)) {
            return null;
        }
        IDevStateScalar iDevStateScalar = (IDevStateScalar)v;
        return iDevStateScalar;
    }

    public int getTabIndexForStateAtt(IDevStateScalar iDevStateScalar) {
        if (iDevStateScalar == null) {
            return -1;
        }
        if (!this.stateModelMap.containsKey(iDevStateScalar)) {
            return -1;
        }
        Object v = this.stateModelMap.get(iDevStateScalar);
        if (v == null) {
            return -1;
        }
        if (!(v instanceof Integer)) {
            return -1;
        }
        Integer n = (Integer)v;
        return n;
    }

    public void addDevStateScalarModel(Integer n, IDevStateScalar iDevStateScalar) {
        if (n == null || iDevStateScalar == null) {
            return;
        }
        if (n < 0 || n >= this.getTabCount()) {
            return;
        }
        if (this.stateModelMap.containsValue(n)) {
            return;
        }
        this.indexStateAttMap.put(n, iDevStateScalar);
        this.stateModelMap.put(iDevStateScalar, n);
        iDevStateScalar.addDevStateScalarListener((IDevStateScalarListener)this);
        iDevStateScalar.addErrorListener((IErrorListener)this);
        iDevStateScalar.refresh();
        if (this.tooltipMode.equalsIgnoreCase(TAB_NAME_TOOLTIP)) {
            this.setToolTipTextAt(n, iDevStateScalar.getName());
        } else if (this.tooltipMode.equalsIgnoreCase(TAB_STATE_TOOLTIP)) {
            try {
                this.setToolTipTextAt(n, iDevStateScalar.getValue());
            }
            catch (Exception exception) {
                this.setToolTipTextAt(n, "UNKNOWN");
            }
        } else {
            this.setToolTipTextAt(n, null);
        }
    }

    public void removeDevStateScalarModel(Integer n, IDevStateScalar iDevStateScalar) {
        if (n == null || iDevStateScalar == null) {
            return;
        }
        if (n < 0 || n >= this.getTabCount()) {
            return;
        }
        if (!this.stateModelMap.containsKey(iDevStateScalar)) {
            return;
        }
        if (!this.indexStateAttMap.containsKey(n)) {
            return;
        }
        Integer n2 = (Integer)this.stateModelMap.get(iDevStateScalar);
        if (n2.intValue() != n.intValue()) {
            return;
        }
        iDevStateScalar.removeDevStateScalarListener((IDevStateScalarListener)this);
        iDevStateScalar.removeErrorListener((IErrorListener)this);
        this.stateModelMap.remove(iDevStateScalar);
        this.indexStateAttMap.remove(n);
    }

    public void devStateScalarChange(DevStateScalarEvent devStateScalarEvent) {
        IDevStateScalar iDevStateScalar = null;
        if (!(devStateScalarEvent.getSource() instanceof IDevStateScalar)) {
            return;
        }
        iDevStateScalar = (IDevStateScalar)devStateScalarEvent.getSource();
        this.setStateOnTab(iDevStateScalar, devStateScalarEvent.getValue());
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        IDevStateScalar iDevStateScalar = null;
        if (!(errorEvent.getSource() instanceof IDevStateScalar)) {
            return;
        }
        iDevStateScalar = (IDevStateScalar)errorEvent.getSource();
        this.setStateOnTab(iDevStateScalar, "UNKNOWN");
    }

    private void setStateOnTab(IDevStateScalar iDevStateScalar, String string) {
        if (iDevStateScalar == null) {
            return;
        }
        if (!this.stateModelMap.containsKey(iDevStateScalar)) {
            return;
        }
        Integer n = (Integer)this.stateModelMap.get(iDevStateScalar);
        try {
            this.setBackgroundAt(n, ATKConstant.getColor4State(string));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (!this.tooltipMode.equalsIgnoreCase(TAB_STATE_TOOLTIP)) {
            return;
        }
        int n2 = this.getTabIndexForStateAtt(iDevStateScalar);
        if (n2 < 0 || n2 >= this.getTabCount()) {
            return;
        }
        this.setToolTipTextAt(n2, string);
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        TabbedPaneDevStateScalarViewer tabbedPaneDevStateScalarViewer = new TabbedPaneDevStateScalarViewer();
        jPanel.setPreferredSize(new Dimension(300, 200));
        jPanel2.setPreferredSize(new Dimension(300, 200));
        tabbedPaneDevStateScalarViewer.addTab("jlptest1", jPanel);
        tabbedPaneDevStateScalarViewer.addTab("jlptest2", jPanel2);
        try {
            IDevStateScalar iDevStateScalar = (IDevStateScalar)attributeList.add("jlp/test/1/State");
            IDevStateScalar iDevStateScalar2 = (IDevStateScalar)attributeList.add("jlp/test/2/State");
            int n = tabbedPaneDevStateScalarViewer.indexOfComponent(jPanel);
            Integer n2 = new Integer(n);
            tabbedPaneDevStateScalarViewer.addDevStateScalarModel(n2, iDevStateScalar);
            int n3 = tabbedPaneDevStateScalarViewer.indexOfComponent(jPanel2);
            Integer n4 = new Integer(n3);
            tabbedPaneDevStateScalarViewer.addDevStateScalarModel(n4, iDevStateScalar2);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setContentPane(tabbedPaneDevStateScalarViewer);
        attributeList.startRefresher();
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class DevStateTabbedPaneUI
    extends MetalTabbedPaneUI {
        DevStateTabbedPaneUI() {
        }

        protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            super.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, false);
        }
    }
}

