/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.StringScalarEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class StringScalarEditor
extends JTextField
implements IStringScalarListener {
    private IStringScalar model = null;
    private String lastSet = null;

    public StringScalarEditor() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringScalarEditor.this.textInsertActionPerformed(actionEvent);
            }
        });
    }

    public void setModel(IStringScalar iStringScalar) {
        if (this.model != null) {
            this.model.removeStringScalarListener((IStringScalarListener)this);
        }
        if (iStringScalar == null) {
            this.model = null;
            return;
        }
        if (!iStringScalar.isWritable()) {
            throw new IllegalArgumentException("StringScalarEditor: Only accept writeable attribute.");
        }
        this.model = iStringScalar;
        this.model.addStringScalarListener((IStringScalarListener)this);
        this.model.refresh();
        String string = this.model.getString();
        if (string == null) {
            string = "NULL";
        }
        this.setText(string);
        this.lastSet = string;
    }

    public IStringScalar getModel() {
        return this.model;
    }

    public void stringScalarChange(StringScalarEvent stringScalarEvent) {
        String string = null;
        long l = System.currentTimeMillis();
        if (this.model != null) {
            string = this.hasFocus() ? this.model.getStringDeviceSetPoint() : this.model.getStringSetPoint();
        }
        if (string != null) {
            if (!string.equals(this.lastSet)) {
                this.setText(string);
                this.lastSet = string;
            }
        } else {
            this.setText("NULL");
            this.lastSet = "NULL";
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setText("Read Error");
        this.lastSet = "Read Error";
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    private void textInsertActionPerformed(ActionEvent actionEvent) {
        this.lastSet = this.getText();
        if (this.model != null) {
            this.model.setString(this.lastSet);
        }
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        StringScalarEditor stringScalarEditor = new StringScalarEditor();
        try {
            IStringScalar iStringScalar = (IStringScalar)attributeList.add("dev/test/10/String_attr_w");
            stringScalarEditor.setModel(iStringScalar);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        attributeList.startRefresher();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(stringScalarEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

