/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.EnumScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimpleEnumScalarViewer;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.attribute.StringScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.StringScalarEditor;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ScalarListSetter
extends JPanel
implements JAutoScrolledTextListener {
    public static final String BOOLEAN_DEFAULT_SETTER = "None";
    public static final String BOOLEAN_COMBO_SETTER = "BooleanComboEditor";
    protected Vector listModel = null;
    protected Vector scalarLabels = null;
    protected Vector scalarViewers = null;
    protected Vector scalarSetters = null;
    protected Vector scalarPropButtons = null;
    protected SimplePropertyFrame propFrame = new SimplePropertyFrame();
    protected Font theFont = new Font("Dialog", 0, 14);
    private boolean labelVisible = true;
    private boolean viewerVisible = true;
    private boolean propertyButtonVisible = true;
    private boolean propertyListEditable = true;
    private boolean unitVisible = true;
    private String booleanSetterType = "None";
    private Color arrowColor = null;
    private String numberSetterType = "deprecated";
    private String stringSetterType = "deprecated";
    public static final String NUMBER_DEFAULT_SETTER = "WheelEditor";
    public static final String NUMBER_COMBO_SETTER = "ComboEditor";
    public static final String STRING_DEFAULT_SETTER = "StringScalarEditor";
    public static final String STRING_COMBO_SETTER = "StringComboEditor";

    public ScalarListSetter() {
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
    }

    public void setModel(AttributeList attributeList) {
        if (attributeList == null) {
            if (this.listModel != null) {
                this.removeComponents();
            }
            return;
        }
        if (this.listModel != null) {
            return;
        }
        int n = attributeList.getSize();
        if (n <= 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            IAttribute iAttribute;
            Object object = attributeList.getElementAt(i);
            if (!(object instanceof INumberScalar) && !(object instanceof IStringScalar) && !(object instanceof IBooleanScalar) && !(object instanceof IEnumScalar) || !(iAttribute = (IAttribute)object).isWritable()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        this.initComponents(attributeList);
        this.setVisible(true);
    }

    protected void removeComponents() {
        Object var3_1 = null;
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = null;
        SimpleEnumScalarViewer simpleEnumScalarViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        StringScalarEditor stringScalarEditor = null;
        StringScalarComboEditor stringScalarComboEditor = null;
        BooleanScalarComboEditor booleanScalarComboEditor = null;
        EnumScalarComboEditor enumScalarComboEditor = null;
        Object var18_12 = null;
        this.propFrame = null;
        this.propFrame = new SimplePropertyFrame();
        int n = this.listModel.size();
        for (int i = 0; i < n; ++i) {
            try {
                INumberScalar iNumberScalar = null;
                IStringScalar iStringScalar = null;
                IBooleanScalar iBooleanScalar = null;
                IEnumScalar iEnumScalar = null;
                var3_1 = this.listModel.get(i);
                if (var3_1 instanceof INumberScalar) {
                    iNumberScalar = var3_1;
                } else if (var3_1 instanceof IStringScalar) {
                    iStringScalar = var3_1;
                } else if (var3_1 instanceof IBooleanScalar) {
                    iBooleanScalar = var3_1;
                } else if (var3_1 instanceof IEnumScalar) {
                    iEnumScalar = var3_1;
                }
                if (iNumberScalar == null && iStringScalar == null && iBooleanScalar == null && iEnumScalar == null) continue;
                var3_1 = this.scalarLabels.get(i);
                if (var3_1 instanceof LabelViewer) {
                    labelViewer = var3_1;
                    labelViewer.setModel(null);
                }
                if ((var3_1 = this.scalarViewers.get(i)) instanceof SimpleScalarViewer) {
                    simpleScalarViewer = var3_1;
                    simpleScalarViewer.clearModel();
                } else if (var3_1 instanceof BooleanScalarCheckBoxViewer) {
                    booleanScalarCheckBoxViewer = var3_1;
                    booleanScalarCheckBoxViewer.clearModel();
                } else if (var3_1 instanceof SimpleEnumScalarViewer) {
                    simpleEnumScalarViewer = var3_1;
                    simpleEnumScalarViewer.clearModel();
                }
                var3_1 = this.scalarSetters.get(i);
                if (var3_1 == null) continue;
                if (var3_1 instanceof NumberScalarWheelEditor) {
                    numberScalarWheelEditor = var3_1;
                    numberScalarWheelEditor.setModel(null);
                    continue;
                }
                if (var3_1 instanceof NumberScalarComboEditor) {
                    numberScalarComboEditor = var3_1;
                    numberScalarComboEditor.setNumberModel(null);
                    continue;
                }
                if (var3_1 instanceof StringScalarEditor) {
                    stringScalarEditor = var3_1;
                    stringScalarEditor.setModel(null);
                    continue;
                }
                if (var3_1 instanceof StringScalarComboEditor) {
                    stringScalarComboEditor = var3_1;
                    stringScalarComboEditor.setStringModel(null);
                    continue;
                }
                if (var3_1 instanceof BooleanScalarComboEditor) {
                    booleanScalarComboEditor = var3_1;
                    if (iBooleanScalar == null || !iBooleanScalar.isWritable()) continue;
                    booleanScalarComboEditor.setAttModel(null);
                    continue;
                }
                if (!(var3_1 instanceof EnumScalarComboEditor)) continue;
                enumScalarComboEditor = var3_1;
                if (iEnumScalar == null || !iEnumScalar.isWritable()) continue;
                enumScalarComboEditor.setEnumModel(null);
                continue;
            }
            catch (Exception exception) {
                System.out.println("ScalarListSetter : setTheFont : Caught exception  " + exception.getMessage());
            }
        }
        this.scalarLabels.removeAllElements();
        this.scalarViewers.removeAllElements();
        this.scalarSetters.removeAllElements();
        this.scalarPropButtons.removeAllElements();
        this.listModel.removeAllElements();
        this.removeAll();
        this.listModel = null;
        this.scalarLabels = null;
        this.scalarViewers = null;
        this.scalarSetters = null;
        this.scalarPropButtons = null;
    }

    public Font getTheFont() {
        return this.theFont;
    }

    public void setTheFont(Font font) {
        Object var4_2 = null;
        LabelViewer labelViewer = null;
        Object var6_4 = null;
        SimpleScalarViewer simpleScalarViewer = null;
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = null;
        SimpleEnumScalarViewer simpleEnumScalarViewer = null;
        Object var10_8 = null;
        Object var11_9 = null;
        JButton jButton = null;
        JComponent jComponent = null;
        if (font != null) {
            this.theFont = font;
            if (this.listModel != null) {
                int n = this.listModel.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        var4_2 = this.scalarLabels.get(i);
                        if (var4_2 instanceof LabelViewer) {
                            labelViewer = var4_2;
                            labelViewer.setFont(this.theFont);
                        }
                        if ((var4_2 = this.scalarViewers.get(i)) != null) {
                            if (var4_2 instanceof SimpleScalarViewer) {
                                simpleScalarViewer = var4_2;
                                simpleScalarViewer.setFont(this.theFont);
                            } else if (var4_2 instanceof BooleanScalarCheckBoxViewer) {
                                booleanScalarCheckBoxViewer = var4_2;
                                booleanScalarCheckBoxViewer.setFont(this.theFont);
                            } else if (var4_2 instanceof SimpleEnumScalarViewer) {
                                simpleEnumScalarViewer = var4_2;
                                simpleEnumScalarViewer.setFont(this.theFont);
                            }
                        }
                        if ((var4_2 = this.scalarSetters.get(i)) instanceof NumberScalarWheelEditor || var4_2 instanceof NumberScalarComboEditor || var4_2 instanceof StringScalarEditor || var4_2 instanceof StringScalarComboEditor || var4_2 instanceof BooleanScalarComboEditor || var4_2 instanceof EnumScalarComboEditor) {
                            jComponent = var4_2;
                            jComponent.setFont(this.theFont);
                        }
                        if (!((var4_2 = this.scalarPropButtons.get(i)) instanceof JButton)) continue;
                        jButton = var4_2;
                        jButton.setFont(this.theFont);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("ScalarListSetter : setTheFont : Caught exception  " + exception.getMessage());
                    }
                }
            }
        }
    }

    public boolean getLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean bl) {
        if (this.labelVisible != bl) {
            this.labelVisible = bl;
            this.changeLabelVisibility();
        }
    }

    private void changeLabelVisibility() {
        Object var3_1 = null;
        LabelViewer labelViewer = null;
        if (this.scalarLabels != null) {
            int n = this.scalarLabels.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.scalarLabels.get(i);
                    if (!(var3_1 instanceof LabelViewer)) continue;
                    labelViewer = var3_1;
                    labelViewer.setVisible(this.labelVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListSetter : changeLabelVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getViewerVisible() {
        return this.viewerVisible;
    }

    public void setViewerVisible(boolean bl) {
        if (this.viewerVisible != bl) {
            this.viewerVisible = bl;
            this.changeViewerVisibility();
        }
    }

    private void changeViewerVisibility() {
        Object var3_1 = null;
        JComponent jComponent = null;
        if (this.scalarViewers != null) {
            int n = this.scalarViewers.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.scalarViewers.get(i);
                    if (var3_1 == null || !(var3_1 instanceof SimpleScalarViewer) && !(var3_1 instanceof BooleanScalarCheckBoxViewer) && !(var3_1 instanceof SimpleEnumScalarViewer)) continue;
                    jComponent = var3_1;
                    jComponent.setVisible(this.viewerVisible);
                    if (!(var3_1 instanceof BooleanScalarCheckBoxViewer) || this.viewerVisible || this.booleanSetterType.equalsIgnoreCase(BOOLEAN_COMBO_SETTER)) continue;
                    jComponent.setVisible(true);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListSetter : changeViewerVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyButtonVisible() {
        return this.propertyButtonVisible;
    }

    public void setPropertyButtonVisible(boolean bl) {
        if (this.propertyButtonVisible != bl) {
            this.propertyButtonVisible = bl;
            this.changePropButtonVisibility();
        }
    }

    private void changePropButtonVisibility() {
        Object var3_1 = null;
        JButton jButton = null;
        if (this.scalarPropButtons != null) {
            int n = this.scalarPropButtons.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.scalarPropButtons.get(i);
                    if (!(var3_1 instanceof JButton)) continue;
                    jButton = var3_1;
                    jButton.setVisible(this.propertyButtonVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListSetter : changePropButtonVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyListEditable() {
        return this.propertyListEditable;
    }

    public void setPropertyListEditable(boolean bl) {
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean bl) {
        if (this.unitVisible != bl) {
            this.unitVisible = bl;
            this.changeUnitVisibility();
        }
    }

    private void changeUnitVisibility() {
        Object var3_1 = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        if (this.scalarViewers != null) {
            int n = this.scalarViewers.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.scalarViewers.get(i);
                    if (var3_1 instanceof SimpleScalarViewer) {
                        simpleScalarViewer = var3_1;
                        simpleScalarViewer.setUnitVisible(this.unitVisible);
                    }
                    if (!((var3_1 = this.scalarSetters.get(i)) instanceof NumberScalarComboEditor)) continue;
                    numberScalarComboEditor = var3_1;
                    numberScalarComboEditor.setUnitVisible(this.unitVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListSetter : changeUnitVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public String getBooleanSetterType() {
        return this.booleanSetterType;
    }

    public void setBooleanSetterType(String string) {
        if (this.listModel != null) {
            return;
        }
        this.booleanSetterType = string.equalsIgnoreCase(BOOLEAN_DEFAULT_SETTER) ? BOOLEAN_DEFAULT_SETTER : (string.equalsIgnoreCase(BOOLEAN_COMBO_SETTER) ? BOOLEAN_COMBO_SETTER : BOOLEAN_DEFAULT_SETTER);
    }

    public String getNumberSetterType() {
        return this.numberSetterType;
    }

    public void setNumberSetterType(String string) {
    }

    public String getStringSetterType() {
        return this.stringSetterType;
    }

    public void setStringSetterType(String string) {
    }

    public Color getArrowColor() {
        if (this.arrowColor == null) {
            return this.getBackground();
        }
        return this.arrowColor;
    }

    public void setArrowColor(Color color) {
        if (color == this.arrowColor) {
            return;
        }
        this.changeArrowColors(color);
        this.arrowColor = color;
    }

    private void changeArrowColors(Color color) {
        Object var4_2 = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        if (this.scalarSetters != null) {
            int n = this.scalarSetters.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var4_2 = this.scalarSetters.get(i);
                    if (!(var4_2 instanceof NumberScalarWheelEditor)) continue;
                    numberScalarWheelEditor = var4_2;
                    if (color == null) {
                        numberScalarWheelEditor.setButtonColor(numberScalarWheelEditor.getBackground());
                        continue;
                    }
                    numberScalarWheelEditor.setButtonColor(color);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changeArrowColors : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public void textExceedBounds(JAutoScrolledText jAutoScrolledText) {
        this.revalidate();
    }

    protected void initComponents(AttributeList attributeList) {
        int n;
        Object object;
        Object object2;
        int n2;
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = null;
        BooleanScalarComboEditor booleanScalarComboEditor = null;
        SimpleEnumScalarViewer simpleEnumScalarViewer = null;
        EnumScalarComboEditor enumScalarComboEditor = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        StringScalarEditor stringScalarEditor = null;
        StringScalarComboEditor stringScalarComboEditor = null;
        JComponent jComponent = null;
        JComponent jComponent2 = null;
        JButton jButton = null;
        this.listModel = new Vector();
        this.scalarLabels = new Vector();
        this.scalarViewers = new Vector();
        this.scalarSetters = new Vector();
        this.scalarPropButtons = new Vector();
        int n3 = 0;
        int n4 = attributeList.size();
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            labelViewer = null;
            simpleScalarViewer = null;
            jComponent = null;
            booleanScalarCheckBoxViewer = null;
            booleanScalarComboEditor = null;
            simpleEnumScalarViewer = null;
            enumScalarComboEditor = null;
            numberScalarWheelEditor = null;
            numberScalarComboEditor = null;
            jComponent2 = null;
            stringScalarEditor = null;
            stringScalarComboEditor = null;
            jButton = null;
            object2 = attributeList.getElementAt(n2);
            if (!(object2 instanceof AAttribute) || !(object = (AAttribute)object2).isWritable() || !(object2 instanceof INumberScalar) && !(object2 instanceof IStringScalar) && !(object2 instanceof IBooleanScalar) && !(object2 instanceof IEnumScalar)) continue;
            INumberScalar iNumberScalar = null;
            IStringScalar iStringScalar = null;
            IBooleanScalar iBooleanScalar = null;
            IEnumScalar iEnumScalar = null;
            if (object2 instanceof INumberScalar) {
                simpleScalarViewer = new SimpleScalarViewer();
                jComponent = simpleScalarViewer;
                iNumberScalar = (INumberScalar)object2;
                boolean bl = false;
                if (iNumberScalar.getPossibleValues() != null && iNumberScalar.getPossibleValues().length > 0) {
                    bl = true;
                }
                if (bl) {
                    numberScalarComboEditor = new NumberScalarComboEditor();
                    numberScalarComboEditor.setFont(this.theFont);
                    numberScalarComboEditor.setBackground(this.getBackground());
                    numberScalarComboEditor.setUnitVisible(this.unitVisible);
                    numberScalarComboEditor.setNumberModel(iNumberScalar);
                    this.scalarSetters.add(numberScalarComboEditor);
                    jComponent2 = numberScalarComboEditor;
                } else {
                    numberScalarWheelEditor = new NumberScalarWheelEditor();
                    numberScalarWheelEditor.setFont(this.theFont);
                    numberScalarWheelEditor.setBackground(this.getBackground());
                    numberScalarWheelEditor.setModel(iNumberScalar);
                    this.scalarSetters.add(numberScalarWheelEditor);
                    jComponent2 = numberScalarWheelEditor;
                }
            } else if (object2 instanceof IBooleanScalar) {
                iBooleanScalar = (IBooleanScalar)object2;
                booleanScalarCheckBoxViewer = new BooleanScalarCheckBoxViewer();
                booleanScalarCheckBoxViewer.setTrueLabel(new String());
                booleanScalarCheckBoxViewer.setFalseLabel(new String());
                jComponent = booleanScalarCheckBoxViewer;
                if (this.booleanSetterType.equalsIgnoreCase(BOOLEAN_COMBO_SETTER)) {
                    booleanScalarComboEditor = new BooleanScalarComboEditor();
                    booleanScalarComboEditor.setFont(this.theFont);
                    booleanScalarComboEditor.setBackground(this.getBackground());
                    booleanScalarComboEditor.setAttModel(iBooleanScalar);
                    jComponent2 = booleanScalarComboEditor;
                } else {
                    jComponent2 = null;
                }
                this.scalarSetters.add(jComponent2);
            } else if (object2 instanceof IEnumScalar) {
                iEnumScalar = (IEnumScalar)object2;
                simpleEnumScalarViewer = new SimpleEnumScalarViewer();
                jComponent = simpleEnumScalarViewer;
                enumScalarComboEditor = new EnumScalarComboEditor();
                enumScalarComboEditor.setFont(this.theFont);
                enumScalarComboEditor.setBackground(this.getBackground());
                enumScalarComboEditor.setEnumModel(iEnumScalar);
                jComponent2 = enumScalarComboEditor;
                this.scalarSetters.add(jComponent2);
            } else {
                simpleScalarViewer = new SimpleScalarViewer();
                jComponent = simpleScalarViewer;
                iStringScalar = (IStringScalar)object2;
                boolean bl = false;
                if (iStringScalar.getPossibleValues() != null && iStringScalar.getPossibleValues().length > 0) {
                    bl = true;
                }
                if (bl) {
                    stringScalarComboEditor = new StringScalarComboEditor();
                    stringScalarComboEditor.setFont(this.theFont);
                    stringScalarComboEditor.setStringModel(iStringScalar);
                    this.scalarSetters.add(stringScalarComboEditor);
                    jComponent2 = stringScalarComboEditor;
                } else {
                    stringScalarEditor = new StringScalarEditor();
                    stringScalarEditor.setFont(this.theFont);
                    stringScalarEditor.setModel(iStringScalar);
                    this.scalarSetters.add(stringScalarEditor);
                    jComponent2 = stringScalarEditor;
                }
            }
            labelViewer = new LabelViewer();
            jButton = new JButton();
            labelViewer.setFont(this.theFont);
            labelViewer.setHorizontalAlignment(JSmoothLabel.RIGHT_ALIGNMENT);
            labelViewer.setBackground(this.getBackground());
            if (iNumberScalar != null) {
                labelViewer.setModel((IAttribute)iNumberScalar);
            } else if (iStringScalar != null) {
                labelViewer.setModel((IAttribute)iStringScalar);
            } else if (iBooleanScalar != null) {
                labelViewer.setModel((IAttribute)iBooleanScalar);
            } else if (iEnumScalar != null) {
                labelViewer.setModel((IAttribute)iEnumScalar);
            }
            if (simpleScalarViewer != null) {
                simpleScalarViewer.setFont(this.theFont);
                simpleScalarViewer.setUnitVisible(this.unitVisible);
                simpleScalarViewer.setBackgroundColor(this.getBackground());
                simpleScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
                simpleScalarViewer.setAlarmEnabled(true);
                simpleScalarViewer.addTextListener(this);
                if (iNumberScalar != null) {
                    simpleScalarViewer.setModel(iNumberScalar);
                } else {
                    simpleScalarViewer.setModel(iStringScalar);
                }
            } else if (booleanScalarCheckBoxViewer != null) {
                booleanScalarCheckBoxViewer.setAttModel(iBooleanScalar);
                booleanScalarCheckBoxViewer.setBackground(this.getBackground());
            } else if (simpleEnumScalarViewer != null) {
                simpleEnumScalarViewer.setFont(this.theFont);
                simpleEnumScalarViewer.setBackgroundColor(this.getBackground());
                simpleEnumScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
                simpleEnumScalarViewer.setAlarmEnabled(true);
                simpleEnumScalarViewer.addTextListener(this);
                simpleEnumScalarViewer.setModel(iEnumScalar);
            }
            jButton.setFont(this.theFont);
            jButton.setBackground(this.getBackground());
            jButton.setText(" ... ");
            jButton.setMargin(new Insets(-3, 0, 3, 0));
            jButton.setToolTipText("Attribute Properties");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScalarListSetter.this.propertyButtonActionPerformed(actionEvent);
                }
            });
            labelViewer.setVisible(this.labelVisible);
            jComponent.setVisible(this.viewerVisible);
            jButton.setVisible(this.propertyButtonVisible);
            if (iBooleanScalar != null && !this.viewerVisible && !this.booleanSetterType.equalsIgnoreCase(BOOLEAN_COMBO_SETTER)) {
                jComponent.setVisible(true);
            }
            if (iNumberScalar != null) {
                iNumberScalar.refresh();
            } else if (iStringScalar != null) {
                iStringScalar.refresh();
            } else if (iBooleanScalar != null) {
                iBooleanScalar.refresh();
            } else if (iEnumScalar != null) {
                iEnumScalar.refresh();
            }
            n = labelViewer.getPreferredSize().height + 2;
            if (n > n5) {
                n5 = n;
            }
            if ((n = jComponent.getPreferredSize().height + 2) > n5) {
                n5 = n;
            }
            if (jComponent2 != null && (n = jComponent2.getPreferredSize().height + 2) > n5) {
                n5 = n;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 6, 2, 1);
            this.add((Component)labelViewer, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 3, 2, 1);
            this.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.fill = 1;
            if (jComponent2 != null) {
                if (iNumberScalar != null) {
                    gridBagConstraints.insets = new Insets(1, 3, 1, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                } else if (iStringScalar != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                } else if (iBooleanScalar != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                } else if (iEnumScalar != null) {
                    gridBagConstraints.insets = new Insets(2, 3, 2, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                }
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.insets = new Insets(2, 3, 2, 6);
            this.add((Component)jButton, gridBagConstraints);
            if (iNumberScalar != null) {
                this.listModel.add(iNumberScalar);
            } else if (iStringScalar != null) {
                this.listModel.add(iStringScalar);
            } else if (iBooleanScalar != null) {
                this.listModel.add(iBooleanScalar);
            } else if (iEnumScalar != null) {
                this.listModel.add(iEnumScalar);
            }
            this.scalarLabels.add(labelViewer);
            this.scalarViewers.add(jComponent);
            this.scalarPropButtons.add(jButton);
            ++n3;
        }
        int n6 = this.scalarViewers.size();
        for (n2 = 0; n2 < n6; ++n2) {
            int n7;
            object2 = this.scalarViewers.get(n2);
            if (object2 instanceof SimpleScalarViewer) {
                simpleScalarViewer = (SimpleScalarViewer)object2;
                n = simpleScalarViewer.getPreferredSize().height + 2;
                if (n < n5) {
                    n7 = (n5 - n) / 2;
                    object = simpleScalarViewer.getMargin();
                    object.top += n7;
                    object.bottom += n7;
                    simpleScalarViewer.setMargin((Insets)object);
                }
            } else if (object2 instanceof SimpleEnumScalarViewer) {
                simpleEnumScalarViewer = (SimpleEnumScalarViewer)object2;
                n = simpleEnumScalarViewer.getPreferredSize().height + 2;
                if (n < n5) {
                    n7 = (n5 - n) / 2;
                    object = simpleEnumScalarViewer.getMargin();
                    object.top += n7;
                    object.bottom += n7;
                    simpleEnumScalarViewer.setMargin((Insets)object);
                }
            }
            if ((object2 = this.scalarSetters.get(n2)) == null || !(object2 instanceof StringScalarEditor)) continue;
            stringScalarEditor = (StringScalarEditor)object2;
            n = stringScalarEditor.getPreferredSize().height + 2;
            if (n >= n5) continue;
            n7 = (n5 - n) / 2;
            object = stringScalarEditor.getMargin();
            object.top += n7;
            object.bottom += n7;
            stringScalarEditor.setMargin((Insets)object);
            stringScalarEditor.setMargin(new Insets(n7, 3, n7 + 2, 3));
        }
    }

    private void propertyButtonActionPerformed(ActionEvent actionEvent) {
        Object e;
        int n = -1;
        if (this.scalarPropButtons == null) {
            return;
        }
        if (this.listModel == null) {
            return;
        }
        int n2 = this.scalarPropButtons.size();
        for (int i = 0; i < n2; ++i) {
            try {
                JButton jButton;
                e = this.scalarPropButtons.get(i);
                if (!(e instanceof JButton) || !(jButton = (JButton)e).equals(actionEvent.getSource())) continue;
                n = i;
                break;
            }
            catch (Exception exception) {
                System.out.println("ScalarListSetter : propertyButtonActionPerformed : Caught exception  " + exception.getMessage());
                return;
            }
        }
        if (n < 0) {
            return;
        }
        INumberScalar iNumberScalar = null;
        IStringScalar iStringScalar = null;
        IBooleanScalar iBooleanScalar = null;
        IEnumScalar iEnumScalar = null;
        try {
            e = this.listModel.get(n);
            if (e instanceof INumberScalar) {
                iNumberScalar = (INumberScalar)e;
            } else if (e instanceof IStringScalar) {
                iStringScalar = (IStringScalar)e;
            } else if (e instanceof IBooleanScalar) {
                iBooleanScalar = (IBooleanScalar)e;
            } else if (e instanceof IEnumScalar) {
                iEnumScalar = (IEnumScalar)e;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iNumberScalar == null && iStringScalar == null && iBooleanScalar == null && iEnumScalar == null) {
            return;
        }
        if (this.propFrame != null) {
            if (iNumberScalar != null) {
                this.propFrame.setModel((IAttribute)iNumberScalar);
            } else if (iStringScalar != null) {
                this.propFrame.setModel((IAttribute)iStringScalar);
            } else if (iBooleanScalar != null) {
                this.propFrame.setModel((IAttribute)iBooleanScalar);
            } else if (iEnumScalar != null) {
                this.propFrame.setModel((IAttribute)iEnumScalar);
            }
            this.propFrame.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        final AttributeList attributeList = new AttributeList();
        ScalarListSetter scalarListSetter = new ScalarListSetter();
        scalarListSetter.setTheFont(new Font("Lucida Bright", 0, 18));
        scalarListSetter.setViewerVisible(false);
        scalarListSetter.setBooleanSetterType(BOOLEAN_COMBO_SETTER);
        try {
            INumberScalar iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_un");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_deux");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_trois");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_quatre");
            IStringScalar iStringScalar = (IStringScalar)attributeList.add("jlp/test/1/att_cinq");
            IBooleanScalar iBooleanScalar = (IBooleanScalar)attributeList.add("jlp/test/1/Att_boolean");
            IAttribute iAttribute = (IAttribute)attributeList.add("jlp/test/1/att_six");
            scalarListSetter.setModel(attributeList);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            exception.printStackTrace();
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                attributeList.startRefresher();
            }
        });
        jFrame.setContentPane(scalarListSetter);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

