/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class IconNumberSpectrumViewer
extends JPanel
implements ISpectrumListener {
    JLabel[] iconViewers;
    Color[] colors;
    int columns = 4;
    Icon[] icons;
    Icon invalidIcon;
    INumberSpectrum model;
    int rows = 0;
    String[][] texts;
    private double[] oldValue = null;
    private int horizontalAlignment = 2;
    private Font font = null;
    private int spectrumDimension = 0;

    public IconNumberSpectrumViewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    protected void updateIcon(JLabel jLabel, int n) {
        try {
            if (n < this.icons.length) {
                jLabel.setIcon(this.icons[n]);
            } else {
                jLabel.setIcon(this.getInvalidIcon());
            }
        }
        catch (Exception exception) {
            jLabel.setIcon(this.getInvalidIcon());
        }
    }

    protected void updateText(JLabel jLabel, String[] stringArray, int n) {
        try {
            jLabel.setText(stringArray[n]);
        }
        catch (Exception exception) {
            jLabel.setText("");
        }
    }

    protected void updateColor(JLabel jLabel, int n) {
        try {
            if (n < this.colors.length) {
                jLabel.setBackground(this.colors[n]);
            } else {
                jLabel.setBackground(this.getBackground());
            }
        }
        catch (Exception exception) {
            jLabel.setBackground(this.getBackground());
        }
    }

    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        double[] dArray = numberSpectrumEvent.getValue();
        if (!Arrays.equals(dArray, this.oldValue)) {
            int n;
            this.removeAll();
            this.setLayout(new GridLayout(this.rows, this.columns));
            if (this.spectrumDimension != this.model.getXDimension()) {
                this.spectrumDimension = this.model.getXDimension();
                this.iconViewers = null;
                this.iconViewers = new JLabel[this.spectrumDimension];
                for (n = 0; n < this.iconViewers.length; ++n) {
                    this.iconViewers[n] = new JLabel(Integer.toString(n), this.horizontalAlignment);
                    if (this.font != null) {
                        this.iconViewers[n].setFont(this.font);
                    }
                    this.iconViewers[n].setOpaque(true);
                    this.iconViewers[n].setBorder(BorderFactory.createEtchedBorder());
                    this.add(this.iconViewers[n]);
                }
            } else {
                for (n = 0; n < this.iconViewers.length; ++n) {
                    this.iconViewers[n].setText(Integer.toString(n));
                    this.iconViewers[n].setToolTipText(Integer.toString(n));
                    this.iconViewers[n].setHorizontalAlignment(this.horizontalAlignment);
                    if (this.font != null) {
                        this.iconViewers[n].setFont(this.font);
                    }
                    this.iconViewers[n].setOpaque(true);
                    this.add(this.iconViewers[n]);
                }
            }
            n = this.iconViewers.length;
            for (int i = 0; i < n; ++i) {
                int n2 = (int)dArray[i];
                this.updateIcon(this.iconViewers[i], n2);
                if (this.texts != null) {
                    this.updateText(this.iconViewers[i], this.texts[i], n2);
                }
                this.updateColor(this.iconViewers[i], n2);
            }
            this.updateUI();
            this.oldValue = (double[])dArray.clone();
        }
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setColors(Color[] colorArray) {
        this.colors = colorArray;
    }

    public String[][] getTexts() {
        return this.texts;
    }

    public void setTexts(String[][] stringArray) {
        this.texts = stringArray;
    }

    public Icon getInvalidIcon() {
        return this.invalidIcon;
    }

    public void setInvalidIcon(Icon icon) {
        this.invalidIcon = icon;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        this.columns = n;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public INumberSpectrum getModel() {
        return this.model;
    }

    public void setModel(INumberSpectrum iNumberSpectrum) {
        if (this.model == null || !this.model.equals(this.model)) {
            if (this.model != null) {
                this.model.removeSpectrumListener((ISpectrumListener)this);
                this.removeAll();
                this.iconViewers = null;
                this.spectrumDimension = 0;
            }
            this.model = iNumberSpectrum;
            if (this.model != null) {
                this.spectrumDimension = this.model.getXDimension();
                this.iconViewers = new JLabel[this.spectrumDimension];
                this.setLayout(new GridLayout(this.rows, this.columns));
                for (int i = 0; i < this.iconViewers.length; ++i) {
                    this.iconViewers[i] = new JLabel(Integer.toString(i), this.horizontalAlignment);
                    if (this.font != null) {
                        this.iconViewers[i].setFont(this.font);
                    }
                    this.iconViewers[i].setOpaque(true);
                    this.iconViewers[i].setBorder(BorderFactory.createEtchedBorder());
                    this.add(this.iconViewers[i]);
                }
                this.model.addSpectrumListener((ISpectrumListener)this);
            }
        }
    }

    public void setIconBorders(Border border) {
        for (int i = 0; i < this.iconViewers.length; ++i) {
            this.iconViewers[i].setBorder(border);
        }
    }

    public Border getIconBorders() {
        return this.iconViewers[0].getBorder();
    }

    public void setFont(Font font) {
        this.font = font;
        if (this.iconViewers == null) {
            return;
        }
        for (int i = 0; i < this.iconViewers.length; ++i) {
            this.iconViewers[i].setFont(font);
            this.iconViewers[i].revalidate();
            this.iconViewers[i].repaint();
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
        if (this.iconViewers == null) {
            return;
        }
        for (int i = 0; i < this.iconViewers.length; ++i) {
            this.iconViewers[i].setHorizontalAlignment(n);
            this.iconViewers[i].revalidate();
            this.iconViewers[i].repaint();
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public Icon[] getIcons() {
        return this.icons;
    }

    public void setIcons(Icon[] iconArray) {
        this.icons = iconArray;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "tests/machine/status/stateOfIDs";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        Icon[] iconArray = new Icon[13];
        AttributeList attributeList = new AttributeList();
        INumberSpectrum iNumberSpectrum = (INumberSpectrum)attributeList.add(string);
        IconNumberSpectrumViewer iconNumberSpectrumViewer = new IconNumberSpectrumViewer();
        iconArray[0] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/bulbDisabled.gif"));
        iconArray[1] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/bulbEnabled.gif"));
        iconArray[2] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledBlue.gif"));
        iconArray[3] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledBrownGray.gif"));
        iconArray[4] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledDarkGray.gif"));
        iconArray[5] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledDarkOrange.gif"));
        iconArray[6] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledGray.gif"));
        iconArray[7] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledGreen.gif"));
        iconArray[8] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledLightOrange.gif"));
        iconArray[9] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledPink.gif"));
        iconArray[10] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledRed.gif"));
        iconArray[11] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledWhite.gif"));
        iconArray[12] = new ImageIcon(iconNumberSpectrumViewer.getClass().getResource("/fr/esrf/tangoatk/widget/icons/ledYellow.gif"));
        iconNumberSpectrumViewer.setColumns(4);
        iconNumberSpectrumViewer.setIcons(iconArray);
        iconNumberSpectrumViewer.setModel(iNumberSpectrum);
        attributeList.startRefresher();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(iconNumberSpectrumViewer);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }
}

