/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.FilterManager;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.container.PicoContainerFactory;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.IEventChannel;
import org.jacorb.notification.servant.ITypedAdmin;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.QoSAdminOperations;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyChannelAdmin.ProxyNotFound;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.ComponentAdapterFactory;

public abstract class AbstractAdmin
implements QoSAdminOperations,
FilterAdminOperations,
FilterStage,
ManageableServant {
    protected static final InterFilterGroupOperator DEFAULT_FILTER_GROUP_OPERATOR = InterFilterGroupOperator.AND_OP;
    private final DisposableManager disposables_ = new DisposableManager();
    private final Integer id_;
    private InterFilterGroupOperator filterGroupOperator_;
    protected final MutablePicoContainer container_;
    private final FilterManager filterManager_;
    private final WeakReference eventChannelReference_;
    private final QoSPropertySet qosSettings_;
    private final MessageFactory messageFactory_;
    protected final OfferManager offerManager_;
    protected final SubscriptionManager subscriptionManager_;
    protected final Logger logger_;
    private final ORB orb_;
    private final POA poa_;
    protected final Object modifyProxiesLock_ = new Object();
    protected final Map pullServants_ = new HashMap();
    protected final Map pushServants_ = new HashMap();
    private final SynchronizedInt proxyIdPool_ = new SynchronizedInt(0);
    private final SynchronizedBoolean disposed_ = new SynchronizedBoolean(false);
    private final List proxyEventListener_ = new ArrayList();
    public final int channelID_;
    private final ComponentAdapterFactory componentAdapterFactory_;
    static /* synthetic */ Class class$org$jacorb$notification$servant$ITypedAdmin;
    static /* synthetic */ Class class$org$picocontainer$defaults$ComponentAdapterFactory;
    static /* synthetic */ Class class$org$jacorb$notification$IContainer;
    static /* synthetic */ Class class$org$jacorb$notification$servant$IAdmin;

    protected AbstractAdmin(IEventChannel iEventChannel, ORB oRB, POA pOA, Configuration configuration, MessageFactory messageFactory, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        this.container_ = iEventChannel.getContainer();
        this.id_ = new Integer(iEventChannel.getAdminID());
        this.orb_ = oRB;
        this.poa_ = pOA;
        this.messageFactory_ = messageFactory;
        this.filterManager_ = new FilterManager();
        this.eventChannelReference_ = new WeakReference<EventChannel>(iEventChannel.getEventChannel());
        this.channelID_ = iEventChannel.getChannelID();
        this.logger_ = ((org.jacorb.config.Configuration)configuration).getNamedLogger(this.getClass().getName());
        this.qosSettings_ = new QoSPropertySet(configuration, 1);
        this.offerManager_ = offerManager;
        this.subscriptionManager_ = subscriptionManager;
        this.componentAdapterFactory_ = (ComponentAdapterFactory)this.container_.getComponentInstance((Object)(class$org$picocontainer$defaults$ComponentAdapterFactory == null ? (class$org$picocontainer$defaults$ComponentAdapterFactory = AbstractAdmin.class$("org.picocontainer.defaults.ComponentAdapterFactory")) : class$org$picocontainer$defaults$ComponentAdapterFactory));
    }

    public final void addDisposeHook(Disposable disposable) {
        this.disposables_.addDisposable(disposable);
    }

    public void setInterFilterGroupOperator(InterFilterGroupOperator interFilterGroupOperator) {
        this.filterGroupOperator_ = interFilterGroupOperator;
    }

    protected POA getPOA() {
        return this.poa_;
    }

    protected ORB getORB() {
        return this.orb_;
    }

    protected MessageFactory getMessageFactory() {
        return this.messageFactory_;
    }

    public POA _default_POA() {
        return this.getPOA();
    }

    int getProxyID() {
        return this.proxyIdPool_.increment();
    }

    public List getFilters() {
        return this.filterManager_.getFilters();
    }

    public int add_filter(Filter filter) {
        return this.filterManager_.add_filter(filter);
    }

    public void remove_filter(int n) throws FilterNotFound {
        this.filterManager_.remove_filter(n);
    }

    public Filter get_filter(int n) throws FilterNotFound {
        return this.filterManager_.get_filter(n);
    }

    public int[] get_all_filters() {
        return this.filterManager_.get_all_filters();
    }

    public void remove_all_filters() {
        this.filterManager_.remove_all_filters();
    }

    public final InterFilterGroupOperator MyOperator() {
        return this.filterGroupOperator_;
    }

    public final EventChannel MyChannel() {
        return (EventChannel)this.eventChannelReference_.get();
    }

    public final int MyID() {
        return this.getID();
    }

    public Property[] get_qos() {
        return this.qosSettings_.get_qos();
    }

    public void set_qos(Property[] propertyArray) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, new NamedPropertyRangeSeqHolder());
        this.qosSettings_.set_qos(propertyArray);
    }

    public void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, namedPropertyRangeSeqHolder);
    }

    public void destroy() {
        this.checkDestroyStatus();
        this.container_.dispose();
        List list = this.container_.getComponentInstancesOfType(class$org$jacorb$notification$IContainer == null ? (class$org$jacorb$notification$IContainer = AbstractAdmin.class$("org.jacorb.notification.IContainer")) : class$org$jacorb$notification$IContainer);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IContainer iContainer = (IContainer)iterator.next();
            iContainer.destroy();
        }
    }

    private void checkDestroyStatus() throws OBJECT_NOT_EXIST {
        if (!this.disposed_.commit(false, true)) {
            throw new OBJECT_NOT_EXIST();
        }
    }

    public void dispose() {
        this.logger_.info("destroy Admin " + this.MyID());
        this.deactivate();
        this.remove_all_filters();
        this.disposables_.dispose();
        this.proxyEventListener_.clear();
    }

    public void deactivate() {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("deactivate Admin: " + this.getID());
        }
        try {
            byte[] byArray = this.getPOA().servant_to_id(this.getServant());
            this.getPOA().deactivate_object(byArray);
        }
        catch (Exception exception) {
            this.logger_.error("Couldn't deactivate Admin", exception);
        }
    }

    public abstract Servant getServant();

    public Integer getID() {
        return this.id_;
    }

    public boolean isDisposed() {
        return this.disposed_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCreateProxyRequestEvent() throws AdminLimitExceeded {
        List list = this.proxyEventListener_;
        synchronized (list) {
            ProxyEvent proxyEvent = new ProxyEvent(this);
            Iterator iterator = this.proxyEventListener_.iterator();
            while (iterator.hasNext()) {
                ProxyEventListener proxyEventListener = (ProxyEventListener)iterator.next();
                proxyEventListener.actionProxyCreationRequest(proxyEvent);
            }
        }
    }

    public boolean hasLifetimeFilter() {
        return false;
    }

    public boolean hasPriorityFilter() {
        return false;
    }

    public MappingFilter getLifetimeFilter() {
        throw new UnsupportedOperationException();
    }

    public MappingFilter getPriorityFilter() {
        throw new UnsupportedOperationException();
    }

    public boolean hasInterFilterGroupOperatorOR() {
        return this.filterGroupOperator_ != null && this.filterGroupOperator_.value() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractProxy getProxy(int n) throws ProxyNotFound {
        Integer n2 = new Integer(n);
        AbstractProxy abstractProxy = null;
        Object object = this.modifyProxiesLock_;
        synchronized (object) {
            abstractProxy = (AbstractProxy)this.pullServants_.get(n2);
            if (abstractProxy == null) {
                abstractProxy = (AbstractProxy)this.pushServants_.get(n2);
            }
        }
        if (abstractProxy == null) {
            throw new ProxyNotFound("The proxy with ID=" + n + " does not exist");
        }
        if (!abstractProxy.isIDPublic()) {
            throw new ProxyNotFound("The proxy with ID=" + n + " is a EventStyle proxy and therefor not accessible by ID");
        }
        return abstractProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] get_all_notify_proxies(Map map, Object object) {
        ArrayList arrayList = new ArrayList();
        Object object2 = object;
        synchronized (object2) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((AbstractProxy)entry.getValue()).isIDPublic()) continue;
                arrayList.add(entry.getKey());
            }
        }
        object2 = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object2).length; ++i) {
            object2[i] = (Integer)arrayList.get(i);
        }
        return object2;
    }

    protected void configureQoS(AbstractProxy abstractProxy) throws UnsupportedQoS {
        abstractProxy.set_qos(this.qosSettings_.get_qos());
    }

    protected void configureInterFilterGroupOperator(AbstractProxy abstractProxy) {
        if (this.filterGroupOperator_ != null && this.filterGroupOperator_.value() == 1) {
            abstractProxy.setInterFilterGroupOperatorOR(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyEventListener(ProxyEventListener proxyEventListener) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            this.proxyEventListener_.add(proxyEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProxyEventListener(ProxyEventListener proxyEventListener) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            this.proxyEventListener_.remove(proxyEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireProxyRemoved(AbstractProxy abstractProxy) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            Iterator iterator = this.proxyEventListener_.iterator();
            ProxyEvent proxyEvent = new ProxyEvent(abstractProxy);
            while (iterator.hasNext()) {
                ((ProxyEventListener)iterator.next()).actionProxyDisposed(proxyEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProxyCreated(AbstractProxy abstractProxy) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            Iterator iterator = this.proxyEventListener_.iterator();
            ProxyEvent proxyEvent = new ProxyEvent(abstractProxy);
            while (iterator.hasNext()) {
                ((ProxyEventListener)iterator.next()).actionProxyCreated(proxyEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProxyToMap(final AbstractProxy abstractProxy, final Map map, final Object object) {
        Object object2 = object;
        synchronized (object2) {
            map.put(abstractProxy.getID(), abstractProxy);
            this.fireProxyCreated(abstractProxy);
        }
        abstractProxy.addDisposeHook(new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object2 = object;
                synchronized (object2) {
                    map.remove(abstractProxy.getID());
                    AbstractAdmin.this.fireProxyRemoved(abstractProxy);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getProxies() {
        ArrayList arrayList = new ArrayList();
        Object object = this.modifyProxiesLock_;
        synchronized (object) {
            arrayList.addAll(this.pullServants_.values());
            arrayList.addAll(this.pushServants_.values());
        }
        return arrayList;
    }

    protected MutablePicoContainer newContainerForNotifyStyleProxy() {
        return this.newContainerForProxy(true);
    }

    protected MutablePicoContainer newContainerForEventStyleProxy() {
        return this.newContainerForProxy(false);
    }

    protected MutablePicoContainer newContainerForTypedProxy(String string) {
        MutablePicoContainer mutablePicoContainer = this.newContainerForNotifyStyleProxy();
        IAdmin iAdmin = (IAdmin)mutablePicoContainer.getComponentInstance((Object)(class$org$jacorb$notification$servant$IAdmin == null ? (class$org$jacorb$notification$servant$IAdmin = AbstractAdmin.class$("org.jacorb.notification.servant.IAdmin")) : class$org$jacorb$notification$servant$IAdmin));
        ITypedAdminImpl iTypedAdminImpl = new ITypedAdminImpl(iAdmin, mutablePicoContainer, string);
        mutablePicoContainer.registerComponentInstance((Object)(class$org$jacorb$notification$servant$ITypedAdmin == null ? (class$org$jacorb$notification$servant$ITypedAdmin = AbstractAdmin.class$("org.jacorb.notification.servant.ITypedAdmin")) : class$org$jacorb$notification$servant$ITypedAdmin), (Object)iTypedAdminImpl);
        return mutablePicoContainer;
    }

    private MutablePicoContainer newContainerForProxy(boolean bl) {
        int n = this.getProxyID();
        return this.newContainerForProxy(n, bl);
    }

    private MutablePicoContainer newContainerForProxy(final int n, final boolean bl) {
        final MutablePicoContainer mutablePicoContainer = PicoContainerFactory.createChildContainer(this.container_);
        IAdmin iAdmin = new IAdmin(){

            public MutablePicoContainer getContainer() {
                return mutablePicoContainer;
            }

            public int getProxyID() {
                return n;
            }

            public boolean isIDPublic() {
                return bl;
            }

            public void destroy() {
                AbstractAdmin.this.container_.removeChildContainer((PicoContainer)mutablePicoContainer);
            }
        };
        mutablePicoContainer.registerComponentInstance((Object)(class$org$jacorb$notification$servant$IAdmin == null ? (class$org$jacorb$notification$servant$IAdmin = AbstractAdmin.class$("org.jacorb.notification.servant.IAdmin")) : class$org$jacorb$notification$servant$IAdmin), (Object)iAdmin);
        return mutablePicoContainer;
    }

    protected ComponentAdapter newComponentAdapter(Object object, Class clazz) {
        return new CachingComponentAdapter(this.componentAdapterFactory_.createComponentAdapter(object, clazz, null));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ITypedAdminImpl
    implements ITypedAdmin {
        private final IAdmin admin_;
        private final MutablePicoContainer container_;
        private final String supportedInterface_;

        private ITypedAdminImpl(IAdmin iAdmin, MutablePicoContainer mutablePicoContainer, String string) {
            this.admin_ = iAdmin;
            this.container_ = mutablePicoContainer;
            this.supportedInterface_ = string;
        }

        public String getSupportedInterface() {
            return this.supportedInterface_;
        }

        public int getProxyID() {
            return this.admin_.getProxyID();
        }

        public boolean isIDPublic() {
            return this.admin_.isIDPublic();
        }

        public MutablePicoContainer getContainer() {
            return this.admin_.getContainer();
        }

        public void destroy() {
            this.container_.unregisterComponent((Object)(class$org$jacorb$notification$servant$ITypedAdmin == null ? (class$org$jacorb$notification$servant$ITypedAdmin = AbstractAdmin.class$("org.jacorb.notification.servant.ITypedAdmin")) : class$org$jacorb$notification$servant$ITypedAdmin));
            this.admin_.destroy();
        }
    }
}

