/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevCmdInfo_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevInfo_3;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.Device;
import fr.esrf.Tango.DeviceHelper;
import fr.esrf.Tango.Device_2;
import fr.esrf.Tango.Device_2Helper;
import fr.esrf.Tango.Device_3;
import fr.esrf.Tango.Device_3Helper;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbRedundancy;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.TacoTangoDevice;
import fr.esrf.TangoApi.TangoUrl;
import fr.esrf.TangoDs.Except;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;

public class Connection
implements ApiDefs {
    protected int idl_version = 1;
    protected Device device = null;
    protected Device_2 device_2 = null;
    protected Device_3 device_3 = null;
    protected TacoTangoDevice taco_device = null;
    private Object obj = null;
    private int dev_timeout = 0;
    protected String devname = null;
    private boolean already_connected = false;
    private boolean device_is_dbase;
    protected String ior = null;
    protected TangoUrl url;
    protected DevSource dev_src = DevSource.CACHE_DEV;
    protected boolean transparent_reconnection = true;
    private DevFailed prev_failed = null;
    private long prev_failed_t0 = 0L;
    protected boolean check_access = true;
    protected int access = 0;

    public Device get_device() {
        return this.device;
    }

    private String buildUrlName(String host, String port) {
        return new String("tango://" + host + ":" + port);
    }

    private String buildUrlName(String host, String port, String devname) {
        return new String("tango://" + host + ":" + port + "/" + devname);
    }

    protected Connection() throws DevFailed {
        this.url = new TangoUrl();
        this.device_is_dbase = true;
        this.transparent_reconnection = true;
        ApiUtil.get_orb();
        this.connect_to_dbase();
        this.devname = this.device.name();
        this.already_connected = true;
    }

    protected Connection(String host, String port) throws DevFailed {
        this.url = new TangoUrl(this.buildUrlName(host, port));
        this.device_is_dbase = true;
        this.transparent_reconnection = true;
        ApiUtil.get_orb();
        this.connect_to_dbase();
        this.devname = this.device.name();
        this.already_connected = true;
    }

    protected Connection(String host, String port, boolean auto_reconnect) throws DevFailed {
        this.url = new TangoUrl(this.buildUrlName(host, port));
        this.device_is_dbase = true;
        this.transparent_reconnection = auto_reconnect;
        ApiUtil.get_orb();
        this.connect_to_dbase();
        this.devname = this.device.name();
        this.already_connected = true;
    }

    protected Connection(String devname) throws DevFailed {
        this.url = new TangoUrl(devname);
        this.device_is_dbase = false;
        this.devname = this.url.devname;
        if (this.url.protocol == 0 && this.url.use_db) {
            this.ior = this.get_exported_ior();
        }
    }

    protected Connection(String devname, boolean check_access) throws DevFailed {
        this.url = new TangoUrl(devname);
        this.device_is_dbase = false;
        this.devname = this.url.devname;
        this.check_access = check_access;
        if (this.url.protocol == 0 && this.url.use_db) {
            this.ior = this.get_exported_ior();
        }
    }

    protected Connection(String devname, String param, int src) throws DevFailed {
        this.devname = devname;
        this.device_is_dbase = false;
        if (src == 1) {
            this.ior = param;
            this.url = new TangoUrl();
            this.url.protocol = 0;
        } else {
            String reason = "TangoApi_INVALID_ARGS";
            String desc = new String("Invalid argument");
            String origin = new String("Connection.Connemction()");
            Except.throw_wrong_syntax_exception(reason, desc, origin);
        }
    }

    protected Connection(String devname, String host, String port) throws DevFailed {
        this.url = new TangoUrl(this.buildUrlName(host, port, devname));
        this.devname = this.url.devname;
        this.device_is_dbase = false;
        if (this.url.protocol == 0) {
            this.ior = this.get_exported_ior();
        }
    }

    protected synchronized void build_connection() throws DevFailed {
        long t = System.currentTimeMillis();
        long delay = t - this.prev_failed_t0;
        boolean try_reconnection = true;
        if (this.device_is_dbase) {
            this.connect_to_dbase();
        } else {
            try {
                if (this.url.protocol == 0) {
                    if (this.prev_failed != null && delay < (long)ApiUtil.getReconnectionDelay()) {
                        try_reconnection = false;
                        throw this.prev_failed;
                    }
                    this.prev_failed_t0 = t;
                    if (this.url.use_db) {
                        this.dev_import();
                    } else {
                        this.dev_import_without_dbase();
                    }
                    this.prev_failed = null;
                } else if (this.url.protocol == 1 && this.taco_device == null) {
                    this.taco_device = new TacoTangoDevice(this.devname, this.url.host);
                }
            }
            catch (DevFailed e) {
                if (try_reconnection) {
                    this.prev_failed_t0 = t;
                    this.prev_failed = e;
                }
                this.ior = null;
                String reason = "TangoApi_CANNOT_IMPORT_DEVICE";
                String desc = new String("Cannot import " + this.devname);
                String origin = new String("Connection.build_connection(" + this.devname + ")");
                Except.throw_communication_failed(e, reason, desc, origin);
            }
        }
    }

    private void createDevice(String corba_str) throws DevFailed {
        try {
            ORB orb = ApiUtil.get_orb();
            this.obj = orb.string_to_object(corba_str);
        }
        catch (RuntimeException e) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_VALID", e.toString().substring(e.toString().indexOf(":") + 2), "Connection.createDevice()");
        }
        String strTimeout = System.getProperty("TANGO_TIMEOUT");
        if (strTimeout == null) {
            strTimeout = "3000";
        }
        try {
            this.dev_timeout = Integer.parseInt(strTimeout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.set_obj_timeout(this.dev_timeout);
        if (this.obj._is_a("IDL:Tango/Device_3:1.0")) {
            this.device_3 = Device_3Helper.narrow(this.obj);
            this.device_2 = this.device_3;
            this.device = this.device_3;
            this.idl_version = 3;
        } else if (this.obj._is_a("IDL:Tango/Device_2:1.0")) {
            this.device_2 = Device_2Helper.narrow(this.obj);
            this.device = this.device_2;
            this.idl_version = 2;
        } else if (this.obj._is_a("IDL:Tango/Device:1.0")) {
            this.device = DeviceHelper.narrow(this.obj);
            this.idl_version = 1;
        } else {
            Except.throw_non_supported_exception("TangoApi_DEVICE_IDL_UNKNOWN", this.devname + " has an IDL revision not suported !", "Connection.createDevice(" + this.devname + ")");
        }
        this.obj._is_a("Dummy");
    }

    public String get_ior() throws DevFailed {
        Database db = this.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(this.url.host, this.url.strport);
        DbDevImportInfo info = db.import_device(this.devname);
        return info.ior;
    }

    private String get_exported_ior() throws DevFailed {
        Database db = this.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(this.url.host, this.url.strport);
        DbDevImportInfo info = db.import_device(this.devname);
        String result = null;
        if (info.exported) {
            result = info.ior;
        }
        if (info.is_taco) {
            this.url.protocol = 1;
        } else {
            this.access = this.url.use_db && this.check_access ? ApiUtil.get_db_obj(this.url.host, this.url.strport).checkAccessControl(this.devname) : 1;
        }
        return result;
    }

    protected void dev_import() throws DevFailed {
        String local_ior = null;
        Database db = this.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(this.url.host, this.url.strport);
        if (this.ior == null) {
            DbDevImportInfo info = db.import_device(this.devname);
            if (!info.exported) {
                Except.throw_connection_failed("TangoApi_DEVICE_NOT_EXPORTED", this.devname + " Not Exported !", "Connection(" + this.devname + ")");
            }
            local_ior = info.ior;
        } else {
            local_ior = this.ior;
        }
        try {
            this.createDevice(local_ior);
            this.already_connected = true;
        }
        catch (DevFailed e) {
            this.device = null;
            this.ior = null;
            throw e;
        }
        catch (Exception e) {
            this.device = null;
            this.ior = null;
            String reason = "TangoApi_CANNOT_IMPORT_DEVICE";
            String s = this.already_connected ? "Re-" : "";
            String desc = new String("Cannot " + s + "import " + this.devname + " :\n\t" + e.toString());
            String origin = new String("Connection.dev_import(" + this.devname + ")");
            Except.throw_connection_failed(reason, desc, origin);
        }
    }

    private void connect_to_dbase() throws DevFailed {
        if (this.device == null) {
            try {
                String db_corbaloc = new String("corbaloc:iiop:" + this.url.host + ":" + this.url.strport + "/database");
                this.createDevice(db_corbaloc);
            }
            catch (SystemException ex) {
                if (this.transparent_reconnection) {
                    try {
                        DbRedundancy dbr = DbRedundancy.get_instance();
                        String th2 = dbr.get(this.url.host + ":" + this.url.port);
                        String db_corbaloc = new String("corbaloc:iiop:" + th2 + "/database");
                        this.createDevice(db_corbaloc);
                    }
                    catch (SystemException e) {
                        this.device = null;
                        this.ior = null;
                        Except.throw_connection_failed("TangoApi_DATABASE_CONNECTION_FAILED", "Connection to database failed  !\n" + e, "connect_to_dbase(" + this.url.host + "," + this.url.strport + ")");
                    }
                }
                this.device = null;
                this.ior = null;
                Except.throw_connection_failed("TangoApi_DATABASE_CONNECTION_FAILED", "Connection to database failed  !\n" + ex, "connect_to_dbase(" + this.url.host + "," + this.url.strport + ")");
            }
        }
    }

    private void dev_import_without_dbase() throws DevFailed {
        if (this.device == null) {
            try {
                String db_corbaloc = new String("corbaloc:iiop:" + this.url.host + ":" + this.url.strport + "/" + this.devname.toLowerCase());
                this.createDevice(db_corbaloc);
                this.access = 1;
            }
            catch (SystemException e) {
                this.device = null;
                this.ior = null;
                e.printStackTrace();
                Except.throw_connection_failed("TangoApi_DEVICE_CONNECTION_FAILED", "Connection to device without database failed  !\n" + e, "Connection.dev_import_without_dbase(" + this.url.host + "," + this.url.strport + ")");
            }
        }
    }

    private void set_obj_timeout(int millis) {
        RelativeRoundtripTimeoutPolicy p = new RelativeRoundtripTimeoutPolicy(10000 * millis);
        this.obj._set_policy_override(new Policy[]{p}, SetOverrideType.ADD_OVERRIDE);
        this.dev_timeout = millis;
    }

    public void set_timeout_millis(int millis) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 1) {
            this.taco_device.set_rpc_timeout(millis);
            return;
        }
        this.set_obj_timeout(millis);
    }

    public int get_timeout() {
        return this.dev_timeout;
    }

    public int get_timeout_millis() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 1) {
            return this.taco_device.get_rpc_timeout();
        }
        return this.dev_timeout;
    }

    protected void throw_dev_failed(Exception e, String command, boolean from_inout_cmd) throws DevFailed {
        String origin;
        if (e instanceof DevFailed) {
            throw (DevFailed)e;
        }
        String string = origin = from_inout_cmd ? new String(this.devname + ".command_inout(" + command + ")") : new String(this.devname + "." + command + ")");
        if (e.toString().indexOf("org.omg.CORBA.NO_RESPONSE") >= 0 || e.toString().indexOf("org.omg.CORBA.TIMEOUT") >= 0 || e.toString().indexOf("org.omg.CORBA.IMP_LIMIT") >= 0) {
            String desc = new String("Device (" + this.devname + ") timed out (>" + this.dev_timeout + " ms)!");
            Except.throw_communication_timeout(new String(e.toString()), desc, origin);
        } else if (e.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 || e.toString().indexOf("org.omg.CORBA.UNKNOWN") >= 0 || e.toString().indexOf("org.omg.CORBA.COMM_FAILURE") >= 0 || e.toString().indexOf("org.omg.CORBA.OBJECT_NOT_EXIST") >= 0) {
            String desc = new String("Lost Connection during command : " + command);
            this.device = null;
            this.ior = null;
            Except.throw_connection_failed(new String(e.toString()), desc, origin);
        } else if (e.toString().startsWith("java.lang.RuntimeException")) {
            String desc = new String("API has catched a RuntimeException" + command);
            this.device = null;
            this.ior = null;
            Except.throw_connection_failed(new String(e.toString()), desc, origin);
        } else {
            System.out.println("API has catched an exception for " + origin + " : \n" + e);
            String desc = new String(e.getMessage());
            e.printStackTrace();
            Except.throw_communication_failed(new String(e.toString()), desc, origin);
        }
    }

    public DeviceData command_inout(String command, DeviceData argin) throws DevFailed {
        Database db;
        Any received = null;
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 1) {
            return this.taco_device.command_inout(command, argin);
        }
        if (this.access == 0 && !(db = ApiUtil.get_db_obj(this.url.host, this.url.strport)).isCommandAllowed(this.devname, command)) {
            if (db.access_devfailed != null) {
                throw db.access_devfailed;
            }
            System.out.println(this.devname + "." + command + "  -> TangoApi_READ_ONLY_MODE");
            Except.throw_connection_failed("TangoApi_READ_ONLY_MODE", this.devname + ".command_inout(" + command + ")  is not authorized !", "Connection.command_inout()");
        }
        boolean done = false;
        int retries = this.transparent_reconnection ? 2 : 1;
        for (int i = 0; i < retries && !done; ++i) {
            try {
                received = this.device_2 != null ? this.device_2.command_inout_2(command, argin.extractAny(), this.dev_src) : this.device.command_inout(command, argin.extractAny());
                done = true;
                continue;
            }
            catch (DevFailed e) {
                String reason = "TangoApi_CANNOT_EXECUTE_COMMAND";
                String desc = new String("Cannot execute command " + command + " on " + this.devname);
                String origin = new String("Connection.command_inout()");
                if (e.errors[0].reason.equals("DB_DeviceNotDefined")) {
                    String d = e.errors[0].desc;
                    int idx = d.lastIndexOf("!");
                    if (idx > 0) {
                        d = d.substring(0, idx);
                    }
                    e.errors[0].desc = d = d + "  " + this.url.host + ":" + this.url.port + " !";
                }
                Except.throw_connection_failed(e, reason, desc, origin);
                continue;
            }
            catch (Exception e) {
                if (e.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 && i == 0) {
                    this.device = null;
                    this.ior = null;
                    this.build_connection();
                    if (i != retries - 1) continue;
                    this.throw_dev_failed(e, command, true);
                    continue;
                }
                this.throw_dev_failed(e, command, true);
            }
        }
        return new DeviceData(received);
    }

    public DeviceData command_inout(String command) throws DevFailed {
        DeviceData argin = new DeviceData();
        return this.command_inout(command, argin);
    }

    public long ping() throws DevFailed {
        this.checkIfTango("ping");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        long t0 = System.currentTimeMillis();
        try {
            this.device.ping();
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT_PING_DEVICE";
            String desc = new String("Cannot ping " + this.devname);
            String origin = new String("Connection.ping()");
            Except.throw_connection_failed(e, reason, desc, origin);
        }
        catch (Exception e) {
            this.throw_dev_failed(e, "ping", false);
        }
        long t1 = System.currentTimeMillis();
        return (int)(t1 - t0) * 1000;
    }

    public String[] black_box(int length) throws DevFailed {
        this.checkIfTango("black_box");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            String[] result = this.device.black_box(length);
            return result;
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT_READ_BLACK BOX";
            String desc = new String("Cannot read black box on " + this.devname);
            String origin = new String("Connection.black_box()");
            Except.throw_connection_failed(e, reason, desc, origin);
        }
        catch (Exception e) {
            this.throw_dev_failed(e, "black_box", false);
        }
        return null;
    }

    public DevInfo_3 info_3() throws DevFailed {
        this.checkIfTango("info");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            DevInfo_3 info_3;
            if (this.device_3 != null) {
                info_3 = this.device_3.info_3();
            } else {
                DevInfo info = this.device.info();
                info_3 = new DevInfo_3(info.dev_class, info.server_id, info.server_host, info.server_version, info.doc_url, "");
            }
            return info_3;
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT_READ _DEVICE_INFO";
            String desc = new String("Cannot read device info on " + this.devname);
            String origin = new String("Connection.info()");
            Except.throw_connection_failed(e, reason, desc, origin);
        }
        catch (Exception e) {
            this.throw_dev_failed(e, "info", false);
        }
        return null;
    }

    public DevInfo info() throws DevFailed {
        this.checkIfTango("info");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            DevInfo info = this.device.info();
            return info;
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT_READ _DEVICE_INFO";
            String desc = new String("Cannot read device info on " + this.devname);
            String origin = new String("Connection.info()");
            Except.throw_connection_failed(e, reason, desc, origin);
        }
        catch (Exception e) {
            this.throw_dev_failed(e, "info", false);
        }
        return null;
    }

    public CommandInfo[] command_list_query() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            CommandInfo[] result;
            if (this.url.protocol == 1) {
                result = this.taco_device.commandListQuery();
            } else if (this.device_2 != null) {
                DevCmdInfo_2[] tmp = this.device_2.command_list_query_2();
                result = new CommandInfo[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    result[i] = new CommandInfo(tmp[i]);
                }
            } else {
                DevCmdInfo[] tmp = this.device.command_list_query();
                result = new CommandInfo[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    result[i] = new CommandInfo(tmp[i]);
                }
            }
            return result;
        }
        catch (DevFailed e) {
            String reason = "TangoApi_CANNOT__READ_CMD_LIST";
            String desc = new String("Cannot read command list for " + this.devname);
            String origin = new String("Connection.command_list_query()");
            Except.throw_connection_failed(e, reason, desc, origin);
        }
        catch (Exception e) {
            this.throw_dev_failed(e, "command_list_query", false);
        }
        return null;
    }

    public int get_idl_version() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        return this.idl_version;
    }

    public DevSource get_source() throws DevFailed {
        if (this.is_taco()) {
            if (this.taco_device == null) {
                this.taco_device = new TacoTangoDevice(this.devname, this.url.host);
            }
            return this.taco_device.get_source();
        }
        return this.dev_src;
    }

    public void set_source(DevSource new_src) throws DevFailed {
        if (this.is_taco()) {
            if (this.taco_device == null) {
                this.taco_device = new TacoTangoDevice(this.devname, this.url.host);
            }
            this.taco_device.set_source(new_src);
        } else {
            this.dev_src = new_src;
        }
    }

    public String get_name() {
        return this.devname;
    }

    public String description() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        return this.device.description();
    }

    public String adm_name() throws DevFailed {
        this.checkIfTango("adm_name");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        String name = null;
        try {
            name = this.device.adm_name();
        }
        catch (Exception e) {
            this.throw_dev_failed(e, "adm_name", false);
        }
        if (!this.url.use_db) {
            name = "tango://" + this.url.host + ":" + this.url.port + "/" + name + "#dbase=no";
        }
        return name;
    }

    public String get_tango_host() throws DevFailed {
        this.checkIfTango("get_tango_host");
        return new String(this.url.host + ":" + this.url.strport);
    }

    public boolean is_taco() {
        return this.url.protocol == 1;
    }

    protected void checkIfTaco(String cmdname) throws DevFailed {
        if (!this.is_taco()) {
            Except.throw_non_supported_exception("TangoApi_NOT_TANGO_CMD", new String(cmdname + " is NOT a TANGO command."), new String(cmdname + "()"));
        }
    }

    protected void checkIfTango(String cmdname) throws DevFailed {
        if (this.is_taco()) {
            Except.throw_non_supported_exception("TangoApi_NOT_TACO_CMD", new String(cmdname + " is NOT a TACO command."), new String(cmdname + "()"));
        }
    }

    public boolean get_transparency_reconnection() {
        return this.transparent_reconnection;
    }

    public void set_transparency_reconnection(boolean val) {
        this.transparent_reconnection = val;
    }

    public int getAccessControl() {
        return this.access;
    }

    public void setAccessControl(int access) {
        this.access = access;
    }

    public boolean isAllowedCommand(String cmd) throws DevFailed {
        return ApiUtil.get_db_obj(this.url.host, this.url.strport).isCommandAllowed(this.devname, cmd);
    }
}

