/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class ToBase
extends PostfixMathCommand {
    int globalBase = -1;
    String prefix = "";

    public ToBase() {
        this.numberOfParameters = -1;
    }

    public ToBase(int n) {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException("base must be between 2 and 2");
        }
        this.globalBase = n;
        this.numberOfParameters = -1;
    }

    public ToBase(int n, String string) {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException("base must be between 2 and 2");
        }
        this.globalBase = n;
        this.numberOfParameters = -1;
        this.prefix = string;
    }

    public boolean checkNumberOfParameters(int n) {
        if (this.globalBase == -1) {
            return n == 2 || n == 3;
        }
        return n == 1 || n == 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(Stack stack) throws ParseException {
        Object e;
        int n = this.curNumberOfParameters;
        int n2 = 0;
        int n3 = 0;
        if (!this.checkNumberOfParameters(n)) {
            throw new ParseException("toBase: can only have 1,2 or 3 arguments");
        }
        if (n == 3 || this.globalBase != -1 && n == 2) {
            try {
                n2 = ((Number)stack.pop()).intValue();
            }
            catch (ClassCastException classCastException) {
                throw new ParseException("toBase: last argument should be an integer");
            }
        }
        if (this.globalBase == -1) {
            e = stack.pop();
            if (!(e instanceof Number)) throw new ParseException("toBase: second argument should be an integer");
            n3 = ((Number)e).intValue();
        } else {
            n3 = this.globalBase;
        }
        if (n3 < 2 || n3 > 36) {
            throw new ParseException("base must be between 2 and 2");
        }
        e = stack.pop();
        String string = null;
        if (e instanceof Integer || e instanceof Short || e instanceof Long) {
            string = this.toBase(((Number)e).longValue(), n3);
        } else {
            if (!(e instanceof Float) && !(e instanceof Double) && !(e instanceof Number)) throw new ParseException("toBase: Cannot convert object of type " + e.getClass().getName());
            string = this.toBase(((Number)e).doubleValue(), n3, n2);
        }
        stack.push(string);
    }

    public String toBase(long l, int n) {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException("base must be between 2 and 2");
        }
        if (l < 0L) {
            return '-' + this.prefix + Long.toString(l, n);
        }
        return this.prefix + Long.toString(l, n);
    }

    public String toBase(double d, int n, int n2) {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException("base must be between 2 and 2");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (d < 0.0) {
            d = -d;
            stringBuffer.append('-');
        }
        stringBuffer.append(this.prefix);
        long l = Math.round(d *= Math.pow(n, n2));
        String string = Long.toString(l, n);
        if (string.length() <= n2) {
            stringBuffer.append("0.");
            for (int i = 0; i < n2 - string.length(); ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        } else if (n2 > 0) {
            stringBuffer.append(string);
            stringBuffer.insert(stringBuffer.length() - n2, '.');
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

