/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AppLauncher
extends JFrame
implements ListSelectionListener {
    Properties properties = new Properties();
    ThreadGroup applications = new ThreadGroup("Applications");
    Thread surveyer;
    private DefaultListModel threads = new DefaultListModel();
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu runMenu;
    private JMenuItem appLabel;
    private JMenuItem exitMenuItem;
    private JMenu helpMenu;
    private JList threadList;

    public AppLauncher() {
        this.initComponents();
        this.threadList.addListSelectionListener(this);
        try {
            this.properties.load(new FileInputStream(new File(".applauncher")));
            for (String string : this.properties.keySet()) {
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AppLauncher.this.startApplication(actionEvent.getActionCommand());
                    }
                });
                this.runMenu.add(jMenuItem);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception, "Error", 0);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        int n = listSelectionEvent.getFirstIndex();
        if (n < 0) {
            return;
        }
        int n2 = listSelectionEvent.getLastIndex();
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (bl || n != n2) {
            return;
        }
        JOptionPane.showMessageDialog(this, this.threads.elementAt(n), "Thread Info", 1);
    }

    protected void startApplication(String string) {
        String string2 = this.properties.getProperty(string);
        System.out.println("Creating new instance for " + string2);
        try {
            new Thread(this.applications, (Runnable)Class.forName(string2).newInstance(), string).start();
            this.applications.list();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception, "Error", 0);
        }
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.runMenu = new JMenu();
        this.appLabel = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.threadList = new JList();
        this.fileMenu.setText("File");
        this.runMenu.setText("Run");
        this.appLabel.setText("Applications");
        this.appLabel.setEnabled(false);
        this.runMenu.add(this.appLabel);
        this.fileMenu.add(this.runMenu);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AppLauncher.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText("Help");
        this.menuBar.add(this.helpMenu);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AppLauncher.this.exitForm(windowEvent);
            }
        });
        this.threadList.setModel(this.threads);
        this.getContentPane().add((Component)this.menuBar, "North");
        this.getContentPane().add((Component)this.threadList, "Center");
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        new AppLauncher().setVisible(true);
    }
}

