/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.command;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.tangoatk.core.AtkEventListenerList;
import fr.esrf.tangoatk.core.CommandExecuteException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DisplayLevelProperty;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IResultListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringProperty;
import fr.esrf.tangoatk.core.TypeProperty;
import fr.esrf.tangoatk.core.command.ACommandHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class ACommand
implements ICommand {
    protected ACommandHelper inputHelper;
    protected ACommandHelper outputHelper;
    protected Map propertyMap;
    protected String name;
    protected String nameSansDevice;
    private transient CommandInfo info;
    private Device device;
    protected String error;
    protected List oldResult;
    protected EventSupport propChanges;
    protected Throwable oldt;
    protected String alias;
    protected int executionCount = 0;
    private static String VERSION = "$Id: ACommand.java,v 1.15 2007/06/14 16:21:52 ounsy Exp $";

    public String getVersion() {
        return VERSION;
    }

    protected void init(Device device, String string, CommandInfo commandInfo) {
        this.propertyMap = new HashMap();
        this.device = device;
        this.nameSansDevice = string;
        this.name = device.getName() + "/" + string;
        this.setInfo(commandInfo);
        this.propChanges = new EventSupport();
    }

    public Device getDevice() {
        return this.device;
    }

    protected void cmdError(String string, Throwable throwable) {
        this.propChanges.fireReadErrorEvent(this, throwable);
        this.oldt = throwable;
    }

    public void storeConfig() {
    }

    public Property getProperty(String string) {
        return (Property)this.propertyMap.get(string);
    }

    int getInType() {
        return this.getNumericProperty("in_type");
    }

    protected String getTypeName(int n) {
        switch (n) {
            case 1: {
                return "boolean";
            }
            case 2: {
                return "short";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "ushort";
            }
            case 7: {
                return "ulong";
            }
            case 3: {
                return "long";
            }
            case 8: {
                return "string";
            }
            case 19: {
                return "scalar";
            }
            case 17: {
                return "long string array";
            }
            case 18: {
                return "double string array";
            }
            case 10: {
                return "short array";
            }
            case 12: {
                return "float array";
            }
            case 13: {
                return "double double";
            }
            case 14: {
                return "unsigned short array";
            }
            case 15: {
                return "unsigned long array";
            }
            case 11: {
                return "long array";
            }
            case 9: {
                return "char array";
            }
            case 16: {
                return "string array";
            }
        }
        return " ";
    }

    public String getInTypeElemName() {
        return this.getTypeName(this.getInType());
    }

    public String getOutTypeElemName() {
        return this.getTypeName(this.getOutType());
    }

    public String getTag() {
        return this.getStringProperty("tag");
    }

    public String getLevel() {
        return this.getStringProperty("level");
    }

    int getNumericProperty(String string) {
        try {
            return this.getProperty(string).getIntValue();
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException(string + " is not a known property");
        }
    }

    int getOutType() {
        return this.getNumericProperty("out_type");
    }

    String getStringProperty(String string) {
        try {
            return this.getProperty(string).getStringValue();
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException(string + " is not a known property");
        }
    }

    public String getInTypeDescription() {
        return this.getStringProperty("in_type_desc");
    }

    public String getOutTypeDescription() {
        return this.getStringProperty("out_type_desc");
    }

    void setInTypeName(String string) {
        this.setProperty("in_type_name", string);
    }

    public Map getPropertyMap() {
        return this.propertyMap;
    }

    void setOutTypeName(String string) {
        this.setProperty("out_type_name", string);
    }

    void setProperty(String string, String string2) {
        Property property = (Property)this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new StringProperty((IEntity)this, string, string2, false));
        } else {
            property.setValue(string2);
        }
    }

    void setProperty(String string, int n) {
        Property property = (Property)this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new TypeProperty(this, string, new Integer(n), false));
        } else {
            property.setValue(new Integer(n));
        }
    }

    protected void setProperty(String string, DispLevel dispLevel) {
        Property property = (Property)this.propertyMap.get(string);
        if (property == null) {
            this.propertyMap.put(string, new DisplayLevelProperty((IEntity)this, string, dispLevel, false));
        } else {
            property.setValue(dispLevel);
        }
    }

    void setInfo(CommandInfo commandInfo) {
        this.info = commandInfo;
        this.setProperty("name", this.name);
        this.setProperty("tag", commandInfo.cmd_tag);
        this.setProperty("in_type", commandInfo.in_type);
        this.setProperty("out_type", commandInfo.out_type);
        this.setProperty("in_type_desc", commandInfo.in_type_desc);
        this.setProperty("out_type_desc", commandInfo.out_type_desc);
        this.setProperty("level", commandInfo.level);
    }

    public void refresh() {
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public String getName() {
        return this.getProperty("name").getStringValue();
    }

    public String getNameSansDevice() {
        return this.nameSansDevice;
    }

    public String toString() {
        return this.nameSansDevice;
    }

    public void addErrorListener(IErrorListener iErrorListener) {
        this.propChanges.addErrorListener(iErrorListener);
    }

    public void removeErrorListener(IErrorListener iErrorListener) {
        this.propChanges.removeErrorListener(iErrorListener);
    }

    public boolean takesInput() {
        return !ACommand.isVoid(this.getInType());
    }

    public boolean takesTableInput() {
        return ACommand.isTable(this.getInType());
    }

    public boolean takesArrayInput() {
        return ACommand.isArray(this.getInType());
    }

    public boolean takesScalarInput() {
        return ACommand.isScalar(this.getInType());
    }

    public boolean doesOutput() {
        return !ACommand.isVoid(this.getOutType());
    }

    public boolean doesArrayOutput() {
        return ACommand.isArray(this.getOutType());
    }

    public static boolean isVoid(int n) {
        return n == 0;
    }

    public static boolean isBoolean(int n) {
        return n == 1;
    }

    public static boolean isString(int n) {
        return n == 8;
    }

    public static boolean isScalar(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public static boolean isArray(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTable(int n) {
        switch (n) {
            case 17: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    void setDevice(Device device) {
        this.device = device;
    }

    void setName(String string) {
        this.setProperty("name", string);
        this.name = string;
    }

    public void execute() {
        this.execute(null);
    }

    public void addResultListener(IResultListener iResultListener) {
        this.propChanges.addResultListener(iResultListener);
    }

    public void removeResultListener(IResultListener iResultListener) {
        this.propChanges.removeResultListener(iResultListener);
    }

    protected void publishResult(List list) {
        this.propChanges.fireResultEvent(this, list);
    }

    public void execute(List list) {
        ++this.executionCount;
        try {
            this.publishResult(this.outputHelper.extractOutput(this.getDevice().executeCommand(this.getName(), this.inputHelper.setInput(list))));
        }
        catch (DevFailed devFailed) {
            this.cmdError("execute(" + this.getName() + " failed", new CommandExecuteException(devFailed));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = "execute(" + this.getName() + " failed: " + exception + ")";
            this.cmdError(string, new CommandExecuteException(string));
        }
    }

    public boolean isOperator() {
        Property property = this.getProperty("level");
        if (property != null && property instanceof DisplayLevelProperty) {
            DisplayLevelProperty displayLevelProperty = (DisplayLevelProperty)property;
            return displayLevelProperty.isOperator();
        }
        return false;
    }

    public boolean isExpert() {
        Property property = this.getProperty("level");
        if (property != null && property instanceof DisplayLevelProperty) {
            DisplayLevelProperty displayLevelProperty = (DisplayLevelProperty)property;
            return displayLevelProperty.isExpert();
        }
        return false;
    }

    public AtkEventListenerList getListenerList() {
        if (this.propChanges == null) {
            return null;
        }
        return this.propChanges.getListenerList();
    }
}

