/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

abstract class NumberAttributeHelper
implements Serializable {
    IAttribute attribute;
    transient DeviceAttribute deviceAttribute;
    EventSupport propChanges;

    NumberAttributeHelper() {
    }

    public void setAttribute(IAttribute iAttribute) {
        this.attribute = iAttribute;
    }

    void init(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
        this.propChanges = ((AAttribute)iAttribute).getPropChanges();
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    public static double[] flatten(double[][] dArray) {
        int n = dArray.length * dArray[0].length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            System.arraycopy(dArray[i], 0, dArray2, i * dArray.length, dArray.length);
        }
        return dArray2;
    }

    public static double[] flatten2double(String[][] stringArray) {
        int n = stringArray.length * stringArray[0].length;
        double[] dArray = new double[n];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                dArray[n2++] = Double.parseDouble(stringArray[i][j]);
            }
        }
        return dArray;
    }

    public void addImageListener(IImageListener iImageListener) {
        this.propChanges.addImageListener(iImageListener);
    }

    public void removeImageListener(IImageListener iImageListener) {
        this.propChanges.removeImageListener(iImageListener);
    }

    abstract void setMinAlarm(double var1, boolean var3);

    abstract void setMaxAlarm(double var1, boolean var3);

    abstract void setMaxValue(double var1, boolean var3);

    abstract void setMinValue(double var1, boolean var3);

    abstract void setMinAlarm(double var1);

    abstract void setMaxAlarm(double var1);

    abstract void setMaxValue(double var1);

    abstract void setMinValue(double var1);

    void fireImageValueChanged(double[][] dArray, long l) {
        this.propChanges.fireImageEvent((INumberImage)this.attribute, dArray, l);
    }

    abstract void insert(double[] var1);

    abstract double[][] getNumberImageValue(DeviceAttribute var1) throws DevFailed;

    abstract String[][] getImageValue(DeviceAttribute var1) throws DevFailed;

    public String getVersion() {
        return "$Id: NumberAttributeHelper.java,v 1.8 2006/06/29 11:19:13 poncet Exp $";
    }
}

