/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.ATKEvent;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberScalar;

public class NumberScalarEvent
extends ATKEvent {
    double value;
    double devValue;
    long timeStamp;
    INumberScalar _source;

    public NumberScalarEvent(INumberScalar iNumberScalar, double d, long l) {
        super(iNumberScalar, l);
        this._source = iNumberScalar;
        this.setValue(d);
    }

    public double getValue() {
        return this.value;
    }

    public double getDeviceValue() {
        double d = 1.0;
        if (this.source != null && this.source instanceof INumberScalar) {
            d = ((INumberScalar)this.source).getDisplayUnitFactor();
        }
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d == 1.0) {
            return this.value;
        }
        this.devValue = this.value / d;
        return this.devValue;
    }

    public double getStandardValue() {
        double d = 1.0;
        double d2 = this.getDeviceValue();
        if (this.source != null && this.source instanceof INumberImage) {
            d = ((INumberImage)this.source).getStandardUnitFactor();
        }
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d == 1.0) {
            return d2;
        }
        double d3 = d2 * d;
        return d3;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public void setSource(INumberScalar iNumberScalar) {
        this.source = iNumberScalar;
        this._source = iNumberScalar;
    }

    public INumberScalar getNumberSource() {
        return this._source;
    }

    public String getVersion() {
        return "$Id: NumberScalarEvent.java,v 1.3 2006/06/29 11:19:12 poncet Exp $";
    }
}

