/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.core.AEntityFactory;
import fr.esrf.tangoatk.core.AtkEventListenerList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.DeviceProperty;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IDeviceListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.IStatusListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class Device
extends DeviceProxy
implements IDevice,
Serializable {
    private String name;
    private boolean supportsEvents;
    protected EventSupport propChanges;
    protected transient DeviceProxy proxy;
    private long refreshCount = 0L;
    private int idlVersion = 0;
    protected Map propertyMap;

    public Device(String string) throws DevFailed {
        super(string);
        this.init(string);
    }

    public Device(String string, String string2, String string3) throws DevFailed {
        super(string, string2, string3);
        this.init(string);
    }

    protected void init(String string) throws DevFailed {
        long l = System.currentTimeMillis();
        this.propertyMap = new HashMap();
        this.propChanges = new EventSupport();
        this.name = string;
        this.supportsEvents = false;
        try {
            this.idlVersion = this.get_idl_version();
            this.trace(2, "Device.get_idl_version(" + string + ") ok", l);
            if (this.idlVersion >= 3) {
                this.supportsEvents = true;
            }
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.get_idl_version(" + string + ") failed", l);
        }
    }

    public void addErrorListener(IErrorListener iErrorListener) {
        this.propChanges.addErrorListener(iErrorListener);
    }

    public void removeErrorListener(IErrorListener iErrorListener) {
        this.propChanges.removeErrorListener(iErrorListener);
    }

    public void addStatusListener(IStatusListener iStatusListener) {
        this.propChanges.addStatusListener(iStatusListener);
    }

    public void removeStatusListener(IStatusListener iStatusListener) {
        this.propChanges.removeStatusListener(iStatusListener);
    }

    public void addStateListener(IStateListener iStateListener) {
        this.propChanges.addStateListener(iStateListener);
    }

    public void removeStateListener(IStateListener iStateListener) {
        this.propChanges.removeStateListener(iStateListener);
    }

    public void addListener(IDeviceListener iDeviceListener) {
        this.propChanges.addStateListener(iDeviceListener);
        this.propChanges.addStatusListener(iDeviceListener);
    }

    public void removeListener(IDeviceListener iDeviceListener) {
        this.propChanges.removeStateListener(iDeviceListener);
        this.propChanges.removeStatusListener(iDeviceListener);
    }

    public EventSupport getPropChanges() {
        return this.propChanges;
    }

    public void refresh() {
        ++this.refreshCount;
        DevState devState = null;
        long l = System.currentTimeMillis();
        try {
            try {
                devState = this.state(false);
                this.trace(64, "Device.refresh(State," + this.name + ") success", l);
                this.propChanges.fireStateEvent(this, Device.toString(devState));
            }
            catch (DevFailed devFailed) {
                this.trace(64, "Device.refresh(State," + this.name + ") failed", l);
                ConnectionException connectionException = new ConnectionException(devFailed);
                this.deviceError("Couldn't read state: ", connectionException);
                String string = this.getName() + ":\n" + connectionException.getDescription();
                this.propChanges.fireStateEvent(this, "UNKNOWN");
                this.propChanges.fireStatusEvent(this, string);
                return;
            }
            l = System.currentTimeMillis();
            try {
                String string = this.status(false);
                this.trace(64, "Device.refresh(Status," + this.name + ") success", l);
                this.propChanges.fireStatusEvent(this, string);
            }
            catch (DevFailed devFailed) {
                this.trace(64, "Device.refresh(Status," + this.name + ") failed", l);
                ConnectionException connectionException = new ConnectionException(devFailed);
                String string = this.getName() + ":\n" + connectionException.getDescription();
                this.propChanges.fireStatusEvent(this, string);
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("-- Device.refresh() : Unexpected exception -----------------------");
            exception.printStackTrace();
            try {
                ConnectionException connectionException = new ConnectionException(exception);
                this.propChanges.fireStateEvent(this, "UNKNOWN");
                this.propChanges.fireStatusEvent(this, "UNKNOWN");
                this.deviceError("Couldn't read state: ", connectionException);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public boolean isAlive() {
        long l = System.currentTimeMillis();
        try {
            this.ping();
            this.trace(2, "Device.ping(" + this.name + ") success", l);
            return true;
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.ping(" + this.name + ") failed", l);
            return false;
        }
    }

    public CommandInfo[] getCommandList() throws DevFailed {
        CommandInfo[] commandInfoArray;
        long l = System.currentTimeMillis();
        try {
            commandInfoArray = this.command_list_query();
            this.trace(2, "Device.command_list_query(" + this.name + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.command_list_query(" + this.name + ") failed", l);
            throw devFailed;
        }
        return commandInfoArray;
    }

    public CommandInfo getCommand(String string) throws DevFailed {
        CommandInfo commandInfo;
        long l = System.currentTimeMillis();
        try {
            commandInfo = this.command_query(string);
            this.trace(2, "Device.command_query(" + this.getName() + "/" + string + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.command_query(" + this.getName() + "/" + string + ") failed", l);
            throw devFailed;
        }
        return commandInfo;
    }

    public AttributeInfo[] getAttributeInfo(String[] stringArray) throws DevFailed {
        AttributeInfo[] attributeInfoArray;
        long l = System.currentTimeMillis();
        try {
            attributeInfoArray = this.get_attribute_info(stringArray);
            this.trace(2, "Device.get_attribute_info(" + stringArray + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.get_attribute_info(" + stringArray + ") failed", l);
            throw devFailed;
        }
        return attributeInfoArray;
    }

    public AttributeInfo getAttributeInfo(String string) throws DevFailed {
        AttributeInfo attributeInfo;
        long l = System.currentTimeMillis();
        try {
            attributeInfo = this.get_attribute_info(AEntityFactory.extractEntityName(string));
            this.trace(2, "Device.get_attribute_config(" + this.getName() + "/" + string + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.get_attribute_info(" + this.getName() + "/" + string + ") failed", l);
            throw devFailed;
        }
        return attributeInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        try {
            String string = this.get_alias();
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void deviceError(String string, Throwable throwable) {
        this.propChanges.fireReadErrorEvent(this, throwable);
    }

    public String getState() {
        DevState devState = null;
        long l = System.currentTimeMillis();
        try {
            devState = this.state(false);
            this.trace(2, "Device.state(" + this.name + ") success", l);
        }
        catch (Exception exception) {
            this.trace(1, "Device.state(" + this.name + ") failed", l);
            this.deviceError("Couldn't read state: ", new ConnectionException(exception));
        }
        return Device.toString(devState);
    }

    public static String toString(DevState devState) {
        if (devState == null) {
            return "UNKNOWN";
        }
        switch (devState.value()) {
            case 0: {
                return "ON";
            }
            case 1: {
                return "OFF";
            }
            case 2: {
                return "CLOSE";
            }
            case 3: {
                return "OPEN";
            }
            case 4: {
                return "INSERT";
            }
            case 5: {
                return "EXTRACT";
            }
            case 6: {
                return "MOVING";
            }
            case 7: {
                return "STANDBY";
            }
            case 8: {
                return "FAULT";
            }
            case 9: {
                return "INIT";
            }
            case 10: {
                return "RUNNING";
            }
            case 11: {
                return "ALARM";
            }
            case 12: {
                return "DISABLE";
            }
        }
        return "UNKNOWN";
    }

    public String getStatus() {
        String string = "UNKNOWN";
        long l = System.currentTimeMillis();
        try {
            string = this.status(false);
            this.trace(2, "Device.status(" + this.name + ") success", l);
        }
        catch (Exception exception) {
            this.trace(1, "Device.status(" + this.name + ") failed", l);
            this.deviceError("Couldn't read status: ", new ConnectionException(exception));
        }
        return string;
    }

    public final DeviceAttribute readAttribute(String string) throws DevFailed {
        DeviceAttribute deviceAttribute;
        long l = System.currentTimeMillis();
        try {
            deviceAttribute = this.read_attribute(AEntityFactory.extractEntityName(string));
            this.trace(8, "Device.read_attribute(" + this.getName() + "/" + string + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(8, "Device.read_attribute(" + this.getName() + "/" + string + ") failed", l);
            throw devFailed;
        }
        return deviceAttribute;
    }

    public long getRefreshCount() {
        return this.refreshCount;
    }

    public int getIdlVersion() {
        return this.idlVersion;
    }

    public final DeviceAttribute readAttributeFromDevice(String string) throws DevFailed {
        DeviceAttribute deviceAttribute;
        long l = System.currentTimeMillis();
        this.set_source(DevSource.DEV);
        try {
            deviceAttribute = this.read_attribute(AEntityFactory.extractEntityName(string));
            this.trace(8, "Device.read_attribute_from_device(" + this.getName() + "/" + string + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(8, "Device.read_attribute_from_device(" + this.getName() + "/" + string + ") failed", l);
            this.set_source(DevSource.CACHE_DEV);
            throw devFailed;
        }
        this.set_source(DevSource.CACHE_DEV);
        return deviceAttribute;
    }

    public void writeAttribute(DeviceAttribute deviceAttribute) throws DevFailed {
        long l = System.currentTimeMillis();
        try {
            this.write_attribute(deviceAttribute);
            this.trace(8, "Device.write_attribute(" + this.name + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(8, "Device.write_attribute(" + this.name + ") failed", l);
            throw devFailed;
        }
        this.refresh();
    }

    public DeviceData executeCommand(String string, DeviceData deviceData) throws DevFailed {
        DeviceData deviceData2 = null;
        long l = System.currentTimeMillis();
        try {
            deviceData2 = this.command_inout(AEntityFactory.extractEntityName(string), deviceData);
            this.trace(16, "Device.command_inout(" + this.getName() + "/" + this.name + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(16, "Device.command_inout(" + this.getName() + "/" + this.name + ") failed", l);
            throw devFailed;
        }
        return deviceData2;
    }

    public void storeInfo(AttributeInfo attributeInfo) throws DevFailed {
        AttributeInfo[] attributeInfoArray = new AttributeInfo[]{attributeInfo};
        long l = System.currentTimeMillis();
        try {
            this.set_attribute_info(attributeInfoArray);
            this.trace(8, "Device.set_attribute_info(" + this.name + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(8, "Device.set_attribute_info(" + this.name + ") failed", l);
            throw devFailed;
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean doesEvent() {
        return this.supportsEvents;
    }

    public String getVersion() {
        return "$Id: Device.java,v 1.32 2007/03/16 09:25:39 ounsy Exp $";
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        System.out.print("Storing device " + this.name + "...");
        objectOutputStream.defaultWriteObject();
        System.out.println("Done");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading device ");
        objectInputStream.defaultReadObject();
        System.out.print(this.name + "...");
        try {
            this.proxy = new DeviceProxy(this.name);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        System.out.println("Done");
    }

    public DeviceProperty getProperty(String string) {
        if (this.propertyMap != null) {
            return (DeviceProperty)this.propertyMap.get(string);
        }
        return null;
    }

    public Map getPropertyMap() {
        return this.propertyMap;
    }

    public void storeProperty(String string) {
        DeviceProperty deviceProperty = (DeviceProperty)this.propertyMap.get(string);
        if (deviceProperty != null) {
            try {
                DbDatum dbDatum = this.get_property(deviceProperty.getName());
                dbDatum.insert(deviceProperty.getValue());
                this.put_property(dbDatum);
            }
            catch (DevFailed devFailed) {
                JOptionPane.showMessageDialog(null, "Could not update property " + deviceProperty.getName(), "Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Could not update property " + deviceProperty.getName() + " : \nThis property is not registered", "Error", 0);
        }
    }

    public void refreshPropertyMap() {
        String[] stringArray = null;
        DbDatum[] dbDatumArray = new DbDatum[]{};
        try {
            stringArray = this.get_property_list("*");
            if (stringArray != null && stringArray.length > 0 && (dbDatumArray = this.get_property(stringArray)) == null) {
                dbDatumArray = new DbDatum[]{};
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < dbDatumArray.length; ++i) {
                hashSet.add(dbDatumArray[i].name);
                Object object = (DeviceProperty)this.propertyMap.get(dbDatumArray[i].name);
                if (object == null) {
                    object = new DeviceProperty(this, dbDatumArray[i].name, dbDatumArray[i].extractStringArray());
                    this.propertyMap.put(dbDatumArray[i].name, object);
                    continue;
                }
                ((DeviceProperty)object).setValue(dbDatumArray[i].extractStringArray());
            }
            Set set = this.propertyMap.keySet();
            if (set != null) {
                for (String string : set) {
                    if (hashSet.contains(string)) continue;
                    this.propertyMap.remove(string);
                }
            }
        }
        catch (DevFailed devFailed) {
            JOptionPane.showMessageDialog(null, "Failed to update property map", "Error", 0);
        }
    }

    public int getDevTimeout() throws ConnectionException {
        long l = System.currentTimeMillis();
        try {
            int n = this.get_timeout_millis();
            this.trace(2, "Device.getDevTimeout(" + this.name + ") success", l);
            return n;
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.getDevTimeout(" + this.name + ") failed", l);
            ConnectionException connectionException = new ConnectionException(devFailed);
            this.deviceError("Couldn't read timeout value : ", connectionException);
            throw connectionException;
        }
        catch (Exception exception) {
            this.trace(1, "Device.getDevTimeout(" + this.name + ") failed", l);
            ConnectionException connectionException = new ConnectionException(exception);
            this.deviceError("Couldn't read timeout value : ", connectionException);
            throw connectionException;
        }
    }

    public synchronized void setDevTimeout(int n) throws ConnectionException {
        long l = System.currentTimeMillis();
        try {
            this.set_timeout_millis(n);
            this.trace(2, "Device.setDevTimeout(" + this.name + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(1, "Device.setDevTimeout(" + this.name + ") failed", l);
            ConnectionException connectionException = new ConnectionException(devFailed);
            this.deviceError("Couldn't set timeout value : ", connectionException);
            throw connectionException;
        }
        catch (Exception exception) {
            this.trace(1, "Device.setDevTimeout(" + this.name + ") failed", l);
            ConnectionException connectionException = new ConnectionException(exception);
            this.deviceError("Couldn't set timeout value : ", connectionException);
            throw connectionException;
        }
    }

    public AtkEventListenerList getListenerList() {
        if (this.propChanges == null) {
            return null;
        }
        return this.propChanges.getListenerList();
    }
}

