/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IEntity;
import java.io.Serializable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AEntityFactory
implements TangoConst,
Serializable {
    private DeviceFactory deviceFactory = DeviceFactory.getInstance();

    public static String extractDeviceName(String string) {
        int n = string.lastIndexOf("/");
        return string.substring(0, n);
    }

    public static String extractDeviceNameAdvanced(String string) throws DevFailed {
        int n = string.lastIndexOf("/");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n2 = stringTokenizer.countTokens();
        switch (n2) {
            case 4: {
                return string.substring(0, n);
            }
            case 3: {
                return string;
            }
            case 2: {
                String string2 = string.substring(0, n);
                Database database = ApiUtil.get_db_obj();
                try {
                    String string3 = database.get_alias_device(string2);
                    if (string3 == null || "".equals(string3) || string2.equals(string3)) {
                        return null;
                    }
                    return string3;
                }
                catch (DevFailed devFailed) {
                    return null;
                }
            }
            case 1: {
                String string4 = new String(string);
                Database database = ApiUtil.get_db_obj();
                try {
                    String string5 = database.get_alias_device(string4);
                    if (string5 == null || "".equals(string5) || string4.equals(string5)) {
                        string5 = database.get_attribute_alias(string4);
                        if (string5 == null || "".equals(string5) || string4.equals(string5)) {
                            return null;
                        }
                        n = string5.lastIndexOf("/");
                        return string5.substring(0, n);
                    }
                    return string5;
                }
                catch (DevFailed devFailed) {
                    try {
                        String string6 = database.get_attribute_alias(string4);
                        if (string6 == null || "".equals(string6) || string4.equals(string6)) {
                            return null;
                        }
                        n = string6.lastIndexOf("/");
                        return string6.substring(0, n);
                    }
                    catch (DevFailed devFailed2) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public static String getFQName(Device device, String string) {
        return new StringBuffer(device.toString()).append("/").append(string).toString();
    }

    public static String extractEntityName(String string) {
        int n = string.lastIndexOf("/");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    public static boolean isWildCard(String string) {
        return string.indexOf("*") != -1;
    }

    protected Device getDevice(String string) throws ConnectionException {
        return this.deviceFactory.getDevice(string);
    }

    public List getEntities(String string) throws ConnectionException {
        try {
            List<IEntity> list;
            Device device = this.getDevice(AEntityFactory.extractDeviceName(string));
            if (!AEntityFactory.isWildCard(string)) {
                list = new Vector<IEntity>();
                list.add(this.getSingleEntity(string, device));
            } else {
                list = this.getWildCardEntities(string, device);
            }
            return list;
        }
        catch (DevFailed devFailed) {
            throw new ConnectionException(devFailed);
        }
    }

    protected abstract List getWildCardEntities(String var1, Device var2) throws DevFailed;

    protected abstract IEntity getSingleEntity(String var1, Device var2) throws DevFailed;

    public abstract int getSize();

    public abstract String getVersion();
}

