/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.EntityAdapter;
import explorer.EntityTableModel;
import explorer.Preferences;
import explorer.Status;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.util.ArrayList;
import javax.swing.JComponent;

public class CommandTableModel
extends EntityTableModel {
    public static final String COMMAND = "Command";

    public CommandTableModel(Status status, Preferences preferences) {
        this.status = status;
        this.entities = new CommandList();
        this.adapters = new ArrayList();
        this.columnIdentifiers = new ArrayList();
        this.preferences = preferences;
    }

    protected void initColumns() {
        this.columnIdentifiers.add(EntityTableModel.DEVICE);
        this.columnIdentifiers.add(COMMAND);
        this.columnNames = new ArrayList(this.columnIdentifiers);
        this.fireTableStructureChanged();
    }

    protected StringBuffer getPreferencePrefix() {
        return new StringBuffer("CommandTable.");
    }

    public Object getValueAt(int row, int column) {
        Object o = this.adapters.get(row);
        ICommand command = ((CommandAdapter)o).getCommand();
        String header = this.getColumnName(column);
        if (EntityTableModel.DEVICE == header) {
            return this.getDeviceAlias((IDevice)command.getDevice());
        }
        if (COMMAND == header) {
            return this.getEntityAlias((IEntity)command);
        }
        return "UGLE";
    }

    protected void addCommand(String name) {
        try {
            this.load(name, null, null);
        }
        catch (ConnectionException e) {
            this.status.status("Cannot load command " + name, (Exception)((Object)e));
        }
    }

    public void load(String name, String alias, String deviceAlias) throws ConnectionException {
        ICommand command = (ICommand)this.entities.add(name);
        if (alias != null) {
            command.setAlias(alias);
        }
        this.addCommand(command);
    }

    public void addEntity(IEntity command) {
        this.entities.add(command);
        if (this.deviceList != null) {
            this.deviceList.add((IDevice)command.getDevice());
        }
        this.addCommand((ICommand)command);
    }

    public void addCommand(ICommand command) {
        if (this.exists((IEntity)command)) {
            return;
        }
        if (this.deviceList != null) {
            this.deviceList.add((IDevice)command.getDevice());
        }
        this.adapters.add(new CommandAdapter(command, this.adapters.size()));
        this.fireTableRowsInserted(this.adapters.size(), this.adapters.size());
    }

    protected boolean isExecuteColumn(int i) {
        if (i == -1) {
            return false;
        }
        return this.columnModel.getColumn(i).getHeaderValue() == COMMAND;
    }

    static {
        COMMAND = COMMAND;
    }

    class CommandAdapter
    implements IStateListener,
    EntityAdapter {
        int row;
        ICommand command;

        public IEntity getEntity() {
            return this.command;
        }

        public void reloadProperties() {
            CommandTableModel.this.fireTableRowsUpdated(this.row, this.row);
        }

        public CommandAdapter(ICommand command, int row) {
            this.row = row;
            this.command = command;
            command.getDevice().addStateListener((IStateListener)this);
        }

        public void errorChange(ErrorEvent evt) {
        }

        public void stateChange(StateEvent evt) {
            JComponent r = CommandTableModel.this.getDeviceRenderer(CommandTableModel.this.getDeviceAlias((IDevice)this.command.getDevice()));
            if (r == null) {
                return;
            }
            r.setBackground(ATKConstant.getColor4State((String)evt.getState()));
            r.setToolTipText(evt.getState());
            CommandTableModel.this.fireTableRowsUpdated(this.row, this.row);
        }

        public ICommand getCommand() {
            return this.command;
        }

        public void remove() {
            this.command.getDevice().removeStateListener((IStateListener)this);
        }
    }
}

