/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import com.braju.format.Format;
import explorer.AttributePanel;
import explorer.BooleanViewer;
import explorer.EntityAdapter;
import explorer.EntityTableModel;
import explorer.Preferences;
import explorer.Status;
import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.NumberImageEvent;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.core.StatusEvent;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class AttributeTableModel
extends EntityTableModel {
    public static final String LABEL = "Label";
    public static final String VALUE = "Value";
    public static final String DISP_UNIT = "Disp. Unit";
    public static final String MIN_VAL = "Min value";
    public static final String MAX_VAL = "Max value";
    public static final String MIN_ALARM = "Min alarm";
    public static final String MAX_ALARM = "Max alarm";
    public static final String UNIT = "Unit";
    public static final String DATA_FORMAT = "Data format";
    public static final String DATA_TYPE = "Data type";
    public static final String DESCRIPTION = "Description";
    public static final String WRITABLE = "Writable";
    public static final String WRITABLE_NAME = "Writable name";
    public static final String MAX_Y = "Max dim y";
    public static final String MAX_X = "Max dim x";
    public static final String STD_UNIT = "Standar unit";
    public static final String SET = "Set";
    protected AttributePanel panel;
    protected AttributePolledList entitiesToRefresh;

    public AttributeTableModel(Status status, Preferences preferences) {
        this.status = status;
        this.entities = new AttributePolledList();
        this.entitiesToRefresh = new AttributePolledList();
        this.adapters = new ArrayList();
        this.columnIdentifiers = new ArrayList();
        this.preferences = preferences;
        this.setRefreshInterval(preferences.getInt("refreshInterval", 1000));
    }

    protected void initColumns() {
        this.columnIdentifiers.add(EntityTableModel.DEVICE);
        this.columnIdentifiers.add(EntityTableModel.NAME);
        this.columnIdentifiers.add(LABEL);
        this.columnIdentifiers.add(VALUE);
        this.columnIdentifiers.add(DISP_UNIT);
        this.columnIdentifiers.add(DESCRIPTION);
        this.columnIdentifiers.add(UNIT);
        this.columnIdentifiers.add(WRITABLE);
        this.columnIdentifiers.add(SET);
        this.columnNames = new ArrayList(this.columnIdentifiers);
        this.columnNames.add(MIN_ALARM);
        this.columnNames.add(MAX_ALARM);
        this.columnNames.add(DATA_FORMAT);
        this.columnNames.add(DATA_TYPE);
        this.columnNames.add(MIN_VAL);
        this.columnNames.add(MAX_VAL);
        this.columnNames.add(WRITABLE_NAME);
        this.columnNames.add(MAX_X);
        this.columnNames.add(MAX_Y);
        this.columnNames.add(EntityTableModel.LEVEL);
        this.columnNames.add(STD_UNIT);
        this.fireTableStructureChanged();
    }

    protected StringBuffer getPreferencePrefix() {
        return new StringBuffer("AttributeTable.");
    }

    public Object getValueAt(int row, int column) {
        Object o = this.adapters.get(row);
        AttributeAdapter adapter = (AttributeAdapter)o;
        IAttribute attribute = adapter.getAttribute();
        String header = this.getColumnName(column);
        if (EntityTableModel.DEVICE.equals(header)) {
            return this.getDeviceAlias((IDevice)attribute.getDevice());
        }
        if (EntityTableModel.NAME.equals(header)) {
            return this.getEntityAlias((IEntity)attribute);
        }
        if (LABEL.equals(header)) {
            return attribute.getLabel();
        }
        if (VALUE.equals(header)) {
            if (attribute instanceof IBooleanScalar) {
                return attribute;
            }
            return adapter;
        }
        if (DISP_UNIT.equals(header)) {
            return attribute.getDisplayUnit();
        }
        if (MIN_VAL.equals(header)) {
            if (attribute instanceof INumberScalar) {
                return new Double(((INumberScalar)attribute).getMinValue());
            }
            return new Double(Double.NaN);
        }
        if (MAX_VAL.equals(header)) {
            if (attribute instanceof INumberScalar) {
                return new Double(((INumberScalar)attribute).getMaxValue());
            }
            return new Double(Double.NaN);
        }
        if (MIN_ALARM.equals(header)) {
            if (attribute instanceof INumberScalar) {
                return new Double(((INumberScalar)attribute).getMinAlarm());
            }
            return new Double(Double.NaN);
        }
        if (MAX_ALARM.equals(header)) {
            if (attribute instanceof INumberScalar) {
                return new Double(((INumberScalar)attribute).getMinAlarm());
            }
            return new Double(Double.NaN);
        }
        if (UNIT.equals(header)) {
            return attribute.getUnit();
        }
        if (DATA_FORMAT.equals(header)) {
            return adapter.getDataFormat();
        }
        if (DATA_TYPE.equals(header)) {
            return adapter.getDataType();
        }
        if (DESCRIPTION.equals(header)) {
            return attribute.getDescription();
        }
        if (WRITABLE.equals(header)) {
            return adapter.getWritable();
        }
        if (WRITABLE_NAME.equals(header)) {
            return adapter.getWritableName();
        }
        if (MAX_X.equals(header)) {
            return new Integer(attribute.getMaxXDimension());
        }
        if (MAX_Y.equals(header)) {
            return new Integer(attribute.getMaxYDimension());
        }
        if (EntityTableModel.LEVEL.equals(header)) {
            return adapter.getLevel();
        }
        if (SET.equals(header)) {
            if (attribute instanceof IBooleanScalar) {
                boolean val = ((IBooleanScalar)attribute).getValue();
                return val ? "Set FALSE" : "Set TRUE";
            }
            return SET;
        }
        return null;
    }

    public void load(String name, String alias, String deviceAlias) throws ConnectionException {
        IAttribute attribute = (IAttribute)this.entities.add(name);
        if (this.deviceList != null) {
            this.deviceList.add((IDevice)attribute.getDevice());
        }
        this.addAttribute(attribute);
    }

    public void addEntity(IEntity attribute) {
        try {
            this.load(attribute.getName(), null, null);
        }
        catch (ConnectionException e) {
            this.status.status("AttributeTableModel.addEntity: Cannot load attribute " + attribute.getName(), (Exception)((Object)e));
        }
    }

    public void removeEntityAt(int row) {
        IEntity attribute = null;
        try {
            attribute = this.getEntityAt(row);
        }
        catch (Exception e) {
            return;
        }
        this.panel.removeAttribute(attribute);
        if (this.deviceList != null) {
            this.deviceList.remove(attribute.getDevice());
        }
        ((EntityAdapter)this.adapters.get(row)).remove();
        this.adapters.remove(row);
        this.entitiesToRefresh.remove(attribute.getName());
        this.fireTableRowsDeleted(row, row);
    }

    public void clear() {
        this.entitiesToRefresh.clear();
        super.clear();
    }

    public void addToRefresher(IAttribute attribute) {
        this.removeFromRefresher(attribute);
        this.entitiesToRefresh.add((IEntity)attribute);
    }

    public void removeFromRefresher(IAttribute attribute) {
        while (this.entitiesToRefresh.remove(attribute.getName())) {
        }
    }

    public void addAttribute(IAttribute attribute) {
        if (this.exists((IEntity)attribute)) {
            return;
        }
        this.addToRefresher(attribute);
        this.panel.addEntity((IEntity)attribute);
        this.adapters.add(new AttributeAdapter(attribute, this.adapters.size()));
        this.fireTableRowsInserted(this.adapters.size() - 1, this.adapters.size() - 1);
    }

    protected void addNumberScalar(String name) {
        try {
            INumberScalar scalar = (INumberScalar)this.entities.add(name);
            this.addAttribute((IAttribute)scalar);
        }
        catch (ConnectionException e) {
            this.status.status("AttributeTableModel.addNumberScalar: Cannot load attribute " + name, (Exception)((Object)e));
        }
    }

    protected void addStringScalar(String name) {
        try {
            IStringScalar scalar = (IStringScalar)this.entities.add(name);
            this.addAttribute((IAttribute)scalar);
        }
        catch (ConnectionException e) {
            this.status.status("AttributeTableModel.addStringScalar: Cannot load attribute " + name, (Exception)((Object)e));
        }
    }

    protected void addNumberSpectrum(String name) {
        try {
            INumberSpectrum spectrum = (INumberSpectrum)this.entities.add(name);
            this.addAttribute((IAttribute)spectrum);
        }
        catch (ConnectionException e) {
            this.status.status("AttributeTableModel.addNumberSpectrum: Cannot load attribute " + name, (Exception)((Object)e));
        }
    }

    protected void addNumberImage(String name) {
        try {
            INumberImage image = (INumberImage)this.entities.add(name);
            this.addAttribute((IAttribute)image);
        }
        catch (ConnectionException e) {
            this.status.status("AttributeTableModel.addNumberImage: Cannot load attribute " + name, (Exception)((Object)e));
        }
    }

    protected boolean isExecuteColumn(int i) {
        return SET.equals(this.columnModel.getColumn(i).getHeaderValue());
    }

    public void refresh() {
        if (!this.entitiesToRefresh.isRefresherStarted()) {
            this.entitiesToRefresh.refresh();
            if (this.deviceList != null) {
                this.deviceList.refresh();
            }
        }
    }

    public boolean isRefresherStarted() {
        return this.entitiesToRefresh.isRefresherStarted();
    }

    public void setRefreshInterval(int milliseconds) {
        this.preferences.putInt("refreshInterval", milliseconds);
        this.entitiesToRefresh.setRefreshInterval(milliseconds);
        if (this.deviceList != null) {
            this.deviceList.setRefreshInterval(milliseconds);
        }
    }

    public int getRefreshInterval() {
        return this.entitiesToRefresh.getRefreshInterval();
    }

    public void startRefresher() {
        if (!this.refresherStarted) {
            this.entitiesToRefresh.startRefresher();
            this.refresherStarted = true;
        }
        if (this.deviceList != null) {
            this.deviceList.start();
        }
    }

    public void stopRefresher() {
        this.refresherStarted = false;
        this.entitiesToRefresh.stopRefresher();
        if (this.deviceList != null) {
            this.deviceList.stop();
        }
    }

    public void setSynchronizedPeriod(boolean synchro) {
        this.entitiesToRefresh.setSynchronizedPeriod(synchro);
    }

    public AttributePanel getPanel() {
        return this.panel;
    }

    public void setPanel(AttributePanel panel) {
        this.panel = panel;
    }

    static {
        LABEL = LABEL;
        VALUE = VALUE;
        DISP_UNIT = DISP_UNIT;
        MIN_VAL = MIN_VAL;
        MAX_VAL = MAX_VAL;
        MIN_ALARM = MIN_ALARM;
        MAX_ALARM = MAX_ALARM;
        UNIT = UNIT;
        DATA_FORMAT = DATA_FORMAT;
        DATA_TYPE = DATA_TYPE;
        DESCRIPTION = DESCRIPTION;
        WRITABLE = WRITABLE;
        WRITABLE_NAME = WRITABLE_NAME;
        MAX_Y = MAX_Y;
        MAX_X = MAX_X;
        STD_UNIT = STD_UNIT;
        SET = SET;
    }

    class AttributeAdapter
    implements IStringScalarListener,
    INumberScalarListener,
    ISpectrumListener,
    IImageListener,
    IStateListener,
    EntityAdapter,
    IBooleanScalarListener {
        int row;
        IAttribute attribute;
        String last = "See tab";
        String format = "";
        double doubleVal;
        boolean boolVal;

        public IEntity getEntity() {
            return this.attribute;
        }

        public void reloadProperties() {
            AttributeTableModel.this.fireTableRowsUpdated(this.row, this.row);
        }

        public AttributeAdapter(IAttribute attribute, int row) {
            this.row = row;
            this.attribute = attribute;
            attribute.getDevice().addStateListener((IStateListener)this);
            if (attribute instanceof INumberScalar) {
                this.last = "----";
                ((INumberScalar)attribute).addNumberScalarListener((INumberScalarListener)this);
                this.format = attribute.getFormat();
            }
            if (attribute instanceof IStringScalar) {
                this.last = "----";
                ((IStringScalar)attribute).addStringScalarListener((IStringScalarListener)this);
            }
            if (attribute instanceof IBooleanScalar) {
                this.last = "----";
                ((IBooleanScalar)attribute).addBooleanScalarListener((IBooleanScalarListener)this);
            }
            if (attribute instanceof INumberSpectrum) {
                ((INumberSpectrum)attribute).addSpectrumListener((ISpectrumListener)this);
            }
            if (attribute instanceof INumberImage) {
                ((INumberImage)attribute).addImageListener((IImageListener)this);
            }
        }

        public void remove() {
            this.attribute.getDevice().removeStateListener((IStateListener)this);
            if (this.attribute instanceof INumberScalar) {
                ((INumberScalar)this.attribute).removeNumberScalarListener((INumberScalarListener)this);
            } else if (this.attribute instanceof IStringScalar) {
                ((IStringScalar)this.attribute).removeStringScalarListener((IStringScalarListener)this);
            } else if (this.attribute instanceof IBooleanScalar) {
                ((IBooleanScalar)this.attribute).removeBooleanScalarListener((IBooleanScalarListener)this);
            } else if (this.attribute instanceof INumberSpectrum) {
                ((INumberSpectrum)this.attribute).removeSpectrumListener((ISpectrumListener)this);
            } else if (this.attribute instanceof INumberImage) {
                ((INumberImage)this.attribute).removeImageListener((IImageListener)this);
            }
        }

        public void statusChange(StatusEvent evt) {
        }

        public void stateChange(StateEvent evt) {
            JComponent r = AttributeTableModel.this.getDeviceRenderer(AttributeTableModel.this.getDeviceAlias((IDevice)this.attribute.getDevice()));
            if (r == null) {
                return;
            }
            r.setBackground(ATKConstant.getColor4State((String)evt.getState()));
            r.setToolTipText(evt.getState());
            AttributeTableModel.this.fireTableRowsUpdated(this.row, this.row);
        }

        JComponent getValueRenderer() {
            if (this.attribute instanceof IBooleanScalar) {
                return AttributeTableModel.this.getRenderer(this.attribute, AttributeTableModel.VALUE);
            }
            return AttributeTableModel.this.getRenderer(this, AttributeTableModel.VALUE);
        }

        public void errorChange(ErrorEvent evt) {
        }

        public void stateChange(AttributeStateEvent evt) {
            JComponent r = this.getValueRenderer();
            if (r == null) {
                return;
            }
            r.setToolTipText(evt.getState());
            r.setBackground(ATKConstant.getColor4Quality((String)evt.getState()));
            AttributeTableModel.this.fireTableRowsUpdated(this.row, this.row);
        }

        public void stringScalarChange(StringScalarEvent evt) {
            this.last = evt.getValue();
            this.updateRenderer();
        }

        public void numberScalarChange(NumberScalarEvent evt) {
            this.doubleVal = evt.getValue();
            this.last = Double.toString(this.doubleVal);
            this.updateRenderer();
        }

        public void booleanScalarChange(BooleanScalarEvent evt) {
            this.boolVal = evt.getValue();
            this.last = this.boolVal ? "true" : "false";
            this.updateRenderer();
        }

        void updateRenderer() {
            JComponent r = this.getValueRenderer();
            if (r == null) {
                return;
            }
            if (r instanceof BooleanViewer) {
                ((BooleanViewer)r).setText(this.getLastValue());
            } else {
                ((JLabel)r).setText(this.getLastValue());
            }
            AttributeTableModel.this.fireTableRowsUpdated(this.row, this.row);
        }

        public void spectrumChange(NumberSpectrumEvent evt) {
        }

        public void imageChange(NumberImageEvent evt) {
        }

        public IAttribute getAttribute() {
            return this.attribute;
        }

        public String getLastValue() {
            if (this.format.equals("No format") || this.format == "") {
                return this.last;
            }
            if (this.format.indexOf(37) == -1) {
                return AttrManip.format((String)this.format, (double)this.doubleVal);
            }
            Object[] o = new Object[]{new Double(this.doubleVal)};
            return Format.sprintf((String)this.format, (Object[])o);
        }

        public String toString() {
            return this.getLastValue();
        }

        public String getLevel() {
            return ((Property)this.attribute.getPropertyMap().get("level")).getPresentation();
        }

        public String getDataFormat() {
            return ((Property)this.attribute.getPropertyMap().get("data_format")).getPresentation();
        }

        public String getDataType() {
            return ((Property)this.attribute.getPropertyMap().get("data_type")).getPresentation();
        }

        public String getWritable() {
            return ((Property)this.attribute.getPropertyMap().get("writable")).getPresentation();
        }

        public String getWritableName() {
            return ((Property)this.attribute.getPropertyMap().get("writable_attr_name")).getPresentation();
        }
    }
}

