
static const char *RcsId = "$Header: /cvsroot/tango-cs/tango/cppserver/TangoTest/TangoTestClass.cpp,v 1.8 2006/03/20 15:21:51 jensmeyer Exp $";

static const char *TagName = "$Name:  $";

static const char *FileName= "$Source: /cvsroot/tango-cs/tango/cppserver/TangoTest/TangoTestClass.cpp,v $"; 

static const char *HttpServer= "http://controle/DeviceServer/doc/";

static const char *RCSfile = "$RCSfile: TangoTestClass.cpp,v $"; 

//+=============================================================================
//
// file :        TangoTestClass.cpp
//
// description : C++ source for the TangoTestClass. A singleton
//               class derived from DeviceClass. It implements the
//               command list and all properties and methods required
//               by the TangoTest once per process.
//
// project :     TANGO Device Server
//
// $Author: jensmeyer $
//
// $Revision: 1.8 $
//
// $Log: TangoTestClass.cpp,v $
// Revision 1.8  2006/03/20 15:21:51  jensmeyer
// Added some castings for porting to VC8
//
// Revision 1.7  2006/02/08 16:14:28  nleclercq
// Minor modifs in RW spectrum and image attributes
//
//
// copyleft :     Synchrotron SOLEIL
//                L'Orme des Merisiers
//                Saint-Aubin - BP 48
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================


#include <tango.h>

#include <TangoTest.h>
#include <TangoTestClass.h>


namespace TangoTest_ns
{

//+----------------------------------------------------------------------------
//
// method : 		DevVoidCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVoidCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVoidCmd::execute(): arrived" << endl;

	((static_cast<TangoTest *>(device))->dev_void());
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		DevBooleanCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevBooleanCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevBooleanCmd::execute(): arrived" << endl;

	Tango::DevBoolean	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_boolean(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevShortCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevShortCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevShortCmd::execute(): arrived" << endl;

	Tango::DevShort	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_short(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevUShortCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevUShortCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevUShortCmd::execute(): arrived" << endl;

	Tango::DevUShort	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_ushort(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevLongCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevLongCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevLongCmd::execute(): arrived" << endl;

	Tango::DevLong	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_long(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevULongCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevULongCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevULongCmd::execute(): arrived" << endl;

	Tango::DevULong	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_ulong(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevFloatCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevFloatCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevFloatCmd::execute(): arrived" << endl;

	Tango::DevFloat	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_float(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevDoubleCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevDoubleCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevDoubleCmd::execute(): arrived" << endl;

	Tango::DevDouble	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_double(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevStringCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevStringCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevStringCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_string(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarCharArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarCharArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarCharArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarCharArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_char_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarShortArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarShortArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarShortArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarShortArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_short_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarUShortArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarUShortArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarUShortArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarUShortArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_ushort_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarLongArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarLongArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarLongArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarLongArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_long_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarULongArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarULongArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarULongArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarULongArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_ulong_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarFloatArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarFloatArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarFloatArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarFloatArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_float_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarDoubleArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarDoubleArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarDoubleArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarDoubleArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_double_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarStringArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarStringArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarStringArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_string_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarLongStringArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarLongStringArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarLongStringArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarLongStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_long_string_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarDoubleStringArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarDoubleStringArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarDoubleStringArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarDoubleStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_double_string_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		SwitchStatesClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *SwitchStatesClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "SwitchStatesClass::execute(): arrived" << endl;

	((static_cast<TangoTest *>(device))->switch_states());
	return new CORBA::Any();
}

//
//----------------------------------------------------------------
//	Initialize pointer for singleton pattern
//----------------------------------------------------------------
//
TangoTestClass *TangoTestClass::_instance = NULL;

//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::TangoTestClass(string &s)
// 
// description : 	constructor for the TangoTestClass
//
// in : - s : The class name
//
//-----------------------------------------------------------------------------
TangoTestClass::TangoTestClass(string &s):DeviceClass(s)
{

	cout2 << "Entering TangoTestClass constructor" << endl;
	get_class_property();
	//set_default_property();
	write_class_property();
	
	cout2 << "Leaving TangoTestClass constructor" << endl;

}
//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::~TangoTestClass()
// 
// description : 	destructor for the TangoTestClass
//
//-----------------------------------------------------------------------------
TangoTestClass::~TangoTestClass()
{
	_instance = NULL;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::instance
// 
// description : 	Create the object if not already done. Otherwise, just
//			return a pointer to the object
//
// in : - name : The class name
//
//-----------------------------------------------------------------------------
TangoTestClass *TangoTestClass::init(const char *name)
{
	if (_instance == NULL)
	{
		try
		{
			string s(name);
			_instance = new TangoTestClass(s);
		}
		catch (bad_alloc)
		{
			throw;
		}		
	}		
	return _instance;
}

TangoTestClass *TangoTestClass::instance()
{
	if (_instance == NULL)
	{
		cerr << "Class is not initialised !!" << endl;
		exit(-1);
	}
	return _instance;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::command_factory
// 
// description : 	Create the command object(s) and store them in the 
//			command list
//
//-----------------------------------------------------------------------------
void TangoTestClass::command_factory()
{
	command_list.push_back(new DevVoidCmd("DevVoid",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"N/A",
		"N/A",
		Tango::OPERATOR));
	command_list.push_back(new DevBooleanCmd("DevBoolean",
		Tango::DEV_BOOLEAN, Tango::DEV_BOOLEAN,
		"Any boolean value",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevShortCmd("DevShort",
		Tango::DEV_SHORT, Tango::DEV_SHORT,
		"Any DevShort value",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevUShortCmd("DevUShort",
		Tango::DEV_USHORT, Tango::DEV_USHORT,
		"Any DevUShort value",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevLongCmd("DevLong",
		Tango::DEV_LONG, Tango::DEV_LONG,
		"Any DevLong value",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevULongCmd("DevULong",
		Tango::DEV_ULONG, Tango::DEV_ULONG,
		"Any DevULong",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevFloatCmd("DevFloat",
		Tango::DEV_FLOAT, Tango::DEV_FLOAT,
		"Any DevFloat value",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevDoubleCmd("DevDouble",
		Tango::DEV_DOUBLE, Tango::DEV_DOUBLE,
		"Any DevDouble value",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevStringCmd("DevString",
		Tango::DEV_STRING, Tango::DEV_STRING,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarCharArrayCmd("DevVarCharArray",
		Tango::DEVVAR_CHARARRAY, Tango::DEVVAR_CHARARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarShortArrayCmd("DevVarShortArray",
		Tango::DEVVAR_SHORTARRAY, Tango::DEVVAR_SHORTARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarUShortArrayCmd("DevVarUShortArray",
		Tango::DEVVAR_USHORTARRAY, Tango::DEVVAR_USHORTARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarLongArrayCmd("DevVarLongArray",
		Tango::DEVVAR_LONGARRAY, Tango::DEVVAR_LONGARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarULongArrayCmd("DevVarULongArray",
		Tango::DEVVAR_ULONGARRAY, Tango::DEVVAR_ULONGARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarFloatArrayCmd("DevVarFloatArray",
		Tango::DEVVAR_FLOATARRAY, Tango::DEVVAR_FLOATARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarDoubleArrayCmd("DevVarDoubleArray",
		Tango::DEVVAR_DOUBLEARRAY, Tango::DEVVAR_DOUBLEARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarStringArrayCmd("DevVarStringArray",
		Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarLongStringArrayCmd("DevVarLongStringArray",
		Tango::DEVVAR_LONGSTRINGARRAY, Tango::DEVVAR_LONGSTRINGARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarDoubleStringArrayCmd("DevVarDoubleStringArray",
		Tango::DEVVAR_DOUBLESTRINGARRAY, Tango::DEVVAR_DOUBLESTRINGARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new SwitchStatesClass("SwitchStates",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::OPERATOR));

	//	add polling if any
	for (unsigned int i=0 ; i<command_list.size(); i++)
	{
	}
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::get_class_property
// 
// description : 	Get the class property for specified name.
//
// in :		string	name : The property name
//
//+----------------------------------------------------------------------------
Tango::DbDatum TangoTestClass::get_class_property(string &prop_name)
{
	for (unsigned int i=0 ; i<cl_prop.size() ; i++)
		if (cl_prop[i].name == prop_name)
			return cl_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::get_default_device_property()
// 
// description : 	Return the default value for device property.
//
//-----------------------------------------------------------------------------
Tango::DbDatum TangoTestClass::get_default_device_property(string &prop_name)
{
	for (unsigned int i=0 ; i<dev_def_prop.size() ; i++)
		if (dev_def_prop[i].name == prop_name)
			return dev_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::get_default_class_property()
// 
// description : 	Return the default value for class property.
//
//-----------------------------------------------------------------------------
Tango::DbDatum TangoTestClass::get_default_class_property(string &prop_name)
{
	for (unsigned int i=0 ; i<cl_def_prop.size() ; i++)
		if (cl_def_prop[i].name == prop_name)
			return cl_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::device_factory
// 
// description : 	Create the device object(s) and store them in the 
//			device list
//
// in :		Tango::DevVarStringArray *devlist_ptr : The device name list
//
//-----------------------------------------------------------------------------
void TangoTestClass::device_factory(const Tango::DevVarStringArray *devlist_ptr)
{

	//	Create all devices.(Automatic code generation)
	//-------------------------------------------------------------
	for (unsigned long i=0 ; i < devlist_ptr->length() ; i++)
	{
		cout4 << "Device name : " << (*devlist_ptr)[i].in() << endl;
						
		// Create devices and add it into the device list
		//----------------------------------------------------
		device_list.push_back(new TangoTest(this, (*devlist_ptr)[i]));							 

		// Export device to the outside world
		// Check before if database used.
		//---------------------------------------------
		if ((Tango::Util::_UseDb == true) && (Tango::Util::_FileDb == false))
			export_device(device_list.back());
		else
			export_device(device_list.back(), (*devlist_ptr)[i]);
	}
	//	End of Automatic code generation
	//-------------------------------------------------------------

}
//+----------------------------------------------------------------------------
//	Method: TangoTestClass::attribute_factory(vector<Tango::Attr *> &att_list)
//-----------------------------------------------------------------------------
void TangoTestClass::attribute_factory(vector<Tango::Attr *> &att_list)
{
	//	Attribute : short_scalar_ro
	short_scalar_roAttrib	*short_scalar_ro = new short_scalar_roAttrib();
	att_list.push_back(short_scalar_ro);

	//	Attribute : short_scalar
	short_scalarAttrib	*short_scalar = new short_scalarAttrib();
	att_list.push_back(short_scalar);

	//	Attribute : short_scalar_w
	short_scalar_wAttrib	*short_scalar_w = new short_scalar_wAttrib();
	att_list.push_back(short_scalar_w);

	//	Attribute : short_scalar_rww
	short_scalar_rwwAttrib	*short_scalar_rww = new short_scalar_rwwAttrib();
	att_list.push_back(short_scalar_rww);

	//	Attribute : long_scalar
	long_scalarAttrib	*long_scalar = new long_scalarAttrib();
	att_list.push_back(long_scalar);

	//	Attribute : long_scalar_w
	long_scalar_wAttrib	*long_scalar_w = new long_scalar_wAttrib();
	att_list.push_back(long_scalar_w);

	//	Attribute : long_scalar_rww
	long_scalar_rwwAttrib	*long_scalar_rww = new long_scalar_rwwAttrib();
	att_list.push_back(long_scalar_rww);

	//	Attribute : double_scalar
	double_scalarAttrib	*double_scalar = new double_scalarAttrib();
	att_list.push_back(double_scalar);

	//	Attribute : double_scalar_w
	double_scalar_wAttrib	*double_scalar_w = new double_scalar_wAttrib();
	att_list.push_back(double_scalar_w);

	//	Attribute : double_scalar_rww
	double_scalar_rwwAttrib	*double_scalar_rww = new double_scalar_rwwAttrib();
	att_list.push_back(double_scalar_rww);

	//	Attribute : string_scalar
	string_scalarAttrib	*string_scalar = new string_scalarAttrib();
	att_list.push_back(string_scalar);

	//	Attribute : boolean_scalar
	boolean_scalarAttrib	*boolean_scalar = new boolean_scalarAttrib();
	Tango::UserDefaultAttrProp	boolean_scalar_prop;
	boolean_scalar_prop.set_label("boolean_scalar");
	boolean_scalar_prop.set_description("A boolean scalar attribute");
	boolean_scalar->set_default_properties(boolean_scalar_prop);
	att_list.push_back(boolean_scalar);

	//	Attribute : float_scalar
	float_scalarAttrib	*float_scalar = new float_scalarAttrib();
	Tango::UserDefaultAttrProp	float_scalar_prop;
	float_scalar_prop.set_label("float_scalar");
	float_scalar_prop.set_description("A float attribute");
	float_scalar->set_default_properties(float_scalar_prop);
	att_list.push_back(float_scalar);

	//	Attribute : uchar_scalar
	uchar_scalarAttrib	*uchar_scalar = new uchar_scalarAttrib();
	Tango::UserDefaultAttrProp	uchar_scalar_prop;
	uchar_scalar_prop.set_label("uchar_scalar");
	uchar_scalar->set_default_properties(uchar_scalar_prop);
	att_list.push_back(uchar_scalar);

	//	Attribute : ushort_scalar
	ushort_scalarAttrib	*ushort_scalar = new ushort_scalarAttrib();
	Tango::UserDefaultAttrProp	ushort_scalar_prop;
	ushort_scalar_prop.set_label("ushort_scalar");
	ushort_scalar->set_default_properties(ushort_scalar_prop);
	att_list.push_back(ushort_scalar);

	//	Attribute : short_spectrum
	short_spectrumAttrib	*short_spectrum = new short_spectrumAttrib();
	att_list.push_back(short_spectrum);

	//	Attribute : long_spectrum
	long_spectrumAttrib	*long_spectrum = new long_spectrumAttrib();
	att_list.push_back(long_spectrum);

	//	Attribute : double_spectrum
	double_spectrumAttrib	*double_spectrum = new double_spectrumAttrib();
	att_list.push_back(double_spectrum);

	//	Attribute : boolean_spectrum
	boolean_spectrumAttrib	*boolean_spectrum = new boolean_spectrumAttrib();
	Tango::UserDefaultAttrProp	boolean_spectrum_prop;
	boolean_spectrum_prop.set_label("boolean_spectrum");
	boolean_spectrum->set_default_properties(boolean_spectrum_prop);
	att_list.push_back(boolean_spectrum);

	//	Attribute : uchar_spectrum
	uchar_spectrumAttrib	*uchar_spectrum = new uchar_spectrumAttrib();
	Tango::UserDefaultAttrProp	uchar_spectrum_prop;
	uchar_spectrum_prop.set_label("uchar_spectrum");
	uchar_spectrum_prop.set_max_value("255");
	uchar_spectrum_prop.set_min_value("0");
	uchar_spectrum_prop.set_description("An unsigned char spectrum attribute");
	uchar_spectrum->set_default_properties(uchar_spectrum_prop);
	att_list.push_back(uchar_spectrum);

	//	Attribute : ushort_spectrum
	ushort_spectrumAttrib	*ushort_spectrum = new ushort_spectrumAttrib();
	Tango::UserDefaultAttrProp	ushort_spectrum_prop;
	ushort_spectrum_prop.set_label("ushort_spectrum");
	ushort_spectrum_prop.set_description("An unsigned short spectrum attribute");
	ushort_spectrum->set_default_properties(ushort_spectrum_prop);
	att_list.push_back(ushort_spectrum);

	//	Attribute : float_spectrum
	float_spectrumAttrib	*float_spectrum = new float_spectrumAttrib();
	Tango::UserDefaultAttrProp	float_spectrum_prop;
	float_spectrum_prop.set_label("float_spectrum");
	float_spectrum_prop.set_description("A float spectrum attribute");
	float_spectrum->set_default_properties(float_spectrum_prop);
	att_list.push_back(float_spectrum);

	//	Attribute : uchar_image_ro
	uchar_image_roAttrib	*uchar_image_ro = new uchar_image_roAttrib();
	Tango::UserDefaultAttrProp	uchar_image_ro_prop;
	uchar_image_ro_prop.set_label("uchar_image");
	uchar_image_ro_prop.set_max_value("255");
	uchar_image_ro_prop.set_min_value("0");
	uchar_image_ro_prop.set_description("An unsigned char image attribute");
	uchar_image_ro->set_default_properties(uchar_image_ro_prop);
	att_list.push_back(uchar_image_ro);

	//	Attribute : ushort_image_ro
	ushort_image_roAttrib	*ushort_image_ro = new ushort_image_roAttrib();
	Tango::UserDefaultAttrProp	ushort_image_ro_prop;
	ushort_image_ro_prop.set_label("ushort_image");
	ushort_image_ro_prop.set_max_value("255");
	ushort_image_ro_prop.set_min_value("0");
	ushort_image_ro_prop.set_description("An unsigned short image attribute");
	ushort_image_ro->set_default_properties(ushort_image_ro_prop);
	att_list.push_back(ushort_image_ro);

	//	Attribute : float_image_ro
	float_image_roAttrib	*float_image_ro = new float_image_roAttrib();
	Tango::UserDefaultAttrProp	float_image_ro_prop;
	float_image_ro_prop.set_label("float_image");
	float_image_ro_prop.set_max_value("255");
	float_image_ro_prop.set_min_value("0");
	float_image_ro_prop.set_description("A float image attribute");
	float_image_ro->set_default_properties(float_image_ro_prop);
	att_list.push_back(float_image_ro);

	//	Attribute : short_image_ro
	short_image_roAttrib	*short_image_ro = new short_image_roAttrib();
	att_list.push_back(short_image_ro);

	//	Attribute : long_image_ro
	long_image_roAttrib	*long_image_ro = new long_image_roAttrib();
	att_list.push_back(long_image_ro);

	//	Attribute : double_image_ro
	double_image_roAttrib	*double_image_ro = new double_image_roAttrib();
	att_list.push_back(double_image_ro);

	//	Attribute : boolean_image_ro
	boolean_image_roAttrib	*boolean_image_ro = new boolean_image_roAttrib();
	Tango::UserDefaultAttrProp	boolean_image_ro_prop;
	boolean_image_ro_prop.set_label("boolean_image");
	boolean_image_ro_prop.set_max_value("1");
	boolean_image_ro_prop.set_min_value("0");
	boolean_image_ro->set_default_properties(boolean_image_ro_prop);
	att_list.push_back(boolean_image_ro);

	//	Attribute : ampli
	ampliAttrib	*ampli = new ampliAttrib();
	att_list.push_back(ampli);

	//	Attribute : wave
	waveAttrib	*wave = new waveAttrib();
	att_list.push_back(wave);

	//	Attribute : short_spectrum_ro
	short_spectrum_roAttrib	*short_spectrum_ro = new short_spectrum_roAttrib();
	att_list.push_back(short_spectrum_ro);

	//	Attribute : float_spectrum_ro
	float_spectrum_roAttrib	*float_spectrum_ro = new float_spectrum_roAttrib();
	att_list.push_back(float_spectrum_ro);

	//	Attribute : long_spectrum_ro
	long_spectrum_roAttrib	*long_spectrum_ro = new long_spectrum_roAttrib();
	att_list.push_back(long_spectrum_ro);

	//	Attribute : double_spectrum_ro
	double_spectrum_roAttrib	*double_spectrum_ro = new double_spectrum_roAttrib();
	att_list.push_back(double_spectrum_ro);

	//	Attribute : boolean_spectrum_ro
	boolean_spectrum_roAttrib	*boolean_spectrum_ro = new boolean_spectrum_roAttrib();
	att_list.push_back(boolean_spectrum_ro);

	//	Attribute : uchar_spectrum_ro
	uchar_spectrum_roAttrib	*uchar_spectrum_ro = new uchar_spectrum_roAttrib();
	att_list.push_back(uchar_spectrum_ro);

	//	Attribute : ushort_spectrum_ro
	ushort_spectrum_roAttrib	*ushort_spectrum_ro = new ushort_spectrum_roAttrib();
	att_list.push_back(ushort_spectrum_ro);

	//	Attribute : boolean_image
	boolean_imageAttrib	*boolean_image = new boolean_imageAttrib();
	att_list.push_back(boolean_image);

	//	Attribute : uchar_image
	uchar_imageAttrib	*uchar_image = new uchar_imageAttrib();
	att_list.push_back(uchar_image);

	//	Attribute : short_image
	short_imageAttrib	*short_image = new short_imageAttrib();
	att_list.push_back(short_image);

	//	Attribute : ushort_image
	ushort_imageAttrib	*ushort_image = new ushort_imageAttrib();
	att_list.push_back(ushort_image);

	//	Attribute : long_image
	long_imageAttrib	*long_image = new long_imageAttrib();
	att_list.push_back(long_image);

	//	Attribute : float_image
	float_imageAttrib	*float_image = new float_imageAttrib();
	att_list.push_back(float_image);

	//	Attribute : double_image
	double_imageAttrib	*double_image = new double_imageAttrib();
	att_list.push_back(double_image);

}

//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::get_class_property()
// 
// description : 	Read the class properties from database.
//
//-----------------------------------------------------------------------------
void TangoTestClass::get_class_property()
{
	//	Initialize your default values here (if not done with  POGO).
	//------------------------------------------------------------------

	//	Read class properties from database.(Automatic code generation)
	//------------------------------------------------------------------
	if (Tango::Util::instance()->_UseDb==false)
		return;

	//	Call database and extract values
	//--------------------------------------------
	get_db_class()->get_property(cl_prop);
	Tango::DbDatum	def_prop;
	int	i = -1;


	//	End of Automatic code generation
	//------------------------------------------------------------------

}

//+----------------------------------------------------------------------------
//
// method : 	TangoTestClass::set_default_property
// 
// description: Set default property (class and device) for wizard.
//              For each property, add to wizard property name and description
//              If default value has been set, add it to wizard property and
//              store it in a DbDatum.
//
//-----------------------------------------------------------------------------
void TangoTestClass::set_default_property()
{
	string	prop_name;
	string	prop_desc;
	string	prop_def;

	vector<string>	vect_data;
	//	Set Default Class Properties
	//	Set Default Device Properties
	prop_name = "Mthreaded_impl";
	prop_desc = "Multi-threaded implementation (true/false";
	prop_def  = "";
	if (prop_def.length()>0)
	{
		Tango::DbDatum	data(prop_name);
		data << vect_data ;
		dev_def_prop.push_back(data);
		add_wiz_dev_prop(prop_name, prop_desc,  prop_def);
	}
	else
		add_wiz_dev_prop(prop_name, prop_desc);

	prop_name = "Sleep_period";
	prop_desc = "Data generation period (in ms";
	prop_def  = "";
	if (prop_def.length()>0)
	{
		Tango::DbDatum	data(prop_name);
		data << vect_data ;
		dev_def_prop.push_back(data);
		add_wiz_dev_prop(prop_name, prop_desc,  prop_def);
	}
	else
		add_wiz_dev_prop(prop_name, prop_desc);

}
//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::write_class_property
// 
// description : 	Set class description as property in database
//
//-----------------------------------------------------------------------------
void TangoTestClass::write_class_property()
{
	//	First time, check if database used
	//--------------------------------------------
	if (Tango::Util::_UseDb == false)
		return;

	Tango::DbData	data;
	string	classname = get_name();
	string	header;
	string::size_type	start, end;

	//	Put title
	Tango::DbDatum	title("ProjectTitle");
	string	str_title("TANGO Device Server for testing generic clients");
	title << str_title;
	data.push_back(title);

	//	Put Description
	Tango::DbDatum	description("Description");
	vector<string>	str_desc;
	str_desc.push_back("A device to test generic clients. It offers a \"echo\" like command for");
	str_desc.push_back("each TANGO data type (i.e. each command returns an exact copy of <argin>).");
	description << str_desc;
	data.push_back(description);
		
	//	put cvs location
	string	rcsId(RcsId);
	string	filename(classname);
	start = rcsId.find("/");
	if (start!=string::npos)
	{
		filename += "Class.cpp";
		end   = rcsId.find(filename);
		if (end>start)
		{
			string	strloc = rcsId.substr(start, end-start);
			//	Check if specific repository
			start = strloc.find("/cvsroot/");
			if (start!=string::npos && start>0)
			{
				string	repository = strloc.substr(0, start);
				if (repository.find("/segfs/")!=string::npos)
					strloc = "ESRF:" + strloc.substr(start, strloc.length()-start);
			}
			Tango::DbDatum	cvs_loc("cvs_location");
			cvs_loc << strloc;
			data.push_back(cvs_loc);
		}
	}

	//	Get CVS tag revision
	string	tagname(TagName);
	header = "$Name: ";
	start = header.length();
	string	endstr(" $");
	end   = tagname.find(endstr);
	if (end>start)
	{
		string	strtag = tagname.substr(start, end-start);
		Tango::DbDatum	cvs_tag("cvs_tag");
		cvs_tag << strtag;
		data.push_back(cvs_tag);
	}

	//	Get URL location
	string	httpServ(HttpServer);
	if (httpServ.length()>0)
	{
		Tango::DbDatum	db_doc_url("doc_url");
		db_doc_url << httpServ;
		data.push_back(db_doc_url);
	}

	//	Call database and and values
	//--------------------------------------------
	get_db_class()->put_property(data);
}

}	// namespace
