/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.FilterManager;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.QoSAdminOperations;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyActive;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyInactive;
import org.omg.CosNotifyChannelAdmin.NotConnected;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.MappingFilterHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.picocontainer.PicoContainer;

public abstract class AbstractProxy
implements FilterAdminOperations,
QoSAdminOperations,
FilterStage,
Disposable,
ManageableServant,
Configurable {
    private final MappingFilter nullMappingFilterRef_;
    protected final boolean isIDPublic_;
    protected final Logger logger_;
    private final SynchronizedBoolean connected_ = new SynchronizedBoolean(false);
    protected final QoSPropertySet qosSettings_;
    protected final Integer id_;
    protected final OfferManager offerManager_;
    protected final SubscriptionManager subscriptionManager_;
    protected Servant thisServant_;
    protected MappingFilter lifetimeFilter_;
    protected MappingFilter priorityFilter_;
    private final FilterManager filterManager_;
    private final SynchronizedBoolean destroyed_ = new SynchronizedBoolean(false);
    private final SynchronizedBoolean disposeInProgress_ = new SynchronizedBoolean(false);
    private final SynchronizedInt errorCounter_ = new SynchronizedInt(0);
    private final POA poa_;
    private final ORB orb_;
    private final TaskProcessor taskProcessor_;
    private boolean isInterFilterGroupOperatorOR_;
    private final boolean disposedProxyDisconnectsClient_;
    private final SynchronizedBoolean active_ = new SynchronizedBoolean(true);
    private final DisposableManager disposables_ = new DisposableManager();
    private final PicoContainer container_;
    static /* synthetic */ Class class$org$jacorb$notification$IContainer;

    protected AbstractProxy(IAdmin iAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        this.id_ = new Integer(iAdmin.getProxyID());
        this.isIDPublic_ = iAdmin.isIDPublic();
        this.container_ = iAdmin.getContainer();
        this.orb_ = oRB;
        this.poa_ = pOA;
        this.taskProcessor_ = taskProcessor;
        this.offerManager_ = offerManager;
        this.subscriptionManager_ = subscriptionManager;
        this.filterManager_ = new FilterManager();
        this.nullMappingFilterRef_ = MappingFilterHelper.narrow(oRB.string_to_object(oRB.object_to_string(null)));
        this.logger_ = ((org.jacorb.config.Configuration)configuration).getNamedLogger(this.getClass().getName());
        this.disposedProxyDisconnectsClient_ = configuration.getAttribute("jacorb.notification.proxy.destroy_causes_disconnect", "on").equals("on");
        this.qosSettings_ = new QoSPropertySet(configuration, 2);
        this.configure(configuration);
    }

    public void configure(Configuration configuration) {
    }

    public void addDisposeHook(Disposable disposable) {
        this.disposables_.addDisposable(disposable);
    }

    public boolean isIDPublic() {
        return this.isIDPublic_;
    }

    protected POA getPOA() {
        return this.poa_;
    }

    protected ORB getORB() {
        return this.orb_;
    }

    protected TaskProcessor getTaskProcessor() {
        return this.taskProcessor_;
    }

    public final int add_filter(Filter filter) {
        return this.filterManager_.add_filter(filter);
    }

    public final void remove_filter(int n) throws FilterNotFound {
        this.filterManager_.remove_filter(n);
    }

    public final Filter get_filter(int n) throws FilterNotFound {
        return this.filterManager_.get_filter(n);
    }

    public final int[] get_all_filters() {
        return this.filterManager_.get_all_filters();
    }

    public final void remove_all_filters() {
        this.filterManager_.remove_all_filters();
    }

    public void validate_event_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) {
        throw new NO_IMPLEMENT();
    }

    public final void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, namedPropertyRangeSeqHolder);
    }

    public final void set_qos(Property[] propertyArray) throws UnsupportedQoS {
        if (this.qosSettings_ != null) {
            this.qosSettings_.set_qos(propertyArray);
        }
    }

    public final Property[] get_qos() {
        return this.qosSettings_.get_qos();
    }

    public final void priority_filter(MappingFilter mappingFilter) {
        this.priorityFilter_ = mappingFilter;
    }

    public final MappingFilter priority_filter() {
        if (this.priorityFilter_ == null) {
            return this.nullMappingFilterRef_;
        }
        return this.priorityFilter_;
    }

    public final MappingFilter lifetime_filter() {
        if (this.lifetimeFilter_ == null) {
            return this.nullMappingFilterRef_;
        }
        return this.lifetimeFilter_;
    }

    public final void lifetime_filter(MappingFilter mappingFilter) {
        this.lifetimeFilter_ = mappingFilter;
    }

    public final Integer getID() {
        return this.id_;
    }

    public final POA _default_POA() {
        return this.getPOA();
    }

    public final List getFilters() {
        return this.filterManager_.getFilters();
    }

    public final void deactivate() {
        this.logger_.info("deactivate Proxy");
        try {
            byte[] byArray = this.getPOA().servant_to_id(this.getServant());
            this.getPOA().deactivate_object(byArray);
        }
        catch (Exception exception) {
            this.logger_.fatalError("Couldn't deactivate Proxy", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDisconnectClient() {
        try {
            if (this.disposedProxyDisconnectsClient_ && this.connected_.get()) {
                this.logger_.info("disconnect_client");
                this.disconnectClient();
            }
        }
        catch (Exception exception) {
            this.logger_.error("disconnect_client raised an unexpected error: ignore", exception);
        }
        finally {
            this.connected_.set(false);
        }
    }

    public final boolean isDisposed() {
        return this.destroyed_.get();
    }

    protected void checkDestroyStatus() throws OBJECT_NOT_EXIST {
        if (!this.destroyed_.commit(false, true)) {
            this.logger_.fatalError("dispose has been called twice");
            throw new OBJECT_NOT_EXIST();
        }
    }

    public final void destroy() {
        this.checkDestroyStatus();
        this.container_.dispose();
        List list = this.container_.getComponentInstancesOfType(class$org$jacorb$notification$IContainer == null ? (class$org$jacorb$notification$IContainer = AbstractProxy.class$("org.jacorb.notification.IContainer")) : class$org$jacorb$notification$IContainer);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IContainer iContainer = (IContainer)iterator.next();
            iContainer.destroy();
        }
    }

    public void dispose() {
        this.logger_.info("Destroy Proxy " + this.id_);
        this.disposeInProgress_.set(true);
        this.tryDisconnectClient();
        this.deactivate();
        this.removeListener();
        this.remove_all_filters();
        this.disposables_.dispose();
    }

    public abstract ProxyType MyType();

    void setInterFilterGroupOperatorOR(boolean bl) {
        this.isInterFilterGroupOperatorOR_ = bl;
    }

    public final boolean hasInterFilterGroupOperatorOR() {
        return this.isInterFilterGroupOperatorOR_;
    }

    public final boolean isConnected() {
        return !this.disposeInProgress_.get() && this.connected_.get();
    }

    public final boolean hasLifetimeFilter() {
        return this.lifetimeFilter_ != null;
    }

    public final boolean hasPriorityFilter() {
        return this.priorityFilter_ != null;
    }

    public final MappingFilter getLifetimeFilter() {
        return this.lifetimeFilter_;
    }

    public final MappingFilter getPriorityFilter() {
        return this.priorityFilter_;
    }

    public void resetErrorCounter() {
        this.errorCounter_.set(0);
    }

    public final int getErrorCounter() {
        return this.errorCounter_.get();
    }

    public final int incErrorCounter() {
        return this.errorCounter_.increment();
    }

    protected boolean isSuspended() {
        return !this.active_.get();
    }

    public final void suspend_connection() throws NotConnected, ConnectionAlreadyInactive {
        this.checkIsConnected();
        if (!this.active_.commit(true, false)) {
            throw new ConnectionAlreadyInactive();
        }
        this.connectionSuspended();
    }

    protected void connectionSuspended() {
    }

    public final void resume_connection() throws NotConnected, ConnectionAlreadyActive {
        this.checkIsConnected();
        if (!this.active_.commit(false, true)) {
            throw new ConnectionAlreadyActive();
        }
        this.connectionResumed();
    }

    protected void connectionResumed() {
    }

    protected void checkIsConnected() throws NotConnected {
        if (!this.connected_.get()) {
            throw new NotConnected();
        }
    }

    protected void checkIsNotConnected() throws AlreadyConnected {
        if (this.connected_.get()) {
            throw new AlreadyConnected();
        }
    }

    protected void checkStillConnected() throws Disconnected {
        if (!this.connected_.get()) {
            this.logger_.fatalError("access on a not connected proxy");
            this.destroy();
            throw new Disconnected();
        }
    }

    protected void connectClient(Object object) {
        this.connected_.set(true);
    }

    protected abstract void disconnectClient();

    protected abstract Servant getServant();

    protected void handleDisconnected(Disconnected disconnected) {
        this.logger_.fatalError("Illegal state: Client think it's disconnected. Proxy thinks Client is still connected. The Proxy will be destroyed.", disconnected);
        this.destroy();
    }

    protected abstract void removeListener();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

