/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.Schedulable;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.interfaces.FilterStage;

public class FilterConsumerAdminTask
extends AbstractFilterTask {
    private static int sCount = 0;
    private int id_ = ++sCount;
    private final List listOfFilterStageWithMessageConsumer_ = new ArrayList();

    public FilterConsumerAdminTask(TaskFactory taskFactory, TaskExecutor taskExecutor) {
        super(taskFactory, taskExecutor);
    }

    public String toString() {
        return "[FilterConsumerAdminTask#" + this.id_ + "]";
    }

    public FilterStage[] getFilterStagesWithMessageConsumer() {
        return this.listOfFilterStageWithMessageConsumer_.toArray(EMPTY_FILTERSTAGE);
    }

    private void clearFilterStagesWithMessageConsumer() {
        this.listOfFilterStageWithMessageConsumer_.clear();
    }

    public void reset() {
        super.reset();
        this.clearFilterStagesWithMessageConsumer();
        this.arrayCurrentFilterStage_ = EMPTY_FILTERSTAGE;
    }

    public void doFilter() throws InterruptedException {
        this.filter();
        this.pushToConsumers();
    }

    private void pushToConsumers() throws InterruptedException {
        FilterStage[] filterStageArray = this.getFilterStagesWithMessageConsumer();
        if (filterStageArray.length > 0) {
            this.getTaskFactory().enqueueMessage(filterStageArray, this.getMessage());
        }
        Schedulable schedulable = this.getTaskFactory().newFilterProxySupplierTask(this);
        schedulable.schedule();
    }

    private void filter() throws InterruptedException {
        for (int i = 0; i < this.arrayCurrentFilterStage_.length; ++i) {
            this.checkInterrupt();
            boolean bl = false;
            if (!this.arrayCurrentFilterStage_[i].isDisposed()) {
                bl = this.getMessage().match(this.arrayCurrentFilterStage_[i]);
            }
            if (bl) {
                if (this.arrayCurrentFilterStage_[i].hasInterFilterGroupOperatorOR()) {
                    this.listOfFilterStageWithMessageConsumer_.addAll(this.arrayCurrentFilterStage_[i].getSubsequentFilterStages());
                    continue;
                }
                this.addFilterStage(this.arrayCurrentFilterStage_[i].getSubsequentFilterStages());
                continue;
            }
            Iterator iterator = this.arrayCurrentFilterStage_[i].getSubsequentFilterStages().iterator();
            while (iterator.hasNext()) {
                FilterStage filterStage = (FilterStage)iterator.next();
                if (!filterStage.hasInterFilterGroupOperatorOR()) continue;
                this.addFilterStage(filterStage);
            }
        }
    }
}

