/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Date;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.engine.DefaultTaskExecutor;
import org.jacorb.notification.engine.DefaultTaskFactory;
import org.jacorb.notification.engine.PullFromSupplierTask;
import org.jacorb.notification.engine.Schedulable;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.IProxyPushSupplier;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.omg.CORBA.Any;
import org.omg.CosNotification.StructuredEvent;

public class DefaultTaskProcessor
implements TaskProcessor,
Disposable {
    final Logger logger_;
    private TaskExecutor matchTaskExecutor_;
    private TaskExecutor pullTaskExecutor_;
    private ClockDaemon clockDaemon_ = new ClockDaemon();
    private DefaultTaskFactory taskFactory_;

    public DefaultTaskProcessor(Configuration configuration) {
        this.clockDaemon_.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("ClockDaemonThread");
                return thread;
            }
        });
        this.logger_ = ((org.jacorb.config.Configuration)configuration).getNamedLogger(this.getClass().getName());
        this.logger_.info("create TaskProcessor");
        int n = configuration.getAttributeAsInteger("jacorb.notification.proxyconsumer.thread_pool_size", 2);
        this.pullTaskExecutor_ = new DefaultTaskExecutor("PullThread", n, true);
        int n2 = configuration.getAttributeAsInteger("jacorb.notification.filter.thread_pool_size", 2);
        this.matchTaskExecutor_ = new DefaultTaskExecutor("FilterThread", n2);
        this.taskFactory_ = new DefaultTaskFactory(this);
        this.taskFactory_.configure(configuration);
    }

    public TaskFactory getTaskFactory() {
        return this.taskFactory_;
    }

    public TaskExecutor getFilterTaskExecutor() {
        return this.matchTaskExecutor_;
    }

    public void dispose() {
        this.logger_.info("shutdown TaskProcessor");
        this.clockDaemon_.shutDown();
        this.matchTaskExecutor_.dispose();
        this.pullTaskExecutor_.dispose();
        this.taskFactory_.dispose();
        this.logger_.debug("shutdown complete");
    }

    public void processMessage(Message message) {
        if (message.hasStopTime()) {
            this.logger_.debug("Message has StopTime");
            if (message.getStopTime() <= System.currentTimeMillis()) {
                this.fireEventDiscarded(message);
                message.dispose();
                this.logger_.debug("Message Stoptime is passed already");
                return;
            }
            new DeferedStopTask(message);
        }
        if (message.hasTimeout()) {
            this.logger_.debug("Message has TimeOut");
            new TimeoutTask(message);
        }
        if (message.hasStartTime() && message.getStartTime() > System.currentTimeMillis()) {
            new DeferedStartTask(message);
        } else {
            this.processMessageInternal(message);
        }
    }

    protected void processMessageInternal(Message message) {
        this.logger_.debug("processMessageInternal");
        Schedulable schedulable = this.taskFactory_.newFilterProxyConsumerTask(message);
        try {
            schedulable.schedule();
        }
        catch (InterruptedException interruptedException) {
            this.logger_.info("Interrupt while scheduling FilterTask", interruptedException);
        }
    }

    public void scheduleTimedPullTask(MessageSupplier messageSupplier) throws InterruptedException {
        PullFromSupplierTask pullFromSupplierTask = new PullFromSupplierTask(this.pullTaskExecutor_);
        pullFromSupplierTask.setTarget(messageSupplier);
        pullFromSupplierTask.schedule();
    }

    public void schedulePushOperation(IProxyPushSupplier iProxyPushSupplier) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    private ClockDaemon getClockDaemon() {
        return this.clockDaemon_;
    }

    public Object executeTaskPeriodically(long l, Runnable runnable, boolean bl) {
        this.logger_.debug("executeTaskPeriodically");
        return this.getClockDaemon().executePeriodically(l, runnable, bl);
    }

    public void cancelTask(Object object) {
        ClockDaemon.cancel((Object)object);
    }

    public Object executeTaskAfterDelay(long l, Runnable runnable) {
        return this.clockDaemon_.executeAfterDelay(l, runnable);
    }

    Object executeTaskAt(long l, Runnable runnable) {
        return this.executeTaskAt(new Date(l), runnable);
    }

    Object executeTaskAt(Date date, Runnable runnable) {
        return this.clockDaemon_.executeAt(date, runnable);
    }

    private void fireEventDiscarded(Message message) {
        switch (message.getType()) {
            case 0: {
                this.fireEventDiscarded(message.toAny());
                break;
            }
            case 1: {
                this.fireEventDiscarded(message.toStructuredEvent());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void fireEventDiscarded(Any any) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Any: " + any + " has been discarded");
        }
    }

    private void fireEventDiscarded(StructuredEvent structuredEvent) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("StructuredEvent: " + structuredEvent + " has been discarded");
        }
    }

    class DeferedStartTask
    implements Runnable {
        final Message message_;

        DeferedStartTask(Message message) {
            if (DefaultTaskProcessor.this.logger_.isDebugEnabled()) {
                DefaultTaskProcessor.this.logger_.debug("Message with Option StartTime=" + message.getStartTime() + " will be defered until then");
            }
            this.message_ = message;
            DefaultTaskProcessor.this.executeTaskAt(this.message_.getStartTime(), (Runnable)this);
        }

        public void run() {
            if (DefaultTaskProcessor.this.logger_.isDebugEnabled()) {
                DefaultTaskProcessor.this.logger_.debug("Defered Message " + this.message_ + " will be processed now");
            }
            DefaultTaskProcessor.this.processMessageInternal(this.message_);
        }
    }

    private class DeferedStopTask
    implements Runnable {
        final Message message_;

        public DeferedStopTask(Message message) {
            this.message_ = message;
            DefaultTaskProcessor.this.executeTaskAt(message.getStopTime(), (Runnable)this);
        }

        public void run() {
            this.message_.actionTimeout();
        }
    }

    private class TimeoutTask
    implements Runnable,
    Message.MessageStateListener {
        Object timerRegistration_;
        final Message message_;

        public TimeoutTask(Message message) {
            this.message_ = message;
            this.message_.setMessageStateListener(this);
            this.timerRegistration_ = DefaultTaskProcessor.this.executeTaskAfterDelay(message.getTimeout(), this);
        }

        public void actionLifetimeChanged(long l) {
            ClockDaemon.cancel((Object)this.timerRegistration_);
            this.timerRegistration_ = DefaultTaskProcessor.this.executeTaskAfterDelay(this.message_.getTimeout(), this);
        }

        public void run() {
            DefaultTaskProcessor.this.logger_.debug("run Timeout");
            this.message_.removeMessageStateListener();
            this.message_.actionTimeout();
        }
    }
}

