/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevStateHelper;
import fr.esrf.Tango.DevStringHelper;
import fr.esrf.Tango.DevVarCharArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarDoubleStringArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarLongStringArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarULongArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;

public abstract class Command
implements TangoConst {
    protected String name;
    protected int in_type;
    protected int out_type;
    protected String in_type_desc;
    protected String out_type_desc;
    protected String device_class_name;
    protected boolean template_cmd = false;
    protected int poll_period = 0;
    protected DispLevel disp_level = DispLevel.OPERATOR;

    public Command(String s, int in, int out) {
        this.name = s;
        this.in_type = in;
        this.out_type = out;
        this.in_type_desc = "";
        this.out_type_desc = "";
    }

    public Command(String s, int in, int out, String in_desc, String out_desc) {
        this.name = s;
        this.in_type = in;
        this.out_type = out;
        this.in_type_desc = in_desc;
        this.out_type_desc = out_desc;
    }

    public Command(String s, int in, int out, DispLevel level) {
        this.name = s;
        this.in_type = in;
        this.out_type = out;
        this.disp_level = level;
    }

    public Command(String s, int in, int out, String in_desc, String out_desc, DispLevel level) {
        this.name = s;
        this.in_type = in;
        this.out_type = out;
        this.in_type_desc = in_desc;
        this.out_type_desc = out_desc;
        this.disp_level = level;
    }

    public abstract Any execute(DeviceImpl var1, Any var2) throws DevFailed;

    public boolean is_allowed(DeviceImpl dev, Any data_in) {
        return true;
    }

    public String get_name() {
        return this.name;
    }

    public int get_in_type() {
        return this.in_type;
    }

    public int get_out_type() {
        return this.out_type;
    }

    public String get_in_type_desc() {
        return this.in_type_desc;
    }

    public String get_out_type_desc() {
        return this.out_type_desc;
    }

    public String get_device_class_name() {
        return this.device_class_name;
    }

    public boolean is_template() {
        return this.template_cmd;
    }

    public void set_in_type_desc(String type) {
        this.in_type_desc = type;
    }

    public void set_out_type_desc(String type) {
        this.out_type_desc = type;
    }

    public void set_device_class_name(String name) {
        this.device_class_name = name;
    }

    public void analyse_methods() throws DevFailed {
        Util.out4.println("In Command.analyse_methods()");
    }

    private Any alloc_any() throws DevFailed {
        Any out_any = null;
        try {
            out_any = Util.instance().get_orb().create_any();
        }
        catch (OutOfMemoryError ex) {
            Util.out3.println("Bad allocation while in alloc_any Command method()");
            Except.throw_exception("API_MemoryAllocation", "Can't allocate memory in server", "Command::alloc_any");
        }
        return out_any;
    }

    public Any insert() throws DevFailed {
        return this.alloc_any();
    }

    public Any insert(boolean data) throws DevFailed {
        Any out_any = this.alloc_any();
        out_any.insert_boolean(data);
        return out_any;
    }

    public Any insert(short data) throws DevFailed {
        Any out_any = this.alloc_any();
        out_any.insert_short(data);
        return out_any;
    }

    public Any insert_u(short data) throws DevFailed {
        Any out_any = this.alloc_any();
        out_any.insert_ushort(data);
        return out_any;
    }

    public Any insert(int data) throws DevFailed {
        Any out_any = this.alloc_any();
        out_any.insert_long(data);
        return out_any;
    }

    public Any insert_u(int data) throws DevFailed {
        Any out_any = this.alloc_any();
        out_any.insert_ulong(data);
        return out_any;
    }

    public Any insert(float data) throws DevFailed {
        Any out_any = this.alloc_any();
        out_any.insert_float(data);
        return out_any;
    }

    public Any insert(double data) throws DevFailed {
        Any out_any = this.alloc_any();
        out_any.insert_double(data);
        return out_any;
    }

    public Any insert(String data) throws DevFailed {
        Any out_any = this.alloc_any();
        out_any.insert_string(data);
        return out_any;
    }

    public Any insert(byte[] data) throws DevFailed {
        Any out_any = this.alloc_any();
        DevVarCharArrayHelper.insert(out_any, data);
        return out_any;
    }

    public Any insert(short[] data) throws DevFailed {
        Any out_any = this.alloc_any();
        DevVarShortArrayHelper.insert(out_any, data);
        return out_any;
    }

    public Any insert_u(short[] data) throws DevFailed {
        Any out_any = this.alloc_any();
        DevVarUShortArrayHelper.insert(out_any, data);
        return out_any;
    }

    public Any insert(int[] data) throws DevFailed {
        Any out_any = this.alloc_any();
        DevVarLongArrayHelper.insert(out_any, data);
        return out_any;
    }

    public Any insert_u(int[] data) throws DevFailed {
        Any out_any = this.alloc_any();
        DevVarULongArrayHelper.insert(out_any, data);
        return out_any;
    }

    public Any insert(float[] data) throws DevFailed {
        Any out_any = this.alloc_any();
        DevVarFloatArrayHelper.insert(out_any, data);
        return out_any;
    }

    public Any insert(double[] data) throws DevFailed {
        Any out_any = this.alloc_any();
        DevVarDoubleArrayHelper.insert(out_any, data);
        return out_any;
    }

    public Any insert(String[] data) throws DevFailed {
        Any out_any = this.alloc_any();
        DevVarStringArrayHelper.insert(out_any, data);
        return out_any;
    }

    public Any insert(DevVarLongStringArray data) throws DevFailed {
        Any out_any = this.alloc_any();
        DevVarLongStringArrayHelper.insert(out_any, data);
        return out_any;
    }

    public Any insert(DevVarDoubleStringArray data) throws DevFailed {
        Any out_any = this.alloc_any();
        DevVarDoubleStringArrayHelper.insert(out_any, data);
        return out_any;
    }

    public Any insert(DevState data) throws DevFailed {
        Any out_any = this.alloc_any();
        DevStateHelper.insert(out_any, data);
        return out_any;
    }

    private void throw_bad_type(String type) throws DevFailed {
        StringBuffer mess = new StringBuffer("Incompatible command argument type, expected type is : Tango_");
        mess.append(type);
        Except.throw_exception("API_IncompatibleCmdArgumentType", new String(mess), new String("Command.extract()"));
    }

    public boolean extract_DevBoolean(Any in) throws DevFailed {
        boolean data = false;
        try {
            data = in.extract_boolean();
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevBoolean");
        }
        return data;
    }

    public short extract_DevShort(Any in) throws DevFailed {
        short data = 0;
        try {
            data = in.extract_short();
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevShort");
        }
        return data;
    }

    public int extract_DevLong(Any in) throws DevFailed {
        int data = 0;
        try {
            data = in.extract_long();
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevLong");
        }
        return data;
    }

    public float extract_DevFloat(Any in) throws DevFailed {
        float data = 0.0f;
        try {
            data = in.extract_float();
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevFloat");
        }
        return data;
    }

    public double extract_DevDouble(Any in) throws DevFailed {
        double data = 0.0;
        try {
            data = in.extract_double();
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevDouble");
        }
        return data;
    }

    public String extract_DevString(Any in) throws DevFailed {
        String data = null;
        try {
            data = DevStringHelper.extract(in);
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevString");
        }
        return data;
    }

    public short extract_DevUShort(Any in) throws DevFailed {
        short data = 0;
        try {
            data = in.extract_ushort();
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevUShort");
        }
        return data;
    }

    public int extract_DevULong(Any in) throws DevFailed {
        int data = 0;
        try {
            data = in.extract_ulong();
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevULong");
        }
        return data;
    }

    public byte[] extract_DevVarCharArray(Any in) throws DevFailed {
        byte[] data = null;
        try {
            data = DevVarCharArrayHelper.extract(in);
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevVarCharArray");
        }
        return data;
    }

    public short[] extract_DevVarShortArray(Any in) throws DevFailed {
        short[] data = null;
        try {
            data = DevVarShortArrayHelper.extract(in);
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevVarShortArray");
        }
        return data;
    }

    public int[] extract_DevVarLongArray(Any in) throws DevFailed {
        int[] data = null;
        try {
            data = DevVarLongArrayHelper.extract(in);
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevVarLongArray");
        }
        return data;
    }

    public float[] extract_DevVarFloatArray(Any in) throws DevFailed {
        float[] data = null;
        try {
            data = DevVarFloatArrayHelper.extract(in);
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevVarFloatArray");
        }
        return data;
    }

    public double[] extract_DevVarDoubleArray(Any in) throws DevFailed {
        double[] data = null;
        try {
            data = DevVarDoubleArrayHelper.extract(in);
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevVarDoubleArray");
        }
        return data;
    }

    public short[] extract_DevVarUShortArray(Any in) throws DevFailed {
        short[] data = null;
        try {
            data = DevVarUShortArrayHelper.extract(in);
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevVarUShortArray");
        }
        return data;
    }

    public int[] extract_DevVarULongArray(Any in) throws DevFailed {
        int[] data = null;
        try {
            data = DevVarULongArrayHelper.extract(in);
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevVarULongArray");
        }
        return data;
    }

    public String[] extract_DevVarStringArray(Any in) throws DevFailed {
        String[] data = null;
        try {
            data = DevVarStringArrayHelper.extract(in);
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevVarStringArray");
        }
        return data;
    }

    public DevVarLongStringArray extract_DevVarLongStringArray(Any in) throws DevFailed {
        DevVarLongStringArray data = null;
        try {
            data = DevVarLongStringArrayHelper.extract(in);
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevVarLongStringArray");
        }
        return data;
    }

    public DevVarDoubleStringArray extract_DevVarDoubleStringArray(Any in) throws DevFailed {
        DevVarDoubleStringArray data = null;
        try {
            data = DevVarDoubleStringArrayHelper.extract(in);
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevVarDoubleStringArray");
        }
        return data;
    }

    public DevState extract_DevState(Any in) throws DevFailed {
        DevState data = null;
        try {
            data = DevStateHelper.extract(in);
        }
        catch (BAD_OPERATION ex) {
            this.throw_bad_type("DevState");
        }
        return data;
    }

    public int get_tag() {
        if (this.disp_level == DispLevel.OPERATOR) {
            return 0;
        }
        return 1;
    }

    public DispLevel get_disp_level() {
        return this.disp_level;
    }

    public void set_disp_level(DispLevel level) {
        this.disp_level = level;
    }

    public int get_polling_period() {
        return this.poll_period;
    }

    public void set_polling_period(int p) {
        this.poll_period = p;
    }
}

