/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.IOP.IOR;

public class IORdump {
    private String iorString = null;
    private String type_id = null;
    private String iiopVersion = null;
    private String host = null;
    private String hostname = "";
    private int port = -1;
    private int prg_number = -1;
    private String devname = null;
    public boolean is_taco = false;

    public IORdump(String devname, String iorString) throws DevFailed {
        this.devname = devname == null ? "unknown" : devname;
        if (iorString == null) {
            DeviceProxy dev = new DeviceProxy(devname);
            iorString = dev.get_ior();
        } else {
            this.iorString = iorString;
        }
        if (iorString != null) {
            if (iorString.equals("nada")) {
                iorString = null;
            } else {
                this.iorAnalysis(iorString);
            }
        }
    }

    public IORdump(String devname) throws DevFailed {
        this.devname = devname;
        DeviceProxy dev = new DeviceProxy(devname);
        this.iorString = dev.get_ior();
        if (this.iorString != null) {
            if (this.iorString.equals("nada")) {
                this.iorString = null;
            } else {
                this.iorAnalysis(this.iorString);
            }
        }
    }

    public IORdump(DeviceProxy dev) throws DevFailed {
        this.devname = dev.name();
        this.iorString = dev.get_ior();
        if (this.iorString != null) {
            if (this.iorString.equals("nada")) {
                this.iorString = null;
            } else {
                this.iorAnalysis(this.iorString);
            }
        }
    }

    public String toString() {
        if (this.iorString == null) {
            return new String("No IOR found in database for " + this.devname + "\n" + "(Maybe, the device has never been exported...)");
        }
        String str = new String("Device:          " + this.devname + "\n" + "type_id:         " + this.get_type_id() + "\n");
        if (!this.is_taco) {
            str = str + "iiop_version:    " + this.get_iiop_version() + "\n";
        }
        str = str + "host:            " + this.get_host() + "\n";
        str = !this.is_taco ? str + "port:            " + this.get_port() : str + "prg number:      " + this.get_prg_number();
        return str;
    }

    private void iorAnalysis(String iorString) throws DevFailed {
        if (iorString == null) {
            return;
        }
        if (iorString.startsWith("rpc:")) {
            this.is_taco = true;
            this.type_id = "Taco";
            this.host = iorString.substring("rpc:".length(), iorString.indexOf(":", "rpc:".length() + 1));
            String s = iorString.substring(iorString.indexOf(":", "rpc:".length() + 1) + 1);
            this.prg_number = Integer.parseInt(s);
            return;
        }
        if (!iorString.startsWith("IOR:")) {
            return;
        }
        ParsedIOR pior = new ParsedIOR(iorString, ApiUtil.get_orb(), null);
        IOR ior = pior.getIOR();
        this.type_id = ior.type_id;
        List profiles = pior.getProfiles();
        for (int i = 0; i < profiles.size(); ++i) {
            IIOPProfile p = (IIOPProfile)profiles.get(i);
            this.iiopVersion = "" + p.version().major + "." + p.version().minor;
            String name = p.getAddress().getHostname();
            try {
                InetAddress iadd = InetAddress.getByName(name);
                String add = iadd.getHostAddress();
                this.hostname = iadd.getHostName();
                this.host = new String(this.hostname + " (" + add + ")");
            }
            catch (Exception e) {
                this.host = new String(name + " (" + e + ")");
            }
            this.port = p.getAddress().getPort();
            if (this.port >= 0) continue;
            this.port += 65536;
        }
    }

    public String get_type_id() {
        return this.type_id;
    }

    public String get_host() {
        return this.host;
    }

    public String get_hostname() {
        return this.hostname;
    }

    public int get_port() {
        return this.port;
    }

    public int get_prg_number() {
        return this.prg_number;
    }

    public String get_iiop_version() {
        return this.iiopVersion;
    }

    public static void printSyntax() {
        System.out.println("IORdump <ior string>      or");
        System.out.println("IORdump -f <ior file name>");
    }

    public static String getIor(String filename) throws FileNotFoundException, SecurityException, IOException {
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        fid.read(inStr);
        String str = new String(inStr);
        fid.close();
        return str;
    }

    public static void main(String[] args) {
        try {
            switch (args.length) {
                case 1: {
                    System.out.println(new IORdump(args[0]).toString());
                    break;
                }
                case 2: {
                    if (args[0].equals("-f")) {
                        System.out.println(new IORdump(null, IORdump.getIor(args[1])).toString());
                        break;
                    }
                }
                default: {
                    IORdump.printSyntax();
                    break;
                }
            }
        }
        catch (DevFailed e) {
            Except.print_exception(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Device name ?");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

