/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.AccessProxy;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbHistory;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.TangoDs.Except;
import java.util.StringTokenizer;
import java.util.Vector;

public class Database
extends Connection {
    private AccessProxy access_proxy = null;
    protected boolean access_checked = false;
    DevFailed access_devfailed = null;

    public Database() throws DevFailed {
    }

    public Database(String host, String port) throws DevFailed {
        super(host, port);
    }

    public String toString() {
        return this.url.host + ":" + this.url.port;
    }

    private String stringArray2String(String[] array) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            if (i >= array.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private void checkAccess() {
        if (this.check_access && !this.access_checked) {
            this.access = this.checkAccessControl(this.devname);
            this.access_checked = true;
        }
    }

    public String get_info() throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argout = this.command_inout("DbInfo");
        String[] info = argout.extractStringArray();
        return this.stringArray2String(info);
    }

    public String[] get_host_list() throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert("*");
        DeviceData argout = this.command_inout("DbGetHostList", argin);
        return argout.extractStringArray();
    }

    public String[] get_host_list(String wildcard) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout("DbGetHostList", argin);
        return argout.extractStringArray();
    }

    public String[] get_server_class_list(String servname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        DeviceData argout = this.command_inout("DbGetDeviceServerClassList", argin);
        String[] list = argout.extractStringArray();
        int nb_classes = list.length == 0 ? 0 : list.length - 1;
        String[] classes = new String[nb_classes];
        int j = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].equals("DServer")) continue;
            classes[j++] = list[i];
        }
        return classes;
    }

    public String[] get_server_name_list() throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert("*");
        DeviceData argout = this.command_inout("DbGetServerNameList", argin);
        return argout.extractStringArray();
    }

    public String[] get_instance_name_list(String servname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        DeviceData argout = this.command_inout("DbGetInstanceNameList", argin);
        return argout.extractStringArray();
    }

    public String[] get_server_list() throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert("*");
        DeviceData argout = this.command_inout("DbGetServerList", argin);
        return argout.extractStringArray();
    }

    public String[] get_server_list(String wildcard) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout("DbGetServerList", argin);
        return argout.extractStringArray();
    }

    public String[] get_host_server_list(String hostname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(hostname);
        DeviceData argout = this.command_inout("DbGetHostServerList", argin);
        return argout.extractStringArray();
    }

    public DbServInfo get_server_info(String servname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        DeviceData argout = this.command_inout("DbGetServerInfo", argin);
        String[] info = argout.extractStringArray();
        return new DbServInfo(info);
    }

    public void put_server_info(DbServInfo info) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[]{info.name, info.host, info.controlled ? "1" : "0", new String("" + info.startup_level)};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout("DbPutServerInfo", argin);
    }

    public void delete_server_info(String servname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        this.command_inout("DbDeleteServerInfo", argin);
    }

    public void add_device(DbDevInfo devinfo) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(devinfo.toStringArray());
        this.command_inout("DbAddDevice", argin);
    }

    public void add_device(String devname, String classname, String servname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DbDevInfo devinfo = new DbDevInfo(devname, classname, servname);
        DeviceData argin = new DeviceData();
        argin.insert(devinfo.toStringArray());
        this.command_inout("DbAddDevice", argin);
    }

    public void delete_device(String devname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        boolean delete = true;
        try {
            DeviceProxy d = new DeviceProxy(devname);
            d.ping();
            delete = false;
        }
        catch (DevFailed e) {
            // empty catch block
        }
        if (delete) {
            DeviceData argin = new DeviceData();
            argin.insert(devname);
            this.command_inout("DbDeleteDevice", argin);
        } else {
            Except.throw_connection_failed("TangoApi_DEVICE_ALIVE", "Cannot delete a device which is ALIVE.", "delete_device()");
        }
    }

    public DeviceInfo get_device_info(String devname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        DeviceData argout = this.command_inout("DbGetDeviceInfo", argin);
        DevVarLongStringArray info = argout.extractLongStringArray();
        return new DeviceInfo(info);
    }

    public DbDevImportInfo import_device(String devname) throws DevFailed {
        int tmp_access = this.access;
        this.access = 1;
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        DeviceData argout = this.command_inout("DbImportDevice", argin);
        DevVarLongStringArray info = argout.extractLongStringArray();
        this.access = tmp_access;
        return new DbDevImportInfo(info);
    }

    public void unexport_device(String devname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        this.command_inout("DbUnExportDevice", argin);
    }

    public void export_device(DbDevExportInfo devinfo) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = devinfo.toStringArray();
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout("DbExportDevice", argin);
    }

    public String[] get_device_class_list(String servname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        DeviceData argout = this.command_inout("DbGetDeviceClassList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_name(String servname, String classname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[]{servname, classname};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        DeviceData argout = this.command_inout("DbGetDeviceList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_domain(String wildcard) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout("DbGetDeviceDomainList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_family(String wildcard) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout("DbGetDeviceFamilyList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_member(String wildcard) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout("DbGetDeviceMemberList", argin);
        return argout.extractStringArray();
    }

    public void add_server(String servname, DbDevInfo[] devinfo) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[1 + 2 * devinfo.length];
        array[0] = servname;
        for (int i = 0; i < devinfo.length; ++i) {
            array[2 * i + 1] = devinfo[i].name;
            array[2 * i + 2] = devinfo[i]._class;
        }
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout("DbAddServer", argin);
    }

    public void delete_server(String devname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        this.command_inout("DbDeleteServer", argin);
    }

    public void export_server(DbDevExportInfo[] devinfo) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[6 * devinfo.length];
        for (int i = 0; i < devinfo.length; ++i) {
            String[] one = devinfo[i].toStringArray();
            for (int j = 0; j < 6; ++j) {
                array[6 * i + j] = new String(one[j]);
            }
        }
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout("DbExportServer", argin);
    }

    public void unexport_server(String devname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        this.command_inout("DbUnExportServer", argin);
    }

    private String[] dbdatum2StringArray(String name, DbDatum[] properties) {
        int size = 2;
        for (int i = 0; i < properties.length; ++i) {
            size += 2;
            size += properties[i].size();
        }
        String[] result = new String[size];
        result[0] = name;
        result[1] = String.valueOf(properties.length);
        int pnum = 2;
        for (int i = 0; i < properties.length; ++i) {
            String[] prop = properties[i].toStringArray();
            for (int j = 0; j < prop.length; ++j) {
                result[pnum++] = prop[j];
            }
        }
        return result;
    }

    private DbDatum[] stringArray2DbDatum(String[] strprop) {
        int nb_prop = Integer.parseInt(strprop[1]);
        DbDatum[] properties = new DbDatum[nb_prop];
        int i = 2;
        int pnum = 0;
        while (i < strprop.length - 1) {
            int nb = Integer.parseInt(strprop[i + 1]);
            int start_val = i + 2;
            int end_val = i + 2 + nb;
            if (nb > 0) {
                properties[pnum++] = new DbDatum(strprop[i], strprop, start_val, end_val);
            } else {
                String s;
                properties[pnum++] = new DbDatum(strprop[i]);
                if (start_val + 1 < strprop.length && ((s = strprop[start_val]).length() == 0 || s.equals(" "))) {
                    end_val = start_val + 1;
                }
            }
            i = end_val;
        }
        return properties;
    }

    private DbDatum[] get_obj_property(String name, String type, DbDatum[] properties) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            array[i] = properties[i].name;
        }
        return this.get_obj_property(name, type, array);
    }

    private DbDatum get_obj_property(String name, String type, String propname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[]{propname};
        DbDatum[] data = this.get_obj_property(name, type, array);
        return data[0];
    }

    private DbDatum[] get_obj_property(String name, String type, String[] propnames) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[1 + propnames.length];
        array[0] = name;
        for (int i = 1; i < propnames.length + 1; ++i) {
            array[i] = propnames[i - 1];
        }
        String cmd = new String("DbGet" + type + "Property");
        DeviceData argin = new DeviceData();
        argin.insert(array);
        DeviceData argout = this.command_inout(cmd, argin);
        String[] result = argout.extractStringArray();
        return this.stringArray2DbDatum(result);
    }

    private void delete_obj_property(String name, String type, DbDatum[] properties) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            array[i] = properties[i].name;
        }
        this.delete_obj_property(name, type, array);
    }

    private void delete_obj_property(String name, String type, String propname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[]{propname};
        this.delete_obj_property(name, type, array);
    }

    private void delete_obj_property(String name, String type, String[] propnames) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[propnames.length + 1];
        array[0] = name;
        for (int i = 0; i < propnames.length; ++i) {
            array[i + 1] = propnames[i];
        }
        String cmd = new String("DbDelete" + type + "Property");
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout(cmd, argin);
    }

    public String[] get_object_list(String wildcard) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout("DbGetObjectList", argin);
        return argout.extractStringArray();
    }

    public String[] get_object_property_list(String objname, String wildcard) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[]{objname, wildcard};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        DeviceData argout = this.command_inout("DbGetPropertyList", argin);
        return argout.extractStringArray();
    }

    public DbDatum[] get_property(String name, String[] propnames) throws DevFailed {
        String type = "";
        return this.get_obj_property(name, type, propnames);
    }

    public DbDatum get_property(String name, String propname) throws DevFailed {
        String type = "";
        return this.get_obj_property(name, type, propname);
    }

    DbDatum get_property(String name, String propname, boolean forced) throws DevFailed {
        int tmp_access = this.access;
        if (forced) {
            this.access = 1;
        }
        String[] array = new String[]{name, propname};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        DeviceData argout = this.command_inout("DbGetProperty", argin);
        String[] result = argout.extractStringArray();
        this.access = tmp_access;
        return this.stringArray2DbDatum(result)[0];
    }

    public DbDatum[] get_property(String name, DbDatum[] properties) throws DevFailed {
        String type = "";
        return this.get_obj_property(name, type, properties);
    }

    public void put_property(String name, DbDatum[] properties) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = this.dbdatum2StringArray(name, properties);
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout("DbPutProperty", argin);
    }

    public void delete_property(String name, String[] propnames) throws DevFailed {
        String type = "";
        this.delete_obj_property(name, type, propnames);
    }

    public void delete_property(String name, String propname) throws DevFailed {
        String type = "";
        this.delete_obj_property(name, type, propname);
    }

    public void delete_property(String name, DbDatum[] properties) throws DevFailed {
        String type = "";
        this.delete_obj_property(name, type, properties);
    }

    public String[] get_class_property_list(String classname, String wildcard) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(classname);
        DeviceData argout = this.command_inout("DbGetClassPropertyList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_property_list(String devname, String wildcard) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[]{devname, wildcard};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        DeviceData argout = this.command_inout("DbGetDevicePropertyList", argin);
        return argout.extractStringArray();
    }

    public String get_class_for_device(String devname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        DeviceData argout = this.command_inout("DbGetClassForDevice", argin);
        return argout.extractString();
    }

    public String[] get_class_inheritance_for_device(String devname) throws DevFailed {
        String[] result;
        block3: {
            if (!this.access_checked) {
                this.checkAccess();
            }
            result = new String[]{"Device_3Impl"};
            try {
                DeviceData argin = new DeviceData();
                argin.insert(devname);
                DeviceData argout = this.command_inout("DbGetClassInheritanceForDevice", argin);
                result = argout.extractStringArray();
            }
            catch (DevFailed e) {
                if (e.errors[0].reason.equals("API_CommandNotFound")) break block3;
                throw e;
            }
        }
        return result;
    }

    public DbDatum[] get_device_property(String name, String[] propnames) throws DevFailed {
        String type = "Device";
        return this.get_obj_property(name, type, propnames);
    }

    public DbDatum get_device_property(String name, String propname) throws DevFailed {
        String type = "Device";
        return this.get_obj_property(name, type, propname);
    }

    public DbDatum[] get_device_property(String name, DbDatum[] properties) throws DevFailed {
        String type = "Device";
        return this.get_obj_property(name, type, properties);
    }

    public void put_device_property(String name, DbDatum[] properties) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = this.dbdatum2StringArray(name, properties);
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout("DbPutDeviceProperty", argin);
    }

    public void delete_device_property(String name, String[] propnames) throws DevFailed {
        String type = "Device";
        this.delete_obj_property(name, type, propnames);
    }

    public void delete_device_property(String name, String propname) throws DevFailed {
        String type = "Device";
        this.delete_obj_property(name, type, propname);
    }

    public void delete_device_property(String name, DbDatum[] properties) throws DevFailed {
        String type = "Device";
        this.delete_obj_property(name, type, properties);
    }

    public DbAttribute[] get_device_attribute_property(String devname, String[] attnames) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        DeviceData argout = null;
        int mode = 2;
        try {
            argin.insert(ApiUtil.toStringArray(devname, attnames));
            argout = this.command_inout("DbGetDeviceAttributeProperty2", argin);
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                argout = this.command_inout("DbGetDeviceAttributeProperty", argin);
                mode = 1;
            }
            throw e;
        }
        return ApiUtil.toDbAttributeArray(argout.extractStringArray(), mode);
    }

    public DbAttribute get_device_attribute_property(String devname, String attname) throws DevFailed {
        String[] attnames = new String[]{attname};
        return this.get_device_attribute_property(devname, attnames)[0];
    }

    public void put_device_attribute_property(String devname, DbAttribute[] attr) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        try {
            argin.insert(ApiUtil.toStringArray(devname, attr, 2));
            this.command_inout("DbPutDeviceAttributeProperty2", argin);
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                argin.insert(ApiUtil.toStringArray(devname, attr, 1));
                this.command_inout("DbPutDeviceAttributeProperty", argin);
            }
            throw e;
        }
    }

    public void put_device_attribute_property(String devname, DbAttribute attr) throws DevFailed {
        DbAttribute[] da = new DbAttribute[]{attr};
        this.put_device_attribute_property(devname, da);
    }

    public void delete_device_attribute_property(String devname, DbAttribute attr) throws DevFailed {
        this.delete_device_attribute_property(devname, attr.name, attr.get_property_list());
    }

    public void delete_device_attribute_property(String devname, DbAttribute[] attr) throws DevFailed {
        for (int i = 0; i < attr.length; ++i) {
            this.delete_device_attribute_property(devname, attr[i].name, attr[i].get_property_list());
        }
    }

    public void delete_device_attribute_property(String devname, String attname, String[] propnames) throws DevFailed {
        if (propnames.length == 0) {
            return;
        }
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[2 + propnames.length];
        array[0] = devname;
        array[1] = attname;
        for (int i = 0; i < propnames.length; ++i) {
            array[i + 2] = propnames[i];
        }
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout("DbDeleteDeviceAttributeProperty", argin);
    }

    public void delete_device_attribute_property(String devname, String attname, String propname) throws DevFailed {
        String[] array = new String[]{propname};
        this.delete_device_attribute_property(devname, attname, array);
    }

    public void delete_device_attribute(String devname, String attname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[]{devname, attname};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout("DbDeleteDeviceAttribute", argin);
    }

    public String[] get_class_list(String servname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        DeviceData argout = this.command_inout("DbGetClassList", argin);
        return argout.extractStringArray();
    }

    public DbDatum[] get_class_property(String name, String[] propnames) throws DevFailed {
        String type = "Class";
        return this.get_obj_property(name, type, propnames);
    }

    public DbDatum get_class_property(String name, String propname) throws DevFailed {
        String type = "Class";
        return this.get_obj_property(name, type, propname);
    }

    public DbDatum[] get_class_property(String name, DbDatum[] properties) throws DevFailed {
        String type = "Class";
        return this.get_obj_property(name, type, properties);
    }

    public void put_class_property(String name, DbDatum[] properties) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = this.dbdatum2StringArray(name, properties);
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout("DbPutClassProperty", argin);
    }

    public void delete_class_property(String name, String[] propnames) throws DevFailed {
        String type = "Class";
        this.delete_obj_property(name, type, propnames);
    }

    public void delete_class_property(String name, String propname) throws DevFailed {
        String type = "Class";
        this.delete_obj_property(name, type, propname);
    }

    public void delete_class_property(String name, DbDatum[] properties) throws DevFailed {
        String type = "Class";
        this.delete_obj_property(name, type, properties);
    }

    public String[] get_class_attribute_list(String classname, String wildcard) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(ApiUtil.toStringArray(classname, wildcard));
        DeviceData argout = this.command_inout("DbGetClassAttributeList", argin);
        return argout.extractStringArray();
    }

    public DbAttribute get_class_attribute_property(String classname, String attname) throws DevFailed {
        String[] attnames = new String[]{attname};
        return this.get_class_attribute_property(classname, attnames)[0];
    }

    public DbAttribute[] get_class_attribute_property(String classname, String[] attnames) throws DevFailed {
        DeviceData argout;
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        int mode = 2;
        try {
            argin.insert(ApiUtil.toStringArray(classname, attnames));
            argout = this.command_inout("DbGetClassAttributeProperty2", argin);
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                argout = this.command_inout("DbGetClassAttributeProperty", argin);
                mode = 1;
            }
            throw e;
        }
        return ApiUtil.toDbAttributeArray(argout.extractStringArray(), mode);
    }

    public void put_class_attribute_property(String classname, DbAttribute[] attr) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(ApiUtil.toStringArray(classname, attr, 1));
        this.command_inout("DbPutClassAttributeProperty", argin);
    }

    public void put_class_attribute_property(String classname, DbAttribute attr) throws DevFailed {
        DbAttribute[] da = new DbAttribute[]{attr};
        this.put_class_attribute_property(classname, da);
    }

    public void delete_class_attribute_property(String name, String attname, String propname) throws DevFailed {
        String[] array = new String[]{propname};
        this.delete_class_attribute_property(name, attname, array);
    }

    public void delete_class_attribute_property(String name, String attname, String[] propnames) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        String[] array = new String[2 + propnames.length];
        array[0] = name;
        array[1] = attname;
        for (int i = 0; i < propnames.length; ++i) {
            array[i + 2] = propnames[i];
        }
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout("DbDeleteClassAttributeProperty", argin);
    }

    public String[] get_device_exported(String wildcard) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout("DbGetDeviceExportedList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_exported_for_class(String classname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(classname);
        DeviceData argout = this.command_inout("DbGetExportdDeviceListForClass", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_alias_list(String wildcard) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout("DbGetDeviceAliasList", argin);
        return argout.extractStringArray();
    }

    public String get_device_alias(String devname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        DeviceData argout = this.command_inout("DbGetDeviceAlias", argin);
        return argout.extractString();
    }

    public String get_alias_device(String alias) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(alias);
        DeviceData argout = this.command_inout("DbGetAliasDevice", argin);
        return argout.extractString();
    }

    public void put_device_alias(String devname, String aliasname) throws DevFailed {
        String[] array = new String[]{devname, aliasname};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout("DbPutDeviceAlias", argin);
    }

    public void delete_device_alias(String alias) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(alias);
        this.command_inout("DbDeleteDeviceAlias", argin);
    }

    public String[] get_attribute_alias_list(String wildcard) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(wildcard);
        DeviceData argout = this.command_inout("DbGetAttributeAliasList", argin);
        return argout.extractStringArray();
    }

    public String get_attribute_alias(String attname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(attname);
        DeviceData argout = this.command_inout("DbGetAttributeAlias", argin);
        return argout.extractString();
    }

    public void put_attribute_alias(String attname, String aliasname) throws DevFailed {
        String[] array = new String[]{attname, aliasname};
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.command_inout("DbPutAttributeAlias", argin);
    }

    public void delete_attribute_alias(String alias) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(alias);
        this.command_inout("DbDeleteAttributeAlias", argin);
    }

    public String[] getDevices(String wildcard) throws DevFailed {
        StringTokenizer stk = new StringTokenizer(wildcard, "/");
        Vector<String> vector = new Vector<String>();
        while (stk.hasMoreTokens()) {
            vector.add(stk.nextToken());
        }
        if (vector.size() < 3) {
            Except.throw_exception("TangoApi_DeviceNameNotValid", "Device name not valid", "ATangoApi.Database.getDevices()");
        }
        String domain = (String)vector.elementAt(0);
        String family = (String)vector.elementAt(1);
        String member = (String)vector.elementAt(2);
        String[] domains = this.get_device_domain(domain);
        if (domains.length == 0) {
            domains = new String[]{domain};
        }
        vector.clear();
        for (int i = 0; i < domains.length; ++i) {
            String[] families = this.get_device_family(domains[i] + "/" + family);
            if (families.length == 0) {
                families = new String[]{family};
            }
            for (int j = 0; j < families.length; ++j) {
                String[] members = this.get_device_member(domains[i] + "/" + families[j] + "/" + member);
                if (members.length == 0) {
                    members = new String[]{member};
                }
                for (int k = 0; k < members.length; ++k) {
                    vector.add(domains[i] + "/" + families[j] + "/" + members[k]);
                }
            }
        }
        String[] devices = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            devices[i] = (String)vector.elementAt(i);
        }
        return devices;
    }

    public DbEventImportInfo import_event(String channel_name) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(channel_name);
        DeviceData argout = this.command_inout("DbImportEvent", argin);
        DevVarLongStringArray info = argout.extractLongStringArray();
        return new DbEventImportInfo(info);
    }

    private DbHistory[] convertPropertyHistory(String[] ret, boolean isAttribute) throws DevFailed {
        int i;
        int offset;
        Vector<DbHistory> v = new Vector<DbHistory>();
        int count = 0;
        String aName = "";
        for (i = 0; i < ret.length; i += count + offset) {
            String pCount;
            String pDate;
            String pName;
            if (isAttribute) {
                aName = ret[i];
                pName = ret[i + 1];
                pDate = ret[i + 2];
                pCount = ret[i + 3];
                offset = 4;
            } else {
                pName = ret[i];
                pDate = ret[i + 1];
                pCount = ret[i + 2];
                offset = 3;
            }
            try {
                count = Integer.parseInt(pCount);
            }
            catch (NumberFormatException e) {
                Except.throw_exception("TangoApi_HisotryInvalid", "History format is invalid", "ATangoApi.Database.convertPropertyHistory()");
            }
            String[] value = new String[count];
            for (int j = 0; j < count; ++j) {
                value[j] = ret[i + offset + j];
            }
            if (isAttribute) {
                v.add(new DbHistory(aName, pName, pDate, value));
                continue;
            }
            v.add(new DbHistory(pName, pDate, value));
        }
        DbHistory[] result = new DbHistory[v.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = (DbHistory)v.get(i);
        }
        return result;
    }

    public DbHistory[] get_device_property_history(String devname, String propname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{devname, propname});
        DeviceData argout = this.command_inout("DbGetDevicePropertyHist", argin);
        return this.convertPropertyHistory(argout.extractStringArray(), false);
    }

    public DbHistory[] get_device_attribute_property_history(String devname, String attname, String propname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{devname, attname, propname});
        DeviceData argout = this.command_inout("DbGetDeviceAttributePropertyHist", argin);
        return this.convertPropertyHistory(argout.extractStringArray(), true);
    }

    public DbHistory[] get_class_property_history(String classname, String propname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{classname, propname});
        DeviceData argout = this.command_inout("DbGetClassPropertyHist", argin);
        return this.convertPropertyHistory(argout.extractStringArray(), false);
    }

    public DbHistory[] get_class_attribute_property_history(String classname, String attname, String propname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{classname, attname, propname});
        DeviceData argout = this.command_inout("DbGetClassAttributePropertyHist", argin);
        return this.convertPropertyHistory(argout.extractStringArray(), true);
    }

    public DbHistory[] get_property_history(String objname, String propname) throws DevFailed {
        if (!this.access_checked) {
            this.checkAccess();
        }
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{objname, propname});
        DeviceData argout = this.command_inout("DbGetPropertyHist", argin);
        return this.convertPropertyHistory(argout.extractStringArray(), false);
    }

    public String[] getServices(String servicename, String instname) throws DevFailed {
        Vector<String> v = new Vector<String>();
        DbDatum datum = this.get_property("CtrlSystem", "Services", true);
        if (!datum.is_empty()) {
            String[] services = datum.extractStringArray();
            String target = servicename + "/";
            if (!instname.equals("*")) {
                target = target + instname;
            }
            for (int i = 0; i < services.length; ++i) {
                int start;
                if (!services[i].startsWith(target) || (start = services[i].indexOf(58)) <= 0) continue;
                v.add(services[i].substring(start + 1));
            }
        }
        String[] result = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            result[i] = (String)v.get(i);
        }
        return result;
    }

    int checkAccessControl(String devname) {
        if (devname.equals(this.devname) && this.access_checked) {
            return this.access;
        }
        int access = 1;
        try {
            if (!this.access_checked && this.access_proxy == null) {
                String access_devname = System.getProperty("ACCESS_DEVNAME");
                if (access_devname == null || access_devname.length() == 0) {
                    String[] services = this.getServices("AccessControl", "*");
                    if (services.length > 0) {
                        access_devname = services[0];
                    } else {
                        System.out.println("No Access Service Found !");
                        return 1;
                    }
                }
                this.access_proxy = new AccessProxy(access_devname);
            }
            if (this.access_proxy != null) {
                access = this.access_proxy.checkAccessControl(devname);
            }
        }
        catch (DevFailed e) {
            Except.print_exception(e);
            access = 0;
            this.access_devfailed = e;
        }
        return access;
    }

    boolean isCommandAllowed(String devname, String cmd) throws DevFailed {
        if (this.access_proxy == null) {
            return !this.check_access;
        }
        return this.access_proxy.isCommandAllowed(devname, cmd);
    }
}

