/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.AttrReadEvent;
import fr.esrf.TangoApi.AttrWrittenEvent;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.CmdDoneEvent;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import org.omg.CORBA.Request;

class AsyncCallObject
implements ApiDefs {
    int id = 0;
    Request request;
    DeviceProxy dev;
    int cmd_type;
    CallBack cb;
    int reply_model;
    String[] names;

    AsyncCallObject(Request request, DeviceProxy dev, int cmd_type, String[] names, int reply_model) {
        this.request = request;
        this.dev = dev;
        this.cmd_type = cmd_type;
        this.names = names;
        this.reply_model = reply_model;
    }

    AsyncCallObject(Request request, DeviceProxy dev, int cmd_type, String[] names) {
        this(request, dev, cmd_type, names, 1);
    }

    void command_inout_reply(int timeout) {
        DevError[] errors = null;
        DeviceData argout = null;
        try {
            argout = timeout == -1 ? this.dev.command_inout_reply(this) : this.dev.command_inout_reply(this, timeout);
        }
        catch (AsynReplyNotArrived e) {
            errors = e.errors;
        }
        catch (DevFailed e) {
            errors = e.errors;
        }
        this.cb.cmd_ended(new CmdDoneEvent(this.dev, this.names[0], argout, errors));
    }

    void read_attribute_reply(int timeout) {
        DevError[] errors = null;
        DeviceAttribute[] argout = null;
        try {
            argout = timeout == -1 ? this.dev.read_attribute_reply(this.id) : this.dev.read_attribute_reply(this.id, timeout);
        }
        catch (AsynReplyNotArrived e) {
            errors = e.errors;
        }
        catch (DevFailed e) {
            errors = e.errors;
        }
        this.cb.attr_read(new AttrReadEvent(this.dev, this.names, argout, errors));
    }

    void write_attribute_reply(int timeout) {
        DevError[] errors = null;
        try {
            if (timeout == -1) {
                this.dev.write_attribute_reply(this.id);
            } else {
                this.dev.write_attribute_reply(this.id, 0);
            }
        }
        catch (AsynReplyNotArrived e) {
            errors = e.errors;
        }
        catch (DevFailed e) {
            errors = e.errors;
        }
        this.cb.attr_written(new AttrWrittenEvent(this.dev, this.names, errors));
    }

    void manage_reply(int timeout) {
        switch (this.cmd_type) {
            case 0: {
                this.command_inout_reply(timeout);
                break;
            }
            case 1: {
                this.read_attribute_reply(timeout);
                break;
            }
            case 2: {
                this.write_attribute_reply(timeout);
            }
        }
    }

    void manage_reply() {
        this.manage_reply(-1);
    }
}

