/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRotatable;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDTransformPanel
extends JPanel
implements ActionListener,
ChangeListener {
    JButton upBtn;
    JButton downBtn;
    JButton leftBtn;
    JButton rightBtn;
    JLabel transXLabel;
    JTextField transXText;
    JLabel transYLabel;
    JTextField transYText;
    JDObject[] allObjects;
    JComponent invoker;
    Rectangle oldRect;
    JSlider scaleXSlider;
    JSlider scaleYSlider;
    JLabel scaleXLabel;
    JTextField scaleXText;
    JLabel scaleYLabel;
    JTextField scaleYText;
    JCheckBox rot90CheckBox;
    JCheckBox rot180CheckBox;
    JCheckBox rot270CheckBox;
    JSlider scaleRSlider;
    JLabel scaleRLabel;
    JTextField scaleRText;
    JCheckBox scaleRatioCheckBox;
    JButton resetTransformBtn;
    JButton dismissBtn;
    int transX;
    int transY;
    int scaleX;
    int scaleY;
    int angle;
    double rotatableAngle;
    boolean transformInited = false;
    Point org;
    boolean isUpdating = false;

    public JDTransformPanel(JDObject[] jDObjectArray, JComponent jComponent) {
        this.allObjects = jDObjectArray;
        this.invoker = jComponent;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(280, 380));
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(JDUtils.createTitleBorder("Translation"));
        jPanel.setBounds(5, 5, 270, 90);
        this.transX = 0;
        this.transY = 0;
        this.upBtn = new JButton();
        this.upBtn.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/up_button.gif")));
        this.upBtn.setBounds(30, 20, 20, 20);
        this.upBtn.addActionListener(this);
        jPanel.add(this.upBtn);
        this.downBtn = new JButton();
        this.downBtn.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/down_button.gif")));
        this.downBtn.setBounds(30, 60, 20, 20);
        this.downBtn.addActionListener(this);
        jPanel.add(this.downBtn);
        this.leftBtn = new JButton();
        this.leftBtn.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/left_button.gif")));
        this.leftBtn.setBounds(10, 40, 20, 20);
        this.leftBtn.addActionListener(this);
        jPanel.add(this.leftBtn);
        this.rightBtn = new JButton();
        this.rightBtn.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/right_button.gif")));
        this.rightBtn.setBounds(50, 40, 20, 20);
        this.rightBtn.addActionListener(this);
        jPanel.add(this.rightBtn);
        this.transXLabel = new JLabel("Horizontal translation");
        this.transXLabel.setHorizontalAlignment(4);
        this.transXLabel.setFont(JDUtils.labelFont);
        this.transXLabel.setForeground(JDUtils.labelColor);
        this.transXLabel.setBounds(80, 20, 135, 24);
        jPanel.add(this.transXLabel);
        this.transXText = new JTextField();
        this.transXText.setMargin(JDUtils.zMargin);
        this.transXText.setEditable(true);
        this.transXText.setFont(JDUtils.labelFont);
        this.transXText.setBounds(220, 20, 40, 24);
        this.transXText.addActionListener(this);
        jPanel.add(this.transXText);
        this.transYLabel = new JLabel("Vertical translation");
        this.transYLabel.setHorizontalAlignment(4);
        this.transYLabel.setFont(JDUtils.labelFont);
        this.transYLabel.setForeground(JDUtils.labelColor);
        this.transYLabel.setBounds(80, 50, 135, 24);
        jPanel.add(this.transYLabel);
        this.transYText = new JTextField();
        this.transYText.setMargin(JDUtils.zMargin);
        this.transYText.setEditable(true);
        this.transYText.setFont(JDUtils.labelFont);
        this.transYText.setBounds(220, 50, 40, 24);
        this.transYText.addActionListener(this);
        jPanel.add(this.transYText);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setBorder(JDUtils.createTitleBorder("Scaling"));
        jPanel2.setBounds(5, 100, 270, 150);
        this.scaleX = 100;
        this.scaleY = 100;
        this.angle = 0;
        this.rotatableAngle = 0.0;
        this.org = JDUtils.getCenter(this.allObjects);
        this.scaleXSlider = new JSlider(10, 500, this.scaleX);
        this.scaleXSlider.setMinorTickSpacing(20);
        this.scaleXSlider.setMajorTickSpacing(100);
        this.scaleXSlider.setPaintTicks(true);
        this.scaleXSlider.setPaintLabels(false);
        this.scaleXSlider.addChangeListener(this);
        this.scaleXSlider.setBounds(5, 20, 135, 50);
        jPanel2.add(this.scaleXSlider);
        this.scaleYSlider = new JSlider(10, 500, this.scaleY);
        this.scaleYSlider.setFont(JDUtils.labelFont);
        this.scaleYSlider.setMinorTickSpacing(20);
        this.scaleYSlider.setMajorTickSpacing(100);
        this.scaleYSlider.setPaintTicks(true);
        this.scaleYSlider.setPaintLabels(false);
        this.scaleYSlider.addChangeListener(this);
        this.scaleYSlider.setBounds(5, 70, 135, 50);
        jPanel2.add(this.scaleYSlider);
        this.scaleXLabel = new JLabel("H scale [%]");
        this.scaleXLabel.setFont(JDUtils.labelFont);
        this.scaleXLabel.setHorizontalAlignment(4);
        this.scaleXLabel.setForeground(JDUtils.labelColor);
        this.scaleXLabel.setBounds(140, 30, 75, 24);
        jPanel2.add(this.scaleXLabel);
        this.scaleXText = new JTextField();
        this.scaleXText.setMargin(JDUtils.zMargin);
        this.scaleXText.setEditable(true);
        this.scaleXText.setFont(JDUtils.labelFont);
        this.scaleXText.setBounds(220, 30, 40, 24);
        this.scaleXText.addActionListener(this);
        jPanel2.add(this.scaleXText);
        this.scaleYLabel = new JLabel("V scale [%]");
        this.scaleYLabel.setHorizontalAlignment(4);
        this.scaleYLabel.setFont(JDUtils.labelFont);
        this.scaleYLabel.setForeground(JDUtils.labelColor);
        this.scaleYLabel.setBounds(140, 80, 75, 24);
        jPanel2.add(this.scaleYLabel);
        this.scaleYText = new JTextField();
        this.scaleYText.setMargin(JDUtils.zMargin);
        this.scaleYText.setEditable(true);
        this.scaleYText.setFont(JDUtils.labelFont);
        this.scaleYText.setBounds(220, 80, 40, 24);
        this.scaleYText.addActionListener(this);
        jPanel2.add(this.scaleYText);
        this.scaleRatioCheckBox = new JCheckBox("Preserve ratio");
        this.scaleRatioCheckBox.setFont(JDUtils.labelFont);
        this.scaleRatioCheckBox.setForeground(JDUtils.labelColor);
        this.scaleRatioCheckBox.setBounds(5, 120, 150, 25);
        this.scaleRatioCheckBox.setSelected(true);
        this.scaleRatioCheckBox.addActionListener(this);
        jPanel2.add(this.scaleRatioCheckBox);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel(null);
        jPanel3.setBorder(JDUtils.createTitleBorder("Rotate"));
        jPanel3.setBounds(5, 255, 270, 90);
        this.rot90CheckBox = new JCheckBox("90deg");
        this.rot90CheckBox.setFont(JDUtils.labelFont);
        this.rot90CheckBox.setForeground(JDUtils.labelColor);
        this.rot90CheckBox.setBounds(5, 20, 80, 24);
        this.rot90CheckBox.addActionListener(this);
        jPanel3.add(this.rot90CheckBox);
        this.rot180CheckBox = new JCheckBox("180deg");
        this.rot180CheckBox.setFont(JDUtils.labelFont);
        this.rot180CheckBox.setForeground(JDUtils.labelColor);
        this.rot180CheckBox.setBounds(85, 20, 90, 24);
        this.rot180CheckBox.addActionListener(this);
        jPanel3.add(this.rot180CheckBox);
        this.rot270CheckBox = new JCheckBox("270deg");
        this.rot270CheckBox.setFont(JDUtils.labelFont);
        this.rot270CheckBox.setForeground(JDUtils.labelColor);
        this.rot270CheckBox.setBounds(175, 20, 88, 24);
        this.rot270CheckBox.addActionListener(this);
        jPanel3.add(this.rot270CheckBox);
        this.scaleRSlider = new JSlider(-180, 180, 0);
        this.scaleRSlider.setMinorTickSpacing(45);
        this.scaleRSlider.setMajorTickSpacing(90);
        this.scaleRSlider.setPaintTicks(true);
        this.scaleRSlider.setPaintLabels(false);
        this.scaleRSlider.addChangeListener(this);
        this.scaleRSlider.setBounds(5, 45, 135, 40);
        jPanel3.add(this.scaleRSlider);
        this.scaleRLabel = new JLabel("Angle [deg]");
        this.scaleRLabel.setFont(JDUtils.labelFont);
        this.scaleRLabel.setHorizontalAlignment(4);
        this.scaleRLabel.setForeground(JDUtils.labelColor);
        this.scaleRLabel.setBounds(140, 50, 75, 24);
        jPanel3.add(this.scaleRLabel);
        this.scaleRText = new JTextField();
        this.scaleRText.setMargin(JDUtils.zMargin);
        this.scaleRText.setEditable(true);
        this.scaleRText.setFont(JDUtils.labelFont);
        this.scaleRText.setBounds(220, 50, 40, 24);
        this.scaleRText.addActionListener(this);
        jPanel3.add(this.scaleRText);
        boolean bl = true;
        for (int i = 0; i < jDObjectArray.length && bl; ++i) {
            bl = jDObjectArray[i] instanceof JDRotatable;
        }
        this.scaleRSlider.setEnabled(bl);
        this.scaleRLabel.setEnabled(bl);
        this.scaleRText.setEnabled(bl);
        this.add(jPanel3);
        this.resetTransformBtn = new JButton("Reset transfom");
        this.resetTransformBtn.setMargin(new Insets(0, 0, 0, 0));
        this.resetTransformBtn.setFont(JDUtils.labelFont);
        this.resetTransformBtn.addActionListener(this);
        this.resetTransformBtn.setBounds(7, 350, 120, 24);
        this.add(this.resetTransformBtn);
        this.dismissBtn = new JButton("Dismiss");
        this.dismissBtn.setMargin(new Insets(0, 0, 0, 0));
        this.dismissBtn.setFont(JDUtils.labelFont);
        this.dismissBtn.addActionListener(this);
        this.dismissBtn.setBounds(192, 350, 80, 24);
        this.add(this.dismissBtn);
        this.updateControls();
    }

    private void updateControls() {
        this.isUpdating = true;
        this.transXText.setText(Integer.toString(this.transX));
        this.transYText.setText(Integer.toString(this.transY));
        this.scaleXText.setText(Integer.toString(this.scaleX));
        this.scaleYText.setText(Integer.toString(this.scaleY));
        this.scaleRText.setText(Double.toString(this.rotatableAngle));
        this.scaleXSlider.setValue(this.scaleX);
        this.scaleYSlider.setValue(this.scaleY);
        this.scaleRSlider.setValue((int)Math.round(this.rotatableAngle));
        this.rot90CheckBox.setSelected(this.angle == 90);
        this.rot180CheckBox.setSelected(this.angle == 180);
        this.rot270CheckBox.setSelected(this.angle == 270);
        this.isUpdating = false;
    }

    private void initTransform() {
        if (!this.transformInited) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].saveTransform();
            }
            this.transformInited = true;
        }
    }

    private void initRepaint() {
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        Rectangle rectangle = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            rectangle = rectangle.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(rectangle.union(this.oldRect));
    }

    private void updateTransform() {
        for (int i = 0; i < this.allObjects.length; ++i) {
            this.allObjects[i].restoreTransform();
            this.allObjects[i].scaleTranslate(this.org.x, this.org.y, (double)this.scaleX / 100.0, (double)this.scaleY / 100.0, this.transX, this.transY);
            for (int j = 0; j < this.angle; j += 90) {
                this.allObjects[i].rotate90(this.org.x, this.org.y);
            }
            if (this.rotatableAngle == 0.0 || !(this.allObjects[i] instanceof JDRotatable)) continue;
            ((JDRotatable)((Object)this.allObjects[i])).rotate(this.rotatableAngle * Math.PI / 180.0, this.org.x, this.org.y);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isUpdating) {
            return;
        }
        this.initRepaint();
        this.initTransform();
        Object object = actionEvent.getSource();
        if (object == this.upBtn) {
            --this.transY;
            JDUtils.modified = true;
        } else if (object == this.downBtn) {
            ++this.transY;
            JDUtils.modified = true;
        } else if (object == this.leftBtn) {
            --this.transX;
            JDUtils.modified = true;
        } else if (object == this.rightBtn) {
            ++this.transX;
            JDUtils.modified = true;
        } else if (object == this.transXText) {
            try {
                this.transX = Integer.parseInt(this.transXText.getText());
                JDUtils.modified = true;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid number", "Error", 0);
            }
        } else if (object == this.transYText) {
            try {
                this.transY = Integer.parseInt(this.transYText.getText());
                JDUtils.modified = true;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid number", "Error", 0);
            }
        } else if (object == this.scaleXText) {
            try {
                this.scaleX = Integer.parseInt(this.scaleXText.getText());
                JDUtils.modified = true;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid number", "Error", 0);
            }
        } else if (object == this.scaleYText) {
            try {
                this.scaleY = Integer.parseInt(this.scaleYText.getText());
                JDUtils.modified = true;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid number", "Error", 0);
            }
        } else if (object == this.scaleRText) {
            try {
                this.rotatableAngle = Double.parseDouble(this.scaleRText.getText());
                JDUtils.modified = true;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid number", "Error", 0);
            }
        } else if (object == this.rot90CheckBox) {
            this.angle = 90;
            JDUtils.modified = true;
        } else if (object == this.rot180CheckBox) {
            this.angle = 180;
            JDUtils.modified = true;
        } else if (object == this.rot270CheckBox) {
            this.angle = 270;
            JDUtils.modified = true;
        } else if (object == this.resetTransformBtn) {
            this.scaleX = 100;
            this.scaleY = 100;
            this.transX = 0;
            this.transY = 0;
            this.angle = 0;
        } else if (object == this.dismissBtn) {
            ATKGraphicsUtils.getWindowForComponent(this).setVisible(false);
        }
        this.updateTransform();
        this.repaintObjects();
        this.updateControls();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.isUpdating) {
            return;
        }
        this.initRepaint();
        this.initTransform();
        Object object = changeEvent.getSource();
        if (object == this.scaleXSlider) {
            this.scaleX = this.scaleXSlider.getValue();
            if (this.scaleRatioCheckBox.isSelected()) {
                this.scaleY = this.scaleX;
            }
            JDUtils.modified = true;
        } else if (object == this.scaleYSlider) {
            this.scaleY = this.scaleYSlider.getValue();
            if (this.scaleRatioCheckBox.isSelected()) {
                this.scaleX = this.scaleY;
            }
            JDUtils.modified = true;
        } else if (object == this.scaleRSlider) {
            this.rotatableAngle = this.scaleRSlider.getValue();
            JDUtils.modified = true;
        }
        this.updateTransform();
        this.repaintObjects();
        this.updateControls();
    }
}

