/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import com.braju.format.Format;
import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.util.ATKField;
import fr.esrf.tangoatk.widget.util.XORCaret;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.PlainDocument;

public class ATKNumberField
extends ATKField {
    protected boolean wheelSwitchEnabled = true;
    protected INumberScalar model;
    protected Color bg;
    protected boolean insertOK = false;

    public void setText(Number number) {
        Object[] objectArray = new Object[]{number};
        if (this.userFormat != null) {
            this.insertOK = true;
            super.setText(this.userFormat.format(number));
            this.insertOK = false;
            return;
        }
        if (this.format.indexOf(37) == -1) {
            super.setText(AttrManip.format((String)this.format, (double)number.doubleValue()));
            return;
        }
        super.setText(Format.sprintf((String)this.format, (Object[])objectArray));
    }

    public void setValue(Number number) {
        if (this.isEditable() && this.receivedEvent) {
            return;
        }
        this.receivedEvent = true;
        int n = this.getCaret().getDot();
        this.setText(number);
        this.getCaret().setDot(n);
    }

    public Number getValue() {
        return new Double(this.getText());
    }

    public void setModel(INumberScalar iNumberScalar) {
        this.model = iNumberScalar;
        this.receivedEvent = false;
        this.modelEditable = this.model.isWritable();
        super.setEditable(this.editable && this.modelEditable);
        Number number = this.model.getNumber();
        if (number == null) {
            return;
        }
        this.init();
        this.setValue(number);
    }

    private void init() {
        this.setText(this.error);
        this.bg = this.getBackground();
        this.setHorizontalAlignment(4);
        if (!this.isEditable()) {
            return;
        }
        this.setCaret(new XORCaret());
        Keymap keymap = this.getKeymap();
        Keymap keymap2 = JTextComponent.addKeymap("wheelmap", keymap);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(40, 0, false);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(37, 0, false);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(39, 0, false);
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(87, 2, false);
        keymap2.addActionForKeyStroke(keyStroke, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATKNumberField.this.upStroke(actionEvent);
            }
        });
        keymap2.addActionForKeyStroke(keyStroke2, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATKNumberField.this.downStroke(actionEvent);
            }
        });
        keymap2.addActionForKeyStroke(keyStroke3, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATKNumberField.this.leftStroke(actionEvent);
            }
        });
        keymap2.addActionForKeyStroke(keyStroke4, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATKNumberField.this.rightStroke(actionEvent);
            }
        });
        keymap2.addActionForKeyStroke(keyStroke5, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ATKNumberField.this.setWheelSwitchEnabled(!ATKNumberField.this.isWheelSwitchEnabled());
            }
        });
        this.setKeymap(keymap2);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                ATKNumberField.this.getCaret().paint(ATKNumberField.this.getGraphics());
            }
        });
    }

    protected void enter(ActionEvent actionEvent) {
        this.inserting = false;
        this.newValue(this.getValue());
    }

    protected void newValue(Number number) {
        try {
            this.model.setNumber(number);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setText(this.model.getNumber());
        }
    }

    public void setWheelSwitchEnabled(boolean bl) {
        this.wheelSwitchEnabled = bl;
        if (bl) {
            this.setToolTipText("Wheel switch enabled, use arrow up or arrow down to adjust the values");
        } else {
            this.setToolTipText("Wheel switch disabled, press C-w to enable");
        }
    }

    public boolean isWheelSwitchEnabled() {
        return this.wheelSwitchEnabled;
    }

    protected double getFactor() {
        int n = this.getCaret().getDot();
        int n2 = this.getText().indexOf(46);
        if (n2 == n) {
            return 0.0;
        }
        int n3 = this.getText().indexOf(45);
        if (n3 == n) {
            return 0.0;
        }
        n3 = this.getText().indexOf(43);
        if (n3 == n) {
            return 0.0;
        }
        n = n2 == -1 ? this.getText().length() - n : n2 - n;
        if (n > 0) {
            --n;
        }
        return Math.pow(10.0, n);
    }

    protected void downStroke(ActionEvent actionEvent) {
        if (!this.isWheelSwitchEnabled()) {
            return;
        }
        this.changeValue(-1);
    }

    protected void upStroke(ActionEvent actionEvent) {
        if (!this.isWheelSwitchEnabled()) {
            return;
        }
        this.changeValue(1);
    }

    protected void leftStroke(ActionEvent actionEvent) {
        this.moveLeft();
    }

    protected void rightStroke(ActionEvent actionEvent) {
        this.moveRight();
    }

    protected void moveRight() {
        int n = this.getCaret().getDot();
        int n2 = this.getText().indexOf(46);
        if (n2 == ++n) {
            ++n;
        }
        if (n >= this.getText().length()) {
            return;
        }
        this.getCaret().setDot(n);
    }

    protected void moveLeft() {
        int n = this.getCaret().getDot();
        int n2 = this.getText().indexOf(46);
        if (n2 == --n) {
            --n;
        }
        if (n < 0) {
            return;
        }
        this.getCaret().setDot(n);
    }

    protected void changeValue(int n) {
        double d = this.getFactor() * (double)n;
        int n2 = this.getCaret().getDot();
        int n3 = this.getText().indexOf(46);
        this.setText(new Double(Double.parseDouble(this.getText()) + d).toString());
        int n4 = this.getText().indexOf(46);
        n2 = n2 + n4 - n3;
        this.getCaret().setDot(n2);
        this.newValue(this.getValue());
    }

    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        ATKNumberField aTKNumberField = new ATKNumberField();
        aTKNumberField.setFont(new Font("Times", 1, 60));
        jFrame.setContentPane(aTKNumberField);
        jFrame.pack();
        jFrame.show();
    }

    class NumberDocument
    extends PlainDocument {
        NumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            try {
                if (ATKNumberField.this.insertOK) {
                    super.insertString(0, string, attributeSet);
                    return;
                }
                if (string.equals(ATKNumberField.this.error)) {
                    super.insertString(0, string, attributeSet);
                    return;
                }
                if (string.equals("-") || string.equals("+")) {
                    this.remove(0, this.getLength());
                    super.insertString(0, string, attributeSet);
                    ATKNumberField.this.inserting = true;
                    return;
                }
                if (string.equals(".")) {
                    int n2 = ATKNumberField.this.getText().indexOf(".");
                    if (n2 != -1) {
                        this.remove(n2, 1);
                        if (n2 < n) {
                            --n;
                        }
                    }
                    super.insertString(n, string, attributeSet);
                    return;
                }
                Double.parseDouble(string);
                if (ATKNumberField.this.inserting) {
                    super.insertString(n, string, attributeSet);
                } else {
                    ATKNumberField.this.inserting = true;
                    this.remove(0, this.getLength());
                    super.insertString(0, string, attributeSet);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

