/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import fr.esrf.tangoatk.widget.attribute.NumberScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.attribute.StringScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.StringScalarEditor;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ScalarListViewer
extends JPanel
implements JAutoScrolledTextListener {
    public static final String NUMBER_DEFAULT_SETTER = "WheelEditor";
    public static final String NUMBER_COMBO_SETTER = "ComboEditor";
    public static final String STRING_DEFAULT_SETTER = "StringScalarEditor";
    public static final String STRING_COMBO_SETTER = "StringComboEditor";
    private Vector listModel = null;
    private Vector scalarLabels = null;
    private Vector scalarViewers = null;
    private Vector scalarSetters = null;
    private Vector scalarPropButtons = null;
    private SimplePropertyFrame propFrame = new SimplePropertyFrame();
    private Font theFont = new Font("Dialog", 0, 14);
    private boolean labelVisible = true;
    private boolean setterVisible = true;
    private boolean propertyButtonVisible = true;
    private boolean propertyListEditable = true;
    private boolean unitVisible = true;
    private String numberSetterType = "WheelEditor";
    private String stringSetterType = "StringScalarEditor";
    private Color arrowColor = null;

    public ScalarListViewer() {
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
    }

    public void setModel(AttributeList attributeList) {
        if (attributeList == null) {
            if (this.listModel != null) {
                this.removeComponents();
            }
            return;
        }
        if (this.listModel != null) {
            return;
        }
        int n = attributeList.getSize();
        if (n <= 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Object object = attributeList.getElementAt(i);
            if (!(object instanceof INumberScalar) && !(object instanceof IStringScalar) && !(object instanceof IBooleanScalar)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        this.initComponents(attributeList);
        this.setVisible(true);
    }

    private void removeComponents() {
        Object var3_1 = null;
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        StringScalarEditor stringScalarEditor = null;
        StringScalarComboEditor stringScalarComboEditor = null;
        Object var14_9 = null;
        this.propFrame = null;
        this.propFrame = new SimplePropertyFrame();
        int n = this.listModel.size();
        for (int i = 0; i < n; ++i) {
            try {
                INumberScalar iNumberScalar = null;
                IStringScalar iStringScalar = null;
                IBooleanScalar iBooleanScalar = null;
                var3_1 = this.listModel.get(i);
                if (var3_1 instanceof INumberScalar) {
                    iNumberScalar = var3_1;
                } else if (var3_1 instanceof IStringScalar) {
                    iStringScalar = var3_1;
                } else if (var3_1 instanceof IBooleanScalar) {
                    iBooleanScalar = var3_1;
                }
                if (iNumberScalar == null && iStringScalar == null && iBooleanScalar == null) continue;
                var3_1 = this.scalarLabels.get(i);
                if (var3_1 instanceof LabelViewer) {
                    labelViewer = var3_1;
                    labelViewer.setModel(null);
                }
                if ((var3_1 = this.scalarViewers.get(i)) instanceof SimpleScalarViewer) {
                    simpleScalarViewer = var3_1;
                    simpleScalarViewer.clearModel();
                } else if (var3_1 instanceof BooleanScalarCheckBoxViewer) {
                    booleanScalarCheckBoxViewer = var3_1;
                    booleanScalarCheckBoxViewer.clearModel();
                }
                var3_1 = this.scalarSetters.get(i);
                if (var3_1 == null) continue;
                if (var3_1 instanceof NumberScalarWheelEditor) {
                    numberScalarWheelEditor = var3_1;
                    if (iNumberScalar == null || !iNumberScalar.isWritable()) continue;
                    numberScalarWheelEditor.setModel(null);
                    continue;
                }
                if (var3_1 instanceof NumberScalarComboEditor) {
                    numberScalarComboEditor = var3_1;
                    if (iNumberScalar == null || !iNumberScalar.isWritable()) continue;
                    numberScalarComboEditor.setNumberModel(null);
                    continue;
                }
                if (var3_1 instanceof StringScalarEditor) {
                    stringScalarEditor = var3_1;
                    if (iStringScalar == null || !iStringScalar.isWritable()) continue;
                    stringScalarEditor.setModel(null);
                    continue;
                }
                if (!(var3_1 instanceof StringScalarComboEditor)) continue;
                stringScalarComboEditor = var3_1;
                if (iStringScalar == null || !iStringScalar.isWritable()) continue;
                stringScalarComboEditor.setStringModel(null);
                continue;
            }
            catch (Exception exception) {
                System.out.println("NumberScalarListViewer : setTheFont : Caught exception  " + exception.getMessage());
            }
        }
        this.scalarLabels.removeAllElements();
        this.scalarViewers.removeAllElements();
        this.scalarSetters.removeAllElements();
        this.scalarPropButtons.removeAllElements();
        this.listModel.removeAllElements();
        this.removeAll();
        this.listModel = null;
        this.scalarLabels = null;
        this.scalarViewers = null;
        this.scalarSetters = null;
        this.scalarPropButtons = null;
    }

    public Font getTheFont() {
        return this.theFont;
    }

    public void setTheFont(Font font) {
        Object var4_2 = null;
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = null;
        Object var8_6 = null;
        Object var9_7 = null;
        JButton jButton = null;
        JComponent jComponent = null;
        if (font != null) {
            this.theFont = font;
            if (this.listModel != null) {
                int n = this.listModel.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        var4_2 = this.scalarLabels.get(i);
                        if (var4_2 instanceof LabelViewer) {
                            labelViewer = var4_2;
                            labelViewer.setFont(this.theFont);
                        }
                        if ((var4_2 = this.scalarViewers.get(i)) instanceof SimpleScalarViewer) {
                            simpleScalarViewer = var4_2;
                            simpleScalarViewer.setFont(this.theFont);
                        } else if (var4_2 instanceof BooleanScalarCheckBoxViewer) {
                            booleanScalarCheckBoxViewer = var4_2;
                            booleanScalarCheckBoxViewer.setFont(this.theFont);
                        }
                        var4_2 = this.scalarSetters.get(i);
                        if (var4_2 != null && (var4_2 instanceof NumberScalarWheelEditor || var4_2 instanceof NumberScalarComboEditor || var4_2 instanceof StringScalarEditor || var4_2 instanceof StringScalarComboEditor)) {
                            jComponent = var4_2;
                            jComponent.setFont(this.theFont);
                        }
                        if (!((var4_2 = this.scalarPropButtons.get(i)) instanceof JButton)) continue;
                        jButton = var4_2;
                        jButton.setFont(this.theFont);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("ScalarListViewer : setTheFont : Caught exception  " + exception.getMessage());
                    }
                }
            }
        }
    }

    public boolean getLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean bl) {
        if (this.labelVisible != bl) {
            this.labelVisible = bl;
            this.changeLabelVisibility();
        }
    }

    private void changeLabelVisibility() {
        Object var3_1 = null;
        LabelViewer labelViewer = null;
        if (this.scalarLabels != null) {
            int n = this.scalarLabels.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.scalarLabels.get(i);
                    if (!(var3_1 instanceof LabelViewer)) continue;
                    labelViewer = var3_1;
                    labelViewer.setVisible(this.labelVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changeLabelVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getSetterVisible() {
        return this.setterVisible;
    }

    public void setSetterVisible(boolean bl) {
        if (this.setterVisible != bl) {
            this.setterVisible = bl;
            this.changeSetterVisibility();
        }
    }

    private void changeSetterVisibility() {
        Object var3_1 = null;
        Object var4_2 = null;
        Object var5_3 = null;
        JComponent jComponent = null;
        if (this.scalarSetters != null) {
            int n = this.scalarSetters.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.scalarSetters.get(i);
                    if (var3_1 == null || !(var3_1 instanceof NumberScalarWheelEditor) && !(var3_1 instanceof NumberScalarComboEditor) && !(var3_1 instanceof StringScalarEditor) && !(var3_1 instanceof StringScalarComboEditor)) continue;
                    jComponent = var3_1;
                    jComponent.setVisible(this.setterVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changeSetterVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyButtonVisible() {
        return this.propertyButtonVisible;
    }

    public void setPropertyButtonVisible(boolean bl) {
        if (this.propertyButtonVisible != bl) {
            this.propertyButtonVisible = bl;
            this.changePropButtonVisibility();
        }
    }

    private void changePropButtonVisibility() {
        Object var3_1 = null;
        JButton jButton = null;
        if (this.scalarPropButtons != null) {
            int n = this.scalarPropButtons.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.scalarPropButtons.get(i);
                    if (!(var3_1 instanceof JButton)) continue;
                    jButton = var3_1;
                    jButton.setVisible(this.propertyButtonVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changePropButtonVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyListEditable() {
        return this.propertyListEditable;
    }

    public void setPropertyListEditable(boolean bl) {
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean bl) {
        if (this.unitVisible != bl) {
            this.unitVisible = bl;
            this.changeUnitVisibility();
        }
    }

    private void changeUnitVisibility() {
        Object var3_1 = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        if (this.scalarViewers != null) {
            int n = this.scalarViewers.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var3_1 = this.scalarViewers.get(i);
                    if (var3_1 instanceof SimpleScalarViewer) {
                        simpleScalarViewer = var3_1;
                        simpleScalarViewer.setUnitVisible(this.unitVisible);
                    }
                    if ((var3_1 = this.scalarSetters.get(i)) == null || !(var3_1 instanceof NumberScalarComboEditor)) continue;
                    numberScalarComboEditor = var3_1;
                    numberScalarComboEditor.setUnitVisible(this.unitVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changeUnitVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public String getNumberSetterType() {
        return this.numberSetterType;
    }

    public void setNumberSetterType(String string) {
        if (this.listModel != null) {
            return;
        }
        this.numberSetterType = string.equalsIgnoreCase(NUMBER_DEFAULT_SETTER) ? NUMBER_DEFAULT_SETTER : (string.equalsIgnoreCase(NUMBER_COMBO_SETTER) ? NUMBER_COMBO_SETTER : NUMBER_DEFAULT_SETTER);
    }

    public String getStringSetterType() {
        return this.stringSetterType;
    }

    public void setStringSetterType(String string) {
        if (this.listModel != null) {
            return;
        }
        this.stringSetterType = string.equalsIgnoreCase(STRING_DEFAULT_SETTER) ? STRING_DEFAULT_SETTER : (string.equalsIgnoreCase(STRING_COMBO_SETTER) ? STRING_COMBO_SETTER : STRING_DEFAULT_SETTER);
    }

    public Color getArrowColor() {
        if (this.arrowColor == null) {
            return this.getBackground();
        }
        return this.arrowColor;
    }

    public void setArrowColor(Color color) {
        if (color == this.arrowColor) {
            return;
        }
        this.changeArrowColors(color);
        this.arrowColor = color;
    }

    private void changeArrowColors(Color color) {
        Object var4_2 = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        if (this.scalarSetters != null) {
            int n = this.scalarSetters.size();
            for (int i = 0; i < n; ++i) {
                try {
                    var4_2 = this.scalarSetters.get(i);
                    if (!(var4_2 instanceof NumberScalarWheelEditor)) continue;
                    numberScalarWheelEditor = var4_2;
                    if (color == null) {
                        numberScalarWheelEditor.setButtonColor(numberScalarWheelEditor.getBackground());
                        continue;
                    }
                    numberScalarWheelEditor.setButtonColor(color);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ScalarListViewer : changeArrowColors : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public void textExceedBounds(JAutoScrolledText jAutoScrolledText) {
        this.revalidate();
    }

    public void setCheckBoxStrings(IBooleanScalar iBooleanScalar, String string, String string2) {
        int n = -1;
        Object var5_5 = null;
        if (iBooleanScalar == null) {
            return;
        }
        if (this.listModel == null) {
            return;
        }
        n = this.listModel.indexOf(iBooleanScalar);
        if (n < 0) {
            return;
        }
        var5_5 = this.scalarViewers.get(n);
        if (var5_5 == null) {
            return;
        }
        if (!(var5_5 instanceof BooleanScalarCheckBoxViewer)) {
            return;
        }
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = var5_5;
        if (string == null) {
            booleanScalarCheckBoxViewer.setTrueLabel(new String());
        } else {
            booleanScalarCheckBoxViewer.setTrueLabel(string);
        }
        if (string2 == null) {
            booleanScalarCheckBoxViewer.setFalseLabel(new String());
        } else {
            booleanScalarCheckBoxViewer.setFalseLabel(string2);
        }
        this.revalidate();
    }

    private void initComponents(AttributeList attributeList) {
        int n;
        Object object;
        int n2;
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        BooleanScalarCheckBoxViewer booleanScalarCheckBoxViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        StringScalarEditor stringScalarEditor = null;
        StringScalarComboEditor stringScalarComboEditor = null;
        JComponent jComponent = null;
        JComponent jComponent2 = null;
        JButton jButton = null;
        this.listModel = new Vector();
        this.scalarLabels = new Vector();
        this.scalarViewers = new Vector();
        this.scalarSetters = new Vector();
        this.scalarPropButtons = new Vector();
        int n3 = 0;
        int n4 = attributeList.size();
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            labelViewer = null;
            jComponent = null;
            booleanScalarCheckBoxViewer = null;
            simpleScalarViewer = null;
            numberScalarWheelEditor = null;
            numberScalarComboEditor = null;
            jComponent2 = null;
            stringScalarEditor = null;
            stringScalarComboEditor = null;
            jButton = null;
            object = attributeList.getElementAt(n2);
            if (!(object instanceof INumberScalar) && !(object instanceof IStringScalar) && !(object instanceof IBooleanScalar)) continue;
            INumberScalar iNumberScalar = null;
            IStringScalar iStringScalar = null;
            IBooleanScalar iBooleanScalar = null;
            if (object instanceof INumberScalar) {
                simpleScalarViewer = new SimpleScalarViewer();
                jComponent = simpleScalarViewer;
                iNumberScalar = (INumberScalar)object;
                if (this.numberSetterType.equalsIgnoreCase(NUMBER_COMBO_SETTER)) {
                    numberScalarComboEditor = new NumberScalarComboEditor();
                    numberScalarComboEditor.setFont(this.theFont);
                    numberScalarComboEditor.setBackground(this.getBackground());
                    numberScalarComboEditor.setUnitVisible(this.unitVisible);
                    if (iNumberScalar.isWritable()) {
                        numberScalarComboEditor.setNumberModel(iNumberScalar);
                        if (this.setterVisible) {
                            numberScalarComboEditor.setVisible(true);
                        } else {
                            numberScalarComboEditor.setVisible(false);
                        }
                    } else {
                        numberScalarComboEditor.setVisible(false);
                    }
                    this.scalarSetters.add(numberScalarComboEditor);
                    jComponent2 = numberScalarComboEditor;
                } else {
                    numberScalarWheelEditor = new NumberScalarWheelEditor();
                    numberScalarWheelEditor.setFont(this.theFont);
                    numberScalarWheelEditor.setBackground(this.getBackground());
                    if (iNumberScalar.isWritable()) {
                        numberScalarWheelEditor.setModel(iNumberScalar);
                        if (this.setterVisible) {
                            numberScalarWheelEditor.setVisible(true);
                        } else {
                            numberScalarWheelEditor.setVisible(false);
                        }
                    } else {
                        numberScalarWheelEditor.setVisible(false);
                    }
                    this.scalarSetters.add(numberScalarWheelEditor);
                    jComponent2 = numberScalarWheelEditor;
                }
            } else if (object instanceof IBooleanScalar) {
                iBooleanScalar = (IBooleanScalar)object;
                booleanScalarCheckBoxViewer = new BooleanScalarCheckBoxViewer();
                booleanScalarCheckBoxViewer.setTrueLabel(new String());
                booleanScalarCheckBoxViewer.setFalseLabel(new String());
                jComponent = booleanScalarCheckBoxViewer;
                jComponent2 = null;
                this.scalarSetters.add(jComponent2);
            } else {
                simpleScalarViewer = new SimpleScalarViewer();
                jComponent = simpleScalarViewer;
                iStringScalar = (IStringScalar)object;
                if (this.stringSetterType.equalsIgnoreCase(STRING_COMBO_SETTER)) {
                    stringScalarComboEditor = new StringScalarComboEditor();
                    stringScalarComboEditor.setFont(this.theFont);
                    if (iStringScalar.isWritable()) {
                        stringScalarComboEditor.setStringModel(iStringScalar);
                        if (this.setterVisible) {
                            stringScalarComboEditor.setVisible(true);
                        } else {
                            stringScalarComboEditor.setVisible(false);
                        }
                    } else {
                        stringScalarComboEditor.setVisible(false);
                    }
                    this.scalarSetters.add(stringScalarComboEditor);
                    jComponent2 = stringScalarComboEditor;
                } else {
                    stringScalarEditor = new StringScalarEditor();
                    stringScalarEditor.setFont(this.theFont);
                    if (iStringScalar.isWritable()) {
                        stringScalarEditor.setModel(iStringScalar);
                        if (this.setterVisible) {
                            stringScalarEditor.setVisible(true);
                        } else {
                            stringScalarEditor.setVisible(false);
                        }
                    } else {
                        stringScalarEditor.setVisible(false);
                    }
                    this.scalarSetters.add(stringScalarEditor);
                    jComponent2 = stringScalarEditor;
                }
            }
            labelViewer = new LabelViewer();
            jButton = new JButton();
            labelViewer.setFont(this.theFont);
            labelViewer.setHorizontalAlignment(JSmoothLabel.RIGHT_ALIGNMENT);
            labelViewer.setBackground(this.getBackground());
            if (this.labelVisible) {
                labelViewer.setVisible(true);
            } else {
                labelViewer.setVisible(false);
            }
            if (iNumberScalar != null) {
                labelViewer.setModel((IAttribute)iNumberScalar);
            } else if (iStringScalar != null) {
                labelViewer.setModel((IAttribute)iStringScalar);
            } else if (iBooleanScalar != null) {
                labelViewer.setModel((IAttribute)iBooleanScalar);
            }
            if (simpleScalarViewer != null) {
                simpleScalarViewer.setFont(this.theFont);
                simpleScalarViewer.setUnitVisible(this.unitVisible);
                simpleScalarViewer.setBackgroundColor(this.getBackground());
                simpleScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
                simpleScalarViewer.setAlarmEnabled(true);
                if (iNumberScalar != null) {
                    simpleScalarViewer.setModel(iNumberScalar);
                } else {
                    simpleScalarViewer.setModel(iStringScalar);
                }
            } else if (booleanScalarCheckBoxViewer != null) {
                booleanScalarCheckBoxViewer.setAttModel(iBooleanScalar);
            }
            jButton.setFont(this.theFont);
            jButton.setBackground(this.getBackground());
            jButton.setText(" ... ");
            jButton.setMargin(new Insets(-3, 0, 3, 0));
            if (!this.propertyButtonVisible && jButton != null) {
                jButton.setVisible(false);
            }
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScalarListViewer.this.propertyButtonActionPerformed(actionEvent);
                }
            });
            if (iNumberScalar != null) {
                iNumberScalar.refresh();
            } else if (iStringScalar != null) {
                iStringScalar.refresh();
            } else if (iBooleanScalar != null) {
                iBooleanScalar.refresh();
            }
            if (simpleScalarViewer != null) {
                simpleScalarViewer.addTextListener(this);
            }
            if ((n = labelViewer.getPreferredSize().height) > n5) {
                n5 = n;
            }
            if ((n = jComponent.getPreferredSize().height) > n5) {
                n5 = n;
            }
            if (jComponent2 != null && (n = jComponent2.getPreferredSize().height) > n5) {
                n5 = n;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(1, 5, 1, 1);
            this.add((Component)labelViewer, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(1, 2, 1, 1);
            this.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.fill = 1;
            if (jComponent2 != null) {
                if (iNumberScalar != null) {
                    gridBagConstraints.insets = new Insets(1, 1, 1, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                } else if (iStringScalar != null) {
                    gridBagConstraints.insets = new Insets(1, 3, 1, 1);
                    this.add((Component)jComponent2, gridBagConstraints);
                }
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.insets = new Insets(1, 3, 1, 5);
            this.add((Component)jButton, gridBagConstraints);
            if (iNumberScalar != null) {
                this.listModel.add(iNumberScalar);
            } else if (iStringScalar != null) {
                this.listModel.add(iStringScalar);
            } else if (iBooleanScalar != null) {
                this.listModel.add(iBooleanScalar);
            }
            this.scalarLabels.add(labelViewer);
            this.scalarViewers.add(jComponent);
            this.scalarPropButtons.add(jButton);
            ++n3;
        }
        int n6 = this.scalarViewers.size();
        for (n2 = 0; n2 < n6; ++n2) {
            Insets insets;
            int n7;
            object = this.scalarViewers.get(n2);
            if (object instanceof SimpleScalarViewer) {
                simpleScalarViewer = (SimpleScalarViewer)object;
                n = simpleScalarViewer.getPreferredSize().height;
                if (n < n5) {
                    n7 = (n5 - n) / 2;
                    insets = simpleScalarViewer.getMargin();
                    insets.top += n7;
                    insets.bottom += n7;
                    simpleScalarViewer.setMargin(insets);
                }
            }
            if ((object = this.scalarSetters.get(n2)) == null || !(object instanceof StringScalarEditor)) continue;
            stringScalarEditor = (StringScalarEditor)object;
            n = stringScalarEditor.getPreferredSize().height;
            if (n >= n5) continue;
            n7 = (n5 - n) / 2;
            insets = stringScalarEditor.getMargin();
            insets.top += n7;
            insets.bottom += n7;
            stringScalarEditor.setMargin(insets);
            stringScalarEditor.setMargin(new Insets(n7, 3, n7 + 2, 3));
        }
    }

    private void propertyButtonActionPerformed(ActionEvent actionEvent) {
        Object e;
        int n = -1;
        if (this.scalarPropButtons == null) {
            return;
        }
        if (this.listModel == null) {
            return;
        }
        int n2 = this.scalarPropButtons.size();
        for (int i = 0; i < n2; ++i) {
            try {
                JButton jButton;
                e = this.scalarPropButtons.get(i);
                if (!(e instanceof JButton) || !(jButton = (JButton)e).equals(actionEvent.getSource())) continue;
                n = i;
                break;
            }
            catch (Exception exception) {
                System.out.println("ScalarListViewer : propertyButtonActionPerformed : Caught exception  " + exception.getMessage());
                return;
            }
        }
        if (n < 0) {
            return;
        }
        INumberScalar iNumberScalar = null;
        IStringScalar iStringScalar = null;
        IBooleanScalar iBooleanScalar = null;
        try {
            e = this.listModel.get(n);
            if (e instanceof INumberScalar) {
                iNumberScalar = (INumberScalar)e;
            } else if (e instanceof IStringScalar) {
                iStringScalar = (IStringScalar)e;
            } else if (e instanceof IBooleanScalar) {
                iBooleanScalar = (IBooleanScalar)e;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iNumberScalar == null && iStringScalar == null && iBooleanScalar == null) {
            return;
        }
        if (this.propFrame != null) {
            if (iNumberScalar != null) {
                this.propFrame.setModel((IAttribute)iNumberScalar);
            } else if (iStringScalar != null) {
                this.propFrame.setModel((IAttribute)iStringScalar);
            } else {
                this.propFrame.setModel((IAttribute)iBooleanScalar);
            }
            this.propFrame.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        final AttributeList attributeList = new AttributeList();
        ScalarListViewer scalarListViewer = new ScalarListViewer();
        try {
            IBooleanScalar iBooleanScalar;
            INumberScalar iNumberScalar = (INumberScalar)attributeList.add("sy/d-tm/profile/Average");
            iNumberScalar = (INumberScalar)attributeList.add("sy/d-tm/profile/ShakerStrength");
            iNumberScalar = (INumberScalar)attributeList.add("sy/d-tm/profile/SpectrumIndex");
            IStringScalar iStringScalar = (IStringScalar)attributeList.add("sy/d-tm/profile/MeasurementPlane");
            iStringScalar = (IStringScalar)attributeList.add("sy/d-tm/profile/ShakerMode");
            IBooleanScalar iBooleanScalar2 = iBooleanScalar = (IBooleanScalar)attributeList.add("sy/d-tm/profile/Complement");
            if (iBooleanScalar2 != null) {
                System.out.println("attcomp != null");
            }
            IBooleanScalar iBooleanScalar3 = iBooleanScalar = (IBooleanScalar)attributeList.add("sy/d-tm/profile/ReferenceSubstraction");
            scalarListViewer.setModel(attributeList);
            scalarListViewer.setCheckBoxStrings(iBooleanScalar2, "comp", null);
            scalarListViewer.setCheckBoxStrings(iBooleanScalar3, "Pulsed", "W Noise");
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                attributeList.startRefresher();
            }
        });
        jFrame.setContentPane(scalarListViewer);
        jFrame.pack();
        jFrame.show();
    }
}

