/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.AccessProxy;
import admin.astor.access.EditTreeItem;
import admin.astor.access.TreePopupMenu;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UsersTree
extends JTree
implements TangoConst {
    static final int USER = -2;
    static final int COLLECTION = -1;
    static final int ADDRESS = 0;
    static final int DEVICE = 1;
    static final String[] collecStr = new String[]{"Allowed Addresses", "Devices"};
    static final int WRITE = 0;
    static final int READ = 1;
    static final String[] rightsStr = new String[]{"write", "read"};
    private static final String img_path = "/app_util/img/";
    static ImageIcon tango_icon;
    static ImageIcon user_icon;
    static ImageIcon add_icon;
    static ImageIcon dev_icon;
    static ImageIcon write_icon;
    static ImageIcon read_icon;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private TreePopupMenu menu;
    private JFrame parent;
    private AccessProxy access_dev;
    CopiedAddresses copied_addresses = new CopiedAddresses();
    CopiedDevices copied_devices = new CopiedDevices();
    private Vector v_users = new Vector();
    private boolean manage_expand = true;
    EditTreeItem edit_item;

    public UsersTree(JFrame parent, AccessProxy access_dev) throws DevFailed {
        this.parent = parent;
        this.access_dev = access_dev;
        this.buildTree();
        this.menu = new TreePopupMenu(this);
    }

    private void buildTree() throws DevFailed {
        String str_root = "Tango Control Access";
        try {
            str_root = ApiUtil.get_db_obj().get_tango_host() + "  Control Access";
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        this.root = new DefaultMutableTreeNode(str_root);
        this.createUserNodes();
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
            }

            public void treeExpanded(TreeExpansionEvent e) {
                UsersTree.this.expandedPerfomed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                UsersTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) < 1) {
            return;
        }
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object o = node.getUserObject();
        int mask = evt.getModifiers();
        if (evt.getClickCount() == 2 && (mask & 0x10) != 0) {
            if (o instanceof AcAddress || o instanceof AcDevice) {
                this.editItem();
            }
        } else if ((mask & 4) != 0) {
            if (o instanceof AcAddress) {
                this.menu.showMenu(evt, 0, o);
            } else if (o instanceof AcDevice) {
                this.menu.showMenu(evt, 1, o);
            } else if (o instanceof String) {
                switch (selectedPath.getPath().length) {
                    case 2: {
                        this.menu.showMenu(evt, -2, o);
                        break;
                    }
                    case 3: {
                        this.menu.showMenu(evt, -1, o);
                    }
                }
            }
        }
    }

    public void expandedPerfomed(TreeExpansionEvent evt) {
        if (!this.manage_expand) {
            return;
        }
        TreePath tp = evt.getPath();
        Object[] path = tp.getPath();
        if (path.length < 3) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getPathComponent(path.length - 1);
        switch (path.length) {
            case 3: {
                if (node.toString().equals(collecStr[0])) {
                    this.createAddressNodes(node);
                    break;
                }
                this.createDeviceNodes(node);
            }
        }
    }

    private void createDeviceNodes(DefaultMutableTreeNode node) {
        try {
            String user = node.getParent().toString();
            AcDevice[] devices = this.getDevices(user);
            for (int i = 0; i < devices.length; ++i) {
                DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(devices[i]);
                this.treeModel.insertNodeInto(d_node, node, i);
            }
            this.removePreviousNode(node, devices.length);
        }
        catch (DevFailed e) {
            this.removePreviousNode(node, 0);
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Cannot read devices", (DevFailed)e);
        }
    }

    private void createAddressNodes(DefaultMutableTreeNode node) {
        try {
            String user = node.getParent().toString();
            String[] addresses = this.access_dev.getAddressesByUser(user);
            if (!this.createChildNodes(node, addresses)) {
                return;
            }
            for (int i = 0; i < addresses.length; ++i) {
                DefaultMutableTreeNode a_node = new DefaultMutableTreeNode(new AcAddress(addresses[i]));
                this.treeModel.insertNodeInto(a_node, node, i);
            }
            this.removePreviousNode(node, addresses.length);
        }
        catch (DevFailed e) {
            this.removePreviousNode(node, 0);
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Cannot read addresses", (DevFailed)e);
        }
    }

    private void createUserNode(String name) {
        DefaultMutableTreeNode u_node = new DefaultMutableTreeNode(name);
        DefaultMutableTreeNode a_node = new DefaultMutableTreeNode(collecStr[0]);
        DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(collecStr[1]);
        a_node.add(new DefaultMutableTreeNode(new Dummy()));
        d_node.add(new DefaultMutableTreeNode(new Dummy()));
        u_node.add(a_node);
        u_node.add(d_node);
        this.root.add(u_node);
    }

    private void createUserNodes() throws DevFailed {
        int i;
        String[] users = this.access_dev.getUsers();
        for (i = 0; i < users.length; ++i) {
            this.v_users.add(users[i]);
        }
        for (i = 0; i < users.length; ++i) {
            this.createUserNode(users[i]);
        }
    }

    private boolean createChildNodes(DefaultMutableTreeNode node, String[] str) {
        boolean create = false;
        if (node.getChildCount() != str.length) {
            create = true;
        } else {
            for (int i = 0; i < str.length; ++i) {
                if (node.getChildAt(i).toString().equals(str[i])) continue;
                create = true;
            }
        }
        return create;
    }

    private void removePreviousNode(DefaultMutableTreeNode node, int offset) {
        while (node.getChildCount() > offset) {
            DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)node.getChildAt(offset);
            this.treeModel.removeNodeFromParent(leaf);
        }
    }

    private AcDevice[] getDevices(String user) throws DevFailed {
        String[] result = this.access_dev.getDevicesByUser(user);
        AcDevice[] ret = new AcDevice[result.length / 2];
        for (int i = 0; i < result.length / 2; ++i) {
            ret[i] = new AcDevice(result[2 * i], result[2 * i + 1]);
        }
        return ret;
    }

    DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    void addUserNode(String[] str) {
        String user = str[0];
        String address = str[1];
        String devname = "*/*/*";
        TreePath tp = null;
        boolean already_exists = false;
        for (int i = 0; !already_exists && i < this.v_users.size(); ++i) {
            if (!this.v_users.get(i).equals(user)) continue;
            already_exists = true;
            DefaultMutableTreeNode user_node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            Object[] path = new TreeNode[]{this.root, user_node, user_node.getChildAt(0), user_node.getChildAt(0).getChildAt(0)};
            tp = new TreePath(path);
            this.setSelectionPath(tp);
            path = new TreeNode[]{this.root, user_node};
            tp = new TreePath(path);
            this.setSelectionPath(tp);
            PopupError.show((Component)this.parent, "\u00dcser  " + user + "  Already exists !");
        }
        if (!already_exists) {
            try {
                this.access_dev.addAddress(user, address);
                this.access_dev.addDevice(user, devname, rightsStr[0]);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
            }
            Object[] path = new TreeNode[4];
            DefaultMutableTreeNode new_user_node = new DefaultMutableTreeNode(user);
            DefaultMutableTreeNode new_str_add_node = new DefaultMutableTreeNode(collecStr[0]);
            DefaultMutableTreeNode new_str_dev_node = new DefaultMutableTreeNode(collecStr[1]);
            DefaultMutableTreeNode new_add_node = new DefaultMutableTreeNode(new AcAddress(address));
            DefaultMutableTreeNode new_dev_node = new DefaultMutableTreeNode(new AcDevice(devname, 0));
            this.treeModel.insertNodeInto(new_user_node, this.root, this.root.getChildCount());
            this.treeModel.insertNodeInto(new_str_add_node, new_user_node, 0);
            this.treeModel.insertNodeInto(new_str_dev_node, new_user_node, 1);
            this.treeModel.insertNodeInto(new_add_node, new_str_add_node, 0);
            this.treeModel.insertNodeInto(new_dev_node, new_str_dev_node, 0);
            path[0] = this.root;
            path[1] = new_user_node;
            path[2] = new_str_add_node;
            path[3] = new_add_node;
            tp = new TreePath(path);
            this.setSelectionPath(tp);
            path[2] = new_str_dev_node;
            path[3] = new_dev_node;
            tp = new TreePath(path);
            this.setSelectionPath(tp);
        }
        this.scrollPathToVisible(tp);
    }

    /*
     * WARNING - void declaration
     */
    void addItem() {
        void var3_3;
        boolean obj_type;
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object o = node.getUserObject();
        if (o.toString().equals(collecStr[0])) {
            obj_type = false;
        } else if (o.toString().equals(collecStr[1])) {
            obj_type = true;
        } else {
            return;
        }
        Object[] path = new DefaultMutableTreeNode[4];
        path[0] = this.root;
        path[1] = node.getParent();
        path[2] = node;
        DefaultMutableTreeNode dummy_node = null;
        if (node.getChildCount() > 0) {
            path[3] = node.getChildAt(0);
        } else {
            dummy_node = new DefaultMutableTreeNode(new Dummy());
            this.treeModel.insertNodeInto(dummy_node, node, node.getChildCount());
            path[3] = dummy_node;
            this.manage_expand = false;
        }
        TreePath tp = new TreePath(path);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
        switch (var3_3) {
            case 0: {
                DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(new AcAddress("*.*.*.*"));
                this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                path[3] = new_node;
                tp = new TreePath(path);
                this.setSelectionPath(tp);
                this.scrollPathToVisible(tp);
                break;
            }
            case 1: {
                DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(new AcDevice("*/*/*", 0));
                this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                path[3] = new_node;
                tp = new TreePath(path);
                this.setSelectionPath(tp);
                this.scrollPathToVisible(tp);
                break;
            }
            default: {
                return;
            }
        }
        if (dummy_node != null) {
            this.treeModel.removeNodeFromParent(dummy_node);
        }
        this.manage_expand = true;
        if (!this.editItem()) {
            void var4_7;
            this.treeModel.removeNodeFromParent((MutableTreeNode)var4_7);
        }
    }

    boolean editItem() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return true;
        }
        Object o = node.getUserObject();
        int obj_type = o instanceof AcDevice ? 1 : 0;
        this.edit_item = new EditTreeItem((Frame)this.parent, this, node.toString(), obj_type);
        if (this.edit_item.showDlg()) {
            String user = node.getParent().getParent().toString();
            String new_name = this.edit_item.getInputs();
            try {
                switch (obj_type) {
                    case 0: {
                        AcAddress add = (AcAddress)o;
                        this.access_dev.removeAddress(user, add.name);
                        this.access_dev.addAddress(user, new_name);
                        add.name = new_name;
                        this.rebuildNode(node, add);
                        break;
                    }
                    case 1: {
                        AcDevice dev = (AcDevice)o;
                        this.access_dev.removeDevice(user, dev.name, rightsStr[dev.right]);
                        this.access_dev.addDevice(user, new_name, rightsStr[dev.right]);
                        dev.name = new_name;
                        this.rebuildNode(node, dev);
                    }
                }
                return true;
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
            }
        }
        return false;
    }

    private void rebuildNode(DefaultMutableTreeNode node, Object obj) {
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(obj);
        int idx = parent_node.getIndex(node);
        this.treeModel.insertNodeInto(new_node, parent_node, idx);
        this.treeModel.removeNodeFromParent(node);
    }

    void removeItem() {
        int obj_type;
        String message;
        String user;
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object o = node.getUserObject();
        if (o instanceof AcDevice) {
            user = node.getParent().getParent().toString();
            message = "Are you sure to want to remove this record";
            obj_type = 1;
        } else if (o instanceof AcAddress) {
            user = node.getParent().getParent().toString();
            message = "Are you sure to want to remove this record";
            obj_type = 0;
        } else {
            user = o.toString();
            obj_type = -2;
            message = "Are you sure to want to remove all records for " + o;
        }
        if (JOptionPane.showConfirmDialog(this, message, "Confirm Dialog", 0) != 0) {
            return;
        }
        try {
            switch (obj_type) {
                case 0: {
                    AcAddress add = (AcAddress)o;
                    this.access_dev.removeAddress(user, add.name);
                    break;
                }
                case 1: {
                    AcDevice dev = (AcDevice)o;
                    this.access_dev.removeDevice(user, dev.name, rightsStr[dev.right]);
                    break;
                }
                case -2: {
                    this.access_dev.removeUser(user);
                }
            }
            this.treeModel.removeNodeFromParent(node);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
        }
    }

    void cloneUser() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object o = node.getUserObject();
        if (o instanceof String) {
            String src_user = o.toString();
            String new_user = (String)JOptionPane.showInputDialog(this.parent, "New User name  ?", "Clone " + src_user + "  ?", 1, null, null, "");
            if (new_user == null) {
                return;
            }
            try {
                this.access_dev.cloneUser(src_user, new_user);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
                return;
            }
            DefaultMutableTreeNode u_node = new DefaultMutableTreeNode(new_user);
            DefaultMutableTreeNode a_node = new DefaultMutableTreeNode(collecStr[0]);
            DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(collecStr[1]);
            this.treeModel.insertNodeInto(a_node, u_node, 0);
            this.treeModel.insertNodeInto(d_node, u_node, 1);
            this.treeModel.insertNodeInto(u_node, this.root, this.root.getChildCount());
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(new Dummy()), a_node, 0);
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(new Dummy()), d_node, 0);
            Object[] path = new DefaultMutableTreeNode[]{this.root, u_node, a_node};
            TreePath tp = new TreePath(path);
            this.setSelectionPath(tp);
            this.scrollPathToVisible(tp);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void pasteItem() {
        boolean obj_type;
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object o = node.getUserObject();
        if (!(o instanceof String)) return;
        if (o.toString().equals(collecStr[1])) {
            obj_type = true;
        } else {
            if (!o.toString().equals(collecStr[0])) return;
            obj_type = false;
        }
        String user = node.getParent().toString();
        try {
            void var3_3;
            DefaultMutableTreeNode new_node = null;
            switch (var3_3) {
                case 0: {
                    String address = this.copied_addresses.addressAt((int)0).name;
                    this.access_dev.addAddress(user, address);
                    new_node = new DefaultMutableTreeNode(new AcAddress(address));
                    this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                    break;
                }
                case 1: {
                    String devname = this.copied_devices.deviceAt((int)0).name;
                    int right = this.copied_devices.deviceAt((int)0).right;
                    this.access_dev.addDevice(user, devname, rightsStr[right]);
                    new_node = new DefaultMutableTreeNode(new AcDevice(devname, right));
                    this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                }
            }
            Object[] path = new DefaultMutableTreeNode[]{this.root, node.getParent(), node, new_node};
            TreePath tp = new TreePath(path);
            this.setSelectionPath(tp);
            this.scrollPathToVisible(tp);
            return;
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
        }
    }

    void copyItem() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object o = node.getUserObject();
        int obj_type = o instanceof AcDevice ? 1 : 0;
        switch (obj_type) {
            case 0: {
                this.copied_addresses.clear();
                this.copied_addresses.add(o);
                break;
            }
            case 1: {
                this.copied_devices.clear();
                this.copied_devices.add(o);
            }
        }
    }

    void toggleRight() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object o = node.getUserObject();
        String user = node.getParent().getParent().toString();
        try {
            AcDevice dev = (AcDevice)o;
            int new_right = dev.right == 1 ? 0 : 1;
            this.access_dev.removeDevice(user, dev.name, rightsStr[dev.right]);
            this.access_dev.addDevice(user, dev.name, rightsStr[new_right]);
            dev.right = new_right;
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
        }
    }

    class CopiedAddresses
    extends Vector {
        CopiedAddresses() {
        }

        public AcAddress addressAt(int i) {
            return (AcAddress)this.get(i);
        }
    }

    class CopiedDevices
    extends Vector {
        CopiedDevices() {
        }

        public AcDevice deviceAt(int i) {
            return (AcDevice)this.get(i);
        }
    }

    class Dummy {
        Dummy() {
        }

        public String toString() {
            return "";
        }
    }

    public class AcDevice {
        String name;
        int right = 1;

        public AcDevice(String add, String r) {
            this.name = add;
            for (int i = 0; i < rightsStr.length; ++i) {
                if (!rightsStr[i].equals(r)) continue;
                this.right = i;
            }
        }

        public AcDevice(String add, int r) {
            this.name = add;
            this.right = r;
        }

        public String toString() {
            return this.name;
        }
    }

    class AcAddress {
        String name;

        public AcAddress(String add) {
            this.name = add;
        }

        public String toString() {
            return this.name;
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int USER = 1;
        private final int COLLEC = 2;
        private final int LEAF = 3;

        public TangoRenderer() {
            tango_icon = new ImageIcon(this.getClass().getResource("/app_util/img/network5.gif"));
            user_icon = new ImageIcon(this.getClass().getResource("/app_util/img/user.gif"));
            add_icon = new ImageIcon(this.getClass().getResource("/app_util/img/server.gif"));
            dev_icon = new ImageIcon(this.getClass().getResource("/app_util/img/device.gif"));
            write_icon = new ImageIcon(this.getClass().getResource("/app_util/img/greenbal.gif"));
            read_icon = new ImageIcon(this.getClass().getResource("/app_util/img/redball.gif"));
            this.fonts = new Font[4];
            this.fonts[0] = new Font("courrier", 1, 18);
            this.fonts[1] = new Font("Monospaced", 1, 14);
            this.fonts[2] = new Font("Monospaced", 1, 12);
            this.fonts[3] = new Font("Monospaced", 0, 12);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(tango_icon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof String) {
                    if (obj.toString().equals(collecStr[0])) {
                        this.setFont(this.fonts[2]);
                        this.setIcon(add_icon);
                    } else if (obj.toString().equals(collecStr[1])) {
                        this.setFont(this.fonts[2]);
                        this.setIcon(dev_icon);
                    } else {
                        this.setIcon(user_icon);
                        this.setFont(this.fonts[1]);
                    }
                } else if (node.getUserObject() instanceof AcAddress) {
                    this.setFont(this.fonts[3]);
                    this.setIcon(add_icon);
                } else if (node.getUserObject() instanceof AcDevice) {
                    this.setFont(this.fonts[3]);
                    AcDevice dev = (AcDevice)node.getUserObject();
                    if (dev.right == 0) {
                        this.setIcon(write_icon);
                    } else {
                        this.setIcon(read_icon);
                    }
                }
            }
            return this;
        }
    }
}

