/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.EditPropertyDialog;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.MultiLineToolTipUI;

public class ServArchitectureDialog
extends JDialog {
    private String servname;
    private boolean from_appli = true;
    private boolean modified = false;
    private ServInfoTree tree;
    public static final boolean EXPAND_NOT_FULL = false;
    public static final boolean EXPAND_FULL = true;
    private static String separator = ", ";
    private JPanel bottomPanel;
    private JButton cancelBtn;
    private JRadioButton expandBtn;
    private JPanel scrollPanel;
    private JTextArea textArea;
    private JScrollPane textScrollPane;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JScrollPane treeScrollPane;

    public ServArchitectureDialog(JDialog parent, String servname) throws DevFailed {
        super((Dialog)parent, false);
        this.servname = servname;
        this.initComponents();
        this.initOwnComponent(parent);
    }

    public ServArchitectureDialog(JFrame parent, String servname) throws DevFailed {
        super((Frame)parent, false);
        this.servname = servname;
        this.initComponents();
        this.initOwnComponent(parent);
    }

    public ServArchitectureDialog(JDialog parent, DeviceProxy dev) throws DevFailed {
        super((Dialog)parent, false);
        this.servname = dev.name().substring("dserver/".length());
        this.initComponents();
        this.initOwnComponent(parent);
    }

    public ServArchitectureDialog(JFrame parent, DeviceProxy dev) throws DevFailed {
        super((Frame)parent, false);
        this.servname = dev.name().substring("dserver/".length());
        this.initComponents();
        this.initOwnComponent(parent);
    }

    private void initOwnComponent(Component parent) throws DevFailed {
        this.tree = new ServInfoTree(this);
        this.treeScrollPane.setViewportView(this.tree);
        this.treeScrollPane.setPreferredSize(new Dimension(350, 450));
        this.textScrollPane.setPreferredSize(new Dimension(350, 180));
        this.titleLabel.setText(this.servname + "  Information");
        if (parent.getWidth() == 0) {
            this.from_appli = false;
        }
        MultiLineToolTipUI.initialize();
        this.pack();
        this.tree.expandTree(false);
    }

    private void initComponents() {
        this.bottomPanel = new JPanel();
        this.expandBtn = new JRadioButton();
        this.cancelBtn = new JButton();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.scrollPanel = new JPanel();
        this.treeScrollPane = new JScrollPane();
        this.textScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ServArchitectureDialog.this.closeDialog(evt);
            }
        });
        this.expandBtn.setText("Expand all properties");
        this.expandBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServArchitectureDialog.this.expandBtnActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.expandBtn);
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServArchitectureDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.cancelBtn);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.titlePanel.add(this.titleLabel);
        this.getContentPane().add((Component)this.titlePanel, "North");
        this.scrollPanel.setLayout(new BorderLayout());
        this.scrollPanel.add((Component)this.treeScrollPane, "Center");
        this.textScrollPane.setPreferredSize(new Dimension(200, 170));
        this.textArea.setEditable(false);
        this.textScrollPane.setViewportView(this.textArea);
        this.scrollPanel.add((Component)this.textScrollPane, "North");
        this.getContentPane().add((Component)this.scrollPanel, "Center");
        this.pack();
    }

    private void expandBtnActionPerformed(ActionEvent evt) {
        if (this.expandBtn.getSelectedObjects() != null) {
            this.tree.expandTree(true);
        } else {
            this.tree.expandTree(false);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.modified && JOptionPane.showConfirmDialog(this, "Some properties have been modified !\n\nDo you want a restart devices ?", "Dialog", 0) == 0) {
            try {
                new DeviceProxy("dserver/" + this.servname).command_inout("init");
            }
            catch (DevFailed e) {
                PopupError.show((Component)this, e);
            }
        }
        this.setVisible(false);
        this.dispose();
        if (!this.from_appli) {
            System.exit(0);
        }
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public static String multiLine2OneLine(String str) {
        int idx;
        if (str == null) {
            return str;
        }
        while ((idx = str.indexOf(10)) >= 0) {
            str = str.substring(0, idx) + separator + str.substring(idx + 1);
        }
        return str;
    }

    public static String OneLine2multiLine(String str) {
        int idx;
        if (str == null) {
            return str;
        }
        while ((idx = str.indexOf(separator)) >= 0) {
            str = str.substring(0, idx) + "\n" + str.substring(idx + separator.length());
        }
        return str;
    }

    public static String[] string2array(String str) {
        Vector<String> v = new Vector<String>();
        StringTokenizer stk = new StringTokenizer(str, separator);
        while (stk.hasMoreTokens()) {
            v.add(stk.nextToken());
        }
        String[] array = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            array[i] = (String)v.elementAt(i);
        }
        return array;
    }

    public static void main(String[] args) {
        String servname = "HdbEventHandler/sr-1";
        if (args.length > 0) {
            servname = args[0];
        }
        try {
            new ServArchitectureDialog(new JDialog(), servname).setVisible(true);
        }
        catch (DevFailed e) {
            PopupError.show((Component)new JDialog(), e);
            System.exit(0);
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon root_icon = new ImageIcon(this.getClass().getResource("/app_util/img/network5.gif"));
        private ImageIcon class_icon = new ImageIcon(this.getClass().getResource("/app_util/img/class.gif"));
        private ImageIcon prop_icon = new ImageIcon(this.getClass().getResource("/app_util/img/attleaf.gif"));
        private ImageIcon leaf_icon = new ImageIcon(this.getClass().getResource("/app_util/img/uleaf.gif"));
        private Font[] fonts = new Font[5];
        private final int TITLE = 0;
        private final int CLASS = 1;
        private final int DEVICE = 2;
        private final int PROP_NAME = 3;
        private final int PROP_DESC = 4;

        public TangoRenderer() {
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 1, 16);
            this.fonts[2] = new Font("helvetica", 1, 12);
            this.fonts[3] = new Font("helvetica", 0, 12);
            this.fonts[4] = new Font("helvetica", 0, 10);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            String tip = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            Object user_obj = node.getUserObject();
            if (row == 0) {
                this.setIcon(this.root_icon);
                this.setFont(this.fonts[0]);
                tip = ((TgServer)user_obj).desc;
            } else if (user_obj instanceof TgClass) {
                this.setIcon(this.class_icon);
                this.setFont(this.fonts[1]);
                tip = ((TgClass)((Object)user_obj)).desc;
            } else if (user_obj instanceof TgDevice) {
                this.setIcon(this.class_icon);
                this.setFont(this.fonts[2]);
            } else if (user_obj instanceof TgProperty) {
                this.setIcon(this.prop_icon);
                this.setFont(this.fonts[3]);
                tip = ((TgProperty)user_obj).desc;
            } else if (user_obj instanceof String) {
                this.setIcon(this.leaf_icon);
                this.setFont(this.fonts[4]);
            }
            this.setToolTipText(tip);
            return this;
        }
    }

    public class TgProperty {
        public String objname;
        public String src;
        public String name;
        public String desc;
        public String def_value;
        public String db_value = null;

        public TgProperty(String objname, String src, String name, String desc, String def_value) {
            this.objname = objname;
            this.src = src;
            this.name = name;
            this.desc = desc;
            this.def_value = "";
            this.def_value = ServArchitectureDialog.multiLine2OneLine(def_value);
        }

        public void setDbValue(String[] values) {
            this.db_value = "";
            for (int i = 0; i < values.length; ++i) {
                this.db_value = this.db_value + values[i];
                if (i >= values.length - 1) continue;
                this.db_value = this.db_value + ", ";
            }
        }

        public String getValue() {
            if (this.db_value == null) {
                return this.def_value;
            }
            return this.db_value;
        }

        public String toString(boolean verbose) {
            if (verbose) {
                return this.src + ": " + this.objname + "/" + this.name + " : \n" + this.desc + "\n" + "    default  value:  " + this.def_value + "\n" + "    database value:  " + this.db_value;
            }
            return this.toString();
        }

        public String toString() {
            return this.name;
        }
    }

    class TgClass
    extends DbClass {
        String name;
        String desc;
        String tagName = null;
        TgProperty[] properties;

        public TgClass(String name, TgProperty[] properties) throws DevFailed {
            super(name);
            this.name = name;
            this.desc = "No Description Found in Database";
            try {
                DbDatum data = this.get_property("Description");
                if (!data.is_empty()) {
                    String[] array = data.extractStringArray();
                    this.desc = "";
                    for (int i = 0; i < array.length; ++i) {
                        this.desc = this.desc + array[i] + "\n";
                    }
                }
                this.properties = new TgProperty[properties.length];
                for (int i = 0; i < properties.length; ++i) {
                    this.properties[i] = new TgProperty(name, properties[i].src, properties[i].name, properties[i].desc, properties[i].def_value);
                    DbDatum d = this.get_property(properties[i].name);
                    if (d.is_empty()) continue;
                    this.properties[i].setDbValue(d.extractStringArray());
                }
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }

        void put_property(TgProperty prop) throws DevFailed {
            if (prop.db_value == null) {
                this.delete_property(prop.name);
            } else {
                String[] value = ServArchitectureDialog.string2array(prop.db_value);
                DbDatum[] data = new DbDatum[]{new DbDatum(prop.name)};
                data[0].insert(value);
                this.put_property(data);
            }
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        public String toString() {
            String label = "Class: ";
            label = this.tagName != null ? (this.tagName.startsWith(this.name) ? label + this.tagName : label + this.name) : label + this.name;
            return label;
        }
    }

    class TgDevice
    extends DeviceProxy {
        String name;
        TgProperty[] properties;

        public TgDevice(String name, TgProperty[] properties) throws DevFailed {
            super(name);
            this.name = name;
            this.properties = new TgProperty[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                this.properties[i] = new TgProperty(name, properties[i].src, properties[i].name, properties[i].desc, properties[i].def_value);
                try {
                    DbDatum data = this.get_property(properties[i].name);
                    if (data.is_empty()) continue;
                    this.properties[i].setDbValue(data.extractStringArray());
                    continue;
                }
                catch (DevFailed e) {
                    Except.print_exception((Exception)((Object)e));
                }
            }
        }

        void put_property(TgProperty prop) throws DevFailed {
            if (prop.db_value == null) {
                this.delete_property(prop.name);
            } else {
                String[] value = ServArchitectureDialog.string2array(prop.db_value);
                DbDatum[] data = new DbDatum[]{new DbDatum(prop.name)};
                data[0].insert(value);
                this.put_property(data);
            }
        }

        public String getTagName() {
            String tagName = "";
            try {
                int end;
                DevInfo info = this.info();
                String servinfo = info.doc_url;
                String tag = "CVS Tag = ";
                int start = servinfo.indexOf(tag);
                if (start > 0 && (end = servinfo.indexOf(10, start += tag.length())) > start) {
                    tagName = servinfo.substring(start, end);
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            return tagName;
        }

        public String toString() {
            return "Device: " + this.name;
        }
    }

    class TgServer {
        String name;
        String desc;

        public TgServer(String name) {
            this.name = name;
            this.desc = "";
            try {
                String admin = "dserver/" + name;
                DeviceInfo info = new DbDevice(admin).get_info();
                this.desc = info.toString();
                ServArchitectureDialog.this.textArea.setText(this.desc);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        public String toString() {
            return this.name;
        }
    }

    class ServInfoTree
    extends JTree {
        private Component parent;
        private DeviceProxy dev = null;
        private String[] devlist = null;
        private DefaultTreeModel treeModel;
        private DefaultMutableTreeNode root;

        public ServInfoTree(Component parent) throws DevFailed {
            this.parent = parent;
            this.initComponent();
        }

        public ServInfoTree(DeviceProxy dev) throws DevFailed {
            this.dev = dev;
            this.initComponent();
        }

        void expandTree(boolean expand) {
            this.expandTree(this.root, expand);
        }

        private void expandTree(DefaultMutableTreeNode node, boolean expand) {
            int nb = node.getChildCount();
            for (int i = 0; i < nb; ++i) {
                TreePath path;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                Object obj = child.getUserObject();
                if (expand || !(obj instanceof TgProperty)) {
                    path = new TreePath(child.getPath());
                    this.expandPath(path);
                    this.expandTree(child, expand);
                }
                if (expand || !(obj instanceof TgProperty)) continue;
                path = new TreePath(child.getPath());
                this.collapsePath(path);
            }
        }

        private void initComponent() throws DevFailed {
            this.root = new DefaultMutableTreeNode(new TgServer(ServArchitectureDialog.this.servname));
            this.createNodes(this.root);
            this.getSelectionModel().setSelectionMode(1);
            this.treeModel = new DefaultTreeModel(this.root);
            this.setModel(this.treeModel);
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setCellRenderer(new TangoRenderer());
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ServInfoTree this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent evt) {
                    ServInfoTree.access$400(this.this$1, evt);
                }
            });
        }

        private void createNodes(DefaultMutableTreeNode root) throws DevFailed {
            if (this.dev == null) {
                this.dev = new DeviceProxy("dserver/" + ServArchitectureDialog.this.servname);
            }
            TgClass[] classes = this.getClasses();
            DefaultMutableTreeNode[] classnodes = new DefaultMutableTreeNode[classes.length];
            for (int c = 0; c < classes.length; ++c) {
                classnodes[c] = new DefaultMutableTreeNode((Object)classes[c]);
                root.add(classnodes[c]);
                for (int p = 0; p < classes[c].properties.length; ++p) {
                    TgProperty prop = classes[c].properties[p];
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(prop);
                    classnodes[c].add(node);
                    node.add(new DefaultMutableTreeNode(prop.getValue()));
                }
                TgDevice[] devices = this.getDevices(classes[c].name);
                DefaultMutableTreeNode[] devnodes = new DefaultMutableTreeNode[devices.length];
                for (int d = 0; d < devices.length; ++d) {
                    devnodes[d] = new DefaultMutableTreeNode((Object)devices[d]);
                    classnodes[c].add(devnodes[d]);
                    for (int p = 0; p < devices[d].properties.length; ++p) {
                        TgProperty prop = devices[d].properties[p];
                        DefaultMutableTreeNode node = new DefaultMutableTreeNode(prop);
                        devnodes[d].add(node);
                        node.add(new DefaultMutableTreeNode(prop.getValue()));
                    }
                }
                if (devices.length <= 0) continue;
                classes[c].setTagName(devices[0].getTagName());
            }
        }

        private TgDevice[] getDevices(String classname) throws DevFailed {
            if (this.devlist == null) {
                DeviceData argout = this.dev.command_inout("QueryDevice");
                this.devlist = argout.extractStringArray();
            }
            Vector<String> v = new Vector<String>();
            String str = classname + "::";
            for (int i = 0; i < this.devlist.length; ++i) {
                if (!this.devlist[i].startsWith(str)) continue;
                v.add(this.devlist[i].substring(str.length()));
            }
            String[] devnames = new String[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                devnames[i] = (String)v.elementAt(i);
            }
            TgProperty[] dev_prop = this.getProperties(classname, "Dev");
            TgDevice[] devices = new TgDevice[devnames.length];
            for (int i = 0; i < devnames.length; ++i) {
                devices[i] = new TgDevice(devnames[i], dev_prop);
            }
            return devices;
        }

        private TgClass[] getClasses() throws DevFailed {
            DeviceData argout = this.dev.command_inout("QueryClass");
            String[] classnames = argout.extractStringArray();
            TgClass[] classes = new TgClass[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                TgProperty[] prop = this.getProperties(classnames[i], "Class");
                classes[i] = new TgClass(classnames[i], prop);
            }
            return classes;
        }

        private TgProperty[] getProperties(String classname, String source) throws DevFailed {
            DeviceData argin = new DeviceData();
            argin.insert(classname);
            String cmd = "QueryWizard" + source + "Property";
            DeviceData argout = this.dev.command_inout(cmd, argin);
            String[] str = argout.extractStringArray();
            TgProperty[] prop = new TgProperty[str.length / 3];
            int n = 0;
            for (int i = 0; i < str.length; i += 3) {
                prop[n] = new TgProperty(classname, source, str[i], str[i + 1], str[i + 2]);
                ++n;
            }
            return prop;
        }

        private void treeMouseClicked(MouseEvent evt) {
            if (this.getRowForLocation(evt.getX(), evt.getY()) < 1) {
                return;
            }
            int mask = evt.getModifiers();
            if (evt.getClickCount() == 2 && (mask & 0x10) != 0) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
                Object o = node.getUserObject();
                if (node.isLeaf() && o instanceof String) {
                    this.editProperty(node);
                }
            }
        }

        private void editProperty(DefaultMutableTreeNode node) {
            DefaultMutableTreeNode prop_node = (DefaultMutableTreeNode)node.getParent();
            TgProperty property = (TgProperty)prop_node.getUserObject();
            EditPropertyDialog dialog = this.parent instanceof JDialog ? new EditPropertyDialog((JDialog)this.parent, property) : new EditPropertyDialog((JFrame)this.parent, property);
            property = dialog.showDialog();
            if (property != null) {
                DefaultMutableTreeNode tg_node = (DefaultMutableTreeNode)prop_node.getParent();
                Object o = tg_node.getUserObject();
                try {
                    if (o instanceof TgClass) {
                        TgClass _class = (TgClass)((Object)o);
                        _class.put_property(property);
                        this.replaceNode(node, property.getValue());
                        ServArchitectureDialog.this.modified = true;
                    } else if (o instanceof TgDevice) {
                        TgDevice dev = (TgDevice)((Object)o);
                        dev.put_property(property);
                        this.replaceNode(node, property.getValue());
                        ServArchitectureDialog.this.modified = true;
                    } else {
                        System.out.println("object " + o + "  not implemented !");
                    }
                }
                catch (DevFailed e) {
                    PopupError.show((Component)this, e);
                }
            }
        }

        private void replaceNode(DefaultMutableTreeNode node, String str) {
            DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
            int pos = 0;
            for (int i = 0; i < parent_node.getChildCount(); ++i) {
                if (!parent_node.getChildAt(i).equals(node)) continue;
                pos = i;
            }
            DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(str);
            this.treeModel.insertNodeInto(new_node, parent_node, pos);
            this.treeModel.removeNodeFromParent(node);
        }

        static /* synthetic */ void access$400(ServInfoTree x0, MouseEvent x1) {
            x0.treeMouseClicked(x1);
        }
    }
}

